/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.content.blocks;

import mindustry.content.Blocks;
import mindustry.content.StatusEffects;
import mindustry.graphics.CacheLayer;
import mindustry.graphics.MultiPacker;
import mindustry.world.Block;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.OreBlock;
import mindustry.world.blocks.environment.Prop;
import mindustry.world.blocks.environment.StaticWall;
import mindustry.world.blocks.environment.TallBlock;
import newhorizon.content.NHContent;
import newhorizon.content.NHItems;
import newhorizon.content.NHLiquids;
import newhorizon.expand.block.environment.OreVein;
import newhorizon.expand.block.environment.TiledFloor;

public class EnvironmentBlock {
    public static Block metalFloorPlain;
    public static Block labFloorLight;
    public static Block labFloorDark;
    public static Floor armorClear;
    public static Block oreZeta;
    public static Block oreSilicon;
    public static Block oreSilicar;
    public static Block oreSmallTitanium;
    public static Block oreNormalTitanium;
    public static Block oreDenseTitanium;
    public static Block orePureTitanium;
    public static Block oreClusterTitanium;
    public static Block platingFloor1;
    public static Block platingFloor2;
    public static Block platingFloor3;
    public static Block platingFloor4;
    public static Block conglomerateWall;
    public static Block darkConglomerateWall;
    public static Block thoriumStoneWall;
    public static Block conglomerateBoulder;
    public static Block darkConglomerateBoulder;
    public static Block conglomerateSparse;
    public static Block conglomerate;
    public static Block conglomerateDense;
    public static Block darkConglomerateSparse;
    public static Block darkConglomerate;
    public static Block darkConglomerateDense;
    public static Block cryoniteSparse;
    public static Block cryonite;
    public static Block erodeRock;
    public static Block erodeRockDense;
    public static Block siliceoustone;
    public static Block thoriumStoneSparse;
    public static Block thoriumStone;
    public static Block thoriumStoneDense;
    public static Block ammoniaWater;
    public static Block ammoniaWaterDeep;
    public static Block ammoniaWaterShallow;
    public static Block zetaCrystalFloor;

    public static void load() {
        oreZeta = new OreBlock("ore-zeta"){
            {
                this.oreDefault = true;
                this.variants = 3;
                this.oreThreshold = 0.95f;
                this.oreScale = 20.380953f;
                this.itemDrop = NHItems.zeta;
                this.localizedName = this.itemDrop.localizedName;
                this.mapColor.set(this.itemDrop.color);
                this.useColor = true;
            }
        };
        oreSilicar = new OreBlock("ore-silicar"){
            {
                this.oreDefault = true;
                this.variants = 3;
                this.oreThreshold = 0.95f;
                this.oreScale = 20.380953f;
                this.itemDrop = NHItems.silicar;
                this.localizedName = this.itemDrop.localizedName;
                this.mapColor.set(this.itemDrop.color);
                this.useColor = true;
            }
        };
        oreSmallTitanium = new OreVein("ore-small-titanium", NHItems.titanium, 0.5f);
        oreNormalTitanium = new OreVein("ore-normal-titanium", NHItems.titanium, 1.0f);
        oreDenseTitanium = new OreVein("ore-dense-titanium", NHItems.titanium, 2.0f);
        orePureTitanium = new OreVein("ore-pure-titanium", NHItems.titanium, 4.0f);
        oreClusterTitanium = new TallBlock("ore-cluster-titanium"){
            {
                this.itemDrop = NHItems.titanium;
                this.shadowOffset = -1.0f;
                this.variants = 3;
                this.attributes.set(NHContent.density, 1.0f);
            }
        };
        conglomerateWall = new StaticWall("conglomerate-wall"){
            {
                this.variants = 3;
            }
        };
        darkConglomerateWall = new StaticWall("dark-conglomerate-wall"){
            {
                this.variants = 3;
            }
        };
        thoriumStoneWall = new StaticWall("thorium-stone-wall"){
            {
                this.variants = 3;
            }
        };
        conglomerateBoulder = new Prop("conglomerate-boulder"){
            {
                this.variants = 4;
            }
        };
        darkConglomerateBoulder = new Prop("dark-conglomerate-boulder"){
            {
                this.variants = 4;
            }
        };
        conglomerateSparse = new Floor("conglomerate-sparse"){
            {
                this.variants = 6;
                this.wall = conglomerateWall;
                this.decoration = conglomerateBoulder;
            }
        };
        conglomerate = new Floor("conglomerate"){
            {
                this.variants = 6;
                this.wall = conglomerateWall;
                this.decoration = conglomerateBoulder;
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                this.mapColor.set(EnvironmentBlock.conglomerateSparse.mapColor).mul(1.05f);
            }
        };
        conglomerateDense = new Floor("conglomerate-dense"){
            {
                this.variants = 6;
                this.wall = conglomerateWall;
                this.decoration = conglomerateBoulder;
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                this.mapColor.set(EnvironmentBlock.conglomerateSparse.mapColor).mul(1.1f);
            }
        };
        darkConglomerateSparse = new Floor("dark-conglomerate-sparse"){
            {
                this.variants = 6;
                this.wall = darkConglomerateWall;
                this.decoration = darkConglomerateBoulder;
            }
        };
        darkConglomerate = new Floor("dark-conglomerate"){
            {
                this.variants = 6;
                this.wall = darkConglomerateWall;
                this.decoration = darkConglomerateBoulder;
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                this.mapColor.set(EnvironmentBlock.darkConglomerateSparse.mapColor).mul(1.05f);
            }
        };
        darkConglomerateDense = new Floor("dark-conglomerate-dense"){
            {
                this.variants = 6;
                this.wall = darkConglomerateWall;
                this.decoration = darkConglomerateBoulder;
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                this.mapColor.set(EnvironmentBlock.darkConglomerateSparse.mapColor).mul(1.1f);
            }
        };
        cryoniteSparse = new Floor("cryonite-sparse"){
            {
                this.variants = 3;
            }
        };
        cryonite = new Floor("cryonite"){
            {
                this.variants = 3;
            }
        };
        erodeRock = new Floor("erode-rock"){
            {
                this.variants = 3;
            }
        };
        erodeRockDense = new Floor("erode-rock-dense"){
            {
                this.variants = 3;
            }
        };
        siliceoustone = new Floor("siliceoustone"){
            {
                this.variants = 4;
            }
        };
        thoriumStoneSparse = new Floor("thorium-stone-sparse"){
            {
                this.variants = 4;
                this.wall = thoriumStoneWall;
            }
        };
        thoriumStone = new Floor("thorium-stone"){
            {
                this.variants = 4;
                this.wall = thoriumStoneWall;
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                this.mapColor.set(EnvironmentBlock.thoriumStoneSparse.mapColor).mul(1.05f);
            }
        };
        thoriumStoneDense = new Floor("thorium-stone-dense"){
            {
                this.variants = 4;
                this.wall = thoriumStoneWall;
            }

            public void createIcons(MultiPacker packer) {
                super.createIcons(packer);
                this.mapColor.set(EnvironmentBlock.thoriumStoneSparse.mapColor).mul(1.1f);
            }
        };
        zetaCrystalFloor = new Floor("zeta-crystal-floor"){
            {
                this.variants = 3;
            }
        };
        ammoniaWater = new Floor("ammonia-water"){
            {
                this.variants = 0;
                this.albedo = 0.9f;
                this.isLiquid = true;
                this.speedMultiplier = 0.75f;
                this.status = StatusEffects.wet;
                this.cacheLayer = CacheLayer.water;
                this.liquidDrop = NHLiquids.ammonia;
            }
        };
        ammoniaWaterDeep = new Floor("ammonia-water-deep"){
            {
                this.variants = 0;
                this.albedo = 0.9f;
                this.isLiquid = true;
                this.drownTime = 300.0f;
                this.speedMultiplier = 0.6f;
                this.status = StatusEffects.wet;
                this.cacheLayer = CacheLayer.water;
                this.liquidDrop = NHLiquids.ammonia;
            }
        };
        ammoniaWaterShallow = new Floor("ammonia-water-shallow"){
            {
                this.variants = 3;
                this.albedo = 0.9f;
                this.isLiquid = true;
                this.speedMultiplier = 0.9f;
                this.status = StatusEffects.wet;
                this.cacheLayer = CacheLayer.water;
                this.liquidDrop = NHLiquids.ammonia;
            }
        };
        platingFloor1 = new TiledFloor("plating-floor-1"){
            {
                this.tileName = "plating-floor";
                this.autotile = true;
                this.drawEdgeOut = false;
                this.drawEdgeIn = false;
            }
        };
        platingFloor3 = new TiledFloor("plating-floor-3"){
            {
                this.useTiles = false;
                this.autotileVariants = 2;
                this.cacheLayer = NHContent.quantumLayer;
                this.autotile = true;
                this.drawEdgeOut = false;
                this.drawEdgeIn = false;
            }

            public int variant(int x, int y, int max) {
                return (x + y) % 2;
            }
        };
        platingFloor4 = new TiledFloor("plating-floor-4"){
            {
                this.useTiles = false;
                this.cacheLayer = NHContent.quantumLayer;
                this.autotile = true;
                this.drawEdgeOut = false;
                this.drawEdgeIn = false;
            }
        };
        metalFloorPlain = new TiledFloor("plating-metal-floor"){
            {
                this.tileName = "plating-floor";
                this.autotile = true;
                this.drawEdgeOut = false;
                this.drawEdgeIn = false;
            }
        };
        Blocks.vibrantCrystalCluster.itemDrop = NHItems.thorium;
        Blocks.crystalCluster.itemDrop = NHItems.thorium;
        Blocks.crystalOrbs.itemDrop = NHItems.beryllium;
        Blocks.whiteTree.itemDrop = NHItems.sporePod;
        Blocks.crystalBlocks.itemDrop = NHItems.sand;
        Blocks.vibrantCrystalCluster.attributes.set(NHContent.density, 1.0f);
        Blocks.crystalCluster.attributes.set(NHContent.density, 1.0f);
        Blocks.crystalOrbs.attributes.set(NHContent.density, 0.75f);
        Blocks.whiteTree.attributes.set(NHContent.density, 0.25f);
        Blocks.crystalBlocks.attributes.set(NHContent.density, 0.5f);
    }
}

