/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.content.blocks;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import mindustry.Vars;
import mindustry.content.Items;
import mindustry.entities.Effect;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.world.Block;
import mindustry.world.blocks.defense.ForceProjector;
import newhorizon.content.NHItems;
import newhorizon.content.NHLiquids;
import newhorizon.expand.block.defence.AdaptRegenProjector;
import newhorizon.expand.block.defence.AdaptWall;
import newhorizon.expand.block.defence.ShieldGenerator;

public class DefenseBlock {
    public static Block presstaniumWall;
    public static Block refactoringMultiWall;
    public static Block setonPhasedWall;
    public static Block shapedWall;
    public static Block standardRegenProjector;
    public static Block heavyRegenProjector;
    public static Block standardForceProjector;
    public static Block largeShieldGenerator;
    public static Block riftShield;

    public static void load() {
        presstaniumWall = new AdaptWall("presstanium-wall"){
            {
                this.health = 1200;
                this.armor = 2.0f;
                this.maxShareStep = 1.0f;
                this.damageReduction = 0.1f;
                this.requirements(Category.defense, ItemStack.with((Object[])new Object[]{NHItems.presstanium, 10, NHItems.juniorProcessor, 6}));
            }
        };
        refactoringMultiWall = new AdaptWall("refactoring-multi-wall"){
            {
                this.health = 1800;
                this.armor = 4.0f;
                this.maxShareStep = 2.0f;
                this.damageReduction = 0.2f;
                this.requirements(Category.defense, ItemStack.with((Object[])new Object[]{NHItems.metalOxhydrigen, 8, Items.carbide, 12}));
            }
        };
        setonPhasedWall = new AdaptWall("seton-phased-wall"){
            {
                this.health = 2400;
                this.armor = 8.0f;
                this.maxShareStep = 2.0f;
                this.damageReduction = 0.3f;
                this.requirements(Category.defense, ItemStack.with((Object[])new Object[]{NHItems.setonAlloy, 6, NHItems.irayrondPanel, 8}));
            }
        };
        shapedWall = new AdaptWall("shaped-wall"){
            {
                this.health = 3000;
                this.armor = 10.0f;
                this.damageReduction = 0.5f;
                this.crushDamageMultiplier = 0.5f;
                this.requirements(Category.defense, ItemStack.with((Object[])new Object[]{NHItems.nodexPlate, 8, NHItems.ancimembrane, 8}));
            }
        };
        standardRegenProjector = new AdaptRegenProjector("standard-regen-projector"){
            {
                this.requirements(Category.effect, ItemStack.with((Object[])new Object[]{NHItems.presstanium, 60, NHItems.juniorProcessor, 50}));
                this.size = 2;
                this.health = 1200;
                this.armor = 8.0f;
                this.range = 25;
                this.healPercent = 0.11111111f;
                this.baseHeal = 0.8333333f;
                this.consumePower(2.0f);
                this.consumeLiquid(NHLiquids.xenFluid, 0.2f);
                this.consumeItem(NHItems.phaseFabric).boost();
            }
        };
        heavyRegenProjector = new AdaptRegenProjector("heavy-regen-projector"){
            {
                this.requirements(Category.effect, ItemStack.with((Object[])new Object[]{NHItems.multipleSteel, 60, NHItems.seniorProcessor, 50}));
                this.size = 3;
                this.health = 3000;
                this.armor = 20.0f;
                this.range = 40;
                this.healPercent = 0.27777776f;
                this.baseHeal = 3.3333333f;
                this.optionalMultiplier = 4.0f;
                this.consumePower(5.0f);
                this.consumeLiquid(NHLiquids.irdryonFluid, 0.1f);
                this.consumeItem(NHItems.ancimembrane).boost();
            }
        };
        final Effect forceShrink = new Effect(20.0f, e -> {
            Draw.color((Color)e.color, (float)e.fout());
            if (Vars.renderer.animateShields) {
                Fill.poly((float)e.x, (float)e.y, (int)4, (float)(e.rotation * e.fout()), (float)45.0f);
            } else {
                Lines.stroke((float)1.5f);
                Draw.alpha((float)0.09f);
                Fill.poly((float)e.x, (float)e.y, (int)4, (float)(e.rotation * e.fout()), (float)45.0f);
                Draw.alpha((float)1.0f);
                Lines.poly((float)e.x, (float)e.y, (int)4, (float)(e.rotation * e.fout()), (float)45.0f);
            }
        }).layer(125.0f);
        standardForceProjector = new ForceProjector("standard-shield-generator"){
            {
                super(arg0);
                this.requirements(Category.effect, ItemStack.with((Object[])new Object[]{NHItems.juniorProcessor, 150, NHItems.presstanium, 150, Items.carbide, 50}));
                this.size = 2;
                this.sides = 4;
                this.health = 1500;
                this.armor = 10.0f;
                this.itemCapacity = 20;
                this.liquidCapacity = 25.0f;
                this.shieldRotation = 45.0f;
                this.radius = 140.0f;
                this.shieldHealth = 2500.0f;
                this.cooldownNormal = 10.0f;
                this.cooldownBrokenBase = this.shieldHealth / 300.0f;
                this.phaseRadiusBoost = 80.0f;
                this.phaseShieldBoost = 2500.0f;
                this.itemConsumer = this.consumeItem(NHItems.zeta).boost();
                this.consumePower(5.0f);
                this.shieldBreakEffect = new Effect(40.0f, e -> {
                    Draw.color((Color)e.color);
                    Lines.stroke((float)(3.0f * e.fout()));
                    Lines.poly((float)e.x, (float)e.y, (int)4, (float)(e.rotation + e.fin()), (float)45.0f);
                }).followParent(true);
                this.buildType = () -> new ForceProjector.ForceBuild(){

                    public void onRemoved() {
                        float radius = this.realRadius();
                        if (!this.broken && radius > 1.0f) {
                            forceShrink.at(this.x, this.y, radius, this.team.color);
                        }
                    }
                };
            }
        };
        largeShieldGenerator = new ForceProjector("large-shield-generator"){
            {
                super(arg0);
                this.requirements(Category.effect, ItemStack.with((Object[])new Object[]{NHItems.seniorProcessor, 200, NHItems.presstanium, 200, Items.phaseFabric, 150, NHItems.multipleSteel, 100}));
                this.size = 4;
                this.sides = 4;
                this.health = 3000;
                this.armor = 20.0f;
                this.itemCapacity = 20;
                this.liquidCapacity = 50.0f;
                this.shieldRotation = 45.0f;
                this.radius = 240.0f;
                this.shieldHealth = 25000.0f;
                this.cooldownNormal = 25.0f;
                this.cooldownBrokenBase = this.shieldHealth / 1200.0f;
                this.phaseRadiusBoost = 120.0f;
                this.phaseShieldBoost = 25000.0f;
                this.itemConsumer = this.consumeItem(NHItems.fusionEnergy).boost();
                this.consumePower(25.0f);
                this.shieldBreakEffect = new Effect(40.0f, e -> {
                    Draw.color((Color)e.color);
                    Lines.stroke((float)(3.0f * e.fout()));
                    Lines.poly((float)e.x, (float)e.y, (int)4, (float)(e.rotation + e.fin()), (float)45.0f);
                }).followParent(true);
                this.buildType = () -> new ForceProjector.ForceBuild(){

                    public void onRemoved() {
                        float radius = this.realRadius();
                        if (!this.broken && radius > 1.0f) {
                            forceShrink.at(this.x, this.y, radius, this.team.color);
                        }
                    }
                };
            }
        };
        riftShield = new ShieldGenerator("rift-shield"){
            {
                this.requirements(Category.effect, ItemStack.with((Object[])new Object[]{NHItems.setonAlloy, 300, NHItems.ancimembrane, 350, NHItems.seniorProcessor, 400, NHItems.nodexPlate, 300}));
            }
        };
    }
}

