/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.content.blocks;

import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.content.Liquids;
import mindustry.entities.Effect;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.type.LiquidStack;
import mindustry.world.Block;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.draw.DrawArcSmelt;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawCrucibleFlame;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawFlame;
import mindustry.world.draw.DrawGlowRegion;
import mindustry.world.draw.DrawLiquidRegion;
import mindustry.world.draw.DrawLiquidTile;
import mindustry.world.draw.DrawMulti;
import mindustry.world.draw.DrawRegion;
import mindustry.world.meta.BuildVisibility;
import newhorizon.content.NHColor;
import newhorizon.content.NHFx;
import newhorizon.content.NHItems;
import newhorizon.content.NHLiquids;
import newhorizon.content.NHStatusEffects;
import newhorizon.expand.block.drawer.DrawFlameRotated;
import newhorizon.expand.block.drawer.DrawLiquidRegionRotated;
import newhorizon.expand.block.drawer.DrawParticleFlow;
import newhorizon.expand.block.drawer.DrawPrinter;
import newhorizon.expand.block.drawer.DrawRegionFlip;
import newhorizon.expand.block.drawer.DrawRegionRotated;
import newhorizon.expand.block.drawer.DrawRegionRotatedDiagonal;
import newhorizon.expand.block.drawer.DrawRotator;
import newhorizon.expand.block.drawer.DrawScanLine;
import newhorizon.expand.block.production.factory.RecipeGenericCrafter;
import newhorizon.util.graphic.DrawFunc;
import newhorizon.util.graphic.EffectWrapper;

public class CraftingBlock {
    public static Block sheetPresser;
    public static Block manufactory;
    public static Block stampingFacility;
    public static Block processorPrinter;
    public static Block condenseFacility;
    public static Block crucibleFoundry;
    public static Block crystallizer;
    public static Block zetaFactory;
    public static Block zetaDissociator;
    public static Block surgeRefactor;
    public static Block fabricSynthesizer;
    public static Block processorEncoder;
    public static Block irdryonMixer;
    public static Block hugeplastaniumFactory;
    public static Block multipleSteelFactory;
    public static Block irayrondFactory;
    public static Block setonFactory;
    public static Block upgradeSortFactory;
    public static Block ancimembraneConcentrator;
    public static Block factory0;
    public static Block factory1;
    public static Block factory2;
    public static Block factory3;
    public static Block factory4;
    public static Block factory5;
    public static Block factory6;

    public static void load() {
        stampingFacility = new RecipeGenericCrafter("stamping-facility"){
            {
                this.requirements(Category.crafting, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.titanium, 45, NHItems.silicon, 60}));
                this.addLink(new int[]{2, 0, 1, 2, 1, 1, -1, 0, 1, -1, 1, 1});
                this.size = 2;
                this.health = 600;
                this.armor = 4.0f;
                this.itemCapacity = 20;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegionRotated(){
                    {
                        this.oneSprite = true;
                        this.suffix = "-base";
                    }
                }, new DrawArcSmelt(){
                    {
                        this.midColor = this.flameColor = NHColor.lightSkyBack.cpy().lerp(Color.lightGray, 0.3f);
                        this.flameRad /= 1.585f;
                        this.particleStroke /= 1.35f;
                        this.particleLen /= 1.25f;
                    }
                }, new DrawRegionFlip("-rot")});
                this.craftEffect = this.updateEffect = NHFx.square(Pal.techBlue, 60.0f, 6, 16.0f, 3.0f);
                this.consumePower(3.0f);
            }
        };
        processorPrinter = new RecipeGenericCrafter("processor-printer"){
            {
                this.requirements(Category.crafting, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.titanium, 30, NHItems.silicon, 45, NHItems.tungsten, 30}));
                this.addLink(new int[]{2, 0, 1, 2, 1, 1, -1, 0, 1, -1, 1, 1});
                this.size = 2;
                this.health = 600;
                this.armor = 4.0f;
                this.itemCapacity = 20;
                this.consumePower(3.0f);
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegionRotated(){
                    {
                        this.oneSprite = true;
                        this.suffix = "-base";
                    }
                }, new DrawScanLine(){
                    {
                        this.scanLength = 24.0f;
                        this.scanAngle = 90.0f;
                        this.scanScl = 6.0f;
                        this.strokeRange = 6.0f;
                        this.colorFrom = Pal.techBlue;
                    }
                }, new DrawScanLine(){
                    {
                        this.scanLength = 12.0f;
                        this.scanScl = 12.0f;
                        this.strokeRange = 12.0f;
                        this.colorFrom = Pal.techBlue;
                    }
                }, new DrawScanLine(){
                    {
                        this.scanLength = 12.0f;
                        this.strokePlusScl = 2.0f;
                        this.scanScl = 12.0f;
                        this.strokeRange = 12.0f;
                        this.totalProgressMultiplier = 1.2f;
                        this.colorFrom = Pal.techBlue;
                    }
                }, new DrawGlowRegion(){
                    {
                        this.suffix = "-glow";
                        this.rotate = true;
                        this.color = Pal.techBlue;
                    }
                }, new DrawRegionFlip(){
                    {
                        this.suffix = "-rot";
                    }
                }});
                this.craftEffect = this.updateEffect = NHFx.square(Pal.techBlue, 60.0f, 6, 16.0f, 3.0f);
            }
        };
        condenseFacility = new RecipeGenericCrafter("condense-facility"){
            {
                this.requirements(Category.crafting, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 25, NHItems.titanium, 100, NHItems.presstanium, 50, NHItems.juniorProcessor, 25}));
                this.health = 600;
                this.armor = 4.0f;
                this.size = 3;
                this.rotate = false;
                this.itemCapacity = 20;
                this.liquidCapacity = 100.0f;
                this.consumePower(2.0f);
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegion("-bottom"), new DrawLiquidTile(NHLiquids.quantumLiquid), new DrawLiquidTile(Liquids.water), new DrawLiquidTile(Liquids.cryofluid), new DrawDefault()});
            }
        };
        crucibleFoundry = new RecipeGenericCrafter("crucible-foundry"){
            {
                this.requirements(Category.crafting, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.presstanium, 30, NHItems.juniorProcessor, 50, NHItems.tungsten, 40, NHItems.zeta, 40}));
                this.addLink(new int[]{2, -1, 1, 2, 0, 1, 2, 1, 1, -2, -1, 1, -2, 0, 1, -2, 1, 1});
                this.size = 3;
                this.health = 900;
                this.armor = 6.0f;
                this.itemCapacity = 20;
                this.liquidCapacity = 15.0f;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegionFlip("-rot"), new DrawFlameRotated(){
                    {
                        this.suffix = "-flame";
                    }
                }});
                this.updateEffect = this.craftEffect = new Effect(90.0f, e -> Angles.randLenVectors((long)e.id, (float)e.fin(), (int)10, (float)20.0f, (x, y, fin, fout) -> {
                    Draw.color((Color)Color.gray);
                    Draw.alpha((float)((0.5f - Math.abs(fin - 0.5f)) * 2.0f));
                    Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(0.5f + fout * 4.0f));
                }));
                this.consumePower(5.0f);
            }
        };
        crystallizer = new RecipeGenericCrafter("crystallizer"){
            {
                this.requirements(Category.crafting, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.presstanium, 60, NHItems.juniorProcessor, 45, Items.tungsten, 30}));
                this.size = 2;
                this.health = 900;
                this.armor = 6.0f;
                this.canMirror = true;
                this.rotations = new int[]{1, 0, 3, 2, 3, 2, 1, 0};
                this.addLink(new int[]{2, 0, 1, 2, 1, 1, 0, 2, 1, 1, 2, 1});
                this.craftTime = 120.0f;
                this.consumePower(5.0f);
                this.itemCapacity = 30;
                this.liquidCapacity = 20.0f;
                this.health = 1600;
                this.craftEffect = Fx.smeltsmoke;
                this.updateEffect = Fx.smeltsmoke;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegionRotated(){
                    {
                        this.suffix = "-rot";
                        this.x = 4.0f;
                        this.y = 4.0f;
                    }
                }, new DrawLiquidRegionRotated(){
                    {
                        this.suffix = "-liquid";
                        this.drawLiquid = Liquids.water;
                        this.x = 4.0f;
                        this.y = 4.0f;
                    }
                }, new DrawLiquidRegionRotated(){
                    {
                        this.suffix = "-liquid";
                        this.drawLiquid = NHLiquids.quantumLiquid;
                        this.x = 4.0f;
                        this.y = 4.0f;
                    }
                }, new DrawFlameRotated(){
                    {
                        this.drawFlame = false;
                        this.flameX = 1.0f;
                        this.flameY = 1.0f;
                        this.flameColor = NHLiquids.quantumLiquid.color;
                        this.flameRadius *= 0.8f;
                        this.flameRadiusIn *= 0.8f;
                    }
                }, new DrawFlameRotated(){
                    {
                        this.drawFlame = false;
                        this.flameX = 8.0f;
                        this.flameY = 0.0f;
                        this.flameColor = NHLiquids.quantumLiquid.color;
                        this.flameRadius *= 0.5f;
                        this.flameRadiusIn *= 0.5f;
                    }
                }, new DrawFlameRotated(){
                    {
                        this.drawFlame = false;
                        this.flameX = 0.0f;
                        this.flameY = 8.0f;
                        this.flameColor = NHLiquids.quantumLiquid.color;
                        this.flameRadius *= 0.5f;
                        this.flameRadiusIn *= 0.5f;
                    }
                }, new DrawRegionRotated(){
                    {
                        this.oneSprite = true;
                        this.suffix = "-edge";
                        this.x = 4.0f;
                        this.y = 4.0f;
                    }
                }});
            }
        };
        zetaFactory = new RecipeGenericCrafter("zeta-factory"){
            {
                this.requirements(Category.crafting, ItemStack.with((Object[])new Object[]{NHItems.hardLight, 50, NHItems.tungsten, 100, NHItems.carbide, 50, NHItems.metalOxhydrigen, 50}));
                this.size = 2;
                this.health = 900;
                this.armor = 6.0f;
                this.itemCapacity = 30;
                this.liquidCapacity = 30.0f;
                this.addLink(new int[]{2, 0, 1, 2, 1, 1, -1, 0, 1, -1, 1, 1});
                this.craftTime = 60.0f;
                this.consumePower(5.0f);
                this.craftEffect = Fx.formsmoke;
                this.updateEffect = NHFx.trailToGray;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegionRotated(){
                    {
                        this.oneSprite = true;
                        this.suffix = "-base";
                    }
                }, new DrawLiquidRegion(){
                    {
                        this.suffix = "-top";
                        this.drawLiquid = NHLiquids.zetaFluidPositive;
                    }
                }, new DrawRegionFlip(){
                    {
                        this.suffix = "-rot";
                    }
                }, new DrawFlame(){
                    {
                        this.flameColor = NHLiquids.zetaFluidPositive.color;
                        this.flameRadius = 3.0f;
                        this.flameRadiusIn = 1.9f;
                        this.flameRadiusScl = 5.0f;
                        this.flameRadiusMag = 2.0f;
                        this.flameRadiusInMag = 1.0f;
                    }
                }});
            }
        };
        zetaDissociator = new GenericCrafter("zeta-dissociator"){
            {
                this.requirements(Category.crafting, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.presstanium, 30, NHItems.juniorProcessor, 40, NHItems.carbide, 60, NHItems.metalOxhydrigen, 45, NHItems.zeta, 60}));
                this.quickRotate = true;
                this.invertFlip = true;
                this.rotate = true;
                this.size = 3;
                this.health = 900;
                this.armor = 6.0f;
                this.itemCapacity = 30;
                this.liquidCapacity = 30.0f;
                this.outputLiquids = LiquidStack.with((Object[])new Object[]{NHLiquids.zetaFluidPositive, 0.075, NHLiquids.zetaFluidNegative, 0.075});
                this.liquidOutputDirections = new int[]{1, 3};
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegion("-bottom"), new DrawRegion("-base"), new DrawRegionRotated(){
                    {
                        this.suffix = "-top-rot";
                    }
                }, new DrawGlowRegion("-glow"){
                    {
                        super(arg0);
                        this.color = NHItems.zeta.color;
                    }
                }});
                this.craftEffect = this.updateEffect = NHFx.square(NHItems.zeta.color, 60.0f, 6, 16.0f, 3.0f);
                this.consumePower(8.0f);
                this.consumeItems(ItemStack.with((Object[])new Object[]{NHItems.zeta, 4}));
            }
        };
        surgeRefactor = new RecipeGenericCrafter("surge-refactor"){
            {
                this.requirements(Category.crafting, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.presstanium, 60, NHItems.juniorProcessor, 90, NHItems.tungsten, 60, NHItems.metalOxhydrigen, 45}));
                this.addLink(new int[]{2, -1, 1, 2, 0, 1, 2, 1, 1, -2, -1, 1, -2, 0, 1, -2, 1, 1});
                this.size = 3;
                this.health = 1200;
                this.armor = 8.0f;
                this.ignoreLiquidFullness = true;
                this.itemCapacity = 30;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegionFlip(){
                    {
                        this.suffix = "-rot";
                    }
                }, new DrawGlowRegion(){
                    {
                        this.rotate = true;
                        this.suffix = "-glow";
                        this.color = NHItems.surgeAlloy.color;
                    }
                }});
                this.craftEffect = this.updateEffect = NHFx.polyCloud(Pal.accent, 60.0f, 3.0f, 16.0f, 6);
                this.consumePower(8.0f);
            }
        };
        fabricSynthesizer = new RecipeGenericCrafter("fabric-synthesizer"){
            {
                this.requirements(Category.crafting, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.presstanium, 90, NHItems.juniorProcessor, 60, NHItems.tungsten, 60, NHItems.metalOxhydrigen, 45}));
                this.addLink(new int[]{2, -1, 1, 2, 0, 1, 2, 1, 1, -2, -1, 1, -2, 0, 1, -2, 1, 1});
                this.size = 3;
                this.craftTime = 60.0f;
                this.outputItems = ItemStack.with((Object[])new Object[]{Items.phaseFabric, 2});
                this.outputLiquids = LiquidStack.with((Object[])new Object[]{NHLiquids.zetaFluidPositive, Float.valueOf(0.05f)});
                this.ignoreLiquidFullness = true;
                this.itemCapacity = 30;
                this.health = 1200;
                this.armor = 8.0f;
                this.craftEffect = this.updateEffect = NHFx.polyCloud(Pal.accent, 60.0f, 3.0f, 16.0f, 6);
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegionRotated(){
                    {
                        this.oneSprite = true;
                        this.suffix = "-base";
                    }
                }, new DrawGlowRegion(){
                    {
                        this.rotate = true;
                        this.suffix = "-glow";
                        this.color = NHItems.phaseFabric.color;
                    }
                }, new DrawScanLine(){
                    {
                        this.scanLength = 24.0f;
                        this.scanAngle = 90.0f;
                        this.scanScl = 6.0f;
                        this.strokeRange = 8.0f;
                        this.colorFrom = NHItems.phaseFabric.color;
                    }
                }, new DrawScanLine(){
                    {
                        this.scanLength = 12.0f;
                        this.scanScl = 12.0f;
                        this.strokeRange = 16.0f;
                        this.colorFrom = NHItems.phaseFabric.color;
                    }
                }, new DrawScanLine(){
                    {
                        this.scanLength = 12.0f;
                        this.strokePlusScl = 2.0f;
                        this.scanScl = 12.0f;
                        this.strokeRange = 16.0f;
                        this.totalProgressMultiplier = 1.2f;
                        this.colorFrom = NHItems.phaseFabric.color;
                    }
                }, new DrawRegionFlip(){
                    {
                        this.suffix = "-rot";
                    }
                }});
                this.consumePower(8.0f);
            }
        };
        multipleSteelFactory = new RecipeGenericCrafter("multiple-steel-factory"){
            {
                this.requirements(Category.crafting, ItemStack.with((Object[])new Object[]{NHItems.presstanium, 120, NHItems.juniorProcessor, 65, NHItems.metalOxhydrigen, 80, NHItems.surgeAlloy, 60}));
                this.size = 3;
                this.rotate = false;
                this.health = 1500;
                this.armor = 10.0f;
                this.itemCapacity = 30;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegion("-base"), new DrawCrucibleFlame(){
                    {
                        this.midColor = this.flameColor = NHColor.lightSkyBack.cpy().lerp(Color.lightGray, 0.3f);
                    }
                }, new DrawRegion("-mid"), new DrawRotator(0.75f, "-rotator-1"){

                    @Override
                    public void draw(Building build) {
                        Drawf.spinSprite((TextureRegion)this.rotator, (float)(build.x + this.x), (float)(build.y + this.y), (float)DrawFunc.rotator_90(DrawFunc.cycle(build.totalProgress() * this.rotateSpeed, 0.0f, craftTime), 0.15f));
                    }
                }, new DrawRotator(1.5f, "-rotator-2"){

                    @Override
                    public void draw(Building build) {
                        Drawf.spinSprite((TextureRegion)this.rotator, (float)(build.x + this.x), (float)(build.y + this.y), (float)(-DrawFunc.rotator_90(DrawFunc.cycle(build.totalProgress() * this.rotateSpeed, 0.0f, craftTime), 0.15f)));
                    }
                }});
                this.lightColor = NHItems.multipleSteel.color;
                this.updateEffect = EffectWrapper.wrap(Fx.smeltsmoke, this.lightColor);
                this.craftEffect = EffectWrapper.wrap(NHFx.square45_6_45, this.lightColor);
                this.consumePower(4.0f);
            }
        };
        processorEncoder = new RecipeGenericCrafter("processor-encoder"){
            {
                this.requirements(Category.crafting, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{Items.surgeAlloy, 90, Items.phaseFabric, 90, Items.carbide, 120, NHItems.zeta, 80}));
                this.size = 2;
                this.addLink(new int[]{2, 0, 1, 2, 1, 1, -1, 0, 1, -1, 1, 1});
                this.craftTime = 120.0f;
                this.itemCapacity = 20;
                this.health = 1500;
                this.armor = 10.0f;
                this.consumePower(4.0f);
                this.outputItems = ItemStack.with((Object[])new Object[]{NHItems.seniorProcessor, 2});
                final Color drawerColor = Pal.accent.cpy().lerp(Color.white, 0.4f);
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegionRotated(){
                    {
                        this.oneSprite = true;
                        this.suffix = "-base";
                    }
                }, new DrawParticleFlow(){
                    {
                        this.startX = -14.0f;
                        this.startY = 0.0f;
                        this.endX = 14.0f;
                        this.endY = 0.0f;
                        this.ignoreRot2_3 = true;
                        this.particleLife = 75.0f;
                        this.particles = 15;
                        this.color = drawerColor;
                    }
                }, new DrawParticleFlow(){
                    {
                        this.startX = -14.0f;
                        this.startY = 0.0f;
                        this.endX = 14.0f;
                        this.endY = 0.0f;
                        this.ignoreRot2_3 = true;
                        this.particleLife = 90.0f;
                        this.particles = 15;
                        this.color = drawerColor;
                    }
                }, new DrawParticleFlow(){
                    {
                        this.startX = -14.0f;
                        this.startY = 0.0f;
                        this.endX = 14.0f;
                        this.endY = 0.0f;
                        this.ignoreRot2_3 = true;
                        this.particleLife = 60.0f;
                        this.particles = 15;
                        this.color = drawerColor;
                    }
                }, new DrawScanLine(){
                    {
                        this.scanLength = 24.0f;
                        this.scanAngle = 90.0f;
                        this.scanScl = 6.0f;
                        this.strokeRange = 6.0f;
                        this.colorFrom = drawerColor;
                    }
                }, new DrawScanLine(){
                    {
                        this.scanLength = 12.0f;
                        this.scanScl = 12.0f;
                        this.strokeRange = 12.0f;
                        this.colorFrom = drawerColor;
                    }
                }, new DrawScanLine(){
                    {
                        this.scanLength = 12.0f;
                        this.strokePlusScl = 2.0f;
                        this.scanScl = 12.0f;
                        this.strokeRange = 12.0f;
                        this.totalProgressMultiplier = 1.2f;
                        this.colorFrom = drawerColor;
                    }
                }, new DrawGlowRegion(){
                    {
                        this.suffix = "-glow";
                        this.rotate = true;
                        this.color = drawerColor;
                    }
                }, new DrawRegionFlip(){
                    {
                        this.suffix = "-rot";
                    }
                }});
            }
        };
        irdryonMixer = new RecipeGenericCrafter("irdryon-mixer"){
            {
                this.requirements(Category.crafting, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.surgeAlloy, 90, NHItems.phaseFabric, 60, NHItems.metalOxhydrigen, 120, NHItems.zeta, 80}));
                this.size = 3;
                this.liquidCapacity = 30.0f;
                this.itemCapacity = 30;
                this.health = 1500;
                this.armor = 10.0f;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegion("-base"), new DrawCrucibleFlame(){
                    {
                        this.particles = 45;
                        this.particleRad = 11.0f;
                    }
                }, new DrawLiquidTile(NHLiquids.irdryonFluid), new DrawRegion("-mid"), new DrawRotator(true){
                    {
                        super(usesSpinDraw);
                        this.rotateSpeed = 2.0f;
                    }
                }});
                this.updateEffectChance = 0.075f;
                this.updateEffect = EffectWrapper.wrap(NHFx.hugeSmokeLong, NHItems.fusionEnergy.color.cpy().a(0.53f));
                this.consumePower(5.0f);
            }
        };
        hugeplastaniumFactory = new RecipeGenericCrafter("plastanium-crafter"){
            {
                this.requirements(Category.crafting, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.presstanium, 90, NHItems.juniorProcessor, 120, Items.surgeAlloy, 80, NHItems.metalOxhydrigen, 40, NHItems.multipleSteel, 60}));
                this.size = 3;
                this.health = 1500;
                this.armor = 10.0f;
                this.rotate = false;
                this.craftTime = 90.0f;
                this.consumePower(10.666667f);
                this.ignoreLiquidFullness = true;
                this.itemCapacity = 30;
                this.liquidCapacity = 60.0f;
                this.craftEffect = Fx.smeltsmoke;
                this.updateEffect = Fx.smeltsmoke;
                this.drawer = new DrawDefault();
            }
        };
        irayrondFactory = new RecipeGenericCrafter("irayrond-factory"){
            {
                this.requirements(Category.crafting, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.presstanium, 90, NHItems.seniorProcessor, 60, NHItems.phaseFabric, 120, NHItems.metalOxhydrigen, 45, NHItems.multipleSteel, 85}));
                this.addLink(new int[]{2, -1, 1, 2, 0, 1, 2, 1, 1, -2, -1, 1, -2, 0, 1, -2, 1, 1});
                this.size = 3;
                this.health = 1800;
                this.armor = 12.0f;
                this.ignoreLiquidFullness = true;
                this.itemCapacity = 30;
                this.craftEffect = Fx.smeltsmoke;
                this.updateEffect = Fx.smeltsmoke;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegionFlip("-rot"), new DrawGlowRegion(){
                    {
                        this.color = NHColor.lightSky;
                        this.rotate = true;
                        this.alpha = 1.1f;
                    }
                }, new DrawFlameRotated(){
                    {
                        this.drawFlame = false;
                        this.flameX = 8.0f;
                        this.flameColor = NHColor.lightSky;
                    }
                }, new DrawFlameRotated(){
                    {
                        this.drawFlame = false;
                        this.flameColor = NHColor.lightSky;
                    }
                }, new DrawFlameRotated(){
                    {
                        this.drawFlame = false;
                        this.flameX = -8.0f;
                        this.flameColor = NHColor.lightSky;
                    }
                }});
                this.consumePower(8.0f);
            }
        };
        setonFactory = new RecipeGenericCrafter("seton-factory"){
            {
                this.requirements(Category.crafting, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.juniorProcessor, 90, NHItems.zeta, 150, Items.surgeAlloy, 90, NHItems.metalOxhydrigen, 80, NHItems.multipleSteel, 65}));
                this.size = 3;
                this.addLink(new int[]{2, -1, 1, 2, 0, 1, 2, 1, 1, -2, -1, 1, -2, 0, 1, -2, 1, 1});
                this.craftTime = 120.0f;
                this.itemCapacity = 30;
                this.health = 1800;
                this.armor = 12.0f;
                this.consumePower(8.0f);
                this.outputItems = ItemStack.with((Object[])new Object[]{NHItems.setonAlloy, 2});
                this.outputLiquids = LiquidStack.with((Object[])new Object[]{NHLiquids.zetaFluidNegative, Float.valueOf(0.05f)});
                this.ignoreLiquidFullness = true;
                this.craftEffect = Fx.smeltsmoke;
                this.updateEffect = Fx.smeltsmoke;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegionFlip("-base"), new DrawRegion("-piston-1"){

                    public void draw(Building build) {
                        Tmp.v1.setAngle(90.0f + build.rotdeg()).setLength(Mathf.absin((float)build.totalProgress(), (float)12.0f, (float)3.0f));
                        Draw.rect((TextureRegion)this.region, (float)(build.x + Tmp.v1.x), (float)(build.y + Tmp.v1.y), (float)((float)this.region.width / 4.0f), (float)((float)this.region.height / 4.0f));
                    }
                }, new DrawRegion("-piston-1"){

                    public void draw(Building build) {
                        Tmp.v1.setAngle(270.0f + build.rotdeg()).setLength(Mathf.absin((float)build.totalProgress(), (float)12.0f, (float)3.0f));
                        Draw.rect((TextureRegion)this.region, (float)(build.x + Tmp.v1.x), (float)(build.y + Tmp.v1.y), (float)((float)this.region.width / 4.0f), (float)((float)(-this.region.height) / 4.0f));
                    }
                }, new DrawRegion("-piston-2"){

                    public void draw(Building build) {
                        Tmp.v1.setAngle(135.0f + build.rotdeg()).setLength(Mathf.absin((float)build.totalProgress(), (float)12.0f, (float)3.0f));
                        Draw.rect((TextureRegion)this.region, (float)(build.x + Tmp.v1.x), (float)(build.y + Tmp.v1.y), (float)((float)this.region.width / 4.0f), (float)((float)this.region.height / 4.0f));
                    }
                }, new DrawRegion("-piston-2"){

                    public void draw(Building build) {
                        Tmp.v1.setAngle(45.0f + build.rotdeg()).setLength(Mathf.absin((float)build.totalProgress(), (float)12.0f, (float)3.0f));
                        Draw.rect((TextureRegion)this.region, (float)(build.x + Tmp.v1.x), (float)(build.y + Tmp.v1.y), (float)((float)(-this.region.width) / 4.0f), (float)((float)this.region.height / 4.0f));
                    }
                }, new DrawRegion("-piston-2"){

                    public void draw(Building build) {
                        Tmp.v1.setAngle(225.0f + build.rotdeg()).setLength(Mathf.absin((float)build.totalProgress(), (float)12.0f, (float)3.0f));
                        Draw.rect((TextureRegion)this.region, (float)(build.x + Tmp.v1.x), (float)(build.y + Tmp.v1.y), (float)((float)this.region.width / 4.0f), (float)((float)(-this.region.height) / 4.0f));
                    }
                }, new DrawRegion("-piston-2"){

                    public void draw(Building build) {
                        Tmp.v1.setAngle(315.0f + build.rotdeg()).setLength(Mathf.absin((float)build.totalProgress(), (float)12.0f, (float)3.0f));
                        Draw.rect((TextureRegion)this.region, (float)(build.x + Tmp.v1.x), (float)(build.y + Tmp.v1.y), (float)((float)(-this.region.width) / 4.0f), (float)((float)(-this.region.height) / 4.0f));
                    }
                }, new DrawRegionFlip("-top")});
            }
        };
        upgradeSortFactory = new RecipeGenericCrafter("nodex-factory"){
            {
                this.requirements(Category.crafting, ItemStack.with((Object[])new Object[]{NHItems.setonAlloy, 160, NHItems.seniorProcessor, 80, NHItems.presstanium, 150, NHItems.irayrondPanel, 90}));
                this.size = 3;
                this.rotate = false;
                this.health = 2100;
                this.armor = 14.0f;
                this.itemCapacity = 40;
                this.hasItems = true;
                this.hasPower = true;
                this.drawer = new DrawPrinter(NHItems.nodexPlate){
                    {
                        super(item);
                        this.printColor = NHColor.darkEnrColor;
                        this.lightColor = Color.valueOf((String)"#E1BAFF");
                        this.moveLength = 4.2f;
                        this.time = 25.0f;
                    }
                };
                this.clipSize = (float)(this.size * 8) * 2.0f;
                this.craftEffect = new Effect(25.0f, e -> {
                    Draw.color((Color)NHColor.darkEnrColor);
                    Angles.randLenVectors((long)e.id, (int)4, (float)(24.0f * e.fout() * e.fout()), (x, y) -> {
                        Lines.stroke((float)(e.fout() * 1.7f));
                        Lines.square((float)(e.x + x), (float)(e.y + y), (float)(2.0f + e.fout() * 6.0f));
                    });
                });
                this.updateEffect = NHStatusEffects.quantization.effect;
                this.consumePower(26.666666f);
            }
        };
        ancimembraneConcentrator = new RecipeGenericCrafter("ancimembrane-concentrator"){
            {
                this.size = 3;
                this.rotate = false;
                this.lightRadius /= 2.0f;
                this.requirements(Category.crafting, ItemStack.with((Object[])new Object[]{NHItems.seniorProcessor, 120, NHItems.multipleSteel, 90, NHItems.zeta, 45, NHItems.setonAlloy, 60}));
                this.craftTime = 120.0f;
                this.health = 2100;
                this.armor = 14.0f;
                this.craftEffect = NHFx.crossBlast(NHColor.ancient, 45.0f, 45.0f);
                this.craftEffect.lifetime *= 1.5f;
                this.updateEffect = NHFx.squareRand(NHColor.ancient, 5.0f, 15.0f);
                this.hasLiquids = true;
                this.hasItems = true;
                this.hasPower = true;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegion("-bottom"), new DrawLiquidTile(NHLiquids.quantumLiquid), new DrawRegion("-bottom-2"), new DrawCrucibleFlame(){
                    {
                        this.flameColor = NHColor.ancient;
                        this.midColor = Color.valueOf((String)"2e2f34");
                        this.circleStroke = 1.05f;
                        this.circleSpace = 2.65f;
                    }

                    public void draw(Building build) {
                        if (build.warmup() > 0.0f && this.flameColor.a > 0.001f) {
                            Lines.stroke((float)(this.circleStroke * build.warmup()));
                            float si = Mathf.absin((float)this.flameRadiusScl, (float)this.flameRadiusMag);
                            float a = this.alpha * build.warmup();
                            Draw.blend((Blending)Blending.additive);
                            Draw.color((Color)this.flameColor, (float)a);
                            float base = Time.time / this.particleLife;
                            rand.setSeed((long)build.id);
                            for (int i = 0; i < this.particles; ++i) {
                                float fin = (rand.random(1.0f) + base) % 1.0f;
                                float fout = 1.0f - fin;
                                float angle = rand.random(360.0f) + Time.time / this.rotateScl % 360.0f;
                                float len = this.particleRad * this.particleInterp.apply(fout);
                                Draw.alpha((float)(a * (1.0f - Mathf.curve((float)fin, (float)(1.0f - this.fadeMargin)))));
                                Fill.square((float)(build.x + Angles.trnsx((float)angle, (float)len)), (float)(build.y + Angles.trnsy((float)angle, (float)len)), (float)(this.particleSize * fin * build.warmup()), (float)45.0f);
                            }
                            Draw.blend();
                            Draw.color((Color)this.midColor, (float)build.warmup());
                            Lines.square((float)build.x, (float)build.y, (float)((this.flameRad + this.circleSpace + si) * build.warmup()), (float)45.0f);
                            Draw.reset();
                        }
                    }
                }, new DrawDefault(), new DrawGlowRegion(){
                    {
                        this.color = NHColor.ancient;
                        this.layer = -1.0f;
                        this.glowIntensity = 1.1f;
                        this.alpha = 1.1f;
                    }
                }, new DrawRotator(1.0f, "-top"){

                    @Override
                    public void draw(Building build) {
                        Drawf.spinSprite((TextureRegion)this.rotator, (float)(build.x + this.x), (float)(build.y + this.y), (float)DrawFunc.rotator_90(DrawFunc.cycle(build.totalProgress() * this.rotateSpeed, 0.0f, craftTime), 0.15f));
                    }
                }});
                this.itemCapacity = 40;
                this.liquidCapacity = 40.0f;
                this.consumePower(26.666666f);
            }
        };
        factory0 = new RecipeGenericCrafter("factory-0"){
            {
                this.requirements(Category.crafting, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.tungsten, 80, NHItems.presstanium, 60, NHItems.juniorProcessor, 40}));
                this.addLink(new int[]{2, 0, 1, 2, 1, 1, -1, 0, 1, -1, 1, 1, 0, 2, 1, 1, 2, 1, 0, -1, 1, 1, -1, 1});
                this.size = 2;
                this.health = 750;
                this.armor = 5.0f;
                this.itemCapacity = 30;
                this.rotate = false;
                this.drawer = new DrawDefault();
                this.consumePower(5.0f);
            }
        };
        factory1 = new RecipeGenericCrafter("factory-1"){
            {
                this.requirements(Category.crafting, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.presstanium, 10, NHItems.juniorProcessor, 80, NHItems.carbide, 40, NHItems.metalOxhydrigen, 80}));
                this.addLink(new int[]{2, 0, 1, 2, 1, 1, -1, 0, 1, -1, 1, 1, 0, 2, 1, 1, 2, 1, 0, -1, 1, 1, -1, 1, -1, 2, 1, 2, -1, 1});
                this.canMirror = true;
                this.rotations = new int[]{1, 0, 1, 0, 3, 2, 3, 2};
                this.size = 2;
                this.health = 1050;
                this.armor = 7.0f;
                this.itemCapacity = 30;
                this.drawer = new DrawRegionRotatedDiagonal("-rot");
                this.consumePower(6.0f);
            }
        };
        factory2 = new RecipeGenericCrafter("factory-2"){
            {
                this.requirements(Category.crafting, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.juniorProcessor, 60, NHItems.metalOxhydrigen, 120, NHItems.phaseFabric, 80, NHItems.surgeAlloy, 80}));
                this.addLink(new int[]{2, -1, 1, 2, 0, 1, 2, 1, 1, -2, -1, 1, -2, 0, 1, -2, 1, 1});
                this.size = 3;
                this.health = 1350;
                this.armor = 9.0f;
                this.itemCapacity = 30;
                this.drawer = new DrawRegionFlip();
                this.consumePower(7.5f);
            }
        };
        factory3 = new RecipeGenericCrafter("factory-3"){
            {
                this.requirements(Category.crafting, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.zeta, 200, NHItems.presstanium, 100, NHItems.multipleSteel, 60, NHItems.seniorProcessor, 40}));
                this.size = 4;
                this.health = 1650;
                this.armor = 11.0f;
                this.itemCapacity = 30;
                this.rotate = false;
                this.drawer = new DrawRegionFlip();
                this.consumePower(10.0f);
            }
        };
        factory4 = new RecipeGenericCrafter("factory-4"){
            {
                this.requirements(Category.crafting, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.juniorProcessor, 100, NHItems.carbide, 60, NHItems.irayrondPanel, 60, NHItems.setonAlloy, 80}));
                this.addLink(new int[]{-2, -2, 1, -2, -1, 1, -2, 0, 1, -1, -2, 1, 0, -2, 1, 2, 2, 1, 2, 1, 1, 2, 0, 1, 1, 2, 1, 0, 2, 1});
                this.canMirror = true;
                this.rotations = new int[]{1, 0, 1, 0, 3, 2, 3, 2};
                this.size = 3;
                this.health = 1950;
                this.armor = 13.0f;
                this.itemCapacity = 30;
                this.drawer = new DrawRegionRotatedDiagonal("-rot");
                this.consumePower(12.0f);
            }
        };
        factory5 = new RecipeGenericCrafter("factory-5"){
            {
                this.requirements(Category.crafting, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.silicon, 150, NHItems.surgeAlloy, 60, NHItems.nodexPlate, 30, NHItems.ancimembrane, 20}));
                this.addLink(new int[]{-2, -1, 1, -2, 0, 1, -2, 1, 1, -2, 2, 1, 3, -1, 1, 3, 0, 1, 3, 1, 1, 3, 2, 1});
                this.size = 4;
                this.health = 2250;
                this.armor = 15.0f;
                this.itemCapacity = 30;
                this.drawer = new DrawRegionFlip();
                this.consumePower(14.0f);
            }
        };
        factory6 = new RecipeGenericCrafter("factory-6"){
            {
                this.requirements(Category.crafting, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.multipleSteel, 150, NHItems.seniorProcessor, 100, NHItems.nodexPlate, 55, NHItems.darkEnergy, 40}));
                this.addLink(new int[]{-2, 1, 1, -2, 2, 1, -2, 3, 1, -1, 3, 1, 0, 3, 1, 1, -2, 1, 2, -2, 1, 3, -2, 1, 3, -1, 1, 3, 0, 1});
                this.canMirror = true;
                this.rotations = new int[]{1, 0, 1, 0, 3, 2, 3, 2};
                this.size = 4;
                this.health = 2550;
                this.armor = 17.0f;
                this.itemCapacity = 30;
                this.drawer = new DrawRegionRotatedDiagonal("-rot");
                this.consumePower(20.0f);
            }
        };
    }
}

