/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.content;

import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Geometry;
import arc.math.geom.Position;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.entities.Effect;
import mindustry.entities.effect.MultiEffect;
import mindustry.entities.units.StatusEntry;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.StatusEffect;
import newhorizon.content.NHColor;
import newhorizon.content.NHContent;
import newhorizon.content.NHFx;
import newhorizon.content.NHStats;
import newhorizon.util.func.NHFunc;
import newhorizon.util.func.NHInterp;
import newhorizon.util.graphic.DrawFunc;
import newhorizon.util.graphic.EffectWrapper;

public class NHStatusEffects {
    public static Rand rand = new Rand();
    public static StatusEffect emp1;
    public static StatusEffect emp2;
    public static StatusEffect emp3;
    public static StatusEffect phased;
    public static StatusEffect overphased;
    public static StatusEffect weak;
    public static StatusEffect ultFireBurn;
    public static StatusEffect stronghold;
    public static StatusEffect quantization;
    public static StatusEffect scrambler;
    public static StatusEffect invincible;
    public static StatusEffect intercepted;
    public static StatusEffect entangled;
    public static StatusEffect end;
    public static StatusEffect staticVel;
    public static StatusEffect scannerDown;
    public static StatusEffect blackWall;
    public static StatusEffect shieldFlag;
    public static StatusEffect accumulateFlag;
    public static StatusEffect executionFlag;
    public static StatusEffect immunityFlag;

    public static void load() {
        entangled = new NHStatusEffect("entangled"){
            {
                this.color = Color.lightGray;
                this.speedMultiplier = 0.95f;
                this.reloadMultiplier = 0.95f;
                this.effectChance = 0.085f;
                this.effect = EffectWrapper.wrap(NHFx.hitSparkLarge, NHColor.ancientLightMid);
            }

            @Override
            public void update(Unit unit, StatusEntry entry) {
                super.update(unit, entry);
                unit.shield *= 0.985f;
                if (unit.shield > 50.0f && Mathf.chanceDelta((double)0.065)) {
                    NHFx.shuttle.at(unit.x + Mathf.random((float)(unit.hitSize * 0.75f)), unit.y + Mathf.random((float)(unit.hitSize * 0.75f)), 45.0f, NHColor.ancient, (Object)Float.valueOf(Mathf.clamp((float)unit.shield, (float)1000.0f, (float)6000.0f) / 8.0f / 22.0f));
                    Effect.shake((float)3.0f, (float)5.0f, (Position)unit);
                }
            }
        };
        overphased = new NHStatusEffect("overphased"){
            {
                this.color = NHColor.deeperBlue;
                this.speedMultiplier = 1.75f;
                this.healthMultiplier = 3.0f;
                this.reloadMultiplier = 2.0f;
                this.damageMultiplier = 1.5f;
                this.effectChance = 0.3f;
                this.permanent = true;
                this.hideDetails = false;
                this.show = true;
            }

            public boolean isHidden() {
                return false;
            }

            @Override
            public void update(Unit unit, StatusEntry entry) {
                super.update(unit, entry);
                if (this.damage > 0.0f) {
                    unit.damageContinuousPierce(this.damage);
                } else if (this.damage < 0.0f) {
                    unit.heal(-1.0f * this.damage * Time.delta);
                }
                if (Mathf.chanceDelta((double)this.effectChance)) {
                    Tmp.v1.trns(unit.rotation, -unit.type.engineOffset).add((Position)unit);
                    NHFunc.randFadeLightningEffect(Tmp.v1.x, Tmp.v1.y, unit.hitSize * 1.7f, Mathf.random((float)8.0f, (float)18.0f), unit.team.color, Mathf.chance((double)0.5));
                    this.effect.at(unit.x + Tmp.v1.x, unit.y + Tmp.v1.y, 0.0f, this.color, this.parentizeEffect ? unit : null);
                }
            }
        };
        stronghold = new NHStatusEffect("stronghold"){
            {
                this.color = Color.lightGray;
                this.speedMultiplier = 0.001f;
                this.healthMultiplier = 2.0f;
            }
        };
        intercepted = new NHStatusEffect("intercepted"){
            {
                this.damage = 0.0f;
                this.speedMultiplier = 0.55f;
                this.healthMultiplier = 0.75f;
                this.damageMultiplier = 0.75f;
                this.effectChance = 0.05f;
                this.effect = NHFx.square45_4_45;
                this.color = Pal.accent;
            }
        };
        ultFireBurn = new NHStatusEffect("ult-fire-burn"){
            {
                this.damage = 1.5f;
                this.color = NHColor.lightSkyBack;
                this.speedMultiplier = 0.75f;
                this.reloadMultiplier = 0.75f;
                this.healthMultiplier = 0.75f;
                this.effect = NHFx.ultFireBurn;
            }
        };
        scannerDown = new NHStatusEffect("scanner-down"){
            {
                this.damageMultiplier = 0.95f;
                this.speedMultiplier = 0.9f;
                this.reloadMultiplier = 0.6f;
                this.effectChance = 0.2f;
                this.color = Pal.heal.cpy().lerp(Pal.lancerLaser, 0.5f);
                this.effect = new MultiEffect(new Effect[]{NHFx.squareRand(Pal.heal, 8.0f, 16.0f), NHFx.squareRand(Pal.lancerLaser, 8.0f, 16.0f)});
            }
        };
        weak = new NHStatusEffect("weak"){
            {
                this.speedMultiplier = 0.75f;
                this.damageMultiplier = 0.8f;
                this.reloadMultiplier = 0.9f;
                this.color = NHColor.thurmixRed;
                this.effectChance = 0.25f;
                this.effect = new MultiEffect(new Effect[]{new Effect(30.0f, e -> {
                    Draw.color((Color)this.color);
                    float drawSize = 24.0f * e.fout();
                    Draw.rect((TextureRegion)NHContent.pointerRegion, (float)e.x, (float)(e.y - e.rotation * 24.0f * e.finpow()), (float)drawSize, (float)drawSize, (float)-180.0f);
                }), NHFx.crossBlast(this.color, 30.0f, 45.0f)});
            }
        };
        phased = new NHStatusEffect("phased"){
            {
                this.damage = -10.0f;
                this.speedMultiplier = 1.5f;
                this.damageMultiplier = 1.25f;
                this.healthMultiplier = 1.5f;
                this.color = NHColor.lightSkyBack;
                this.effectChance = 0.25f;
                this.effect = NHFx.squareRand(this.color, 8.0f, 16.0f);
            }
        };
        end = new NHStatusEffect("end"){
            {
                this.damage = 200.0f;
                this.color = NHColor.darkEnrColor;
                this.damageMultiplier = 0.5f;
                this.reloadMultiplier = 0.5f;
                this.speedMultiplier = 0.5f;
                this.effectChance = 0.075f;
                this.effect = new Effect(20.0f, 20.0f, e -> {
                    Draw.color((Color)Color.white, (Color)this.color, (float)(e.fin() + 0.35f));
                    Lines.stroke((float)(1.5f * e.fout((Interp)Interp.pow3Out)));
                    Lines.square((float)e.x, (float)e.y, (float)(Mathf.randomSeed((long)e.id, (float)2.0f, (float)8.0f) * e.fin((Interp)Interp.pow2Out) + 6.0f), (float)45.0f);
                });
            }

            @Override
            public void update(Unit unit, StatusEntry entry) {
                super.update(unit, entry);
                unit.damage(120.0f, true);
                if (!Vars.headless && Mathf.chanceDelta((double)0.1)) {
                    Tmp.v1.rnd(Mathf.random((float)(unit.hitSize() / 3.5f), (float)unit.hitSize()) * 2.0f);
                    NHFx.shuttleLerp.at(unit.x + Tmp.v1.x, unit.y + Tmp.v1.y, Tmp.v1.angle(), this.color, (Object)Float.valueOf(Tmp.v1.len()));
                }
            }
        };
        scrambler = new NHStatusEffect("scrambler-status"){
            {
                this.reloadMultiplier = 0.35f;
                this.damage = 0.35f;
                this.speedMultiplier = 0.125f;
                this.color = NHColor.thermoPst;
                this.effectChance = 0.1f;
                this.effect = new MultiEffect(new Effect[]{new Effect(30.0f, e -> {
                    Draw.color((Color)this.color);
                    float drawSize = 24.0f * e.fout();
                    Draw.rect((TextureRegion)NHContent.pointerRegion, (float)e.x, (float)(e.y - e.rotation * 24.0f * e.finpow()), (float)drawSize, (float)drawSize, (float)-180.0f);
                }), NHFx.lightningHitSmall(this.color)});
            }
        };
        quantization = new NHStatusEffect("quantization"){
            {
                this.color = NHColor.darkEnrColor;
                this.effectChance = 0.1f;
                this.damage = -2.0f;
                this.effect = NHFx.squareRand(this.color, 5.0f, 13.0f);
                this.reloadMultiplier = 1.25f;
                this.damageMultiplier = 1.25f;
                this.speedMultiplier = 1.25f;
                this.buildSpeedMultiplier = 1.25f;
                this.healthMultiplier = 0.75f;
            }
        };
        invincible = new NHStatusEffect("invincible"){
            {
                this.healthMultiplier = 3.0f;
            }

            public void draw(Unit unit, float time) {
                Draw.z((float)110.0f);
                Draw.color((Color)NHColor.lightSkyBack);
                float size = Mathf.clamp((float)(time / 30.0f)) * (float)NHContent.upgrade.height * Draw.scl;
                for (int i : Mathf.signs) {
                    Tmp.v1.trns(unit.rotation + (float)(90 * i), unit.hitSize * 1.5f).add((Position)unit);
                    Draw.rect((TextureRegion)NHContent.upgrade, (float)Tmp.v1.x, (float)Tmp.v1.y, (float)size, (float)size, (float)(unit.rotation + (float)(90 * i) - 90.0f));
                }
            }
        };
        staticVel = new NHStatusEffect("static-vel"){
            {
                this.permanent = true;
                this.color = Pal.gray;
                this.speedMultiplier = 1.0E-5f;
            }

            @Override
            public void update(Unit unit, StatusEntry entry) {
                super.update(unit, entry);
                unit.vel = unit.vel.scl(0.05f);
            }
        };
        emp1 = new NHStatusEffect("emp-1"){
            {
                this.effect = NHFx.emped;
                this.effectChance = 0.1f;
                this.reactive = false;
                this.speedMultiplier = 0.8f;
                this.reloadMultiplier = 0.8f;
                this.damageMultiplier = 0.8f;
            }
        };
        emp2 = new NHStatusEffect("emp-2"){
            {
                this.effect = NHFx.emped;
                this.effectChance = 0.2f;
                this.reactive = false;
                this.speedMultiplier = 0.5f;
                this.reloadMultiplier = 0.5f;
                this.damageMultiplier = 0.5f;
                this.init(() -> this.override.add((Object)emp1));
            }
        };
        emp3 = new NHStatusEffect("emp-3"){
            {
                this.effect = NHFx.emped;
                this.effectChance = 0.3f;
                this.reactive = false;
                this.speedMultiplier = 0.2f;
                this.reloadMultiplier = 0.2f;
                this.damageMultiplier = 0.2f;
                this.init(() -> this.override.add((Object)emp1, (Object)emp2));
            }
        };
        immunityFlag = new StatusEffect("immunity-flag");
        executionFlag = new NHStatusEffect("execution-flag"){
            {
                this.speedMultiplier = 0.0f;
            }

            public void onRemoved(Unit unit) {
                super.onRemoved(unit);
                float damagePercent = 0.25f;
                float killThreshold = 0.5f;
                boolean shouldKill = unit.health() < unit.maxHealth() * killThreshold;
                float size = unit.type.hitSize * (shouldKill ? 9.0f : 3.0f);
                Effect eff = new Effect(120.0f, size * 2.0f, e -> {
                    Draw.color((Color)NHColor.darkEnrFront, (Color)Color.white, (float)(e.fout() * 0.55f));
                    for (int i = 0; i < 4; ++i) {
                        DrawFunc.tri(e.x, e.y, size / 20.0f * (e.fout() * 3.0f + 1.0f) / 4.0f * (e.fout((Interp)Interp.pow3In) + 0.5f) / 1.5f, size * Mathf.curve((float)e.fin(), (float)0.0f, (float)0.05f) * e.fout((Interp)Interp.pow3), i * 90 + 45);
                    }
                });
                for (int i = 0; i < 4; ++i) {
                    eff.at(unit.x + (float)Geometry.d4x((int)i) * unit.type.hitSize / 2.0f, unit.y + (float)Geometry.d4y((int)i) * unit.type.hitSize / 2.0f);
                }
                eff.at(unit.x, unit.y);
                if (shouldKill) {
                    unit.kill();
                } else {
                    unit.damagePierce(unit.maxHealth() * damagePercent);
                }
            }
        };
        accumulateFlag = new NHStatusEffect("accumulate-flag"){

            public void draw(Unit unit, float time) {
                super.draw(unit, time);
                float scl = time / this.getTimeThreshold(unit);
                Draw.z((float)110.0f);
                Draw.color((Color)NHColor.darkEnrFront);
                Lines.stroke((float)Mathf.clamp((float)(unit.hitSize / 40.0f), (float)0.5f, (float)2.5f));
                Lines.arc((float)unit.x, (float)unit.y, (float)(unit.hitSize * 1.5f), (float)scl);
                Lines.arc((float)unit.x, (float)unit.y, (float)(unit.hitSize * 2.0f), (float)scl);
                Lines.stroke((float)(Mathf.clamp((float)(unit.hitSize / 20.0f), (float)1.0f, (float)5.0f) * scl));
                Lines.circle((float)unit.x, (float)unit.y, (float)(unit.hitSize * 1.75f));
                int step = (int)Mathf.clamp((float)(unit.hitSize / 4.0f), (float)8.0f, (float)20.0f);
                for (int i = 0; i < step; ++i) {
                    float rot = (float)i * (360.0f / (float)step);
                    Tmp.v1.set(unit.hitSize * 1.75f, 0.0f).rotate(rot).add((Position)unit);
                    Drawf.tri((float)Tmp.v1.x, (float)Tmp.v1.y, (float)(unit.hitSize * 0.1f), (float)(unit.hitSize * 0.5f * scl), (float)rot);
                    Drawf.tri((float)Tmp.v1.x, (float)Tmp.v1.y, (float)(unit.hitSize * 0.1f), (float)(unit.hitSize * 0.5f * scl), (float)(rot + 180.0f));
                }
            }

            @Override
            public void update(Unit unit, StatusEntry entry) {
                super.update(unit, entry);
                if (unit.getDuration(accumulateFlag) >= this.getTimeThreshold(unit)) {
                    Effect eff = new Effect(60.0f, e -> {
                        Draw.color((Color)NHColor.darkEnrFront);
                        Lines.stroke((float)Mathf.clamp((float)(unit.hitSize / 40.0f), (float)0.5f, (float)2.5f));
                        float scl = e.fout((Interp)Interp.pow3Out);
                        Lines.circle((float)unit.x, (float)unit.y, (float)(unit.hitSize * 1.5f * scl));
                        Lines.circle((float)unit.x, (float)unit.y, (float)(unit.hitSize * 2.0f * scl));
                        Lines.stroke((float)Mathf.clamp((float)(unit.hitSize / 20.0f), (float)1.0f, (float)5.0f));
                        Lines.circle((float)unit.x, (float)unit.y, (float)(unit.hitSize * 1.75f * scl));
                        int step = (int)Mathf.clamp((float)(unit.hitSize / 4.0f), (float)8.0f, (float)20.0f);
                        for (int i = 0; i < step; ++i) {
                            float rot = (float)i * (360.0f / (float)step);
                            Tmp.v1.set(unit.hitSize * scl * 1.75f, 0.0f).rotate(rot).add((Position)unit);
                            Drawf.tri((float)Tmp.v1.x, (float)Tmp.v1.y, (float)(unit.hitSize * 0.1f), (float)(unit.hitSize * 0.5f * scl), (float)rot);
                            Drawf.tri((float)Tmp.v1.x, (float)Tmp.v1.y, (float)(unit.hitSize * 0.1f), (float)(unit.hitSize * 0.5f * scl), (float)(rot + 180.0f));
                        }
                    });
                    eff.at((Position)unit);
                    unit.apply(executionFlag, 60.0f);
                    unit.apply(immunityFlag, 90.0f);
                    unit.unapply(accumulateFlag);
                }
            }

            public float getTimeThreshold(Unit unit) {
                return Mathf.sqrt((float)unit.hitSize) * 100.0f;
            }
        };
        shieldFlag = new NHStatusEffect("shield-flag"){
            {
                this.color = Pal.techBlue;
                this.permanent = true;
                this.show = false;
            }
        };
        blackWall = new NHStatusEffect("black-wall"){

            public void applied(Unit unit, float time, boolean extend) {
                super.applied(unit, time, extend);
                if (!unit.hasEffect(immunityFlag)) {
                    unit.apply(accumulateFlag, unit.getDuration(accumulateFlag) + unit.getDuration(blackWall));
                }
                unit.unapply(blackWall);
            }
        };
    }

    public static Effect execution(float scale) {
        float xDst = scale * 1.25f;
        float yDst = scale / 5.0f;
        float step = scale / 100.0f;
        return new Effect(75.0f, e -> {
            float alpha = e.fout(Interp.reverse);
            Draw.color((Color)NHColor.darkEnrFront);
            rand.setSeed((long)e.id);
            Lines.stroke((float)(step / 1.5f));
            for (float i = 0.0f; i < xDst; i += step) {
                float x = NHInterp.upThenFastDown.apply(rand.random(1.0f)) * xDst;
                float y = rand.random(-yDst, yDst);
                float xScl = Interp.reverse.apply(x / xDst);
                float yScl = Interp.reverse.apply(Math.abs(y / yDst));
                Draw.alpha((float)(Interp.pow10Out.apply(alpha * xScl * yScl) * 0.5f));
                Tmp.v1.set(x * Interp.reverse.apply(e.fin((Interp)Interp.pow2Out)) - (float)rand.random(6, 10), y).rotate(e.rotation).add(e.x, e.y);
                Lines.lineAngle((float)Tmp.v1.x, (float)Tmp.v1.y, (float)e.rotation, (float)(step * 15.0f + rand.random(step * 0.5f) * e.fout()));
            }
        });
    }

    public static Effect blast(float scale) {
        float xDst = scale * 1.25f;
        Effect rect = new Effect(100.0f, xDst * 1.25f, e -> {
            Draw.blend((Blending)Blending.additive);
            float radius = e.fin((Interp)Interp.pow3Out) * xDst / 1.6f;
            Fill.light((float)e.x, (float)e.y, (int)4, (float)radius, (Color)Tmp.c1.set(e.color).a(e.fout((Interp)Interp.pow5Out)), (Color)Color.clear);
            Draw.blend();
        }).layer(110.15f);
        Effect rectOut = new Effect(90.0f, xDst * 1.25f, e -> {
            Draw.blend((Blending)Blending.additive);
            float radius = e.fin((Interp)Interp.pow3Out) * xDst / 1.6f;
            Fill.light((float)e.x, (float)e.y, (int)4, (float)radius, (Color)Color.clear, (Color)Tmp.c1.set(e.color).a(e.fout((Interp)Interp.pow5Out)));
            Draw.blend();
        }).layer(110.15f);
        return new MultiEffect(new Effect[]{rect, rectOut});
    }

    public static class NHStatusEffect
    extends StatusEffect {
        public Seq<StatusEffect> override = new Seq();

        public NHStatusEffect(String name) {
            super(name);
            this.outline = false;
        }

        public void update(Unit unit, StatusEntry entry) {
            super.update(unit, entry);
            this.override.each(arg_0 -> ((Unit)unit).unapply(arg_0));
        }

        public void setStats() {
            super.setStats();
            if (!this.override.isEmpty()) {
                for (StatusEffect e : this.override) {
                    this.stats.add(NHStats.overrides, e.emoji() + e, new Object[0]);
                }
            }
        }
    }
}

