/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.content;

import arc.func.Boolf;
import arc.func.Cons;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.content.StatusEffects;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Lightning;
import mindustry.entities.Sized;
import mindustry.entities.Units;
import mindustry.entities.abilities.MoveEffectAbility;
import mindustry.entities.bullet.ArtilleryBulletType;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.ContinuousFlameBulletType;
import mindustry.entities.bullet.EmpBulletType;
import mindustry.entities.bullet.ExplosionBulletType;
import mindustry.entities.bullet.FireBulletType;
import mindustry.entities.bullet.FlakBulletType;
import mindustry.entities.bullet.LaserBulletType;
import mindustry.entities.bullet.MissileBulletType;
import mindustry.entities.bullet.ShrapnelBulletType;
import mindustry.entities.effect.MultiEffect;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.Healthc;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import newhorizon.NHSetting;
import newhorizon.NewHorizon;
import newhorizon.content.NHColor;
import newhorizon.content.NHFx;
import newhorizon.content.NHItems;
import newhorizon.content.NHSounds;
import newhorizon.content.NHStatusEffects;
import newhorizon.content.NHUnitTypes;
import newhorizon.content.bullets.RaidBullets;
import newhorizon.expand.bullets.AccelBulletType;
import newhorizon.expand.bullets.AdaptedLightningBulletType;
import newhorizon.expand.bullets.EffectBulletType;
import newhorizon.expand.bullets.LightningLinkerBulletType;
import newhorizon.expand.bullets.ShieldBreakerType;
import newhorizon.expand.bullets.TrailFadeBulletType;
import newhorizon.expand.bullets.adapt.AdaptBulletType;
import newhorizon.expand.bullets.raid.BasicRaidBulletType;
import newhorizon.expand.entities.UltFire;
import newhorizon.expand.units.AdaptedMissileUnitType;
import newhorizon.expand.units.unitEntity.PesterEntity;
import newhorizon.util.feature.PosLightning;
import newhorizon.util.func.NHFunc;
import newhorizon.util.func.NHInterp;
import newhorizon.util.graphic.DrawFunc;
import newhorizon.util.graphic.EffectWrapper;
import newhorizon.util.graphic.OptionalMultiEffect;

public class NHBullets {
    public static String CIRCLE_BOLT;
    public static String STRIKE;
    public static String MISSILE_LARGE;
    public static String MINE_BULLET;
    public static UnitType airRaidMissile;
    public static UnitType skyMissile;
    public static BulletType lightningAir;
    public static BulletType artilleryHydro;
    public static BulletType artilleryMulti;
    public static BulletType artilleryNgt;
    public static BulletType artilleryFusion;
    public static BulletType artilleryPhase;
    public static BulletType shieldDestroyer;
    public static BulletType ancientArtilleryProjectile;
    public static BulletType ancientBall;
    public static BulletType ancientStd;
    public static BulletType pesterBlackHole;
    public static BulletType nuBlackHole;
    public static BulletType laugraBullet;
    public static BulletType collapserBullet;
    public static BulletType railGun1;
    public static BulletType railGun2;
    public static BulletType railGun3;
    public static BulletType declineProjectile;
    public static BulletType atomSeparator;
    public static BulletType blastEnergyPst;
    public static BulletType blastEnergyNgt;
    public static BulletType warperBullet;
    public static BulletType airRaidBomb;
    public static BulletType hyperBlastLinker;
    public static BulletType hyperBlast;
    public static BulletType arc_9000;
    public static BulletType eternity;
    public static BulletType arc_9000_frag;
    public static BulletType synchroZeta;
    public static BulletType synchroThermoPst;
    public static BulletType synchroFusionEnergy;
    public static BulletType synchroTitanium;
    public static BulletType synchroTungsten;
    public static BulletType missileTitanium;
    public static BulletType missileThorium;
    public static BulletType missileZeta;
    public static BulletType missileNormal;
    public static BulletType missileStrike;
    public static BulletType ultFireball;
    public static BulletType basicSkyFrag;
    public static BulletType annMissile;
    public static BulletType guardianBullet;
    public static BulletType guardianBulletLightningBall;
    public static BulletType saviourBullet;
    public static BulletType basicRaid;
    public static BulletType raidBulletType;

    private static void loadPriority() {
        arc_9000_frag = new FlakBulletType(3.75f, 200.0f){
            {
                this.lightColor = this.lightningColor = NHColor.darkEnrColor;
                this.trailColor = this.lightningColor;
                this.backColor = NHColor.darkEnrColor;
                this.frontColor = NHColor.darkEnrFront;
                this.trailLength = 14;
                this.trailWidth = 2.7f;
                this.trailRotation = true;
                this.trailInterval = 3.0f;
                this.trailEffect = NHFx.polyTrail(this.backColor, this.frontColor, 4.65f, 22.0f);
                this.trailChance = 0.0f;
                this.despawnEffect = this.hitEffect = NHFx.darkErnExplosion;
                this.knockback = 12.0f;
                this.lifetime = 90.0f;
                this.width = 17.0f;
                this.height = 42.0f;
                this.collidesTiles = false;
                this.splashDamageRadius = 60.0f;
                this.splashDamage = this.damage * 0.6f;
                this.lightning = 3;
                this.lightningLength = 8;
                this.smokeEffect = Fx.shootBigSmoke2;
                this.hitShake = 8.0f;
                this.status = StatusEffects.sapped;
                this.statusDuration = 600.0f;
            }
        };
        lightningAir = new BulletType(1.0E-4f, 0.0f){
            {
                this.lifetime = Fx.lightning.lifetime;
                this.hitEffect = Fx.hitLancer;
                this.despawnEffect = Fx.none;
                this.status = StatusEffects.shocked;
                this.statusDuration = 10.0f;
                this.hittable = false;
                this.collidesGround = false;
                this.lightColor = Color.white;
            }
        };
        shieldDestroyer = new ShieldBreakerType(22.0f, 0.0f, STRIKE, 3000.0f){
            {
                this.fragSpawnSpacing = 0.5f;
                this.backColor = this.lightColor = NHColor.ancientLightMid;
                this.lightningColor = this.lightColor;
                this.trailColor = this.lightColor;
                this.hitColor = this.lightColor;
                this.frontColor = NHColor.ancientLight;
                this.hittable = false;
                this.absorbable = false;
                this.collides = false;
                this.shrinkY = 0.0f;
                this.shrinkX = 0.0f;
                this.trailLength = 60;
                this.trailWidth = 2.2f;
                this.width = 18.0f;
                this.height = 55.0f;
                this.hitSoundVolume = 3.0f;
                this.hitSound = NHSounds.shock;
                this.suppressionRange = this.splashDamageRadius;
                this.suppressionDuration = 600.0f;
                this.scaledSplashDamage = true;
                this.splashDamageRadius = 240.0f;
                this.status = NHStatusEffects.entangled;
                this.statusDuration = 300.0f;
                this.despawnHit = true;
                this.trailEffect = NHFx.polyCloud(this.backColor, 30.0f, 8.0f, 18.0f, 4);
                this.trailChance = 0.4f;
                this.trailInterval = 2.0f;
                this.hitEffect = NHFx.square45_8_45;
                this.despawnEffect = new OptionalMultiEffect(NHFx.hitSparkHuge, NHFx.smoothColorCircle(this.hitColor, this.splashDamageRadius + 50.0f, 95.0f), NHFx.spreadOutSpark(160.0f, this.splashDamageRadius + 40.0f, 72, 4, 72.0f, 13.0f, 4.0f, (Interp)Interp.pow3Out));
            }
        };
        warperBullet = new AccelBulletType(4.0f, 20.0f, CIRCLE_BOLT){
            {
                this.shrinkY = 0.35f;
                this.shrinkX = 0.35f;
                this.buildingDamageMultiplier = 1.5f;
                this.keepVelocity = false;
                this.velocityBegin = 0.5f;
                this.velocityIncrease = 3.0f;
                this.accelerateBegin = 0.01f;
                this.accelerateEnd = 0.9f;
                this.homingPower = 0.0f;
                this.backColor = this.lightColor = NHColor.lightSkyBack;
                this.lightningColor = this.lightColor;
                this.trailColor = this.lightColor;
                this.hitColor = this.lightColor;
                this.frontColor = NHColor.lightSkyFront;
                this.splashDamageRadius = 20.0f;
                this.splashDamage = this.damage * 0.3f;
                this.height = 8.0f;
                this.width = 8.0f;
                this.trailChance = 0.2f;
                this.trailParam = 1.75f;
                this.trailEffect = NHFx.trailToGray;
                this.lifetime = 120.0f;
                this.collidesAir = false;
                this.hitSound = Sounds.explosion;
                this.hitEffect = NHFx.square45_4_45;
                this.shootEffect = NHFx.circleSplash;
                this.smokeEffect = Fx.shootBigSmoke;
                this.despawnEffect = NHFx.crossBlast(this.hitColor, 50.0f);
            }
        };
        hyperBlastLinker = new LightningLinkerBulletType(){
            {
                this.effectLightningChance = 0.15f;
                this.damage = 220.0f;
                this.lightningColor = this.hitColor = NHColor.thermoPst;
                this.lightColor = this.hitColor;
                this.trailColor = this.hitColor;
                this.backColor = this.hitColor;
                this.size = 8.0f;
                this.frontColor = NHColor.thermoPst.cpy().lerp(Color.white, 0.25f);
                this.range = 200.0f;
                this.trailWidth = 8.0f;
                this.trailLength = 20;
                this.speed = 5.0f;
                this.linkRange = 280.0f;
                this.maxHit = 8;
                this.drag = 0.085f;
                this.splashDamageRadius = 120.0f;
                this.splashDamage = this.lightningDamage = this.damage / 4.0f;
                this.lifetime = 50.0f;
                this.scaleLife = false;
                this.despawnEffect = NHFx.lightningHitLarge(this.hitColor);
                this.hitEffect = new OptionalMultiEffect(NHFx.hitSpark(this.backColor, 65.0f, 22, this.splashDamageRadius, 4.0f, 16.0f), NHFx.blast(this.backColor, this.splashDamageRadius / 2.0f));
                this.shootEffect = NHFx.hitSpark(this.backColor, 45.0f, 12, 60.0f, 3.0f, 8.0f);
                this.smokeEffect = NHFx.hugeSmokeGray;
            }
        };
        hyperBlast = new BasicBulletType(3.3f, 400.0f){
            {
                this.lifetime = 60.0f;
                this.trailLength = 15;
                this.drawSize = 250.0f;
                this.drag = 0.0075f;
                this.despawnEffect = this.hitEffect = NHFx.lightningHitLarge(NHItems.thermoCorePositive.color);
                this.knockback = 12.0f;
                this.width = 15.0f;
                this.height = 37.0f;
                this.splashDamageRadius = 40.0f;
                this.splashDamage = this.lightningDamage = this.damage * 0.75f;
                this.lightningColor = this.trailColor = NHItems.thermoCorePositive.color;
                this.lightColor = this.trailColor;
                this.backColor = this.trailColor;
                this.frontColor = Color.white;
                this.lightning = 3;
                this.lightningLength = 8;
                this.smokeEffect = Fx.shootBigSmoke2;
                this.trailChance = 0.6f;
                this.trailEffect = NHFx.trailToGray;
                this.hitShake = 3.0f;
            }
        };
    }

    public static void load() {
        CIRCLE_BOLT = NewHorizon.name("circle-bolt");
        STRIKE = NewHorizon.name("strike");
        NHBullets.loadPriority();
        raidBulletType = new BasicRaidBulletType(){
            {
                this.speed = 7.0f;
                this.damage = 1000.0f;
                this.lifetime = 200.0f;
                this.trailEffect = NHFx.hugeTrail;
                this.trailParam = 6.0f;
                this.trailChance = 0.2f;
                this.trailInterval = 3.0f;
                this.trailWidth = 5.0f;
                this.trailLength = 55;
                this.trailInterp = Interp.slope;
                this.splashDamage = this.damage;
                this.splashDamageRadius = 120.0f;
                this.splashDamagePierce = false;
                this.scaledSplashDamage = true;
                this.despawnHit = true;
                this.collides = false;
                this.shrinkX = 0.33f;
                this.shrinkY = 0.33f;
                this.width = 17.0f;
                this.height = 55.0f;
                this.hitShake = 12.0f;
                this.despawnShake = 12.0f;
                this.hitEffect = new MultiEffect(new Effect[]{NHFx.square(this.hitColor, 200.0f, 20, this.splashDamageRadius + 80.0f, 10.0f), NHFx.lightningHitLarge, NHFx.hitSpark(this.hitColor, 130.0f, 85, this.splashDamageRadius * 1.5f, 2.2f, 10.0f), NHFx.subEffect(140.0f, this.splashDamageRadius + 12.0f, 33, 34.0f, (Interp)Interp.pow2Out, (i, x, y, rot, fin) -> {
                    float fout = Interp.pow2Out.apply(1.0f - fin);
                    for (int s : Mathf.signs) {
                        Drawf.tri((float)x, (float)y, (float)(12.0f * fout), (float)(45.0f * Mathf.curve((float)fin, (float)0.0f, (float)0.1f) * NHFx.fout(fin, 0.25f)), (float)(rot + (float)(s * 90)));
                    }
                })});
                this.despawnEffect = NHFx.circleOut(145.0f, this.splashDamageRadius + 15.0f, 3.0f);
                this.shootEffect = EffectWrapper.wrap(NHFx.missileShoot, this.hitColor);
                this.smokeEffect = NHFx.instShoot(this.hitColor, this.frontColor);
                this.despawnSound = this.hitSound = Sounds.explosion;
            }
        };
        basicRaid = new BasicRaidBulletType();
        artilleryHydro = new ArtilleryBulletType(3.0f, 120.0f){
            {
                this.scaledSplashDamage = true;
                this.splashDamage = this.damage;
                this.splashDamageRadius = 16.0f;
                this.inaccuracy = 4.0f;
                this.reloadMultiplier = 1.3f;
                this.lightningColor = this.trailColor = Pal.techBlue;
                this.lightColor = this.trailColor;
                this.hitColor = this.trailColor;
                this.backColor = this.trailColor;
                this.frontColor = NHColor.lightSkyFront;
                this.sprite = MINE_BULLET;
                this.height = 10.0f;
                this.width = 10.0f;
                this.shrinkY = 0.2f;
                this.shrinkX = 0.2f;
                this.trailWidth = 2.1f;
                this.trailLength = 16;
                this.trailInterp = Interp.slope;
                this.shootEffect = NHFx.shootCircleSmall(this.backColor);
                this.smokeEffect = Fx.shootSmokeDisperse;
                this.despawnEffect = EffectWrapper.wrap(NHFx.circleOut, this.backColor, this.splashDamageRadius + 5.0f);
                this.hitEffect = NHFx.circleSplash;
                this.trailParam = 1.2f;
            }
        };
        artilleryMulti = new ArtilleryBulletType(6.0f, 160.0f){
            {
                this.scaledSplashDamage = true;
                this.splashDamage = this.damage;
                this.splashDamageRadius = 8.0f;
                this.inaccuracy = -1.0f;
                this.lightningColor = this.trailColor = NHItems.multipleSteel.color;
                this.lightColor = this.trailColor;
                this.hitColor = this.trailColor;
                this.backColor = this.trailColor;
                this.frontColor = NHColor.lightSkyFront;
                this.sprite = MINE_BULLET;
                this.height = 8.0f;
                this.width = 8.0f;
                this.shrinkY = 0.2f;
                this.shrinkX = 0.2f;
                this.trailWidth = 1.8f;
                this.trailLength = 10;
                this.trailInterp = Interp.slope;
                this.shootEffect = NHFx.shootCircleSmall(this.backColor);
                this.smokeEffect = Fx.shootSmokeDisperse;
                this.despawnEffect = NHFx.square45_4_45;
                this.hitEffect = EffectWrapper.wrap(NHFx.lightningHitSmall, this.backColor, 10.0f);
                this.trailParam = 1.0f;
                this.fragBullet = new ShrapnelBulletType(){
                    {
                        this.lifetime = 18.0f;
                        this.length = 25.0f;
                        this.damage = 180.0f;
                        this.serrations = 2;
                        this.status = StatusEffects.shocked;
                        this.statusDuration = 60.0f;
                        this.fromColor = NHColor.lightSkyFront;
                        this.toColor = NHColor.lightSkyBack;
                        this.serrationSpaceOffset = 40.0f;
                        this.width = 4.0f;
                        this.despawnEffect = this.hitEffect = Fx.none;
                    }
                };
                this.fragBullets = 2;
                this.fragRandomSpread = 0.0f;
                this.fragSpread = 72.0f;
                this.fragAngle = 36.0f;
            }
        };
        artilleryNgt = new TrailFadeBulletType(2.0f, 250.0f){
            {
                this.tracers = 1;
                this.tracerStroke = 1.2f;
                this.tracerSpacing = 4.0f;
                this.tracerUpdateSpacing = 2.3f;
                this.hitBlinkTrail = false;
                this.reloadMultiplier = 0.8f;
                this.collidesTiles = false;
                this.collides = false;
                this.collidesAir = false;
                this.scaleLife = true;
                this.hitShake = 1.0f;
                this.hitSound = Sounds.explosion;
                this.scaledSplashDamage = true;
                this.splashDamage = this.damage;
                this.splashDamageRadius = 55.0f;
                this.inaccuracy = 2.0f;
                this.lightning = 2;
                this.lightningLength = 3;
                this.lightningLengthRand = 6;
                this.bulletInterval = 3.0f;
                this.intervalBullets = 1;
                this.intervalBullet = new AdaptedLightningBulletType(){
                    {
                        this.lightColor = this.lightningColor = NHItems.thermoCoreNegative.color;
                        this.lightningLength = 3;
                        this.lightningLengthRand = 5;
                    }
                };
                this.lightningColor = this.trailColor = NHItems.thermoCoreNegative.color;
                this.lightColor = this.trailColor;
                this.hitColor = this.trailColor;
                this.backColor = this.trailColor;
                this.frontColor = Color.white;
                this.sprite = MINE_BULLET;
                this.height = 14.0f;
                this.width = 14.0f;
                this.shrinkY = 0.2f;
                this.shrinkX = 0.2f;
                this.shrinkInterp = Interp.slope;
                this.trailWidth = 2.6f;
                this.trailLength = 22;
                this.trailInterp = Interp.slope;
                this.shootEffect = NHFx.shootCircleSmall(this.backColor);
                this.smokeEffect = Fx.shootSmokeDisperse;
                this.despawnEffect = NHFx.blast(this.backColor, 40.0f);
                this.hitEffect = NHFx.hitSparkHuge;
                this.fragBullet = new ShrapnelBulletType(){
                    {
                        this.lifetime = 18.0f;
                        this.length = 22.0f;
                        this.damage = 50.0f;
                        this.serrations = 2;
                        this.status = StatusEffects.shocked;
                        this.statusDuration = 60.0f;
                        this.fromColor = NHColor.lightSkyFront;
                        this.toColor = NHColor.lightSkyBack;
                        this.serrationSpaceOffset = 40.0f;
                        this.width = 5.0f;
                        this.despawnEffect = this.hitEffect = Fx.none;
                    }
                };
                this.fragBullets = 4;
                this.fragRandomSpread = 0.0f;
                this.fragSpread = 90.0f;
                this.fragAngle = 45.0f;
            }
        };
        artilleryFusion = new ArtilleryBulletType(6.0f, 180.0f){
            {
                this.scaledSplashDamage = true;
                this.splashDamage = this.damage;
                this.splashDamageRadius = 63.0f;
                this.inaccuracy = 3.0f;
                this.lightningColor = this.trailColor = NHItems.fusionEnergy.color;
                this.lightColor = this.trailColor;
                this.hitColor = this.trailColor;
                this.backColor = this.trailColor;
                this.frontColor = Color.white;
                this.sprite = MINE_BULLET;
                this.height = 10.0f;
                this.width = 10.0f;
                this.shrinkY = 0.2f;
                this.shrinkX = 0.2f;
                this.trailWidth = 2.0f;
                this.trailLength = 10;
                this.trailInterp = Interp.slope;
                this.shootEffect = NHFx.shootCircleSmall(this.backColor);
                this.smokeEffect = Fx.shootSmokeDisperse;
                this.despawnEffect = NHFx.blast(this.backColor, this.splashDamageRadius * 0.66f);
                this.hitEffect = Fx.none;
                this.trailParam = 1.15f;
                this.fragBullets = 2;
                this.fragRandomSpread = 0.0f;
                this.fragSpread = 72.0f;
                this.fragAngle = 36.0f;
                this.incendAmount = 2;
                this.incendChance = 0.7f;
                this.incendSpread = this.splashDamageRadius;
            }
        };
        artilleryPhase = new AccelBulletType(6.0f, 90.0f){
            {
                this.velocityBegin = 3.0f;
                this.velocityIncrease = 9.0f;
                this.accelerateBegin = 0.075f;
                this.accelerateEnd = 0.77f;
                this.lifetime = 80.0f;
                this.pierceCap = 2;
                this.inaccuracy = -1.0f;
                this.lightningColor = this.trailColor = Items.phaseFabric.color;
                this.lightColor = this.trailColor;
                this.hitColor = this.trailColor;
                this.backColor = this.trailColor;
                this.frontColor = Color.white;
                this.status = NHStatusEffects.emp3;
                this.statusDuration = 90.0f;
                this.shootEffect = EffectWrapper.wrap(NHFx.shootLine(30.0f, 30.0f), this.backColor);
                this.smokeEffect = Fx.shootSmokeDisperse;
                this.hitEffect = NHFx.hitSparkLarge;
                this.despawnEffect = NHFx.square45_4_45;
                this.ammoMultiplier = 6.0f;
                this.reloadMultiplier = 0.2f;
                this.buildingDamageMultiplier = 0.75f;
                this.collidesAir = false;
                this.width = 12.0f;
                this.height = 33.0f;
                this.trailWidth = 2.6f;
                this.trailLength = 10;
                this.trailEffect = NHFx.instTrail(this.backColor, 32.0f, false);
                this.trailParam = 4.0f;
                this.trailInterval = 4.0f;
            }

            public void hitTile(Bullet b, Building build, float x, float y, float initialHealth, boolean direct) {
                super.hitTile(b, build, x, y, initialHealth, direct);
                build.applySlowdown(0.2f, this.statusDuration);
                build.applyHealSuppression(this.statusDuration);
            }
        };
        ancientArtilleryProjectile = new ShieldBreakerType(7.0f, 6000.0f, MISSILE_LARGE, 7000.0f){
            {
                this.lightningColor = this.hitColor = NHColor.ancientLightMid;
                this.lightColor = this.hitColor;
                this.trailColor = this.hitColor;
                this.backColor = this.hitColor;
                this.frontColor = NHColor.ancientLight;
                this.trailEffect = NHFx.hugeTrail;
                this.trailParam = 6.0f;
                this.trailChance = 0.2f;
                this.trailInterval = 3.0f;
                this.lifetime = 200.0f;
                this.scaleLife = true;
                this.trailWidth = 5.0f;
                this.trailLength = 55;
                this.trailInterp = Interp.slope;
                this.lightning = 6;
                this.lightningLengthRand = 22;
                this.lightningLength = 22;
                this.splashDamage = this.damage;
                this.lightningDamage = this.damage / 15.0f;
                this.splashDamageRadius = 120.0f;
                this.scaledSplashDamage = true;
                this.despawnHit = true;
                this.collides = false;
                this.shrinkX = 0.33f;
                this.shrinkY = 0.33f;
                this.width = 17.0f;
                this.height = 55.0f;
                this.hitShake = 12.0f;
                this.despawnShake = 12.0f;
                this.hitEffect = new MultiEffect(new Effect[]{NHFx.square(this.hitColor, 200.0f, 20, this.splashDamageRadius + 80.0f, 10.0f), NHFx.lightningHitLarge, NHFx.hitSpark(this.hitColor, 130.0f, 85, this.splashDamageRadius * 1.5f, 2.2f, 10.0f), NHFx.subEffect(140.0f, this.splashDamageRadius + 12.0f, 33, 34.0f, (Interp)Interp.pow2Out, (i, x, y, rot, fin) -> {
                    float fout = Interp.pow2Out.apply(1.0f - fin);
                    for (int s : Mathf.signs) {
                        Drawf.tri((float)x, (float)y, (float)(12.0f * fout), (float)(45.0f * Mathf.curve((float)fin, (float)0.0f, (float)0.1f) * NHFx.fout(fin, 0.25f)), (float)(rot + (float)(s * 90)));
                    }
                })});
                this.despawnEffect = NHFx.circleOut(145.0f, this.splashDamageRadius + 15.0f, 3.0f);
                this.shootEffect = EffectWrapper.wrap(NHFx.missileShoot, this.hitColor);
                this.smokeEffect = NHFx.instShoot(this.hitColor, this.frontColor);
                this.despawnSound = this.hitSound = Sounds.explosion;
                this.fragBullets = 22;
                this.fragBullet = new BasicBulletType(2.0f, 300.0f, CIRCLE_BOLT){
                    {
                        super(arg0, arg1, arg2);
                        this.height = 10.0f;
                        this.width = 10.0f;
                        this.shrinkX = 0.7f;
                        this.shrinkY = 0.7f;
                        this.lightningColor = this.hitColor = NHColor.ancientLightMid;
                        this.lightColor = this.hitColor;
                        this.trailColor = this.hitColor;
                        this.backColor = this.hitColor;
                        this.frontColor = NHColor.ancientLight;
                        this.trailEffect = Fx.missileTrail;
                        this.trailParam = 3.5f;
                        this.splashDamage = 80.0f;
                        this.splashDamageRadius = 40.0f;
                        this.lifetime = 18.0f;
                        this.lightning = 2;
                        this.lightningLengthRand = 4;
                        this.lightningLength = 4;
                        this.lightningDamage = 30.0f;
                        this.hitSoundVolume /= 2.2f;
                        this.hitShake = 4.0f;
                        this.despawnShake = 4.0f;
                        this.despawnSound = this.hitSound = Sounds.explosionDull;
                        this.trailWidth = 5.0f;
                        this.trailLength = 35;
                        this.trailInterp = Interp.slope;
                        this.despawnEffect = NHFx.blast(this.hitColor, 40.0f);
                        this.hitEffect = NHFx.hitSparkHuge;
                    }
                };
                this.fragLifeMax = 5.0f;
                this.fragLifeMin = 1.5f;
                this.fragVelocityMax = 2.0f;
                this.fragVelocityMin = 0.35f;
            }
        };
        ancientStd = new AccelBulletType(2.85f, 120.0f){
            {
                this.frontColor = NHColor.ancientLight;
                this.hitColor = this.lightColor = NHColor.ancient;
                this.lightningColor = this.lightColor;
                this.backColor = this.lightColor;
                this.trailColor = NHColor.ancientLightMid;
                this.lifetime = 126.0f;
                this.knockback = 2.0f;
                this.ammoMultiplier = 8.0f;
                this.accelerateBegin = 0.1f;
                this.accelerateEnd = 0.85f;
                this.status = NHStatusEffects.entangled;
                this.statusDuration = 30.0f;
                this.despawnSound = this.hitSound = Sounds.explosionDull;
                this.hitSoundVolume /= 4.0f;
                this.velocityBegin = 8.0f;
                this.velocityIncrease = -5.0f;
                this.homingDelay = 20.0f;
                this.homingPower = 0.05f;
                this.homingRange = 120.0f;
                this.pierceBuilding = true;
                this.despawnHit = true;
                this.despawnShake = 5.0f;
                this.hitShake = 5.0f;
                this.lightning = 1;
                this.lightningCone = 360.0f;
                this.lightningLengthRand = 12;
                this.lightningLength = 4;
                this.width = 10.0f;
                this.height = 35.0f;
                this.pierceCap = 8;
                this.shrinkY = 0.0f;
                this.shrinkX = 0.0f;
                this.lightningDamage = this.damage * 0.85f;
                this.hitEffect = NHFx.hitSparkLarge;
                this.despawnEffect = NHFx.square45_6_45;
                this.shootEffect = NHFx.shootCircleSmall(this.backColor);
                this.smokeEffect = NHFx.hugeSmokeGray;
                this.trailEffect = NHFx.trailToGray;
                this.trailLength = 15;
                this.trailWidth = 2.0f;
                this.drawSize = 300.0f;
            }
        };
        ancientBall = new AccelBulletType(2.85f, 240.0f, MINE_BULLET){
            {
                this.frontColor = Color.white;
                this.hitColor = this.lightColor = NHColor.ancient;
                this.trailColor = this.lightColor;
                this.lightningColor = this.lightColor;
                this.backColor = this.lightColor;
                this.lifetime = 95.0f;
                this.spin = 3.0f;
                this.status = NHStatusEffects.entangled;
                this.statusDuration = 300.0f;
                this.accelerateBegin = 0.15f;
                this.accelerateEnd = 0.95f;
                this.despawnSound = this.hitSound = Sounds.explosionTitan;
                this.velocityBegin = 8.0f;
                this.velocityIncrease = -7.5f;
                this.collides = false;
                this.scaledSplashDamage = true;
                this.scaleLife = true;
                this.despawnHit = true;
                this.despawnShake = 18.0f;
                this.hitShake = 18.0f;
                this.lightning = 4;
                this.lightningCone = 360.0f;
                this.lightningLengthRand = 12;
                this.lightningLength = 10;
                this.height = 30.0f;
                this.width = 30.0f;
                this.shrinkY = 0.0f;
                this.shrinkX = 0.0f;
                this.splashDamageRadius = 120.0f;
                this.splashDamage = 800.0f;
                this.lightningDamage = this.damage * 0.85f;
                this.hitEffect = NHFx.hitSparkLarge;
                this.despawnEffect = NHFx.square45_6_45;
                this.trailEffect = NHFx.trailToGray;
                this.trailLength = 15;
                this.trailWidth = 5.0f;
                this.drawSize = 300.0f;
                this.shootEffect = NHFx.instShoot(this.backColor, this.frontColor);
                this.smokeEffect = NHFx.lightningHitLarge;
                this.hitEffect = new Effect(90.0f, e -> {
                    Draw.color((Color)this.backColor, (Color)this.frontColor, (float)(e.fout() * 0.7f));
                    Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * this.height / 1.25f));
                    Lines.stroke((float)(e.fout() * 3.0f));
                    Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 80.0f));
                    Lines.stroke((float)(e.fout() * 2.0f));
                    Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 50.0f));
                    Angles.randLenVectors((long)e.id, (int)35, (float)(18.0f + 100.0f * e.fin()), (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(e.fslope() * 12.0f + 4.0f)));
                    Draw.color((Color)this.frontColor);
                    Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * this.height / 1.75f));
                });
                this.despawnEffect = new OptionalMultiEffect(NHFx.hitSparkHuge, NHFx.instHit(this.backColor, 3, 120.0f));
                this.fragBullets = 3;
                this.fragBullet = new LaserBulletType(){
                    {
                        this.length = 460.0f;
                        this.damage = 4060.0f;
                        this.width = 45.0f;
                        this.status = NHStatusEffects.entangled;
                        this.statusDuration = 120.0f;
                        this.lifetime = 65.0f;
                        this.splashDamage = 800.0f;
                        this.splashDamageRadius = 120.0f;
                        this.hitShake = 18.0f;
                        this.lightningSpacing = 35.0f;
                        this.lightningLength = 8;
                        this.lightningDelay = 1.1f;
                        this.lightningLengthRand = 15;
                        this.lightningDamage = 450.0f;
                        this.lightningAngleRand = 40.0f;
                        this.largeHit = true;
                        this.scaledSplashDamage = true;
                        this.hitColor = this.lightColor = Items.surgeAlloy.color.cpy().lerp(Pal.accent, 0.055f);
                        this.trailColor = this.lightColor;
                        this.lightningColor = this.lightColor;
                        this.despawnHit = false;
                        this.hitEffect = new Effect(90.0f, 500.0f, e -> {
                            Draw.color((Color)backColor, (Color)frontColor, (float)(e.fout() * 0.7f));
                            Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * height / 1.55f));
                            Lines.stroke((float)(e.fout() * 3.0f));
                            Lines.circle((float)e.x, (float)e.y, (float)(e.fin((Interp)Interp.pow3Out) * 80.0f));
                            Angles.randLenVectors((long)e.id, (int)18, (float)(18.0f + 100.0f * e.fin()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 7.0f)));
                            Draw.color((Color)frontColor);
                            Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * height / 2.0f));
                        });
                        this.sideAngle = 15.0f;
                        this.sideWidth = 0.0f;
                        this.sideLength = 0.0f;
                        this.colors = new Color[]{this.hitColor.cpy().a(0.2f), this.hitColor, Color.white};
                    }

                    public void despawned(Bullet b) {
                    }

                    public void init(Bullet b) {
                        Vec2 p = new Vec2().set(NHFunc.collideBuildOnLength(b.team, b.x, b.y, this.length, b.rotation(), (Boolf<Building>)((Boolf)bu -> true)));
                        float resultLength = b.dst((Position)p);
                        float rot = b.rotation();
                        b.fdata = resultLength;
                        this.laserEffect.at(b.x, b.y, rot, (Object)Float.valueOf(resultLength * 0.75f));
                        if (this.lightningSpacing > 0.0f) {
                            int idx = 0;
                            for (float i = 0.0f; i <= resultLength; i += this.lightningSpacing) {
                                float cx = b.x + Angles.trnsx((float)rot, (float)i);
                                float cy = b.y + Angles.trnsy((float)rot, (float)i);
                                int f = idx++;
                                for (int s : Mathf.signs) {
                                    Time.run((float)((float)f * this.lightningDelay), () -> {
                                        if (b.isAdded() && b.type == this) {
                                            Lightning.create((Bullet)b, (Color)this.lightningColor, (float)(this.lightningDamage < 0.0f ? this.damage : this.lightningDamage), (float)cx, (float)cy, (float)(rot + (float)(90 * s) + Mathf.range((float)this.lightningAngleRand)), (int)(this.lightningLength + Mathf.random((int)this.lightningLengthRand)));
                                        }
                                    });
                                }
                            }
                        }
                    }

                    public void draw(Bullet b) {
                        float realLength = b.fdata;
                        float f = Mathf.curve((float)b.fin(), (float)0.0f, (float)0.2f);
                        float baseLen = realLength * f;
                        float cwidth = this.width;
                        float compound = 1.0f;
                        Tmp.v1.trns(b.rotation(), baseLen);
                        for (Color color : this.colors) {
                            Draw.color((Color)color);
                            Lines.stroke((float)((cwidth *= this.lengthFalloff) * b.fout()));
                            Lines.lineAngle((float)b.x, (float)b.y, (float)b.rotation(), (float)baseLen, (boolean)false);
                            Fill.circle((float)(Tmp.v1.x + b.x), (float)(Tmp.v1.y + b.y), (float)(Lines.getStroke() * 2.2f));
                            Fill.circle((float)b.x, (float)b.y, (float)(1.0f * cwidth * b.fout()));
                            compound *= this.lengthFalloff;
                        }
                        Draw.reset();
                        Drawf.light((float)b.x, (float)b.y, (float)(b.x + Tmp.v1.x), (float)(b.y + Tmp.v1.y), (float)(this.width * 1.4f * b.fout()), (Color)this.colors[0], (float)0.6f);
                    }
                };
            }
        };
        pesterBlackHole = new EffectBulletType(120.0f){
            {
                this.despawnHit = true;
                this.splashDamageRadius = 240.0f;
                this.lightningDamage = 2000.0f;
                this.lightning = 2;
                this.lightningLength = 4;
                this.lightningLengthRand = 8;
                this.scaledSplashDamage = true;
                this.collidesTiles = true;
                this.collidesGround = true;
                this.collidesAir = true;
                this.splashDamage = 3800.0f;
                this.damage = 10000.0f;
            }

            @Override
            public void draw(Bullet b) {
                if (!(b.data instanceof Seq)) {
                    return;
                }
                Seq data = (Seq)b.data;
                Draw.color((Color)b.team.color, (Color)Color.white, (float)(b.fin() * 0.7f));
                Draw.alpha((float)(b.fin((Interp)Interp.pow3Out) * 1.1f));
                Lines.stroke((float)(2.0f * b.fout()));
                for (Sized s : data) {
                    if (s instanceof Building) {
                        Fill.square((float)s.getX(), (float)s.getY(), (float)(s.hitSize() / 2.0f));
                        continue;
                    }
                    Lines.spikes((float)s.getX(), (float)s.getY(), (float)(s.hitSize() * (0.5f + b.fout() * 2.0f)), (float)(s.hitSize() / 2.0f * b.fslope() + 12.0f * b.fin()), (int)4, (float)45.0f);
                }
                Drawf.light((float)b.x, (float)b.y, (float)b.fdata, (Color)b.team.color, (float)(0.3f + b.fin() * 0.8f));
            }

            public void hitT(Sized target, Entityc o, Team team, float x, float y) {
                for (int i = 0; i < this.lightning; ++i) {
                    Lightning.create((Team)team, (Color)team.color, (float)this.lightningDamage, (float)x, (float)y, (float)Mathf.random((int)360), (int)(this.lightningLength + Mathf.random((int)this.lightningLengthRand)));
                }
                if (target instanceof Unit && ((Unit)target).health > 1000.0f) {
                    PesterEntity.hitter.create(o, team, x, y, 0.0f);
                }
            }

            public void update(Bullet b) {
                super.update(b);
                if (!(b.data instanceof Seq)) {
                    return;
                }
                Seq data = (Seq)b.data;
                data.remove(d -> !((Healthc)d).isValid());
            }

            public void despawned(Bullet b) {
                super.despawned(b);
                float rad = 33.0f;
                Vec2 v = new Vec2().set((Position)b);
                Team t = b.team;
                for (int i = 0; i < 5; ++i) {
                    Time.run((float)((float)i * 0.35f + (float)Mathf.random((int)2)), () -> {
                        Tmp.v1.rnd(rad / 3.0f).scl(Mathf.random());
                        NHFx.shuttle.at(v.x + Tmp.v1.x, v.y + Tmp.v1.y, Tmp.v1.angle(), t.color, (Object)Float.valueOf(Mathf.random((float)(rad * 3.0f), (float)(rad * 12.0f))));
                    });
                }
                if (!(b.data instanceof Seq)) {
                    return;
                }
                Entityc o = b.owner();
                Seq data = (Seq)b.data;
                for (Sized s : data) {
                    float size = Math.min(s.hitSize(), 85.0f);
                    Time.run((float)Mathf.random((int)44), () -> {
                        if (Mathf.chance((double)0.32) || data.size < 8) {
                            NHFx.shuttle.at(s.getX(), s.getY(), 45.0f, t.color, (Object)Float.valueOf(Mathf.random((float)(size * 3.0f), (float)(size * 12.0f))));
                        }
                        this.hitT(s, o, t, s.getX(), s.getY());
                    });
                }
                this.createSplashDamage(b, b.x, b.y);
            }

            public void init(Bullet b) {
                super.init(b);
                if (!(b.data instanceof Float)) {
                    return;
                }
                float fdata = ((Float)b.data()).floatValue();
                Seq data = new Seq();
                Vars.indexer.eachBlock(null, b.x, b.y, fdata, bu -> bu.team != b.team, arg_0 -> ((Seq)data).add(arg_0));
                Groups.unit.intersect(b.x - fdata / 2.0f, b.y - fdata / 2.0f, fdata, fdata, u -> {
                    if (u.team != b.team) {
                        data.add(u);
                    }
                });
                b.data = data;
                NHFx.circleOut.at(b.x, b.y, fdata * 1.25f, b.team.color);
            }
        };
        nuBlackHole = new EffectBulletType(20.0f){
            {
                this.despawnHit = true;
                this.hitColor = NHColor.ancientLightMid;
                this.splashDamageRadius = 36.0f;
                this.lightningDamage = 2000.0f;
                this.lightning = 2;
                this.lightningLength = 4;
                this.lightningLengthRand = 8;
                this.scaledSplashDamage = true;
                this.collidesTiles = true;
                this.collidesGround = true;
                this.collidesAir = true;
                this.splashDamage = 0.0f;
                this.damage = 10000.0f;
            }

            @Override
            public void draw(Bullet b) {
                if (!(b.data instanceof Seq)) {
                    return;
                }
                Seq data = (Seq)b.data;
                Draw.color((Color)b.team.color, (Color)Color.white, (float)(b.fin() * 0.7f));
                Draw.alpha((float)(b.fin((Interp)Interp.pow3Out) * 1.1f));
                Lines.stroke((float)(2.0f * b.fout()));
                for (Sized s : data) {
                    if (s instanceof Building) {
                        Fill.square((float)s.getX(), (float)s.getY(), (float)(s.hitSize() / 2.0f));
                        continue;
                    }
                    Lines.spikes((float)s.getX(), (float)s.getY(), (float)(s.hitSize() * (0.5f + b.fout() * 2.0f)), (float)(s.hitSize() / 2.0f * b.fslope() + 12.0f * b.fin()), (int)4, (float)45.0f);
                }
                Drawf.light((float)b.x, (float)b.y, (float)b.fdata, (Color)this.hitColor, (float)(0.3f + b.fin() * 0.8f));
            }

            public void hitT(Entityc o, Team team, float x, float y) {
                for (int i = 0; i < this.lightning; ++i) {
                    Lightning.create((Team)team, (Color)team.color, (float)this.lightningDamage, (float)x, (float)y, (float)Mathf.random((int)360), (int)(this.lightningLength + Mathf.random((int)this.lightningLengthRand)));
                }
                PesterEntity.hitter.create(o, team, x, y, 0.0f, 3000.0f, 1.0f, 1.0f, null);
            }

            public void update(Bullet b) {
                super.update(b);
                if (!(b.data instanceof Seq) || b.timer(0, 5.0f)) {
                    return;
                }
                Seq data = (Seq)b.data;
                data.remove(d -> !((Healthc)d).isValid());
            }

            public void despawned(Bullet b) {
                super.despawned(b);
                float rad = 33.0f;
                if (!(b.data instanceof Seq)) {
                    return;
                }
                Entityc o = b.owner();
                Seq data = (Seq)b.data;
                for (Sized s : data) {
                    float size = Math.min(s.hitSize(), 75.0f);
                    if (Mathf.chance((double)0.32) || data.size < 8) {
                        float sd = Mathf.random((float)(size * 3.0f), (float)(size * 12.0f));
                        NHFx.shuttleDark.at(s.getX() + Mathf.range((float)size), s.getY() + Mathf.range((float)size), 45.0f, b.team.color, (Object)Float.valueOf(sd));
                    }
                    this.hitT(o, b.team, s.getX(), s.getY());
                }
                this.createSplashDamage(b, b.x, b.y);
            }

            public void init(Bullet b) {
                super.init(b);
                b.fdata = this.splashDamageRadius;
                Seq data = new Seq();
                Vars.indexer.eachBlock(null, b.x, b.y, b.fdata, bu -> bu.team != b.team, arg_0 -> ((Seq)data).add(arg_0));
                Groups.unit.intersect(b.x - b.fdata / 2.0f, b.y - b.fdata / 2.0f, b.fdata, b.fdata, u -> {
                    if (u.team != b.team) {
                        data.add(u);
                    }
                });
                b.data = data;
            }
        };
        collapserBullet = new LightningLinkerBulletType(){
            {
                this.effectLightningChance = 0.15f;
                this.damage = 200.0f;
                this.lightningColor = this.hitColor = NHColor.thurmixRed;
                this.lightColor = this.hitColor;
                this.trailColor = this.hitColor;
                this.backColor = this.hitColor;
                this.size = 10.0f;
                this.frontColor = NHColor.thurmixRedLight;
                this.range = 600.0f;
                this.spreadEffect = Fx.none;
                this.trailWidth = 8.0f;
                this.trailLength = 20;
                this.speed = 6.0f;
                this.linkRange = 280.0f;
                this.maxHit = 12;
                this.drag = 0.0065f;
                this.hitSound = Sounds.explosion;
                this.splashDamageRadius = 60.0f;
                this.splashDamage = this.lightningDamage = this.damage / 3.0f;
                this.lifetime = 130.0f;
                this.despawnEffect = NHFx.lightningHitLarge(this.hitColor);
                this.hitEffect = NHFx.sharpBlast(this.hitColor, this.frontColor, 35.0f, this.splashDamageRadius * 1.25f);
                this.shootEffect = NHFx.hitSpark(this.backColor, 45.0f, 12, 60.0f, 3.0f, 8.0f);
                this.smokeEffect = NHFx.hugeSmoke;
            }
        };
        railGun1 = new AdaptBulletType(){
            {
                this.width = 12.0f;
                this.height = 36.0f;
                this.trailLength = 20;
                this.trailWidth = 2.0f;
                this.trailInterval = 1.0f;
                this.trailRotation = true;
                this.pierceBuilding = true;
                this.pierce = true;
                this.pierceArmor = true;
                this.pierceCap = 3;
                this.ammoMultiplier = 1.0f;
                this.lifetime = 20.0f;
                this.speed = 35.0f;
                this.damage = 1750.0f;
                this.shieldDamageMultiplier = 0.1f;
                this.velocityIncrease = 10.0f;
                this.trailColor = this.lightColor = NHItems.irayrondPanel.color;
                this.backColor = this.lightColor;
                this.frontColor = this.lightColor;
                this.hitColor = this.lightColor;
                this.lightningColor = this.lightColor;
                this.chargeEffect = NHFx.railShoot(NHItems.irayrondPanel.color, 620.0f + this.rangeChange + 20.0f, 10.0f, 90.0f, 25.0f);
                this.lightning = 4;
                this.lightningLength = 6;
                this.lightningLengthRand = 10;
                this.shootEffect = NHFx.instShoot(this.lightningColor, this.lightningColor.cpy().lerp(Color.white, 0.2f));
                this.hitEffect = NHFx.instHit(this.lightningColor);
                this.smokeEffect = Fx.smokeCloud;
                this.trailEffect = NHFx.instTrail(this.lightningColor, 60.0f, true);
                this.despawnEffect = new OptionalMultiEffect(NHFx.instBomb(this.lightningColor), NHFx.hitSparkLarge, NHFx.square45_6_45);
                this.lightningDamage = this.damage / 8.0f;
                this.buildingDamageMultiplier = 0.5f;
                this.hitShake = 8.0f;
                this.knockback = 14.0f;
                this.hitSound = Sounds.explosion;
                this.despawnSound = Sounds.explosion;
            }
        };
        railGun2 = new AdaptBulletType(){
            {
                this.width = 16.0f;
                this.height = 50.0f;
                this.trailLength = 18;
                this.trailWidth = 2.0f;
                this.trailInterval = 1.0f;
                this.trailChance = 0.4f;
                this.trailRotation = true;
                this.pierceBuilding = true;
                this.pierce = true;
                this.pierceArmor = true;
                this.pierceCap = 6;
                this.ammoMultiplier = 1.0f;
                this.rangeChange = 60.0f;
                this.lifetime = 16.0f;
                this.speed = 45.0f;
                this.damage = 500.0f;
                this.shieldDamageMultiplier = 0.2f;
                this.splashDamage = 2000.0f;
                this.splashDamageRadius = 80.0f;
                this.frontColor = NHItems.irayrondPanel.color;
                this.trailColor = this.lightColor = NHItems.irayrondPanel.color.cpy().lerp(NHColor.deeperBlue, 0.4f);
                this.backColor = this.lightColor;
                this.hitColor = this.lightColor;
                this.lightningColor = this.lightColor;
                this.chargeEffect = NHFx.railShoot(NHItems.irayrondPanel.color, 620.0f + this.rangeChange + 20.0f, 10.0f, 90.0f, 25.0f);
                this.lightning = 4;
                this.lightningLength = 6;
                this.lightningLengthRand = 10;
                this.shootEffect = NHFx.instShoot(this.lightningColor, this.lightningColor.cpy().lerp(Color.white, 0.2f));
                this.hitEffect = NHFx.instHit(this.lightningColor, 6, 120.0f);
                this.smokeEffect = NHFx.hugeSmokeGray;
                this.trailEffect = NHFx.instTrail(this.lightningColor, 40.0f, true);
                this.despawnEffect = new OptionalMultiEffect(NHFx.instBomb(this.lightningColor), NHFx.hitSparkHuge, NHFx.square45_8_45);
                this.lightningDamage = this.damage / 7.5f;
                this.buildingDamageMultiplier = 0.5f;
                this.hitShake = 12.0f;
                this.knockback = 22.0f;
                this.hitSound = Sounds.explosion;
                this.despawnSound = Sounds.explosion;
            }
        };
        railGun3 = new AdaptBulletType(){
            {
                this.width = 16.0f;
                this.height = 50.0f;
                this.trailLength = 18;
                this.trailWidth = 2.0f;
                this.trailInterval = 1.0f;
                this.trailChance = 0.4f;
                this.trailRotation = true;
                this.pierceBuilding = true;
                this.pierce = true;
                this.pierceArmor = true;
                this.pierceCap = 2;
                this.ammoMultiplier = 1.0f;
                this.rangeChange = 120.0f;
                this.lifetime = 12.8f;
                this.speed = 60.0f;
                this.damage = 3250.0f;
                this.shieldDamageMultiplier = 0.5f;
                this.frontColor = NHItems.irayrondPanel.color;
                this.trailColor = this.lightColor = NHItems.irayrondPanel.color.cpy().lerp(NHColor.darkEnrColor, 0.6f);
                this.backColor = this.lightColor;
                this.hitColor = this.lightColor;
                this.lightningColor = this.lightColor;
                this.chargeEffect = NHFx.railShoot(NHItems.darkEnergy.color, 620.0f + this.rangeChange + 20.0f, 10.0f, 90.0f, 25.0f);
                this.lightning = 6;
                this.lightningLength = 12;
                this.lightningLengthRand = 20;
                this.shootEffect = NHFx.instShoot(this.lightningColor, this.lightningColor.cpy().lerp(Color.white, 0.2f));
                this.hitEffect = NHFx.instHit(this.lightningColor, 6, 120.0f);
                this.smokeEffect = NHFx.hugeSmoke;
                this.trailEffect = NHFx.instTrail(this.lightningColor, 40.0f, true);
                this.despawnEffect = new OptionalMultiEffect(NHFx.instBomb(this.lightningColor), NHFx.sharpBlast(this.backColor, this.frontColor, 50.0f, 90.0f));
                this.lightningDamage = this.damage / 7.0f;
                this.splashDamage = 2000.0f;
                this.splashDamageRadius = 80.0f;
                this.intervalBullets = 2;
                this.bulletInterval = 5.0f;
                this.intervalBullet = new AdaptedLightningBulletType(){
                    {
                        this.hitColor = this.lightColor = NHColor.darkEnrColor;
                        this.trailColor = this.lightColor;
                        this.lightningColor = this.lightColor;
                        this.lightningLength = 4;
                        this.lightningLengthRand = 15;
                        this.damage = 200.0f;
                    }
                };
                this.buildingDamageMultiplier = 0.75f;
                this.hitShake = 22.0f;
                this.knockback = 32.0f;
                this.hitSound = Sounds.explosion;
                this.despawnSound = Sounds.explosion;
            }
        };
        blastEnergyPst = new AccelBulletType(0.85f, 280.0f, CIRCLE_BOLT){
            {
                this.frontColor = Color.white;
                this.trailColor = this.lightColor = NHItems.thermoCorePositive.color.cpy().lerp(Color.white, 0.15f);
                this.lightningColor = this.lightColor;
                this.backColor = this.lightColor;
                this.lifetime = 64.0f;
                this.ammoMultiplier = 4.0f;
                this.accelerateBegin = 0.1f;
                this.accelerateEnd = 0.85f;
                this.velocityIncrease = 14.0f;
                this.despawnShake = 2.0f;
                this.hitShake = 2.0f;
                this.lightning = 3;
                this.lightningCone = 360.0f;
                this.lightningLengthRand = 12;
                this.lightningLength = 4;
                this.homingPower = 0.165f;
                this.homingRange = 600.0f;
                this.homingDelay = 33.0f;
                this.height = 9.0f;
                this.width = 9.0f;
                this.splashDamageRadius = 30.0f;
                this.lightningDamage = this.damage * 0.65f;
                this.splashDamage = 0.65f * this.damage;
                this.shrinkY = 0.0f;
                this.shrinkX = 0.0f;
                this.hitEffect = NHFx.crossBlast(this.backColor);
                this.despawnEffect = NHFx.hyperBlast(this.backColor);
                this.shootEffect = NHFx.shootCircleSmall(this.backColor);
                this.smokeEffect = Fx.shootBigSmoke;
                this.trailEffect = NHFx.trailToGray;
                this.trailChance = 0.23f;
                this.trailParam = 2.7f;
                this.trailLength = 15;
                this.trailWidth = 2.2f;
                this.drawSize = 300.0f;
            }
        };
        blastEnergyNgt = new AccelBulletType(3.85f, 200.0f){
            {
                this.frontColor = Color.white;
                this.trailColor = this.lightColor = NHItems.thermoCoreNegative.color;
                this.lightningColor = this.lightColor;
                this.backColor = this.lightColor;
                this.lifetime = 60.0f;
                this.knockback = 4.0f;
                this.rangeChange = 120.0f;
                this.ammoMultiplier = 8.0f;
                this.accelerateBegin = 0.1f;
                this.accelerateEnd = 0.85f;
                this.velocityIncrease = 18.0f;
                this.despawnShake = 5.0f;
                this.hitShake = 5.0f;
                this.lightning = 3;
                this.lightningCone = 360.0f;
                this.lightningLengthRand = 12;
                this.lightningLength = 4;
                this.width = 11.0f;
                this.height = 46.0f;
                this.pierceCap = 4;
                this.shrinkY = 0.0f;
                this.shrinkX = 0.0f;
                this.splashDamageRadius = 120.0f;
                this.lightningDamage = this.damage * 0.85f;
                this.splashDamage = 0.85f * this.damage;
                this.hitEffect = NHFx.lightningHitLarge(this.backColor);
                this.despawnEffect = NHFx.crossBlast(this.backColor);
                this.shootEffect = NHFx.shootCircleSmall(this.backColor);
                this.smokeEffect = Fx.shootBigSmoke;
                this.trailEffect = NHFx.trailToGray;
                this.reloadMultiplier = 1.25f;
                this.trailLength = 15;
                this.trailWidth = 2.44f;
                this.drawSize = 300.0f;
                this.inaccuracy = 0.0f;
            }
        };
        atomSeparator = new ContinuousFlameBulletType(300.0f){
            {
                this.shake = 3.0f;
                this.lightColor = this.lightningColor = NHColor.lightSkyBack;
                this.flareColor = this.lightningColor;
                this.hitColor = this.lightningColor;
                this.colors = new Color[]{NHColor.lightSkyBack.cpy().mul(0.75f, 0.85f, 1.0f, 0.65f), NHColor.lightSkyBack.cpy().mul(1.0f, 1.0f, 1.0f, 0.65f), NHColor.lightSkyBack.cpy().lerp(NHColor.deeperBlue, 0.5f), NHColor.deeperBlue};
                this.width = 6.0f;
                this.length = 380.0f;
                this.oscScl = 0.9f;
                this.oscMag *= 2.0f;
                this.lifetime = 35.0f;
                this.lightning = 4;
                this.lightningLength = 2;
                this.lightningLengthRand = 18;
                this.flareLength = 75.0f;
                this.flareWidth = 6.0f;
                this.hitEffect = NHFx.shootCircleSmall(NHColor.lightSkyBack);
                this.shootEffect = NHFx.lightningHitLarge(NHColor.lightSkyBack);
                this.lightningDamage = this.damage / 6.0f;
                this.despawnHit = false;
                this.pierceArmor = true;
            }

            public void update(Bullet b) {
                super.update(b);
                if (Mathf.chanceDelta((double)0.11)) {
                    for (int i = 0; i < this.lightning; ++i) {
                        Lightning.create((Bullet)b, (Color)this.lightningColor, (float)(this.lightningDamage < 0.0f ? this.damage : this.lightningDamage), (float)b.x, (float)b.y, (float)(b.rotation() + Mathf.range((float)(this.lightningCone / 2.0f)) + this.lightningAngle), (int)(this.lightningLength + Mathf.random((int)this.lightningLengthRand)));
                    }
                }
            }

            public void hit(Bullet b, float x, float y) {
                this.hitEffect.at(x, y, b.rotation(), this.hitColor);
                this.hitSound.at(x, y, this.hitSoundPitch, this.hitSoundVolume);
                Effect.shake((float)this.hitShake, (float)this.hitShake, (Position)b);
                Lightning.create((Bullet)b, (Color)this.lightningColor, (float)(this.lightningDamage < 0.0f ? this.damage : this.lightningDamage), (float)x, (float)y, (float)(b.rotation() + Mathf.range((float)(this.lightningCone / 2.0f)) + this.lightningAngle), (int)(this.lightningLength + Mathf.random((int)this.lightningLengthRand)));
            }
        };
        declineProjectile = new AdaptBulletType(){
            {
                this.lifetime = 122.0f;
                this.speed = 9.25f;
                this.damage = 350.0f;
                this.hittable = false;
                this.scaledSplashDamage = true;
                this.trailInterp = NHInterp.artilleryPlus;
                this.shrinkInterp = NHInterp.artilleryPlus;
                this.shrinkX = 0.75f;
                this.shrinkY = 0.4f;
                this.width = 25.0f;
                this.height = 55.0f;
                this.trailWidth = 4.7f;
                this.trailLength = 60;
                this.trailChance = 0.6f;
                this.trailEffect = NHFx.trailToGray;
                this.maxRange = 740.0f;
                this.pierceBuilding = false;
                this.pierce = false;
                this.collidesTiles = false;
                this.collideFloor = false;
                this.collideTerrain = false;
                this.scaleLife = true;
                this.lightning = 6;
                this.lightningLength = 4;
                this.lightningLengthRand = 32;
                this.splashDamageRadius = 76.0f;
                this.splashDamage = this.damage;
                this.lightningDamage = this.damage * 0.5f;
                this.trailColor = this.hitColor = NHColor.lightSkyBack;
                this.lightningColor = this.hitColor;
                this.lightColor = this.hitColor;
                this.backColor = this.hitColor;
                this.knockback = 20.0f;
                this.frontColor = NHColor.lightSkyFront;
                this.shootEffect = this.despawnEffect = NHFx.square(this.backColor, 40.0f, 4, 40.0f, 6.0f);
                this.smokeEffect = NHFx.hugeSmokeGray;
                this.despawnShake = 22.0f;
                this.hitSound = Sounds.explosion;
                this.hitEffect = new OptionalMultiEffect(NHFx.blast(this.backColor, 45.0f), NHFx.crossBlast(this.backColor, 120.0f, 45.0f), NHFx.hitSpark(this.backColor, 150.0f, 45, 170.0f, 2.0f, 13.0f));
                this.fragBullets = 7;
                this.fragBullet = basicSkyFrag;
                this.fragLifeMax = 0.5f;
                this.fragLifeMin = 0.25f;
                this.fragVelocityMax = 0.72f;
                this.fragVelocityMin = 0.075f;
            }

            public void removed(Bullet b) {
                if (this.trailLength > 0 && b.trail != null && b.trail.size() > 0) {
                    NHFx.trailFadeFast.at(b.x, b.y, this.trailWidth, this.trailColor, (Object)b.trail.copy());
                }
            }

            @Override
            public void init(Bullet b) {
                super.init(b);
                b.lifetime *= Mathf.random((float)0.955f, (float)1.025f);
            }

            public void hitTile(Bullet b, Building build, float x, float y, float initialHealth, boolean direct) {
                super.hitTile(b, build, x, y, initialHealth, direct);
                UltFire.createChance((Teamc)b, this.splashDamageRadius, 0.1f);
            }
        };
        airRaidBomb = new BasicBulletType(18.0f, 800.0f, STRIKE){
            {
                this.trailLength = 14;
                this.lightColor = this.lightningColor = NHColor.darkEnrColor;
                this.backColor = this.lightningColor;
                this.trailColor = this.lightningColor;
                this.frontColor = Color.white;
                this.hitSound = Sounds.explosion;
                this.trailChance = 0.075f;
                this.trailEffect = NHFx.polyTrail;
                this.trailParam = 6.0f;
                this.drawSize = 120.0f;
                this.collides = false;
                this.scaleLife = true;
                this.despawnShake = 16.0f;
                this.hitShake = 16.0f;
                this.lightning = 3;
                this.lightningCone = 360.0f;
                this.lightningLength = 20;
                this.lightningLengthRand = 20;
                this.shootEffect = NHFx.instShoot(this.backColor, this.frontColor);
                this.smokeEffect = NHFx.square(NHColor.darkEnrColor, 50.0f, 3, 80.0f, 5.0f);
                this.shrinkY = 0.0f;
                this.shrinkX = 0.0f;
                this.splashDamageRadius = 100.0f;
                this.splashDamage = this.lightningDamage = this.damage;
                this.height = 66.0f;
                this.width = 20.0f;
                this.lifetime = 120.0f;
                this.despawnEffect = NHFx.instHit(this.backColor, 4, 180.0f);
                this.hitEffect = new OptionalMultiEffect(NHFx.largeDarkEnergyHit, NHFx.square(NHColor.darkEnrColor, 100.0f, 3, 80.0f, 8.0f), NHFx.largeDarkEnergyHitCircle);
            }
        };
        skyMissile = new AdaptedMissileUnitType("sky-missile"){
            {
                this.speed = 2.3f;
                this.accel = 0.45f;
                this.drag /= 2.0f;
                this.trailAppearDelay = 22.0f;
                this.lifetime = 201.0f;
                this.armor = 5.0f;
                this.outlineColor = NHUnitTypes.OColor;
                this.health = 800.0f;
                this.homingDelay = 17.0f;
                this.lowAltitude = true;
                this.engineSize = 2.0f;
                this.engineOffset = 18.0f;
                this.engineColor = this.trailColor = NHColor.lightSkyBack;
                this.engineLayer = 110.0f;
                this.trailLength = 13;
                this.deathExplosionEffect = Fx.none;
                this.loopSoundVolume = 0.1f;
                this.abilities.add((Object)new MoveEffectAbility(){
                    {
                        this.effect = NHFx.skyTrail;
                        this.y = -engineOffset;
                        this.interval = 5.0f;
                    }
                });
                this.weapons.add((Object)new Weapon(){
                    {
                        this.shootCone = 360.0f;
                        this.mirror = false;
                        this.reload = 1.0f;
                        this.shootOnDeath = true;
                        this.shootSound = Sounds.beamPlasma;
                        this.bullet = new ExplosionBulletType(40.0f, 180.0f){
                            {
                                super(arg0, arg1);
                                this.lightningColor = this.hitColor = NHColor.lightSky;
                                this.lightColor = this.hitColor;
                                this.trailColor = this.hitColor;
                                this.hitSound = this.despawnSound = Sounds.none;
                                this.scaledSplashDamage = true;
                                this.splashDamageRadius = 40.0f;
                                this.lightningDamage = this.damage;
                                this.despawnShake = 16.0f;
                                this.hitShake = 16.0f;
                                this.lightning = 2;
                                this.lightningCone = 360.0f;
                                this.lightningLength = 5;
                                this.lightningLengthRand = 5;
                                this.shootEffect = new MultiEffect(new Effect[]{NHFx.blast(NHColor.lightSky, 30.0f), NHFx.hitSparkHuge});
                            }
                        };
                    }
                });
            }

            public void draw(Unit unit) {
                Draw.zTransform(f -> f - 2.0f);
                super.draw(unit);
                Draw.zTransform();
            }
        };
        airRaidMissile = new AdaptedMissileUnitType("air-raid-missile"){
            {
                this.speed = 10.0f;
                this.accel = 0.32f;
                this.drag /= 2.0f;
                this.lifetime = 108.0f;
                this.targetPriority = 0.0f;
                this.rotateSpeed = 3.5f;
                this.baseRotateSpeed = 3.5f;
                this.armor = 10.0f;
                this.outlineColor = Pal.darkOutline;
                this.health = 4000.0f;
                this.homingDelay = 17.0f;
                this.lowAltitude = true;
                this.engineSize = 2.75f;
                this.engineOffset = 23.0f;
                this.engineColor = this.trailColor = NHColor.darkEnrColor;
                this.engineLayer = 110.0f;
                this.trailLength = 45;
                this.deathExplosionEffect = Fx.none;
                this.loopSoundVolume = 0.1f;
                this.abilities.add((Object)new MoveEffectAbility(){
                    {
                        this.effect = NHFx.hugeSmoke;
                        this.rotation = 180.0f;
                        this.y = -22.0f;
                        this.color = Color.grays((float)0.6f).lerp(NHColor.darkEnrColor, 0.5f).a(0.9f);
                        this.interval = 5.0f;
                    }
                });
                this.clipSize = 620.0f;
                this.weapons.add((Object)new Weapon(){
                    {
                        this.shootCone = 360.0f;
                        this.mirror = false;
                        this.reload = 1.0f;
                        this.shootOnDeath = true;
                        this.shootSound = Sounds.explosion;
                        this.predictTarget = false;
                        this.shake = 12.0f;
                        this.bullet = new ExplosionBulletType(4200.0f, 150.0f){
                            {
                                super(arg0, arg1);
                                this.lightningColor = this.hitColor = NHColor.darkEnrColor;
                                this.lightColor = this.hitColor;
                                this.trailColor = this.hitColor;
                                this.suppressionRange = 600.0f;
                                this.suppressionDuration = 600.0f;
                                this.hitSound = this.despawnSound = Sounds.none;
                                this.status = NHStatusEffects.emp3;
                                this.lightningDamage = this.damage = this.splashDamage / 1.5f;
                                this.scaledSplashDamage = true;
                                this.splashDamageRadius = 200.0f;
                                this.despawnShake = 16.0f;
                                this.hitShake = 16.0f;
                                this.lightning = 6;
                                this.lightningCone = 360.0f;
                                this.lightningLength = 15;
                                this.lightningLengthRand = 15;
                                this.fragLifeMin = 0.6f;
                                this.fragLifeMax = 1.0f;
                                this.fragVelocityMin = 0.4f;
                                this.fragVelocityMax = 0.6f;
                                this.fragBullets = 8;
                                this.fragBullet = arc_9000_frag;
                                this.shootEffect = new OptionalMultiEffect(NHFx.largeDarkEnergyHit, NHFx.blast(NHColor.darkEnrColor, 140.0f), NHFx.largeDarkEnergyHitCircle, NHFx.subEffect(150.0f, this.splashDamageRadius * 0.66f, 13, 34.0f, (Interp)Interp.pow2Out, (i, x, y, rot, fin) -> {
                                    float fout = Interp.pow2Out.apply(1.0f - fin);
                                    float finpow = Interp.pow3Out.apply(fin);
                                    Tmp.v1.trns(rot, 25.0f * finpow);
                                    for (int s : Mathf.signs) {
                                        Drawf.tri((float)x, (float)y, (float)(12.0f * fout), (float)(45.0f * Mathf.curve((float)finpow, (float)0.0f, (float)0.3f) * NHFx.fout(fin, 0.15f)), (float)(rot + (float)(s * 90)));
                                    }
                                }));
                            }
                        };
                    }
                });
            }
        };
        synchroTitanium = new AdaptBulletType(){
            {
                this.damage = 60.0f;
                this.buildingDamageMultiplier = 1.0f;
                this.shieldDamageMultiplier = 0.5f;
                this.speed = 8.0f;
                this.lifetime = 35.0f;
                this.width = 8.0f;
                this.height = 42.0f;
                this.shrinkX = 0.0f;
                this.trailWidth = 1.7f;
                this.trailLength = 9;
                this.lightColor = this.lightningColor = NHColor.lightSkyBack.cpy().lerp(Color.royal, 0.45f);
                this.hitColor = this.lightningColor;
                this.backColor = this.lightningColor;
                this.trailColor = this.lightningColor;
                this.frontColor = this.backColor.cpy().lerp(Color.white, 0.35f);
                this.shootEffect = NHFx.square(this.backColor, 45.0f, 5, 38.0f, 4.0f);
                this.smokeEffect = Fx.shootBigSmoke;
                this.despawnEffect = NHFx.square(this.backColor, 85.0f, 5, 52.0f, 5.0f);
                this.hitEffect = NHFx.hitSparkLarge;
                this.pierceCap = 3;
                this.ammoMultiplier = 4.0f;
                this.bundleName = "synchro-titanium";
            }
        };
        synchroTungsten = new AdaptBulletType(){
            {
                this.damage = 80.0f;
                this.buildingDamageMultiplier = 1.0f;
                this.shieldDamageMultiplier = 0.5f;
                this.speed = 7.0f;
                this.lifetime = 44.0f;
                this.width = 8.0f;
                this.height = 42.0f;
                this.shrinkX = 0.0f;
                this.trailWidth = 1.7f;
                this.trailLength = 9;
                this.lightColor = this.lightningColor = Items.tungsten.color;
                this.hitColor = this.lightningColor;
                this.backColor = this.lightningColor;
                this.trailColor = this.lightningColor;
                this.frontColor = this.backColor.cpy().lerp(Color.white, 0.35f);
                this.shootEffect = NHFx.square(this.backColor, 45.0f, 5, 38.0f, 4.0f);
                this.smokeEffect = Fx.shootBigSmoke;
                this.despawnEffect = NHFx.square(this.backColor, 85.0f, 5, 52.0f, 5.0f);
                this.hitEffect = NHFx.hitSparkLarge;
                this.reloadMultiplier = 0.75f;
                this.rangeChange = 40.0f;
                this.pierceCap = 4;
                this.ammoMultiplier = 6.0f;
                this.bundleName = "synchro-Tungsten";
            }
        };
        synchroZeta = new AdaptBulletType(){
            {
                this.damage = 100.0f;
                this.buildingDamageMultiplier = 1.0f;
                this.shieldDamageMultiplier = 0.7f;
                this.speed = 8.0f;
                this.lifetime = 35.0f;
                this.width = 8.0f;
                this.height = 42.0f;
                this.shrinkX = 0.0f;
                this.trailWidth = 1.7f;
                this.trailLength = 9;
                this.lightColor = this.lightningColor = Items.phaseFabric.color;
                this.hitColor = this.lightningColor;
                this.backColor = this.lightningColor;
                this.trailColor = this.lightningColor;
                this.frontColor = Color.white;
                this.shootEffect = NHFx.square(this.backColor, 45.0f, 5, 38.0f, 4.0f);
                this.frontColor = this.backColor.cpy().lerp(Color.white, 0.35f);
                this.despawnEffect = this.hitEffect = NHFx.square(this.backColor, 85.0f, 5, 52.0f, 5.0f);
                this.status = NHStatusEffects.emp2;
                this.statusDuration = 180.0f;
                this.pierceCap = 6;
                this.ammoMultiplier = 6.0f;
                this.bundleName = "synchro-zeta";
            }
        };
        synchroFusionEnergy = new AdaptBulletType(){
            {
                this.damage = 180.0f;
                this.shieldDamageMultiplier = 0.8f;
                this.speed = 7.0f;
                this.lifetime = 43.0f;
                this.width = 8.0f;
                this.height = 42.0f;
                this.shrinkX = 0.0f;
                this.trailWidth = 1.7f;
                this.trailLength = 9;
                this.lightColor = this.lightningColor = NHItems.fusionEnergy.color;
                this.hitColor = this.lightningColor;
                this.backColor = this.lightningColor;
                this.trailColor = this.lightningColor;
                this.frontColor = Color.white;
                this.shootEffect = NHFx.square(this.backColor, 45.0f, 5, 38.0f, 4.0f);
                this.smokeEffect = Fx.shootBigSmoke;
                this.splashDamage = 75.0f;
                this.splashDamageRadius = 32.0f;
                this.despawnEffect = this.hitEffect = new OptionalMultiEffect(NHFx.circleOut(this.backColor, this.splashDamageRadius * 1.25f), NHFx.hitSparkLarge);
                this.ammoMultiplier = 4.0f;
                this.reloadMultiplier = 0.75f;
                this.rangeChange = 40.0f;
                this.status = StatusEffects.melting;
                this.statusDuration = 180.0f;
                this.makeFire = true;
                this.bundleName = "synchro-fusionEnergy";
            }
        };
        synchroThermoPst = new BasicBulletType(8.0f, 80.0f){
            {
                this.lifetime = 48.0f;
                this.width = 8.0f;
                this.height = 42.0f;
                this.shrinkX = 0.0f;
                this.trailWidth = 1.7f;
                this.trailLength = 9;
                this.lightColor = this.lightningColor = NHColor.thermoPst;
                this.hitColor = this.lightningColor;
                this.backColor = this.lightningColor;
                this.trailColor = this.lightningColor;
                this.frontColor = this.backColor.cpy().lerp(Color.white, 0.35f);
                this.shootEffect = NHFx.square(this.backColor, 45.0f, 5, 38.0f, 4.0f);
                this.smokeEffect = Fx.shootBigSmoke;
                this.despawnEffect = this.hitEffect = NHFx.lightningHitLarge;
                this.lightningDamage = this.damage;
                this.lightningLength = 6;
                this.lightningLengthRand = 12;
                this.lightning = 3;
                this.ammoMultiplier = 8.0f;
                this.reloadMultiplier = 0.8f;
                this.status = StatusEffects.melting;
                this.statusDuration = 120.0f;
            }
        };
        laugraBullet = new AccelBulletType(1000.0f, STRIKE){
            {
                this.status = NHStatusEffects.entangled;
                this.statusDuration = 320.0f;
                this.pierceArmor = true;
                this.lightOpacity = 0.7f;
                this.reflectable = false;
                this.knockback = 3.0f;
                this.impact = true;
                this.velocityBegin = 1.0f;
                this.velocityIncrease = 18.0f;
                this.accelerateBegin = 0.05f;
                this.accelerateEnd = 0.55f;
                this.pierceBuilding = true;
                this.pierce = true;
                this.buildingDamageMultiplier = 3.0f;
                this.pierceCap = 7;
                this.hitColor = this.lightColor = NHColor.ancient;
                this.trailColor = this.lightColor;
                this.backColor = this.lightColor;
                this.lightningColor = this.lightColor;
                this.lightRadius = 70.0f;
                this.shootEffect = new EffectWrapper(NHFx.shootLine(33.0f, 32.0f), this.backColor);
                this.smokeEffect = NHFx.hugeSmokeLong;
                this.lifetime = 40.0f;
                this.frontColor = Color.white;
                this.lightning = 2;
                this.lightningDamage = 200.0f;
                this.lightningLength = 7;
                this.lightningLengthRand = 16;
                this.splashDamageRadius = 36.0f;
                this.splashDamage = this.damage / 2.0f;
                this.width = 13.0f;
                this.height = 35.0f;
                this.speed = 7.0f;
                this.trailLength = 20;
                this.trailWidth = 2.3f;
                this.trailInterval = 1.76f;
                this.hitShake = 8.0f;
                this.trailRotation = true;
                this.keepVelocity = true;
                this.hitSound = Sounds.beamPlasma;
                this.trailEffect = new Effect(10.0f, e -> {
                    Draw.color((Color)this.trailColor, (Color)Color.white, (float)(e.fout() * 0.66f));
                    for (int s : Mathf.signs) {
                        DrawFunc.tri(e.x, e.y, 3.0f, 30.0f * Mathf.curve((float)e.fin(), (float)0.0f, (float)0.1f) * e.fout(0.9f), e.rotation + 145.0f * (float)s);
                    }
                });
                this.hitEffect = new OptionalMultiEffect(NHFx.square45_6_45, NHFx.hitSparkLarge);
                this.despawnEffect = NHFx.lightningHitLarge;
            }

            public void hitTile(Bullet b, Building build, float x, float y, float initialHealth, boolean direct) {
                super.hitTile(b, build, x, y, initialHealth, direct);
                if (build.block.armor > 10.0f || build.block.absorbLasers) {
                    b.time(b.lifetime());
                }
            }
        };
        saviourBullet = new EmpBulletType(){
            {
                float rad = 100.0f;
                this.rangeOverride = 400.0f;
                this.scaleLife = true;
                this.lightOpacity = 0.7f;
                this.healPercent = 20.0f;
                this.timeIncrease = 3.0f;
                this.timeDuration = 1200.0f;
                this.powerDamageScl = 3.0f;
                this.damage = 100.0f;
                this.hitColor = this.lightColor = Pal.heal;
                this.lightRadius = 70.0f;
                this.shootEffect = Fx.hitEmpSpark;
                this.smokeEffect = Fx.healWave;
                this.lifetime = 60.0f;
                this.lightningColor = this.backColor = Pal.heal;
                this.frontColor = Color.white;
                this.lightning = 3;
                this.lightningDamage = this.damage;
                this.lightningLength = 7;
                this.lightningLengthRand = 16;
                this.width = 16.0f;
                this.height = 35.0f;
                this.speed = 8.0f;
                this.trailLength = 20;
                this.trailWidth = 2.7f;
                this.trailColor = Pal.heal;
                this.trailInterval = 3.0f;
                this.splashDamage = this.damage * 0.75f;
                this.splashDamageRadius = rad;
                this.hitShake = 4.0f;
                this.trailRotation = true;
                this.status = StatusEffects.electrified;
                this.hitSound = Sounds.beamPlasma;
                this.trailEffect = new Effect(16.0f, e -> {
                    Draw.color((Color)Pal.heal);
                    for (int s : Mathf.signs) {
                        DrawFunc.tri(e.x, e.y, 4.0f, 30.0f * Mathf.curve((float)e.fin(), (float)0.0f, (float)0.1f) * e.fout(0.9f), e.rotation + 135.0f * (float)s);
                    }
                });
                this.hitEffect = new OptionalMultiEffect(NHFx.blast(this.backColor, rad), NHFx.hitSpark(this.backColor, 120.0f, 40, rad * 1.7f, 2.5f, 12.0f));
                this.despawnEffect = NHFx.crossBlast(this.backColor, rad * 1.8f, 45.0f);
            }

            public void hit(Bullet b) {
                super.hit(b);
                NHFunc.extinguish((Teamc)b, this.splashDamageRadius, 3000.0f);
            }
        };
        basicSkyFrag = new BasicBulletType(3.8f, 50.0f){
            {
                this.speed = 6.0f;
                this.trailLength = 12;
                this.trailWidth = 2.0f;
                this.lifetime = 60.0f;
                this.despawnEffect = NHFx.square45_4_45;
                this.hitEffect = new Effect(45.0f, e -> {
                    Fx.rand.setSeed((long)e.id);
                    Draw.color((Color)NHColor.lightSkyFront, (Color)NHColor.lightSkyBack, (float)e.fin());
                    Lines.stroke((float)(1.75f * e.fout()));
                    if (NHSetting.enableDetails()) {
                        Lines.spikes((float)e.x, (float)e.y, (float)((float)Fx.rand.random(14, 28) * e.finpow()), (float)((float)Fx.rand.random(1, 5) * e.fout() + (float)Fx.rand.random(5, 8) * e.fin(NHInterp.parabola4Reversed)), (int)4, (float)45.0f);
                    }
                    Lines.square((float)e.x, (float)e.y, (float)((float)Fx.rand.random(4, 14) * e.fin((Interp)Interp.pow3Out)), (float)45.0f);
                });
                this.knockback = 4.0f;
                this.width = 15.0f;
                this.height = 37.0f;
                this.lightningDamage = this.damage * 0.65f;
                this.trailColor = this.hitColor = NHColor.lightSkyBack;
                this.lightningColor = this.hitColor;
                this.lightColor = this.hitColor;
                this.backColor = this.hitColor;
                this.frontColor = NHColor.lightSkyFront;
                this.lightning = 2;
                this.lightningLengthRand = 3;
                this.lightningLength = 3;
                this.smokeEffect = Fx.shootBigSmoke2;
                this.trailChance = 0.2f;
                this.trailEffect = NHFx.skyTrail;
                this.drag = 0.015f;
                this.hitShake = 2.0f;
                this.hitSound = Sounds.explosion;
            }

            public void hit(Bullet b) {
                super.hit(b);
                UltFire.createChance((Teamc)b, 12.0f, 0.0075f);
            }
        };
        missileStrike = new MissileBulletType(4.2f, 18.0f){
            {
                this.width = 8.0f;
                this.height = 8.0f;
                this.shrinkY = 0.0f;
                this.pierceCap = 6;
                this.drag = -0.01f;
                this.homingPower = 0.125f;
                this.homingRange = 120.0f;
                this.splashDamageRadius = 6.0f;
                this.splashDamage = this.damage / 8.0f;
                this.ammoMultiplier = 10.0f;
                this.trailColor = this.lightColor = NHItems.presstanium.color.cpy().lerp(Color.white, 0.3f);
                this.backColor = this.lightColor;
                this.frontColor = this.backColor.cpy().lerp(Color.white, 0.7f);
                this.hitEffect = NHFx.lightningHitSmall(this.backColor);
                this.despawnEffect = NHFx.shootCircleSmall(this.backColor);
                this.lifetime = 58.0f;
                this.inaccuracy = 0.0f;
                if (NHSetting.enableDetails()) {
                    this.trailColor = NHColor.trail;
                    this.trailWidth = 1.0f;
                    this.trailLength = 12;
                }
            }

            public void update(Bullet b) {
                Teamc target;
                if (this.homingPower > 1.0E-4f && b.time >= this.homingDelay && (target = Units.closestTarget((Team)b.team, (float)b.x, (float)b.y, (float)this.homingRange, e -> !b.collided.contains(e.id), t -> this.collidesGround)) != null) {
                    b.vel.setAngle(Angles.moveToward((float)b.rotation(), (float)b.angleTo((Position)target), (float)(this.homingPower * Time.delta * 50.0f)));
                }
                if (this.trailChance > 0.0f && Mathf.chanceDelta((double)this.trailChance)) {
                    this.trailEffect.at(b.x, b.y, this.trailParam, this.trailColor);
                }
            }
        };
        missileNormal = new MissileBulletType(4.2f, 12.0f){
            {
                this.width = 8.0f;
                this.height = 8.0f;
                this.shrinkY = 0.0f;
                this.drag = -0.01f;
                this.splashDamageRadius = 8.0f;
                this.splashDamage = this.damage / 2.0f;
                this.ammoMultiplier = 3.0f;
                this.hitEffect = Fx.flakExplosion;
                this.despawnEffect = Fx.flakExplosion;
                this.lifetime = 58.0f;
                this.inaccuracy = 0.0f;
                if (NHSetting.enableDetails()) {
                    this.trailColor = NHColor.trail;
                    this.trailWidth = 1.0f;
                    this.trailLength = 12;
                }
            }
        };
        missileTitanium = new MissileBulletType(4.2f, 20.0f){
            {
                this.width = 8.0f;
                this.height = 8.0f;
                this.shrinkY = 0.0f;
                this.pierceCap = 1;
                this.drag = -0.01f;
                this.splashDamageRadius = 6.0f;
                this.splashDamage = this.damage / 4.0f;
                this.ammoMultiplier = 3.0f;
                this.backColor = this.lightColor = Items.titanium.color.cpy().lerp(Color.white, 0.2f);
                this.frontColor = this.backColor.cpy().lerp(Color.white, 0.7f);
                this.hitEffect = NHFx.lightningHitSmall(this.backColor);
                this.despawnEffect = NHFx.shootCircleSmall(this.backColor);
                this.lifetime = 58.0f;
                this.inaccuracy = 0.0f;
                if (NHSetting.enableDetails()) {
                    this.trailColor = NHColor.trail;
                    this.trailWidth = 1.0f;
                    this.trailLength = 12;
                }
            }
        };
        missileThorium = new MissileBulletType(4.2f, 34.0f){
            {
                this.width = 8.0f;
                this.height = 8.0f;
                this.shrinkY = 0.0f;
                this.pierceCap = 2;
                this.knockback = 8.0f;
                this.drag = -0.01f;
                this.ammoMultiplier = 3.0f;
                this.trailColor = this.lightColor = Items.thorium.color.cpy().lerp(Color.white, 0.2f);
                this.backColor = this.lightColor;
                this.frontColor = this.backColor.cpy().lerp(Color.white, 0.7f);
                this.homingPower = 0.08f;
                this.lifetime = 58.0f;
                this.hitEffect = NHFx.instHit(this.backColor, 2, 30.0f);
                this.despawnEffect = NHFx.shootCircleSmall(this.backColor);
                this.inaccuracy = 0.0f;
                if (NHSetting.enableDetails()) {
                    this.trailColor = NHColor.trail;
                    this.trailWidth = 1.0f;
                    this.trailLength = 12;
                }
            }
        };
        missileZeta = new MissileBulletType(4.2f, 18.0f){
            {
                this.width = 8.0f;
                this.height = 8.0f;
                this.shrinkY = 0.0f;
                this.drag = -0.01f;
                this.ammoMultiplier = 3.0f;
                this.lightningColor = this.hitColor = NHItems.zeta.color.cpy().lerp(Color.white, 0.2f);
                this.lightColor = this.hitColor;
                this.trailColor = this.hitColor;
                this.backColor = this.hitColor;
                this.frontColor = this.backColor.cpy().lerp(Color.white, 0.7f);
                this.splashDamageRadius = 4.0f;
                this.splashDamage = this.damage / 3.0f;
                this.despawnEffect = Fx.smoke;
                this.hitEffect = NHFx.hitSpark;
                this.lifetime = 58.0f;
                this.lightningDamage = this.damage / 2.0f;
                this.lightning = 2;
                this.lightningLength = 10;
                this.inaccuracy = 0.0f;
                if (NHSetting.enableDetails()) {
                    this.trailColor = NHColor.trail;
                    this.trailWidth = 1.0f;
                    this.trailLength = 12;
                }
            }
        };
        arc_9000 = new LightningLinkerBulletType(2.75f, 200.0f){
            {
                this.trailWidth = 4.5f;
                this.trailLength = 66;
                this.chargeEffect = new OptionalMultiEffect(NHFx.darkEnergyCharge, NHFx.darkEnergyChargeBegin);
                this.spreadEffect = this.slopeEffect = Fx.none;
                this.trailEffect = NHFx.hitSparkHuge;
                this.trailInterval = 5.0f;
                this.lightColor = this.lightningColor = NHColor.darkEnrColor;
                this.hitColor = this.lightningColor;
                this.trailColor = this.lightningColor;
                this.backColor = this.lightningColor;
                this.frontColor = NHColor.darkEnr;
                this.randomGenerateRange = 340.0f;
                this.randomLightningNum = 3;
                this.linkRange = 280.0f;
                this.range = 800.0f;
                this.drawSize = 500.0f;
                this.drag = 0.0035f;
                this.fragLifeMin = 0.3f;
                this.fragLifeMax = 1.0f;
                this.fragVelocityMin = 0.3f;
                this.fragVelocityMax = 1.25f;
                this.fragBullets = 14;
                this.intervalBullets = 2;
                this.intervalBullet = this.fragBullet = arc_9000_frag;
                this.hitSound = Sounds.explosion;
                this.splashDamageRadius = 120.0f;
                this.splashDamage = 1000.0f;
                this.lightningDamage = 375.0f;
                this.collidesTiles = true;
                this.pierce = false;
                this.collides = false;
                this.ammoMultiplier = 1.0f;
                this.lifetime = 300.0f;
                this.despawnEffect = NHFx.circleOut(this.hitColor, this.splashDamageRadius * 1.5f);
                this.hitEffect = NHFx.largeDarkEnergyHit;
                this.shootEffect = NHFx.darkEnergyShootBig;
                this.smokeEffect = NHFx.darkEnergySmokeBig;
                this.hitSpacing = 3.0f;
            }

            @Override
            public void update(Bullet b) {
                super.update(b);
                if (NHSetting.enableDetails() && b.timer(1, 6.0f)) {
                    for (int j = 0; j < 2; ++j) {
                        NHFunc.randFadeLightningEffect(b.x, b.y, Mathf.random((int)360), Mathf.random((int)7, (int)12), this.backColor, Mathf.chance((double)0.5));
                    }
                }
            }

            @Override
            public void draw(Bullet b) {
                Draw.color((Color)this.backColor);
                DrawFunc.surround(b.id, b.x, b.y, this.size * 1.45f, 14, 7.0f, 11.0f, (b.fin(NHInterp.parabola4Reversed) + 1.0f) / 2.0f * b.fout(0.1f));
                this.drawTrail(b);
                Draw.color((Color)this.backColor);
                Fill.circle((float)b.x, (float)b.y, (float)this.size);
                Draw.z((float)110.0001f);
                Draw.color((Color)this.frontColor);
                Fill.circle((float)b.x, (float)b.y, (float)(this.size * 0.62f));
                Draw.z((float)99.89f);
                Draw.color((Color)this.frontColor);
                Fill.circle((float)b.x, (float)b.y, (float)(this.size * 0.66f));
                Draw.z((float)100.0f);
                Drawf.light((float)b.x, (float)b.y, (float)(this.size * 1.85f), (Color)this.backColor, (float)0.7f);
            }
        };
        ultFireball = new FireBulletType(1.0f, 10.0f){
            {
                this.colorFrom = NHColor.lightSkyFront;
                this.colorMid = NHColor.lightSkyBack;
                this.lifetime = 12.0f;
                this.radius = 4.0f;
                this.trailEffect = NHFx.ultFireBurn;
            }

            public void draw(Bullet b) {
                Draw.color((Color)this.colorFrom, (Color)this.colorMid, (Color)this.colorTo, (float)b.fin());
                Fill.square((float)b.x, (float)b.y, (float)(this.radius * b.fout()), (float)45.0f);
                Draw.reset();
            }

            public void update(Bullet b) {
                if (Mathf.chanceDelta((double)this.fireTrailChance)) {
                    UltFire.create(b.tileOn());
                }
                if (Mathf.chanceDelta((double)this.fireEffectChance)) {
                    this.trailEffect.at(b.x, b.y);
                }
                if (Mathf.chanceDelta((double)this.fireEffectChance2)) {
                    this.trailEffect2.at(b.x, b.y);
                }
            }
        };
        annMissile = new BasicBulletType(5.6f, 80.0f, STRIKE){
            {
                this.backColor = this.lightColor = NHColor.lightSkyBack;
                this.lightningColor = this.lightColor;
                this.trailColor = this.lightColor;
                this.frontColor = NHColor.lightSkyFront;
                this.lightning = 3;
                this.lightningCone = 360.0f;
                this.lightningLength = 9;
                this.lightningLengthRand = 9;
                this.splashDamageRadius = 60.0f;
                this.splashDamage = this.lightningDamage = this.damage * 0.7f;
                this.range = 320.0f;
                this.scaleLife = true;
                this.width = 12.0f;
                this.height = 30.0f;
                this.trailLength = 15;
                this.drawSize = 250.0f;
                this.trailParam = 1.4f;
                this.trailChance = 0.35f;
                this.lifetime = 50.0f;
                this.homingDelay = 10.0f;
                this.homingPower = 0.05f;
                this.homingRange = 150.0f;
                this.hitEffect = NHFx.lightningHitLarge(NHColor.lightSkyBack);
                this.shootEffect = NHFx.hugeSmokeGray;
                this.smokeEffect = new Effect(45.0f, e -> {
                    Draw.color((Color)this.lightColor, (Color)Color.white, (float)(e.fout() * 0.7f));
                    Angles.randLenVectors((long)e.id, (int)8, (float)(5.0f + 55.0f * e.fin()), (float)e.rotation, (float)45.0f, (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 3.0f)));
                });
                this.despawnEffect = new Effect(32.0f, e -> {
                    Draw.color((Color)Color.gray);
                    Angles.randLenVectors((long)(e.id + 1), (int)8, (float)(2.0f + 30.0f * e.finpow()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 4.0f + 0.5f)));
                    Draw.color((Color)this.lightColor, (Color)Color.white, (float)e.fin());
                    Lines.stroke((float)(e.fout() * 2.0f));
                    Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * e.fout() * 13.0f));
                    Angles.randLenVectors((long)e.id, (int)4, (float)(7.0f + 40.0f * e.fin()), (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(e.fslope() * 8.0f + 3.0f)));
                });
            }
        };
        guardianBulletLightningBall = new LightningLinkerBulletType(3.0f, 120.0f){
            private final Effect RshootEffect = new Effect(24.0f, e -> {
                e.scaled(10.0f, b -> {
                    Draw.color((Color)e.color);
                    Lines.stroke((float)(b.fout() * 3.0f + 0.2f));
                    Lines.circle((float)b.x, (float)b.y, (float)(b.fin() * 70.0f));
                });
                Draw.color((Color)e.color);
                for (int i : Mathf.signs) {
                    DrawFunc.tri(e.x, e.y, 8.0f * e.fout(), 85.0f, e.rotation + 90.0f * (float)i);
                }
                if (!NHSetting.enableDetails()) {
                    return;
                }
                Draw.color((Color)Color.black);
                for (int i : Mathf.signs) {
                    DrawFunc.tri(e.x, e.y, 3.0f * e.fout(), 38.0f, e.rotation + 90.0f * (float)i);
                }
            });
            private final Effect RsmokeEffect = NHFx.hitSparkLarge;
            {
                this.lifetime = 120.0f;
                this.keepVelocity = false;
                this.splashDamage = 80.0f;
                this.damage = 80.0f;
                this.lightningDamage = 80.0f;
                this.splashDamageRadius = 50.0f;
                this.homingDelay = 20.0f;
                this.homingRange = 300.0f;
                this.homingPower = 0.025f;
                this.smokeEffect = this.shootEffect = Fx.none;
                this.effectLingtning = 0;
                this.maxHit = 6;
                this.despawnShake = 5.0f;
                this.hitShake = 5.0f;
                this.hitSound = this.despawnSound = Sounds.beamPlasma;
                this.size = 7.2f;
                this.trailWidth = 3.0f;
                this.trailLength = 16;
                this.linkRange = 80.0f;
                this.scaleLife = false;
                this.despawnHit = false;
                this.collidesGround = true;
                this.collidesAir = true;
                this.despawnEffect = this.hitEffect = new OptionalMultiEffect(NHFx.lightningHitLarge, NHFx.hitSparkHuge);
                this.trailEffect = this.slopeEffect = NHFx.trailFromWhite;
                this.spreadEffect = new Effect(32.0f, e -> Angles.randLenVectors((long)e.id, (int)2, (float)(6.0f + 45.0f * e.fin()), (x, y) -> {
                    Draw.color((Color)e.color);
                    Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * this.size / 2.0f));
                    Draw.color((Color)Color.black);
                    Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * (this.size / 3.0f - 1.0f)));
                })).layer(110.00001f);
            }

            public Color getColor(Bullet b) {
                return Tmp.c1.set(b.team.color).lerp(Color.white, 0.1f + Mathf.absin((float)4.0f, (float)0.15f));
            }

            @Override
            public void update(Bullet b) {
                this.updateTrail(b);
                this.updateHoming(b);
                this.updateWeaving(b);
                this.updateBulletInterval(b);
                Effect.shake((float)this.hitShake, (float)this.hitShake, (Position)b);
                if (b.timer(5, this.hitSpacing)) {
                    this.slopeEffect.at(b.x + Mathf.range((float)(this.size / 4.0f)), b.y + Mathf.range((float)(this.size / 4.0f)), Mathf.random((float)2.0f, (float)4.0f), b.team.color);
                    this.spreadEffect.at(b.x, b.y, b.team.color);
                    PosLightning.createRange(b, this.collidesAir, this.collidesGround, (Position)b, b.team, this.linkRange, this.maxHit, b.team.color, Mathf.chanceDelta((double)this.randomLightningChance), this.lightningDamage, this.lightningLength, 2.5f, this.boltNum, (Cons<Position>)((Cons)p -> this.liHitEffect.at(p.getX(), p.getY(), b.team.color)));
                }
                if (Mathf.chanceDelta((double)0.1)) {
                    this.slopeEffect.at(b.x + Mathf.range((float)(this.size / 4.0f)), b.y + Mathf.range((float)(this.size / 4.0f)), Mathf.random((float)2.0f, (float)4.0f), b.team.color);
                    this.spreadEffect.at(b.x, b.y, b.team.color);
                }
                if (this.randomGenerateRange > 0.0f && Mathf.chance((double)(Time.delta * this.randomGenerateChance)) && b.lifetime - b.time > PosLightning.lifetime) {
                    PosLightning.createRandomRange(b, b.team, (Position)b, this.randomGenerateRange, this.backColor, Mathf.chanceDelta((double)this.randomLightningChance), 0.0f, 0, this.boltWidth, this.boltNum, this.randomLightningNum, (Cons<Position>)((Cons)hitPos -> {
                        this.randomGenerateSound.at(hitPos, Mathf.random((float)0.9f, (float)1.1f));
                        Damage.damage((Team)b.team, (float)hitPos.getX(), (float)hitPos.getY(), (float)(this.splashDamageRadius / 8.0f), (float)(this.splashDamage * b.damageMultiplier() / 8.0f), (boolean)this.collidesAir, (boolean)this.collidesGround);
                        NHFx.lightningHitLarge.at(hitPos.getX(), hitPos.getY(), b.team.color);
                        this.hitModifier.get(hitPos);
                    }));
                }
                if (Mathf.chanceDelta((double)this.effectLightningChance) && b.lifetime - b.time > Fx.chainLightning.lifetime && NHSetting.enableDetails()) {
                    for (int i = 0; i < this.effectLingtning; ++i) {
                        Vec2 v = randVec.rnd(this.effectLightningLength + Mathf.random((float)this.effectLightningLengthRand)).add((Position)b).add(Tmp.v1.set(b.vel).scl(Fx.chainLightning.lifetime / 2.0f));
                        Fx.chainLightning.at(b.x, b.y, 12.0f, b.team.color, (Object)v.cpy());
                        NHFx.lightningHitSmall.at(v.x, v.y, 20.0f, b.team.color);
                    }
                }
            }

            @Override
            public void init(Bullet b) {
                super.init(b);
                b.lifetime *= Mathf.randomSeed((long)b.id, (float)0.875f, (float)1.125f);
                this.RsmokeEffect.at(b.x, b.y, b.team.color);
                this.RshootEffect.at(b.x, b.y, b.rotation(), b.team.color);
            }

            public void drawTrail(Bullet b) {
                if (this.trailLength > 0 && b.trail != null) {
                    float z = Draw.z();
                    Draw.z((float)(z - 1.0E-4f));
                    b.trail.draw(this.getColor(b), this.trailWidth);
                    Draw.z((float)z);
                }
            }

            @Override
            public void draw(Bullet b) {
                this.drawTrail(b);
                Draw.color((Color)Tmp.c1);
                Fill.circle((float)b.x, (float)b.y, (float)this.size);
                float[] param = new float[]{9.0f, 28.0f, 1.0f, 9.0f, 22.0f, -1.25f, 12.0f, 16.0f, -0.45f};
                for (int i = 0; i < param.length / 3; ++i) {
                    for (int j : Mathf.signs) {
                        Drawf.tri((float)b.x, (float)b.y, (float)(param[i * 3] * b.fout()), (float)(param[i * 3 + 1] * b.fout()), (float)(b.rotation() + 90.0f * (float)j + param[i * 3 + 2] * Time.time));
                    }
                }
                Draw.color((Color)Color.black);
                Fill.circle((float)b.x, (float)b.y, (float)(this.size / 6.125f + this.size / 3.0f * Mathf.curve((float)b.fout(), (float)0.1f, (float)0.35f)));
                Drawf.light((float)b.x, (float)b.y, (float)(this.size * 6.85f), (Color)b.team.color, (float)0.7f);
            }

            @Override
            public void despawned(Bullet b) {
                PosLightning.createRandomRange(b, b.team, (Position)b, this.randomGenerateRange, b.team.color, Mathf.chanceDelta((double)this.randomLightningChance), 0.0f, 0, this.boltWidth, this.boltNum, this.randomLightningNum, (Cons<Position>)((Cons)hitPos -> {
                    Damage.damage((Team)b.team, (float)hitPos.getX(), (float)hitPos.getY(), (float)this.splashDamageRadius, (float)(this.splashDamage * b.damageMultiplier()), (boolean)this.collidesAir, (boolean)this.collidesGround);
                    NHFx.lightningHitLarge.at(hitPos.getX(), hitPos.getY(), b.team.color);
                    this.liHitEffect.at(hitPos);
                    for (int j = 0; j < this.lightning; ++j) {
                        Lightning.create((Bullet)b, (Color)b.team.color, (float)(this.lightningDamage < 0.0f ? this.damage : this.lightningDamage), (float)b.x, (float)b.y, (float)(b.rotation() + Mathf.range((float)(this.lightningCone / 2.0f)) + this.lightningAngle), (int)(this.lightningLength + Mathf.random((int)this.lightningLengthRand)));
                    }
                    this.hitSound.at(hitPos, Mathf.random((float)0.9f, (float)1.1f));
                    this.hitModifier.get(hitPos);
                }));
                if (this.despawnHit) {
                    this.hit(b);
                } else {
                    this.createUnits(b, b.x, b.y);
                }
                if (!this.fragOnHit) {
                    this.createFrags(b, b.x, b.y);
                }
                this.despawnEffect.at(b.x, b.y, b.rotation(), b.team.color);
                this.despawnSound.at((Position)b);
                Effect.shake((float)this.despawnShake, (float)this.despawnShake, (Position)b);
            }

            public void hit(Bullet b, float x, float y) {
                this.hitEffect.at(x, y, b.rotation(), b.team.color);
                this.hitSound.at(x, y, this.hitSoundPitch, this.hitSoundVolume);
                Effect.shake((float)this.hitShake, (float)this.hitShake, (Position)b);
                if (this.fragOnHit) {
                    this.createFrags(b, x, y);
                }
                this.createPuddles(b, x, y);
                this.createIncend(b, x, y);
                this.createUnits(b, x, y);
                if (this.suppressionRange > 0.0f) {
                    Damage.applySuppression((Team)b.team, (float)b.x, (float)b.y, (float)this.suppressionRange, (float)this.suppressionDuration, (float)0.0f, (float)this.suppressionEffectChance, (Position)new Vec2(b.x, b.y));
                }
                this.createSplashDamage(b, x, y);
                for (int i = 0; i < this.lightning; ++i) {
                    Lightning.create((Bullet)b, (Color)b.team.color, (float)(this.lightningDamage < 0.0f ? this.damage : this.lightningDamage), (float)b.x, (float)b.y, (float)(b.rotation() + Mathf.range((float)(this.lightningCone / 2.0f)) + this.lightningAngle), (int)(this.lightningLength + Mathf.random((int)this.lightningLengthRand)));
                }
            }

            public void removed(Bullet b) {
                if (this.trailLength > 0 && b.trail != null && b.trail.size() > 0) {
                    Fx.trailFade.at(b.x, b.y, this.trailWidth, b.team.color, (Object)b.trail.copy());
                }
            }
        };
        guardianBullet = new AccelBulletType(2.0f, 180.0f){
            {
                this.width = 22.0f;
                this.height = 40.0f;
                this.velocityBegin = 1.0f;
                this.velocityIncrease = 11.0f;
                this.accelInterp = NHInterp.inOut;
                this.accelerateBegin = 0.045f;
                this.accelerateEnd = 0.675f;
                this.pierceCap = 3;
                this.splashDamage = this.damage / 4.0f;
                this.splashDamageRadius = 24.0f;
                this.trailLength = 30;
                this.trailWidth = 3.0f;
                this.lifetime = 160.0f;
                this.trailEffect = NHFx.trailFromWhite;
                this.pierceArmor = true;
                this.trailRotation = false;
                this.trailChance = 0.35f;
                this.trailParam = 4.0f;
                this.homingRange = 640.0f;
                this.homingPower = 0.075f;
                this.homingDelay = 5.0f;
                this.lightning = 3;
                this.lightningLengthRand = 10;
                this.lightningLength = 5;
                this.lightningDamage = this.damage / 4.0f;
                this.shootEffect = this.smokeEffect = Fx.none;
                this.hitEffect = this.despawnEffect = new OptionalMultiEffect(new Effect(65.0f, b -> {
                    Draw.color((Color)b.color);
                    Fill.circle((float)b.x, (float)b.y, (float)(6.0f * b.fout((Interp)Interp.pow3Out)));
                    Angles.randLenVectors((long)b.id, (int)6, (float)(35.0f * b.fin() + 5.0f), (x, y) -> Fill.circle((float)(b.x + x), (float)(b.y + y), (float)(4.0f * b.fout((Interp)Interp.pow2Out))));
                }), NHFx.hitSparkLarge);
                this.despawnHit = false;
                this.rangeOverride = 480.0f;
            }

            @Override
            public void update(Bullet b) {
                super.update(b);
            }

            public void updateTrailEffects(Bullet b) {
                if (this.trailChance > 0.0f && Mathf.chanceDelta((double)this.trailChance)) {
                    this.trailEffect.at(b.x, b.y, this.trailRotation ? b.rotation() : this.trailParam, b.team.color);
                }
                if (this.trailInterval > 0.0f && b.timer(0, this.trailInterval)) {
                    this.trailEffect.at(b.x, b.y, this.trailRotation ? b.rotation() : this.trailParam, b.team.color);
                }
            }

            public void hit(Bullet b, float x, float y) {
                b.hit = true;
                this.hitEffect.at(x, y, b.rotation(), b.team.color);
                this.hitSound.at(x, y, this.hitSoundPitch, this.hitSoundVolume);
                Effect.shake((float)this.hitShake, (float)this.hitShake, (Position)b);
                if (this.splashDamageRadius > 0.0f && !b.absorbed) {
                    Damage.damage((Team)b.team, (float)x, (float)y, (float)this.splashDamageRadius, (float)(this.splashDamage * b.damageMultiplier()), (boolean)this.collidesAir, (boolean)this.collidesGround);
                    if (this.status != StatusEffects.none) {
                        Damage.status((Team)b.team, (float)x, (float)y, (float)this.splashDamageRadius, (StatusEffect)this.status, (float)this.statusDuration, (boolean)this.collidesAir, (boolean)this.collidesGround);
                    }
                }
                for (int i = 0; i < this.lightning; ++i) {
                    Lightning.create((Bullet)b, (Color)b.team.color, (float)(this.lightningDamage < 0.0f ? this.damage : this.lightningDamage), (float)b.x, (float)b.y, (float)(b.rotation() + Mathf.range((float)(this.lightningCone / 2.0f)) + this.lightningAngle), (int)(this.lightningLength + Mathf.random((int)this.lightningLengthRand)));
                }
                if (!(b.owner instanceof Unit)) {
                    return;
                }
                Unit from = (Unit)b.owner;
                if (from.dead || !from.isAdded() || from.healthf() > 0.99f) {
                    return;
                }
                NHFx.chainLightningFade.at(b.x, b.y, (float)Mathf.random((int)12, (int)20), b.team.color, (Object)from);
                from.heal(this.damage / 8.0f);
            }

            public void despawned(Bullet b) {
                this.despawnEffect.at(b.x, b.y, b.rotation(), b.team.color);
                Effect.shake((float)this.despawnShake, (float)this.despawnShake, (Position)b);
            }

            public void removed(Bullet b) {
                if (this.trailLength > 0 && b.trail != null && b.trail.size() > 0) {
                    Fx.trailFade.at(b.x, b.y, this.trailWidth, b.team.color, (Object)b.trail.copy());
                }
            }

            public void init(Bullet b) {
                super.init(b);
                b.vel.rotate((float)NHFunc.rand(b.id).random(360));
            }

            public void draw(Bullet b) {
                Tmp.c1.set(b.team.color).lerp(Color.white, Mathf.absin((float)4.0f, (float)0.3f));
                if (this.trailLength > 0 && b.trail != null) {
                    float z = Draw.z();
                    Draw.z((float)(z - 0.01f));
                    b.trail.draw(Tmp.c1, this.trailWidth);
                    Draw.z((float)z);
                }
                Draw.color((Color)b.team.color, (Color)Color.white, (float)0.35f);
                DrawFunc.arrow(b.x, b.y, 5.0f, 35.0f, -6.0f, b.rotation());
                Draw.color((Color)Tmp.c1);
                DrawFunc.arrow(b.x, b.y, 5.0f, 35.0f, 12.0f, b.rotation());
                Draw.reset();
            }
        };
        eternity = new AccelBulletType(10.0f, 1000.0f){
            {
                this.drawSize = 1200.0f;
                this.shrinkY = 0.0f;
                this.shrinkX = 0.0f;
                this.height = 0.0f;
                this.width = 0.0f;
                this.collides = false;
                this.despawnHit = false;
                this.collidesTiles = true;
                this.collidesGround = true;
                this.collidesAir = true;
                this.splashDamage = 4000.0f;
                this.velocityBegin = 6.0f;
                this.velocityIncrease = -5.9f;
                this.accelerateEnd = 0.75f;
                this.accelerateBegin = 0.1f;
                this.accelInterp = Interp.pow2;
                this.trailInterp = Interp.pow10Out;
                this.despawnSound = Sounds.beamPlasma;
                this.hitSound = Sounds.explosion;
                this.hitShake = 60.0f;
                this.despawnShake = 100.0f;
                this.lightning = 12;
                this.lightningDamage = 2000.0f;
                this.lightningLength = 50;
                this.lightningLengthRand = 80;
                this.status = NHStatusEffects.end;
                this.statusDuration = 1200.0f;
                this.fragBullets = 1;
                this.fragBullet = arc_9000;
                this.fragVelocityMin = 0.4f;
                this.fragVelocityMax = 0.6f;
                this.fragLifeMin = 0.5f;
                this.fragLifeMax = 0.7f;
                this.intervalBullet = new AccelBulletType(4.0f, 2000.0f){
                    {
                        super(speed, damage);
                        this.width = 44.0f;
                        this.height = 80.0f;
                        this.velocityBegin = 2.0f;
                        this.velocityIncrease = 11.0f;
                        this.accelInterp = NHInterp.inOut;
                        this.accelerateBegin = 0.045f;
                        this.accelerateEnd = 0.675f;
                        this.pierceCap = 3;
                        this.splashDamage = this.damage / 4.0f;
                        this.splashDamageRadius = 24.0f;
                        this.trailLength = 30;
                        this.trailWidth = 3.0f;
                        this.lifetime = 100.0f;
                        this.trailEffect = NHFx.trailFromWhite;
                        this.pierceArmor = true;
                        this.trailRotation = false;
                        this.trailChance = 0.35f;
                        this.trailParam = 4.0f;
                        this.homingRange = 640.0f;
                        this.homingPower = 0.12f;
                        this.homingDelay = 6.0f;
                        this.lightning = 3;
                        this.lightningLengthRand = 10;
                        this.lightningLength = 5;
                        this.lightningDamage = this.damage / 4.0f;
                        this.shootEffect = this.smokeEffect = Fx.none;
                        this.hitEffect = new OptionalMultiEffect(new Effect(65.0f, b -> {
                            Draw.color((Color)NHColor.darkEnrColor);
                            Fill.circle((float)b.x, (float)b.y, (float)(6.0f * b.fout((Interp)Interp.pow3Out)));
                            Angles.randLenVectors((long)b.id, (int)6, (float)(35.0f * b.fin() + 5.0f), (x, y) -> Fill.circle((float)(b.x + x), (float)(b.y + y), (float)(4.0f * b.fout((Interp)Interp.pow2Out))));
                        }), NHFx.hitSparkLarge);
                        this.despawnEffect = new OptionalMultiEffect(NHFx.crossBlast(NHColor.darkEnrColor, 80.0f), NHFx.circleOut(NHColor.darkEnrColor, 60.0f));
                        this.despawnHit = false;
                        this.rangeOverride = 480.0f;
                    }

                    @Override
                    public void update(Bullet b) {
                        super.update(b);
                    }

                    public void updateTrailEffects(Bullet b) {
                        if (this.trailChance > 0.0f && Mathf.chanceDelta((double)this.trailChance)) {
                            this.trailEffect.at(b.x, b.y, this.trailRotation ? b.rotation() : this.trailParam, NHColor.darkEnrColor);
                        }
                        if (this.trailInterval > 0.0f && b.timer(0, this.trailInterval)) {
                            this.trailEffect.at(b.x, b.y, this.trailRotation ? b.rotation() : this.trailParam, NHColor.darkEnrColor);
                        }
                    }

                    public void hit(Bullet b, float x, float y) {
                        b.hit = true;
                        this.hitEffect.at(x, y, b.rotation(), NHColor.darkEnrColor);
                        this.hitSound.at(x, y, this.hitSoundPitch, this.hitSoundVolume);
                        Effect.shake((float)this.hitShake, (float)this.hitShake, (Position)b);
                        if (this.splashDamageRadius > 0.0f && !b.absorbed) {
                            Damage.damage((Team)b.team, (float)x, (float)y, (float)this.splashDamageRadius, (float)(this.splashDamage * b.damageMultiplier()), (boolean)this.collidesAir, (boolean)this.collidesGround);
                            if (this.status != StatusEffects.none) {
                                Damage.status((Team)b.team, (float)x, (float)y, (float)this.splashDamageRadius, (StatusEffect)this.status, (float)this.statusDuration, (boolean)this.collidesAir, (boolean)this.collidesGround);
                            }
                        }
                        for (int i = 0; i < this.lightning; ++i) {
                            Lightning.create((Bullet)b, (Color)NHColor.darkEnrColor, (float)(this.lightningDamage < 0.0f ? this.damage : this.lightningDamage), (float)b.x, (float)b.y, (float)(b.rotation() + Mathf.range((float)(this.lightningCone / 2.0f)) + this.lightningAngle), (int)(this.lightningLength + Mathf.random((int)this.lightningLengthRand)));
                        }
                        if (!(b.owner instanceof Unit)) {
                            return;
                        }
                        Unit from = (Unit)b.owner;
                        if (from.dead || !from.isAdded() || from.healthf() > 0.99f) {
                            return;
                        }
                        NHFx.chainLightningFade.at(b.x, b.y, (float)Mathf.random((int)12, (int)20), NHColor.darkEnrColor, (Object)from);
                        from.heal(this.damage / 8.0f);
                    }

                    public void despawned(Bullet b) {
                        this.despawnEffect.at(b.x, b.y, b.rotation(), NHColor.darkEnrColor);
                        Effect.shake((float)this.despawnShake, (float)this.despawnShake, (Position)b);
                    }

                    public void removed(Bullet b) {
                        if (this.trailLength > 0 && b.trail != null && b.trail.size() > 0) {
                            Fx.trailFade.at(b.x, b.y, this.trailWidth, NHColor.darkEnrColor, (Object)b.trail.copy());
                        }
                    }

                    public void init(Bullet b) {
                        super.init(b);
                        b.vel.rotate((float)NHFunc.rand(b.id).random(360));
                    }

                    public void draw(Bullet b) {
                        Tmp.c1.set(NHColor.darkEnrColor).lerp(Color.white, Mathf.absin((float)4.0f, (float)0.3f));
                        if (this.trailLength > 0 && b.trail != null) {
                            float z = Draw.z();
                            Draw.z((float)(z - 0.01f));
                            b.trail.draw(Tmp.c1, this.trailWidth);
                            Draw.z((float)z);
                        }
                        Draw.color((Color)NHColor.darkEnrColor, (Color)Color.white, (float)0.35f);
                        DrawFunc.arrow(b.x, b.y, 5.0f, 35.0f, -6.0f, b.rotation());
                        Draw.color((Color)Tmp.c1);
                        DrawFunc.arrow(b.x, b.y, 5.0f, 35.0f, 12.0f, b.rotation());
                        Draw.reset();
                    }
                };
                this.bulletInterval = 3.0f;
                this.intervalRandomSpread = 20.0f;
                this.intervalBullets = 2;
                this.intervalAngle = 360.0f;
                this.intervalSpread = 360.0f;
                this.trailWidth = 12.0f;
                this.trailLength = 120;
                this.ammoMultiplier = 1.0f;
                this.hittable = false;
                this.scaleLife = true;
                this.splashDamageRadius = 400.0f;
                this.lightningColor = this.trailColor = NHColor.darkEnrColor;
                this.lightColor = this.trailColor;
                this.hitColor = this.trailColor;
                Effect effect = NHFx.crossBlast(this.hitColor, 420.0f, 45.0f);
                effect.lifetime += 180.0f;
                this.despawnEffect = NHFx.circleOut(this.hitColor, this.splashDamageRadius);
                this.hitEffect = new OptionalMultiEffect(NHFx.blast(this.hitColor, 200.0f), new Effect(180.0f, 600.0f, e -> {
                    float rad = 120.0f;
                    float f = (e.fin((Interp)Interp.pow10Out) + 8.0f) / 9.0f * Mathf.curve((float)Interp.slowFast.apply(e.fout(0.75f)), (float)0.0f, (float)0.85f);
                    Draw.alpha((float)(0.9f * e.foutpowdown()));
                    Draw.color((Color)Color.white, (Color)e.color, (float)(e.fin() + 0.6f));
                    Fill.circle((float)e.x, (float)e.y, (float)(rad * f));
                    e.scaled(45.0f, i -> {
                        Lines.stroke((float)(7.0f * i.fout()));
                        Lines.circle((float)i.x, (float)i.y, (float)(rad * 3.0f * i.finpowdown()));
                        Lines.circle((float)i.x, (float)i.y, (float)(rad * 2.0f * i.finpowdown()));
                    });
                    Draw.color((Color)Color.white);
                    Fill.circle((float)e.x, (float)e.y, (float)(rad * f * 0.75f));
                    Drawf.light((float)e.x, (float)e.y, (float)(rad * f * 2.0f), (Color)Draw.getColor(), (float)0.7f);
                }).layer(110.001f), effect, new Effect(260.0f, 460.0f, e -> {
                    Draw.blend((Blending)Blending.additive);
                    Draw.z((float)114.2f);
                    float radius = e.fin((Interp)Interp.pow3Out) * 230.0f;
                    Fill.light((float)e.x, (float)e.y, (int)Lines.circleVertices((float)radius), (float)radius, (Color)Color.clear, (Color)Tmp.c1.set(NHColor.darkEnrColor).a(e.fout((Interp)Interp.pow10Out)));
                    Draw.blend();
                }));
            }

            public void draw(Bullet b) {
                super.draw(b);
                Draw.color((Color)NHColor.darkEnrColor, (Color)Color.white, (float)(b.fout() * 0.25f));
                float rand = Mathf.randomSeed((long)b.id, (float)60.0f);
                float extend = Mathf.curve((float)b.fin((Interp)Interp.pow10Out), (float)0.075f, (float)1.0f);
                float rot = b.fout((Interp)Interp.pow10In);
                float chargeCircleFrontRad = 20.0f;
                float width = chargeCircleFrontRad * 1.2f;
                Fill.circle((float)b.x, (float)b.y, (float)(width * (b.fout() + 4.0f) / 3.5f));
                float rotAngle = b.fdata;
                for (int i : Mathf.signs) {
                    DrawFunc.tri(b.x, b.y, width * b.foutpowdown(), 200.0f + 570.0f * extend, rotAngle + (float)(90 * i) - 45.0f);
                }
                for (int i : Mathf.signs) {
                    DrawFunc.tri(b.x, b.y, width * b.foutpowdown(), 200.0f + 570.0f * extend, rotAngle + (float)(90 * i) + 45.0f);
                }
                if (NHSetting.enableDetails()) {
                    float cameraFin = (1.0f + 2.0f * DrawFunc.cameraDstScl(b.x, b.y, Vars.mobile ? 200.0f : 320.0f)) / 3.0f;
                    float triWidth = b.fout() * chargeCircleFrontRad * cameraFin;
                    for (int i : Mathf.signs) {
                        Fill.tri((float)b.x, (float)(b.y + triWidth), (float)b.x, (float)(b.y - triWidth), (float)(b.x + (float)i * cameraFin * chargeCircleFrontRad * (23.0f + Mathf.absin((float)10.0f, (float)0.75f)) * (b.fout() * 1.25f + 1.0f)), (float)b.y);
                    }
                }
                float rad = this.splashDamageRadius * b.fin((Interp)Interp.pow5Out) * Interp.circleOut.apply(b.fout(0.15f));
                Lines.stroke((float)(8.0f * b.fin((Interp)Interp.pow2Out)));
                Lines.circle((float)b.x, (float)b.y, (float)rad);
                Draw.color((Color)Color.white);
                Fill.circle((float)b.x, (float)b.y, (float)(width * (b.fout() + 4.0f) / 5.5f));
                Drawf.light((float)b.x, (float)b.y, (float)rad, (Color)this.hitColor, (float)0.5f);
            }

            public void init(Bullet b) {
                super.init(b);
                b.fdata = Mathf.randomSeed((long)b.id, (float)90.0f);
            }

            @Override
            public void update(Bullet b) {
                super.update(b);
                b.fdata += b.vel.len() / 3.0f;
            }

            public void despawned(Bullet b) {
                super.despawned(b);
                float rad = 120.0f;
                float spacing = 3.0f;
                Angles.randLenVectors((long)b.id, (int)8, (float)(this.splashDamageRadius / 1.25f), (x, y) -> {
                    float nowX = b.x + x;
                    float nowY = b.y + y;
                    Vec2 vec2 = new Vec2(nowX, nowY);
                    Team team = b.team;
                    float mul = b.damageMultiplier();
                    Time.run((float)(Mathf.random((float)6.0f, (float)24.0f) + Mathf.sqrt((float)(x * x + y * y)) / this.splashDamageRadius * 3.0f), () -> {
                        int i;
                        if (Mathf.chanceDelta((double)0.4f)) {
                            this.hitSound.at(vec2.x, vec2.y, this.hitSoundPitch, this.hitSoundVolume);
                        }
                        this.despawnSound.at((Position)vec2);
                        Effect.shake((float)this.hitShake, (float)this.hitShake, (Position)vec2);
                        for (i = 0; i < this.lightning / 2; ++i) {
                            Lightning.create((Team)team, (Color)this.lightningColor, (float)this.lightningDamage, (float)vec2.x, (float)vec2.y, (float)Mathf.random((float)360.0f), (int)(this.lightningLength + Mathf.random((int)this.lightningLengthRand)));
                        }
                        this.hitEffect.at(vec2.x, vec2.y, 0.0f, this.hitColor);
                        this.hitSound.at(vec2.x, vec2.y, this.hitSoundPitch, this.hitSoundVolume);
                        if (this.fragBullet != null) {
                            for (i = 0; i < this.fragBullets; ++i) {
                                this.fragBullet.create((Entityc)team.cores().firstOpt(), team, vec2.x, vec2.y, (float)Mathf.random((int)360), Mathf.random((float)this.fragVelocityMin, (float)this.fragVelocityMax), Mathf.random((float)this.fragLifeMin, (float)this.fragLifeMax));
                            }
                        }
                        if (this.splashDamageRadius > 0.0f && !b.absorbed) {
                            Damage.damage((Team)team, (float)vec2.x, (float)vec2.y, (float)this.splashDamageRadius, (float)(this.splashDamage * mul), (boolean)this.collidesAir, (boolean)this.collidesGround);
                            if (this.status != StatusEffects.none) {
                                Damage.status((Team)team, (float)vec2.x, (float)vec2.y, (float)this.splashDamageRadius, (StatusEffect)this.status, (float)this.statusDuration, (boolean)this.collidesAir, (boolean)this.collidesGround);
                            }
                        }
                    });
                });
            }
        };
        RaidBullets.load();
    }

    static {
        MISSILE_LARGE = "missile-large";
        MINE_BULLET = "mine-bullet";
    }
}

