/*
 * Decompiled with CFR 0.152.
 */
package newhorizon;

import arc.Core;
import arc.Events;
import arc.func.Boolp;
import arc.func.Floatp;
import arc.func.Intp;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.ImageButton;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.layout.Collapser;
import arc.scene.ui.layout.Stack;
import arc.scene.ui.layout.Table;
import arc.scene.ui.layout.WidgetGroup;
import arc.util.Log;
import arc.util.Reflect;
import arc.util.Scaling;
import java.util.concurrent.atomic.AtomicInteger;
import mindustry.Vars;
import mindustry.core.UI;
import mindustry.editor.MapEditorDialog;
import mindustry.game.EventType;
import mindustry.game.MapObjectives;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import newhorizon.content.NHContent;
import newhorizon.expand.game.MapObjectives.ReuseObjective;
import newhorizon.expand.game.MapObjectives.TriggerObjective;
import newhorizon.util.ui.DelayCollapser;
import newhorizon.util.ui.DelaySlideBar;
import newhorizon.util.ui.ObjectiveSign;
import newhorizon.util.ui.dialog.NHWorldSettingDialog;
import newhorizon.util.ui.frag.PayloadInventoryFragment;

public class NHUI {
    public static final float maxWidth = 329.0f;
    public static Table HUD_overlay;
    public static Table HUD_waves;
    public static Table HUD_statustable;
    public static Table HUD_status;
    public static Table itemInv;
    public static WidgetGroup HUD_waves_editor;
    public static Element infoTable;
    public static NHWorldSettingDialog nhWorldSettingDialog;
    public static PayloadInventoryFragment payloadInventoryFragment;

    public static void init() {
        nhWorldSettingDialog = new NHWorldSettingDialog();
        try {
            NHUI.getReferences();
            NHUI.rebuildSkipButton();
            NHUI.preProcess();
            NHUI.buildObjectiveTable();
            NHUI.postProcess();
        }
        catch (Exception e) {
            Log.err((Throwable)e);
        }
        payloadInventoryFragment = new PayloadInventoryFragment();
        payloadInventoryFragment.build(NHUI.itemInv.parent);
        Events.run((Object)EventType.Trigger.update, () -> {
            NHUI.payloadInventoryFragment.table.visible = NHUI.itemInv.visible && !Vars.state.isMenu();
            payloadInventoryFragment.rebuild();
        });
        try {
            BaseDialog menu = (BaseDialog)Reflect.get(MapEditorDialog.class, (Object)Vars.ui.editor, (String)"menu");
            menu.cont.row().button("@mod.ui.nh-extra-menu", (Drawable)new TextureRegionDrawable(NHContent.icon), 30.0f, () -> nhWorldSettingDialog.show()).padTop(1.0f).size(370.0f, 60.0f);
        }
        catch (Exception e) {
            Log.err((Throwable)e);
        }
    }

    public static void getReferences() {
        HUD_overlay = (Table)Vars.ui.hudGroup.find("overlaymarker");
        HUD_waves_editor = (WidgetGroup)HUD_overlay.find("waves/editor");
        HUD_waves = (Table)HUD_waves_editor.find("waves");
        HUD_statustable = (Table)HUD_waves.find("statustable");
        HUD_status = (Table)HUD_statustable.find("status");
        itemInv = (Table)Vars.ui.hudGroup.find("inventory");
    }

    public static void rebuildSkipButton() {
        final ImageButton skip = (ImageButton)HUD_statustable.find("skip");
        skip.setStyle((Button.ButtonStyle)new ImageButton.ImageButtonStyle(){
            {
                this.over = Tex.buttonSelectTrans;
                this.down = Tex.whitePane;
                this.up = Tex.pane;
                this.imageUp = Icon.play;
                this.disabled = Tex.paneRight;
                this.imageDisabledColor = Color.clear;
                this.imageUpColor = Color.white;
            }
        });
        skip.addChild(new Table(Tex.underline){
            {
                super(arg0);
                this.touchable = Touchable.disabled;
                this.setSize(skip.getWidth(), skip.getHeight());
            }
        }.visible(() -> !Vars.state.rules.waves || !Vars.state.rules.waveSending || !Vars.net.server() && !Vars.player.admin && Vars.net.active() || Vars.state.enemies != 0 || Vars.spawner.isSpawning()));
    }

    public static void preProcess() {
        infoTable = HUD_waves.find("infotable");
        infoTable.remove();
    }

    public static void postProcess() {
        HUD_waves.add(infoTable).width(329.0f).left();
    }

    public static void buildObjectiveTable() {
        HUD_waves.row().add((Element)new Table(Tex.buttonEdge4, t -> {
            Table infoT = new Table();
            infoT.touchable = Touchable.childrenOnly;
            ImageButton b = new ImageButton((Drawable)Icon.downOpen, Styles.clearNonei);
            b.clicked(() -> {
                if (b.isChecked()) {
                    infoT.clear();
                    infoT.table().padTop(4.0f);
                    ScrollPane pane = (ScrollPane)infoT.pane(Styles.smallPane, i -> {
                        i.align(10).defaults().growX().fillY().row();
                        Vars.state.rules.objectives.each(mapObjective -> {
                            Boolp shown = () -> mapObjective.qualified() && !mapObjective.hidden;
                            DelayCollapser col = new DelayCollapser(NHUI.getObjectiveTable(mapObjective), !shown.get());
                            col.setCollapsed(true, () -> !shown.get());
                            i.add((Element)col).row();
                        });
                    }).grow().maxHeight(NHUI.getHeight() / 2.0f).get();
                    pane.name = "pane";
                    pane.setFadeScrollBars(true);
                    pane.setForceScroll(false, true);
                    infoT.exited(() -> Core.scene.unfocus((Element)infoT));
                } else {
                    Core.scene.unfocus((Element)infoT);
                }
            });
            b.update(() -> {
                if (Vars.state.isMenu()) {
                    b.setChecked(false);
                }
            });
            t.table(bl -> {
                bl.table(table -> table.label(() -> {
                    AtomicInteger activeCount = new AtomicInteger();
                    Vars.state.rules.objectives.each(obj -> {
                        if (obj.qualified() && !obj.hidden) {
                            activeCount.getAndIncrement();
                        }
                    });
                    return activeCount.get() == 0 ? "[lightgray]No Objective[]" : activeCount.get() + " Objective(s)";
                }).maxWidth(289.0f).pad(8.0f, 16.0f, 8.0f, 0.0f).row()).growX().height(50.0f).marginLeft(10.0f);
                bl.add((Element)b).size(50.0f).padLeft(10.0f);
            }).growX().fillY().margin(4.0f).padBottom(4.0f);
            ((Collapser)t.row().collapser(infoT, true, () -> ((ImageButton)b).isChecked()).growX().get()).setDuration(0.1f);
        })).left().margin(10.0f).growX().row();
    }

    public static Table getObjectiveTable(MapObjectives.MapObjective e) {
        return new Table(t -> {
            Floatp realTime;
            Floatp countup;
            Object obj;
            t.defaults().growX().fillY().padBottom(6.0f).pad(6.0f);
            if (e instanceof MapObjectives.ResearchObjective) {
                obj = (MapObjectives.ResearchObjective)e;
                t.add((Element)NHUI.objectiveTable(obj.content.fullIcon, () -> NHUI.lambda$getObjectiveTable$15((MapObjectives.ResearchObjective)obj), () -> 1, (Prov<CharSequence>)((Prov)() -> "Research:"), () -> ((MapObjectives.ResearchObjective)obj).isCompleted()));
            }
            if (e instanceof MapObjectives.ItemObjective) {
                obj = (MapObjectives.ItemObjective)e;
                t.add((Element)NHUI.objectiveTable(obj.item.fullIcon, () -> NHUI.lambda$getObjectiveTable$18((MapObjectives.ItemObjective)obj), () -> NHUI.lambda$getObjectiveTable$19((MapObjectives.ItemObjective)obj), (Prov<CharSequence>)((Prov)() -> "Obtain:"), () -> ((MapObjectives.ItemObjective)obj).isCompleted()));
            }
            if (e instanceof MapObjectives.CoreItemObjective) {
                obj = (MapObjectives.CoreItemObjective)e;
                t.add((Element)NHUI.objectiveTable(obj.item.fullIcon, () -> NHUI.lambda$getObjectiveTable$21((MapObjectives.CoreItemObjective)obj), () -> NHUI.lambda$getObjectiveTable$22((MapObjectives.CoreItemObjective)obj), (Prov<CharSequence>)((Prov)() -> "Collect:"), () -> ((MapObjectives.CoreItemObjective)obj).isCompleted()));
            }
            if (e instanceof MapObjectives.BuildCountObjective) {
                obj = (MapObjectives.BuildCountObjective)e;
                t.add((Element)NHUI.objectiveTable(obj.block.fullIcon, () -> NHUI.lambda$getObjectiveTable$24((MapObjectives.BuildCountObjective)obj), () -> NHUI.lambda$getObjectiveTable$25((MapObjectives.BuildCountObjective)obj), (Prov<CharSequence>)((Prov)() -> "Build:"), () -> ((MapObjectives.BuildCountObjective)obj).isCompleted()));
            }
            if (e instanceof MapObjectives.UnitCountObjective) {
                obj = (MapObjectives.UnitCountObjective)e;
                t.add((Element)NHUI.objectiveTable(obj.unit.fullIcon, () -> NHUI.lambda$getObjectiveTable$27((MapObjectives.UnitCountObjective)obj), () -> NHUI.lambda$getObjectiveTable$28((MapObjectives.UnitCountObjective)obj), (Prov<CharSequence>)((Prov)() -> "Build:"), () -> ((MapObjectives.UnitCountObjective)obj).isCompleted()));
            }
            if (e instanceof MapObjectives.DestroyUnitsObjective) {
                obj = (MapObjectives.DestroyUnitsObjective)e;
                t.add((Element)NHUI.objectiveTable(Icon.units.getRegion(), () -> Vars.state.stats.enemyUnitsDestroyed, () -> NHUI.lambda$getObjectiveTable$31((MapObjectives.DestroyUnitsObjective)obj), (Prov<CharSequence>)((Prov)() -> "Destroy:"), () -> ((MapObjectives.DestroyUnitsObjective)obj).isCompleted()));
            }
            if (e instanceof MapObjectives.TimerObjective) {
                obj = (MapObjectives.TimerObjective)e;
                countup = () -> NHUI.lambda$getObjectiveTable$33((MapObjectives.TimerObjective)obj);
                realTime = () -> NHUI.lambda$getObjectiveTable$34((MapObjectives.TimerObjective)obj);
                t.add((Element)NHUI.objectiveTable(Icon.refresh.getRegion(), () -> (int)countup.get(), () -> (int)realTime.get(), (Prov<CharSequence>)((Prov)() -> UI.formatTime((float)countup.get()) + "/" + UI.formatTime((float)realTime.get())), () -> ((MapObjectives.TimerObjective)obj).isCompleted(), false));
            }
            if (e instanceof MapObjectives.DestroyBlockObjective) {
                obj = (MapObjectives.DestroyBlockObjective)e;
                t.add((Element)NHUI.objectiveTable(obj.block.fullIcon, () -> NHUI.lambda$getObjectiveTable$38((MapObjectives.DestroyBlockObjective)obj), () -> 1, (Prov<CharSequence>)((Prov)() -> NHUI.lambda$getObjectiveTable$40((MapObjectives.DestroyBlockObjective)obj)), () -> ((MapObjectives.DestroyBlockObjective)obj).isCompleted()));
            }
            if (e instanceof MapObjectives.DestroyBlocksObjective) {
                obj = (MapObjectives.DestroyBlocksObjective)e;
                t.add((Element)NHUI.objectiveTable(obj.block.fullIcon, () -> ((MapObjectives.DestroyBlocksObjective)obj).progress(), () -> NHUI.lambda$getObjectiveTable$41((MapObjectives.DestroyBlocksObjective)obj), (Prov<CharSequence>)((Prov)() -> NHUI.lambda$getObjectiveTable$42((MapObjectives.DestroyBlocksObjective)obj)), () -> ((MapObjectives.DestroyBlocksObjective)obj).isCompleted()));
            }
            if (e instanceof MapObjectives.CommandModeObjective) {
                obj = (MapObjectives.CommandModeObjective)e;
                t.add((Element)NHUI.objectiveTable(Icon.units.getRegion(), () -> NHUI.lambda$getObjectiveTable$43((MapObjectives.CommandModeObjective)obj), () -> 1, (Prov<CharSequence>)((Prov)() -> ((MapObjectives.CommandModeObjective)obj).text()), () -> ((MapObjectives.CommandModeObjective)obj).isCompleted()));
            }
            if (e instanceof MapObjectives.FlagObjective) {
                obj = (MapObjectives.FlagObjective)e;
                t.add((Element)NHUI.objectiveTable(Icon.info.getRegion(), () -> NHUI.lambda$getObjectiveTable$45((MapObjectives.FlagObjective)obj), () -> 1, (Prov<CharSequence>)((Prov)() -> ((MapObjectives.FlagObjective)obj).text()), () -> ((MapObjectives.FlagObjective)obj).isCompleted()));
            }
            if (e instanceof MapObjectives.DestroyCoreObjective) {
                obj = (MapObjectives.DestroyCoreObjective)e;
                t.add((Element)NHUI.objectiveTable(Icon.effect.getRegion(), () -> NHUI.lambda$getObjectiveTable$47((MapObjectives.DestroyCoreObjective)obj), () -> 1, (Prov<CharSequence>)((Prov)() -> ((MapObjectives.DestroyCoreObjective)obj).text()), () -> ((MapObjectives.DestroyCoreObjective)obj).isCompleted()));
            }
            if (e instanceof ReuseObjective) {
                obj = (ReuseObjective)e;
                countup = ((ReuseObjective)((Object)((Object)obj)))::getCountup;
                realTime = () -> NHUI.lambda$getObjectiveTable$49((ReuseObjective)((Object)((Object)obj)));
                t.add((Element)NHUI.objectiveTable(Icon.refresh.getRegion(), () -> (int)countup.get(), () -> (int)realTime.get(), (Prov<CharSequence>)((Prov)() -> UI.formatTime((float)countup.get()) + "/" + UI.formatTime((float)realTime.get())), () -> ((ReuseObjective)((Object)((Object)obj))).isCompleted(), false));
            }
            if (e instanceof TriggerObjective) {
                obj = (TriggerObjective)e;
                countup = ((TriggerObjective)((Object)((Object)obj)))::getCountup;
                realTime = () -> NHUI.lambda$getObjectiveTable$53((TriggerObjective)((Object)((Object)obj)));
                TextureRegion region = NHContent.objective;
                if (obj.timer.contains("event-0") || obj.timer.contains("raid")) {
                    region = NHContent.raid;
                }
                if (obj.timer.contains("event-1") || obj.timer.contains("fleet")) {
                    region = NHContent.fleet;
                }
                TextureRegion finalRegion = region;
                t.add((Element)new Stack(new Element[]{new Table(table -> table.add((Element)new DelaySlideBar((Prov<Color>)((Prov)() -> Pal.accent), (Prov<CharSequence>)((Prov)() -> "     " + UI.formatTime((float)countup.get()) + "/" + UI.formatTime((float)realTime.get())), () -> Mathf.clamp((float)(countup.get() / realTime.get())))).padLeft(20.0f).height(40.0f).expandX().fillX()), new Table(table -> table.image(finalRegion).size(56.0f).pad(-8.0f).expandX().left())}));
            }
        });
    }

    public static Stack objectiveTable(TextureRegion region, Intp value, Intp target, Prov<CharSequence> info, Boolp checked, boolean text) {
        return new Stack(new Element[]{new Table(table -> table.add((Element)new DelaySlideBar((Prov<Color>)((Prov)() -> Pal.accent), (Prov<CharSequence>)((Prov)() -> "            " + info.get() + (text ? value.get() + "/" + target.get() : "")), () -> Mathf.clamp((float)((float)value.get() / (float)target.get())))).padLeft(20.0f).height(40.0f).expandX().fillX()), new Table(image -> image.image(region).scaling(Scaling.fit).size(32.0f).padTop(4.0f).padBottom(4.0f).padLeft(56.0f).padRight(8.0f)).left(), new Table(table -> table.add((Element)new ObjectiveSign(Pal.gray, Pal.accent, 2.0f, 4.0f, 5.0f, checked)).size(40.0f).expandX().left())});
    }

    public static Stack objectiveTable(TextureRegion region, Intp value, Intp target, Prov<CharSequence> info, Boolp checked) {
        return NHUI.objectiveTable(region, value, target, info, checked, true);
    }

    public static float getWidth() {
        return Core.graphics.getWidth();
    }

    public static float getHeight() {
        return Core.graphics.getHeight();
    }

    private static /* synthetic */ float lambda$getObjectiveTable$53(TriggerObjective obj) {
        return obj.duration;
    }

    private static /* synthetic */ float lambda$getObjectiveTable$49(ReuseObjective obj) {
        return obj.duration * Vars.state.rules.objectiveTimerMultiplier;
    }

    private static /* synthetic */ int lambda$getObjectiveTable$47(MapObjectives.DestroyCoreObjective obj) {
        return Mathf.num((boolean)obj.isCompleted());
    }

    private static /* synthetic */ int lambda$getObjectiveTable$45(MapObjectives.FlagObjective obj) {
        return Mathf.num((boolean)obj.isCompleted());
    }

    private static /* synthetic */ int lambda$getObjectiveTable$43(MapObjectives.CommandModeObjective obj) {
        return Mathf.num((boolean)obj.isCompleted());
    }

    private static /* synthetic */ CharSequence lambda$getObjectiveTable$42(MapObjectives.DestroyBlocksObjective obj) {
        return "Destroy:" + obj.block.localizedName;
    }

    private static /* synthetic */ int lambda$getObjectiveTable$41(MapObjectives.DestroyBlocksObjective obj) {
        return obj.positions.length;
    }

    private static /* synthetic */ CharSequence lambda$getObjectiveTable$40(MapObjectives.DestroyBlockObjective obj) {
        return "Destroy:" + obj.block.localizedName;
    }

    private static /* synthetic */ int lambda$getObjectiveTable$38(MapObjectives.DestroyBlockObjective obj) {
        return Mathf.num((boolean)obj.isCompleted());
    }

    private static /* synthetic */ float lambda$getObjectiveTable$34(MapObjectives.TimerObjective obj) {
        return obj.duration * Vars.state.rules.objectiveTimerMultiplier;
    }

    private static /* synthetic */ float lambda$getObjectiveTable$33(MapObjectives.TimerObjective obj) {
        return ((Float)Reflect.get((Object)obj, (String)"countup")).floatValue();
    }

    private static /* synthetic */ int lambda$getObjectiveTable$31(MapObjectives.DestroyUnitsObjective obj) {
        return obj.count;
    }

    private static /* synthetic */ int lambda$getObjectiveTable$28(MapObjectives.UnitCountObjective obj) {
        return obj.count;
    }

    private static /* synthetic */ int lambda$getObjectiveTable$27(MapObjectives.UnitCountObjective obj) {
        return Vars.state.rules.defaultTeam.data().countType(obj.unit);
    }

    private static /* synthetic */ int lambda$getObjectiveTable$25(MapObjectives.BuildCountObjective obj) {
        return obj.count;
    }

    private static /* synthetic */ int lambda$getObjectiveTable$24(MapObjectives.BuildCountObjective obj) {
        return Vars.state.stats.placedBlockCount.get((Object)obj.block, 0);
    }

    private static /* synthetic */ int lambda$getObjectiveTable$22(MapObjectives.CoreItemObjective obj) {
        return obj.amount;
    }

    private static /* synthetic */ int lambda$getObjectiveTable$21(MapObjectives.CoreItemObjective obj) {
        return Vars.state.stats.coreItemCount.get((Object)obj.item);
    }

    private static /* synthetic */ int lambda$getObjectiveTable$19(MapObjectives.ItemObjective obj) {
        return obj.amount;
    }

    private static /* synthetic */ int lambda$getObjectiveTable$18(MapObjectives.ItemObjective obj) {
        return Vars.state.rules.defaultTeam.items().get(obj.item);
    }

    private static /* synthetic */ int lambda$getObjectiveTable$15(MapObjectives.ResearchObjective obj) {
        return Mathf.num((boolean)obj.isCompleted());
    }
}

