function getBridge() {
  const bridge = globalThis.__NAPCAT_BRIDGE__;
  if (!bridge) throw new Error('[QCE Overlay] Bridge未初始化');
  return bridge;
}

export class OneBotMsgApi {
  constructor(obContext, core) {
    this.obContext = obContext;
    this.core = core;
  }

  async parseMessage(message, quickReply = false) {
    return this.parseMessageV2(message, true, false, quickReply);
  }

  async parseMessageV2(message, parseMultiForward = true, rawMessage = false, quickReply = false) {
    const { core } = getBridge();
    if (core?.onebot?.msgApi?.parseMessageV2) {
      return core.onebot.msgApi.parseMessageV2(message, parseMultiForward, rawMessage, quickReply);
    }
    
    return {
      arrayMsg: {
        message_id: message.msgId,
        message_seq: message.msgSeq,
        time: parseInt(message.msgTime),
        sender: { user_id: message.senderUin, nickname: message.sendNickName },
        message: [],
        raw_message: '',
        message_type: message.chatType === 2 ? 'group' : 'private'
      }
    };
  }
}

export default OneBotMsgApi;
