/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.util.Time;
import mindustry.gen.Building;
import mindustry.world.draw.DrawBlock;

public class DrawBubbles
extends DrawBlock {
    public Color color = Color.valueOf("7457ce");
    public int amount = 12;
    public int sides = 8;
    public float strokeMin = 0.2f;
    public float spread = 3.0f;
    public float timeScl = 30.0f;
    public float recurrence = 6.0f;
    public float radius = 3.0f;
    public boolean fill = false;

    public DrawBubbles(Color color) {
        this.color = color;
    }

    public DrawBubbles() {
    }

    @Override
    public void draw(Building build) {
        if (build.warmup() <= 0.001f) {
            return;
        }
        Draw.color(this.color);
        Draw.alpha(build.warmup());
        rand.setSeed(build.id);
        for (int i = 0; i < this.amount; ++i) {
            float x = rand.range(this.spread);
            float y = rand.range(this.spread);
            float life = 1.0f - (Time.time / this.timeScl + rand.random(this.recurrence)) % this.recurrence;
            if (!(life > 0.0f)) continue;
            float rad = (1.0f - life) * this.radius;
            if (this.fill) {
                Fill.circle(build.x + x, build.y + y, rad);
                continue;
            }
            Lines.stroke(build.warmup() * (life + this.strokeMin));
            Lines.poly(build.x + x, build.y + y, this.sides, rad);
        }
        Draw.color();
    }
}

