/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.units;

import arc.Core;
import arc.Events;
import arc.Graphics;
import arc.audio.Sound;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.ImageButton;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.ai.UnitCommand;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.gen.Player;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.io.TypeIO;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.UnitType;
import mindustry.ui.Bar;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.blocks.units.UnitBlock;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;

public class Reconstructor
extends UnitBlock {
    public float constructTime = 120.0f;
    public Seq<UnitType[]> upgrades = new Seq();
    public int[] capacities = new int[0];
    public Sound createSound = Sounds.unitCreate;
    public float createSoundVolume = 1.0f;

    public Reconstructor(String name) {
        super(name);
        this.regionRotated1 = 1;
        this.regionRotated2 = 2;
        this.commandable = true;
        this.ambientSound = Sounds.loopUnitBuilding;
        this.configurable = true;
        this.config(UnitCommand.class, (build, command) -> {
            build.command = command;
        });
        this.configClear(build -> {
            build.command = null;
        });
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect(this.region, plan.drawx(), plan.drawy());
        Draw.rect(this.inRegion, plan.drawx(), plan.drawy(), (float)(plan.rotation * 90));
        Draw.rect(this.outRegion, plan.drawx(), plan.drawy(), (float)(plan.rotation * 90));
        Draw.rect(this.topRegion, plan.drawx(), plan.drawy());
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.inRegion, this.outRegion, this.topRegion};
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("progress", entity -> new Bar("bar.progress", Pal.ammo, entity::fraction));
        this.addBar("units", e -> new Bar(() -> e.unit() == null ? "[lightgray]\ue815" : Core.bundle.format("bar.unitcap", Fonts.getUnicodeStr(e.unit().name), e.team.data().countType(e.unit()), e.unit() == null || e.unit().useUnitCap ? Units.getStringCap(e.team) : "\u221e"), () -> Pal.power, () -> e.unit() == null ? 0.0f : (e.unit().useUnitCap ? (float)e.team.data().countType(e.unit()) / (float)Units.getCap(e.team) : 1.0f)));
    }

    @Override
    public void setStats() {
        this.stats.timePeriod = this.constructTime;
        super.setStats();
        this.stats.add(Stat.productionTime, this.constructTime / 60.0f, StatUnit.seconds);
        this.stats.add(Stat.output, table -> {
            table.row();
            for (UnitType[] upgrade : this.upgrades) {
                if (!upgrade[0].unlockedNow() || !upgrade[1].unlockedNow()) continue;
                table.table(Styles.grayPanel, t -> {
                    t.left();
                    t.image(upgrade[0].uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit).with(i -> StatValues.withTooltip(i, upgrade[0]));
                    t.table(info -> {
                        info.add(upgrade[0].localizedName).left();
                        info.row();
                    }).pad(10.0f).left();
                }).fill().padTop(5.0f).padBottom(5.0f);
                table.table(Styles.grayPanel, t -> t.image(Icon.right).color(Pal.darkishGray).size(40.0f).pad(10.0f)).fill().padTop(5.0f).padBottom(5.0f);
                table.table(Styles.grayPanel, t -> {
                    t.left();
                    t.image(upgrade[1].uiIcon).size(40.0f).pad(10.0f).right().scaling(Scaling.fit).with(i -> StatValues.withTooltip(i, upgrade[1]));
                    t.table(info -> {
                        info.add(upgrade[1].localizedName).right();
                        info.row();
                    }).pad(10.0f).right();
                }).fill().padTop(5.0f).padBottom(5.0f);
                table.row();
            }
        });
    }

    @Override
    public void init() {
        this.initCapacities();
        super.init();
    }

    @Override
    public void afterPatch() {
        this.initCapacities();
        super.afterPatch();
    }

    public void initCapacities() {
        this.capacities = new int[Vars.content.items().size];
        this.itemCapacity = 10;
        ConsumeItems cons = (ConsumeItems)this.findConsumer(c -> c instanceof ConsumeItems);
        if (cons != null) {
            for (ItemStack stack : cons.items) {
                this.capacities[stack.item.id] = Math.max(this.capacities[stack.item.id], stack.amount * 2);
                this.itemCapacity = Math.max(this.itemCapacity, stack.amount * 2);
            }
        }
        this.consumeBuilder.each(c -> {
            c.multiplier = b -> Vars.state.rules.unitCost(b.team);
        });
    }

    public void addUpgrade(UnitType from, UnitType to) {
        this.upgrades.add(new UnitType[]{from, to});
    }

    public class ReconstructorBuild
    extends UnitBlock.UnitBuild {
        @Nullable
        public Vec2 commandPos;
        @Nullable
        public UnitCommand command;
        boolean constructing;

        public ReconstructorBuild() {
            super(Reconstructor.this);
        }

        public float fraction() {
            return this.progress / Reconstructor.this.constructTime;
        }

        @Override
        public Vec2 getCommandPosition() {
            return this.commandPos;
        }

        @Override
        public void onCommand(Vec2 target) {
            this.commandPos = target;
        }

        @Override
        public boolean acceptUnitPayload(Unit unit) {
            return this.hasUpgrade(unit.type) && !this.upgrade(unit.type).isBanned();
        }

        public boolean canSetCommand() {
            UnitType output = this.unit();
            return output != null && output.commands.size > 1 && output.allowChangeCommands;
        }

        @Override
        public Graphics.Cursor getCursor() {
            return this.canSetCommand() ? super.getCursor() : Graphics.Cursor.SystemCursor.arrow;
        }

        @Override
        public boolean shouldShowConfigure(Player player) {
            return this.canSetCommand();
        }

        @Override
        public void buildConfiguration(Table table) {
            UnitType unit = this.unit();
            if (unit == null) {
                this.deselect();
                return;
            }
            ButtonGroup group = new ButtonGroup();
            group.setMinCheckCount(0);
            int i = 0;
            int columns = 4;
            table.background(Styles.black6);
            Seq<UnitCommand> list = this.unit().commands;
            for (UnitCommand item : list) {
                ImageButton button = table.button(item.getIcon(), Styles.clearNoneTogglei, 40.0f, () -> {
                    this.configure(item);
                    this.deselect();
                }).tooltip(item.localized()).group(group).get();
                button.update(() -> button.setChecked(this.command == item || this.command == null && unit.defaultCommand == item));
                if (++i % columns != 0) continue;
                table.row();
            }
        }

        @Override
        public boolean acceptPayload(Building source, Payload payload) {
            if (this.payload != null || !this.enabled && source != this || this.relativeTo(source) == this.rotation || !(payload instanceof UnitPayload)) {
                return false;
            }
            UnitPayload pay = (UnitPayload)payload;
            UnitType upgrade = this.upgrade(pay.unit.type);
            if (upgrade != null) {
                if (!upgrade.unlockedNowHost() && !this.team.isAI()) {
                    pay.showOverlay(Icon.tree);
                    Events.fire(EventType.Trigger.cannotUpgrade);
                }
                if (upgrade.isBanned()) {
                    pay.showOverlay(Icon.cancel);
                }
            }
            return upgrade != null && (this.team.isAI() || upgrade.unlockedNowHost()) && !upgrade.isBanned();
        }

        @Override
        public int getMaximumAccepted(Item item) {
            return Mathf.round((float)Reconstructor.this.capacities[item.id] * Vars.state.rules.unitCost(this.team));
        }

        @Override
        public void overwrote(Seq<Building> builds) {
            if (builds.first().block == this.block) {
                this.items.add(builds.first().items);
            }
        }

        @Override
        public void draw() {
            Draw.rect(Reconstructor.this.region, this.x, this.y);
            boolean fallback = true;
            for (int i = 0; i < 4; ++i) {
                if (!this.blends(i) || i == this.rotation) continue;
                Draw.rect(Reconstructor.this.inRegion, this.x, this.y, (float)(i * 90 - 180));
                fallback = false;
            }
            if (fallback) {
                Draw.rect(Reconstructor.this.inRegion, this.x, this.y, (float)(this.rotation * 90));
            }
            Draw.rect(Reconstructor.this.outRegion, this.x, this.y, this.rotdeg());
            if (this.constructing() && this.hasArrived()) {
                Draw.draw(35.0f, () -> {
                    Draw.alpha(1.0f - this.progress / Reconstructor.this.constructTime);
                    Draw.rect(((UnitPayload)this.payload).unit.type.fullIcon, this.x, this.y, ((UnitPayload)this.payload).rotation() - 90.0f);
                    Draw.reset();
                    Drawf.construct((Building)this, this.upgrade(((UnitPayload)this.payload).unit.type), ((UnitPayload)this.payload).rotation() - 90.0f, this.progress / Reconstructor.this.constructTime, this.speedScl, this.time);
                });
            } else {
                Draw.z(35.0f);
                this.drawPayload();
            }
            Draw.z(35.1f);
            Draw.rect(Reconstructor.this.topRegion, this.x, this.y);
        }

        @Override
        public Object senseObject(LAccess sensor) {
            if (sensor == LAccess.config) {
                return this.unit();
            }
            return super.senseObject(sensor);
        }

        @Override
        public void updateTile() {
            this.constructing = this.constructing();
            boolean valid = false;
            if (this.payload != null) {
                if (!this.hasUpgrade(((UnitPayload)this.payload).unit.type)) {
                    this.moveOutPayload();
                } else if (this.moveInPayload()) {
                    if (this.efficiency > 0.0f) {
                        valid = true;
                        this.progress += this.edelta() * Vars.state.rules.unitBuildSpeed(this.team);
                    }
                    if (this.progress >= Reconstructor.this.constructTime) {
                        ((UnitPayload)this.payload).unit = this.upgrade(((UnitPayload)this.payload).unit.type).create(((UnitPayload)this.payload).unit.team());
                        if (((UnitPayload)this.payload).unit.isCommandable()) {
                            if (this.commandPos != null) {
                                ((UnitPayload)this.payload).unit.command().commandPosition(this.commandPos);
                            }
                            ((UnitPayload)this.payload).unit.command().command(this.command == null && ((UnitPayload)this.payload).unit.type.defaultCommand != null ? ((UnitPayload)this.payload).unit.type.defaultCommand : this.command);
                        }
                        Reconstructor.this.createSound.at(this, 1.0f + Mathf.range(0.06f), Reconstructor.this.createSoundVolume);
                        this.progress %= 1.0f;
                        Effect.shake(2.0f, 3.0f, this);
                        Fx.producesmoke.at(this);
                        this.consume();
                        Events.fire(new EventType.UnitCreateEvent(((UnitPayload)this.payload).unit, this));
                    }
                }
            }
            this.speedScl = Mathf.lerpDelta(this.speedScl, Mathf.num(valid), 0.05f);
            this.time += this.edelta() * this.speedScl * Vars.state.rules.unitBuildSpeed(this.team);
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.progress) {
                return Mathf.clamp(this.fraction());
            }
            if (sensor == LAccess.itemCapacity) {
                return Mathf.round((float)Reconstructor.this.itemCapacity * Vars.state.rules.unitCost(this.team));
            }
            return super.sense(sensor);
        }

        @Override
        public boolean shouldConsume() {
            return this.constructing && this.enabled;
        }

        @Override
        public Object config() {
            return this.command;
        }

        public UnitType unit() {
            if (this.payload == null) {
                return null;
            }
            UnitType t = this.upgrade(((UnitPayload)this.payload).unit.type);
            return t != null && (t.unlockedNowHost() || this.team.isAI()) ? t : null;
        }

        public boolean constructing() {
            return this.payload != null && this.hasUpgrade(((UnitPayload)this.payload).unit.type);
        }

        public boolean hasUpgrade(UnitType type) {
            UnitType t = this.upgrade(type);
            return t != null && (t.unlockedNowHost() || this.team.isAI()) && !type.isBanned();
        }

        public UnitType upgrade(UnitType type) {
            UnitType[] r = Reconstructor.this.upgrades.find(u -> u[0] == type);
            return r == null ? null : r[1];
        }

        @Override
        public byte version() {
            return 3;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
            TypeIO.writeVecNullable(write, this.commandPos);
            TypeIO.writeCommand(write, this.command);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 1) {
                this.progress = read.f();
            }
            if (revision >= 2) {
                this.commandPos = TypeIO.readVecNullable(read);
            }
            if (revision >= 3) {
                this.command = TypeIO.readCommand(read);
            }
        }
    }
}

