/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.Liquids;
import mindustry.entities.Effect;
import mindustry.entities.effect.MultiEffect;
import mindustry.entities.effect.WrapEffect;
import mindustry.gen.Sounds;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.blocks.heat.HeatConsumer;
import mindustry.world.blocks.power.PowerGenerator;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class VariableReactor
extends PowerGenerator {
    public float maxHeat = 100.0f;
    public float unstableSpeed = 0.0055555557f;
    public float warmupSpeed = 0.1f;
    public Effect effect = Fx.fluxVapor;
    public float effectChance = 0.05f;
    public Color effectColor = Color.valueOf("ffdf9d");
    public float flashThreshold = 0.01f;
    public float flashAlpha = 0.4f;
    public float flashSpeed = 7.0f;
    public Color flashColor1 = Color.red;
    public Color flashColor2 = Color.valueOf("89e8b6");
    public TextureRegion lightsRegion;

    public VariableReactor(String name) {
        super(name);
        this.powerProduction = 20.0f;
        this.rebuildable = false;
        this.explosionRadius = 16;
        this.explosionDamage = 1500;
        this.explodeEffect = new MultiEffect(Fx.bigShockwave, new WrapEffect(Fx.titanSmoke, Color.valueOf("e3ae6f")));
        this.explodeSound = Sounds.explosionReactor2;
        this.explosionPuddles = 70;
        this.explosionPuddleRange = 48.0f;
        this.explosionPuddleLiquid = Liquids.slag;
        this.explosionPuddleAmount = 100.0f;
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("instability", entity -> new Bar("bar.instability", Pal.sap, () -> entity.instability));
        this.addBar("heat", entity -> new Bar(() -> Core.bundle.format("bar.heatpercent", (int)entity.heat, (int)(Mathf.clamp(entity.heat / this.maxHeat) * 100.0f)), () -> Pal.lightOrange, () -> entity.heat / this.maxHeat));
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.input, this.maxHeat, StatUnit.heatUnits);
    }

    public class VariableReactorBuild
    extends PowerGenerator.GeneratorBuild
    implements HeatConsumer {
        public float[] sideHeat = new float[4];
        public float heat = 0.0f;
        public float instability;
        public float totalProgress;
        public float warmup;
        public float flash;

        @Override
        public void updateTile() {
            this.heat = this.calculateHeat(this.sideHeat);
            this.productionEfficiency = this.efficiency;
            this.warmup = Mathf.lerpDelta(this.warmup, this.productionEfficiency > 0.0f ? 1.0f : 0.0f, VariableReactor.this.warmupSpeed);
            if (this.instability >= 1.0f) {
                this.kill();
            }
            this.totalProgress += this.productionEfficiency * Time.delta;
            if (Mathf.chanceDelta(VariableReactor.this.effectChance * this.warmup)) {
                VariableReactor.this.effect.at(this.x, this.y, VariableReactor.this.effectColor);
            }
        }

        @Override
        public boolean shouldExplode() {
            return this.heat > 0.0f;
        }

        @Override
        public void draw() {
            super.draw();
            if (this.instability > VariableReactor.this.flashThreshold) {
                if (!Vars.state.isPaused()) {
                    this.flash += (1.0f + (this.instability - VariableReactor.this.flashThreshold) / (1.0f - VariableReactor.this.flashThreshold) * VariableReactor.this.flashSpeed) * Time.delta;
                }
                Draw.z(31.0f);
                Draw.blend(Blending.additive);
                Draw.color(VariableReactor.this.flashColor1, VariableReactor.this.flashColor2, Mathf.absin(this.flash, 8.0f, 1.0f));
                Draw.alpha(VariableReactor.this.flashAlpha * Mathf.clamp((this.instability - VariableReactor.this.flashThreshold) / (1.0f - VariableReactor.this.flashThreshold) * 4.0f));
                Draw.rect(VariableReactor.this.lightsRegion, this.x, this.y);
                Draw.blend();
            }
        }

        @Override
        public float totalProgress() {
            return this.totalProgress;
        }

        @Override
        public float warmup() {
            return this.warmup;
        }

        @Override
        public void updateEfficiencyMultiplier() {
            float target = Mathf.clamp(this.heat / VariableReactor.this.maxHeat);
            float efficiencyMet = Mathf.clamp(Mathf.zero(target) ? 1.0f : this.efficiency / target);
            boolean met = efficiencyMet >= 0.99999f;
            this.instability = Mathf.approachDelta(this.instability, met ? 0.0f : 1.0f, met ? 0.5f : VariableReactor.this.unstableSpeed * (1.0f - efficiencyMet));
            this.efficiency *= target;
        }

        @Override
        public float[] sideHeat() {
            return this.sideHeat;
        }

        @Override
        public float heatRequirement() {
            return VariableReactor.this.maxHeat;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.heat);
            write.f(this.instability);
            write.f(this.warmup);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.heat = read.f();
            this.instability = read.f();
            this.warmup = read.f();
        }
    }
}

