/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.Events;
import arc.math.Interp;
import arc.math.geom.Vec2;
import arc.scene.Group;
import arc.scene.actions.Actions;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;

public class PlanConfigFragment {
    Table table = new Table();
    BuildPlan selected;

    public void build(Group parent) {
        this.table.visible = false;
        parent.addChild(this.table);
        Events.on(EventType.ResetEvent.class, e -> this.forceHide());
    }

    public void showConfig(BuildPlan plan) {
        if (this.selected == plan || plan.block == null) {
            this.hide();
            return;
        }
        Block block = plan.block;
        if (!block.configurable) {
            return;
        }
        this.selected = plan;
        this.table.clear();
        Seq<UnlockableContent> options = new Seq<UnlockableContent>();
        block.getPlanConfigs(options);
        if (options.isEmpty()) {
            return;
        }
        ItemSelection.buildTable(this.table, options, () -> {
            UnlockableContent c;
            Object patt1290$temp;
            UnlockableContent unlockableContent = this.selected != null ? ((patt1290$temp = this.selected.config) instanceof UnlockableContent ? (c = (UnlockableContent)patt1290$temp) : null) : null;
            return unlockableContent;
        }, content -> {
            this.selected.config = content;
            this.hide();
        }, block.selectionRows, block.selectionColumns);
        this.table.pack();
        this.table.setTransform(true);
        this.table.visible = true;
        this.table.actions(Actions.scaleTo(0.0f, 1.0f), Actions.visible(true), Actions.scaleTo(1.0f, 1.0f, 0.07f, Interp.pow3Out));
        this.table.update(() -> {
            this.table.setOrigin(1);
            if (plan.isDone() || !Vars.control.input.selectPlans.contains(plan) && !Vars.player.dead() && !Vars.player.unit().plans.contains(plan)) {
                this.hide();
                return;
            }
            Vec2 pos = Core.input.mouseScreen(plan.drawx(), plan.drawy() - (float)(block.size * 8) / 2.0f - 1.0f);
            this.table.setPosition(pos.x, pos.y, 2);
        });
    }

    public void forceHide() {
        this.table.visible = false;
        this.selected = null;
    }

    public void hide() {
        this.selected = null;
        this.table.actions(Actions.scaleTo(0.0f, 1.0f, 0.06f, Interp.pow3Out), Actions.visible(false));
    }
}

