/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.Events;
import arc.files.Fi;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Floatc;
import arc.func.Func;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.g2d.TextureRegion;
import arc.input.KeyCode;
import arc.scene.event.ClickListener;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.TextButton;
import arc.scene.ui.Tooltip;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.ArcRuntimeException;
import arc.util.Http;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import arc.util.io.Streams;
import arc.util.serialization.Jval;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.ctype.UnlockableContent;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.io.JsonIO;
import mindustry.mod.ModListing;
import mindustry.mod.Mods;
import mindustry.ui.BorderImage;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class ModsDialog
extends BaseDialog {
    private ObjectMap<String, TextureRegion> textureCache = new ObjectMap();
    private float modImportProgress;
    private String searchtxt = "";
    @Nullable
    private Seq<ModListing> modList;
    private boolean orderDate = true;
    private BaseDialog currentContent;
    private BaseDialog browser;
    private Table browserTable;
    private float scroll = 0.0f;

    public ModsDialog() {
        super("@mods");
        this.addCloseButton();
        this.browser = new BaseDialog("@mods.browser");
        this.browser.cont.table((Table table) -> {
            table.left();
            table.image(Icon.zoom);
            table.field(this.searchtxt, res -> {
                this.searchtxt = res;
                this.rebuildBrowser();
            }).growX().get();
            table.button(Icon.list, Styles.emptyi, 32.0f, () -> {
                this.orderDate = !this.orderDate;
                this.rebuildBrowser();
            }).update((T b) -> {
                b.getStyle().imageUp = this.orderDate ? Icon.list : Icon.star;
            }).size(40.0f).get().addListener(new Tooltip(tip -> tip.label(() -> this.orderDate ? "@mods.browser.sortdate" : "@mods.browser.sortstars").left()));
        }).fillX().padBottom(4.0f);
        this.browser.cont.row();
        this.browser.cont.pane((Table tablebrow) -> {
            tablebrow.margin(10.0f).top();
            this.browserTable = tablebrow;
        }).scrollX(false);
        this.browser.addCloseButton();
        this.browser.makeButtonOverlay();
        this.browser.onResize(this::rebuildBrowser);
        this.buttons.button("@mods.guide", Icon.link, () -> Core.app.openURI("https://mindustrygame.github.io/wiki/modding/1-modding/")).size(210.0f, 64.0f);
        if (!Vars.mobile) {
            this.buttons.button("@mods.openfolder", Icon.link, () -> Core.app.openFolder(Vars.modDirectory.absolutePath()));
        }
        this.shown(this::setup);
        this.onResize(this::setup);
        Events.on(EventType.ResizeEvent.class, event -> {
            if (this.currentContent != null) {
                this.currentContent.hide();
                this.currentContent = null;
            }
        });
        this.hidden(() -> {
            if (Vars.mods.requiresReload()) {
                Vars.mods.reload();
            }
        });
    }

    void modError(Throwable error) {
        Vars.ui.loadfrag.hide();
        if (error instanceof NoSuchMethodError || Strings.getCauses(error).contains((Throwable)((Object)((Boolf<Throwable>)t -> t.getMessage() != null && (t.getMessage().contains("trust anchor") || t.getMessage().contains("SSL") || t.getMessage().contains("protocol")))))) {
            Vars.ui.showErrorMessage("@feature.unsupported");
        } else if (error instanceof Http.HttpStatusException) {
            Http.HttpStatusException st = (Http.HttpStatusException)error;
            Vars.ui.showErrorMessage(Core.bundle.format("connectfail", Strings.capitalize(st.status.toString().toLowerCase())));
        } else if (error.getMessage() != null && error.getMessage().toLowerCase(Locale.ROOT).contains("writable dex")) {
            Vars.ui.showException("@error.moddex", error);
        } else {
            Vars.ui.showException(error);
        }
    }

    void getModList(Cons<Seq<ModListing>> listener) {
        this.getModList(0, listener);
    }

    void getModList(int index, Cons<Seq<ModListing>> listener) {
        if (index >= Vars.modJsonURLs.length) {
            return;
        }
        if (this.modList != null) {
            listener.get(this.modList);
            return;
        }
        Http.get(Vars.modJsonURLs[index], response -> {
            String strResult = response.getResultAsString();
            Core.app.post(() -> {
                try {
                    this.modList = JsonIO.json.fromJson(Seq.class, ModListing.class, strResult);
                    SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    Func<String, Date> parser = text -> {
                        try {
                            return d.parse((String)text);
                        }
                        catch (Exception e) {
                            return new Date();
                        }
                    };
                    this.modList.sortComparing(m -> (Date)parser.get(m.lastUpdated)).reverse();
                    listener.get(this.modList);
                }
                catch (Exception e) {
                    Log.err(e);
                    Vars.ui.showException(e);
                }
            });
        }, error -> {
            if (index < Vars.modJsonURLs.length - 1) {
                this.getModList(index + 1, listener);
            } else {
                Core.app.post(() -> {
                    this.modError((Throwable)error);
                    if (this.browser != null) {
                        this.browser.hide();
                    }
                });
            }
        });
    }

    void setup() {
        float h = 110.0f;
        float w = Math.min((float)Core.graphics.getWidth() / Scl.scl(1.05f) - Scl.scl(28.0f), 520.0f);
        this.cont.clear();
        this.cont.defaults().width(Math.min((float)Core.graphics.getWidth() / Scl.scl(1.05f), 556.0f)).pad(4.0f);
        this.cont.add("@mod.reloadrequired").visible(Vars.mods::requiresReload).center().get().setAlignment(1);
        this.cont.row();
        this.cont.table((Table buttons) -> {
            buttons.left().defaults().growX().height(60.0f).uniformX();
            TextButton.TextButtonStyle style = Styles.flatBordert;
            float margin = 12.0f;
            buttons.button("@mod.import", (Drawable)Icon.add, style, () -> {
                BaseDialog dialog = new BaseDialog("@mod.import");
                TextButton.TextButtonStyle bstyle = Styles.flatt;
                dialog.cont.table(Tex.button, t -> {
                    t.defaults().size(300.0f, 70.0f);
                    t.margin(12.0f);
                    t.button("@mod.import.file", (Drawable)Icon.file, bstyle, () -> {
                        dialog.hide();
                        Vars.platform.showMultiFileChooser(file -> {
                            try {
                                Vars.mods.importMod((Fi)file);
                                this.setup();
                            }
                            catch (Exception e) {
                                Vars.ui.showException(e.getMessage() != null && e.getMessage().toLowerCase(Locale.ROOT).contains("writable dex") ? "@error.moddex" : "", e);
                                Log.err(e);
                            }
                        }, "zip", "jar");
                    }).margin(12.0f);
                    t.row();
                    t.button("@mod.import.github", (Drawable)Icon.github, bstyle, () -> {
                        dialog.hide();
                        Vars.ui.showTextInput("@mod.import.github", "", 64, Core.settings.getString("lastmod", ""), text -> {
                            if ((text = text.trim().replace(" ", "")).startsWith("https://github.com/")) {
                                text = text.substring("https://github.com/".length());
                            }
                            Core.settings.put("lastmod", text);
                            this.githubImportMod((String)text, false, null);
                        });
                    }).margin(12.0f);
                });
                dialog.addCloseButton();
                dialog.show();
            }).margin(margin);
            buttons.button("@mods.browser", (Drawable)Icon.menu, style, this::showModBrowser).margin(margin);
        }).width(w);
        this.cont.row();
        if (!Vars.mods.list().isEmpty()) {
            boolean[] anyDisabled = new boolean[]{false};
            Table[] pane = new Table[]{null};
            Cons<String> rebuild = query -> {
                pane[0].clear();
                boolean any = false;
                for (final Mods.LoadedMod item : Vars.mods.list()) {
                    if (!Strings.matches(query, item.meta.displayName)) continue;
                    any = true;
                    if (!item.enabled() && !anyDisabled[0] && Vars.mods.list().size > 0) {
                        anyDisabled[0] = true;
                        pane[0].row();
                        pane[0].image().growX().height(4.0f).pad(6.0f).color(Pal.gray).row();
                    }
                    pane[0].button((Button t) -> {
                        t.top().left();
                        t.margin(12.0f);
                        String stateDetails = this.getStateDetails(item);
                        if (stateDetails != null) {
                            t.addListener(new Tooltip(f -> f.background(Styles.black8).margin(4.0f).add(stateDetails).growX().width(400.0f).wrap()));
                        }
                        t.defaults().left().top();
                        t.table((Table title1) -> {
                            title1.left();
                            title1.add(new BorderImage(){
                                {
                                    if (item.iconTexture != null) {
                                        this.setDrawable(new TextureRegion(item.iconTexture));
                                    } else {
                                        this.setDrawable(Tex.nomap);
                                    }
                                    this.border(Pal.accent);
                                }
                            }).size(h - 8.0f).padTop(-8.0f).padLeft(-8.0f).padRight(8.0f);
                            title1.table((Table text) -> {
                                boolean hideDisabled = !item.isSupported() || item.hasUnmetDependencies() || item.hasContentErrors();
                                String shortDesc = item.meta.shortDescription();
                                text.add("[accent]" + Strings.stripColors(item.meta.displayName) + "\n" + (shortDesc.length() > 0 ? "[lightgray]" + shortDesc + "\n" : "") + (item.enabled() || hideDisabled ? "" : Core.bundle.get("mod.disabled") + "")).wrap().top().width(300.0f).growX().left();
                                text.row();
                                String state = this.getStateText(item);
                                if (state != null) {
                                    text.labelWrap(state).growX().row();
                                }
                            }).top().growX();
                            title1.add().growX();
                        }).growX().growY().left();
                        t.table((Table right) -> {
                            right.right();
                            right.button((Drawable)(item.enabled() ? Icon.downOpen : Icon.upOpen), Styles.clearNonei, () -> {
                                Vars.mods.setEnabled(item, !item.enabled());
                                this.setup();
                            }).size(50.0f).disabled(!item.isSupported());
                            right.button((Drawable)(item.hasSteamID() ? Icon.link : Icon.trash), Styles.clearNonei, () -> {
                                if (!item.hasSteamID()) {
                                    Vars.ui.showConfirm("@confirm", "@mod.remove.confirm", () -> {
                                        Vars.mods.removeMod(item);
                                        this.setup();
                                    });
                                } else {
                                    Vars.platform.viewListing(item);
                                }
                            }).size(50.0f);
                            if (Vars.steam && !item.hasSteamID()) {
                                right.row();
                                right.button((Drawable)Icon.export, Styles.clearNonei, () -> Vars.platform.publish(item)).size(50.0f);
                            }
                        }).growX().right().padRight(-8.0f).padTop(-8.0f);
                    }, (Button.ButtonStyle)Styles.flatBordert, () -> this.showMod(item)).size(w, h).growX().pad(4.0f);
                    pane[0].row();
                }
                if (!any) {
                    pane[0].add("@none.found").color(Color.lightGray).pad(4.0f);
                }
            };
            if (!Vars.mobile || Core.graphics.isPortrait()) {
                this.cont.table((Table search) -> {
                    search.image(Icon.zoom).padRight(8.0f);
                    search.field("", rebuild).growX();
                }).fillX().padBottom(4.0f);
            }
            this.cont.row();
            this.cont.pane((Table table1) -> {
                pane[0] = table1.margin(10.0f).top();
                rebuild.get("");
            }).scrollX(false).update((T s) -> {
                this.scroll = s.getScrollY();
            }).get().setScrollYForce(this.scroll);
        } else {
            this.cont.table(Styles.black6, t -> t.add("@mods.none")).height(80.0f);
        }
        this.cont.row();
    }

    @Nullable
    private String getStateText(Mods.LoadedMod item) {
        if (item.isOutdated()) {
            return "@mod.incompatiblemod";
        }
        if (item.isBlacklisted()) {
            return "@mod.blacklisted";
        }
        if (!item.isSupported()) {
            return "@mod.incompatiblegame";
        }
        if (item.state == Mods.ModState.circularDependencies) {
            return "@mod.circulardependencies";
        }
        if (item.state == Mods.ModState.incompleteDependencies) {
            return "@mod.incompletedependencies";
        }
        if (item.hasUnmetDependencies()) {
            return "@mod.unmetdependencies";
        }
        if (item.hasContentErrors()) {
            return "@mod.erroredcontent";
        }
        if (item.meta.hidden) {
            return "@mod.multiplayer.compatible";
        }
        return null;
    }

    @Nullable
    private String getStateDetails(Mods.LoadedMod item) {
        if (item.isOutdated()) {
            return "@mod.incompatiblemod.details";
        }
        if (item.isBlacklisted()) {
            return "@mod.blacklisted.details";
        }
        if (!item.isSupported()) {
            return Core.bundle.format("mod.requiresversion.details", item.meta.minGameVersion);
        }
        if (item.state == Mods.ModState.circularDependencies) {
            return "@mod.circulardependencies.details";
        }
        if (item.state == Mods.ModState.incompleteDependencies) {
            return Core.bundle.format("mod.incompletedependencies.details", item.missingDependencies.toString(", "));
        }
        if (item.hasUnmetDependencies()) {
            return Core.bundle.format("mod.missingdependencies.details", item.missingDependencies.toString(", "));
        }
        if (item.hasContentErrors()) {
            return "@mod.erroredcontent.details";
        }
        return null;
    }

    private void showMod(Mods.LoadedMod mod) {
        BaseDialog dialog = new BaseDialog(mod.meta.displayName);
        dialog.addCloseButton();
        if (!Vars.mobile) {
            dialog.buttons.button("@mods.openfolder", Icon.link, () -> Core.app.openFolder(mod.file.absolutePath()));
        }
        if (mod.getRepo() != null) {
            boolean showImport = !mod.hasSteamID();
            dialog.buttons.button("@mods.github.open", Icon.link, () -> Core.app.openURI("https://github.com/" + mod.getRepo()));
            if (Vars.mobile && showImport) {
                dialog.buttons.row();
            }
            if (showImport) {
                dialog.buttons.button("@mods.browser.reinstall", Icon.download, () -> this.githubImportMod(mod.getRepo(), mod.isJava(), null));
            }
        }
        dialog.cont.pane((Table desc) -> {
            String state;
            desc.center();
            desc.defaults().padTop(10.0f).left();
            desc.add("@editor.name").padRight(10.0f).color(Color.gray).padTop(0.0f);
            desc.row();
            desc.add(mod.meta.displayName).growX().wrap().padTop(2.0f);
            desc.row();
            if (mod.meta.author != null) {
                desc.add("@editor.author").padRight(10.0f).color(Color.gray);
                desc.row();
                desc.add(mod.meta.author).growX().wrap().padTop(2.0f);
                desc.row();
            }
            if (mod.meta.version != null) {
                desc.add("@mod.version").padRight(10.0f).color(Color.gray).top();
                desc.row();
                desc.add(mod.meta.version).growX().wrap().padTop(2.0f);
                desc.row();
            }
            if (mod.meta.description != null) {
                desc.add("@editor.description").padRight(10.0f).color(Color.gray).top();
                desc.row();
                desc.add(mod.meta.description).growX().wrap().padTop(2.0f);
                desc.row();
            }
            if ((state = this.getStateDetails(mod)) != null) {
                desc.add("@mod.disabled").padTop(13.0f).padBottom(-6.0f).row();
                desc.add(state).growX().wrap().row();
            }
        }).width(400.0f);
        Seq all = Seq.with(Vars.content.getContentMap()).flatten().select(c -> {
            UnlockableContent u;
            return c.minfo.mod == mod && c instanceof UnlockableContent && !(u = (UnlockableContent)c).isHidden();
        }).as();
        if (all.any()) {
            dialog.cont.row();
            dialog.cont.button("@mods.viewcontent", Icon.book, () -> {
                BaseDialog d = new BaseDialog(mod.meta.displayName);
                d.cont.pane((Table cs) -> {
                    int i = 0;
                    for (UnlockableContent c : all) {
                        cs.button(new TextureRegionDrawable(c.uiIcon), Styles.flati, 32.0f, () -> Vars.ui.content.show(c)).size(50.0f).with(im -> {
                            ClickListener click = im.getClickListener();
                            im.update(() -> im.getImage().color.lerp(!click.isOver() ? Color.lightGray : Color.white, 0.4f * Time.delta));
                        }).tooltip(c.localizedName);
                        if (++i % (int)Math.min((float)Core.graphics.getWidth() / Scl.scl(110.0f), 14.0f) != 0) continue;
                        cs.row();
                    }
                }).grow();
                d.addCloseButton();
                d.show();
                this.currentContent = d;
            }).size(300.0f, 50.0f).pad(4.0f);
        }
        dialog.show();
    }

    private void showModBrowser() {
        this.rebuildBrowser();
        this.browser.show();
    }

    private void rebuildBrowser() {
        final ObjectSet<String> installed = Vars.mods.list().map(m -> m.getRepo()).asSet();
        this.browserTable.clear();
        this.browserTable.add("@loading");
        int cols = (int)Math.max((float)Core.graphics.getWidth() / Scl.scl(480.0f), 1.0f);
        this.getModList(0, rlistings -> {
            this.browserTable.clear();
            int i = 0;
            Seq<ModListing> listings = rlistings;
            if (!this.orderDate) {
                listings = rlistings.copy();
                listings.sortComparing(m1 -> -m1.stars);
            }
            for (ModListing mod : listings) {
                if ((mod.hasJava || mod.hasScripts && !mod.iosCompatible) && Vars.ios || !Strings.matches(this.searchtxt, mod.name) && !Strings.matches(this.searchtxt, mod.repo)) continue;
                float s = 64.0f;
                this.browserTable.button((Button con) -> {
                    con.margin(0.0f);
                    con.left();
                    final String repo = mod.repo;
                    con.add(new BorderImage(){
                        TextureRegion last;
                        {
                            this.border(installed.contains(repo) ? Pal.accent : Color.lightGray);
                            this.setDrawable(Tex.nomap);
                            this.pad = Scl.scl(4.0f);
                        }

                        @Override
                        public void draw() {
                            TextureRegion next;
                            super.draw();
                            if (!ModsDialog.this.textureCache.containsKey(repo)) {
                                this.last = Core.atlas.find("nomap");
                                ModsDialog.this.textureCache.put(repo, this.last);
                                Http.get("https://raw.githubusercontent.com/Anuken/MindustryMods/master/icons/" + repo.replace("/", "_"), res -> {
                                    Pixmap pix = new Pixmap(res.getResult());
                                    Core.app.post(() -> {
                                        try {
                                            Texture tex = new Texture(pix);
                                            tex.setFilter(Texture.TextureFilter.linear);
                                            ModsDialog.this.textureCache.put(repo, new TextureRegion(tex));
                                            pix.dispose();
                                        }
                                        catch (Exception e) {
                                            Log.err(e);
                                        }
                                    });
                                }, err -> {});
                            }
                            if (this.last != (next = (TextureRegion)ModsDialog.this.textureCache.get(repo))) {
                                this.last = next;
                                this.setDrawable(next);
                            }
                        }
                    }).size(s).pad(8.0f);
                    String infoText = "[accent]" + mod.name.replace("\n", "") + (installed.contains(mod.repo) ? "\n[lightgray]" + Core.bundle.get("mod.installed") : "") + "\n[lightgray]\ue809 " + mod.stars + (!Version.isAtLeast(mod.minGameVersion) ? "\n" + Core.bundle.format("mod.requiresversion", mod.minGameVersion) : (mod.hasJava && Strings.parseDouble(mod.minGameVersion, 0.0) < 154.0 ? "\n" + Core.bundle.get("mod.incompatiblemod") : ""));
                    con.add(infoText).width(358.0f).wrap().grow().pad(4.0f, 2.0f, 4.0f, 6.0f).top().left().labelAlign(10);
                }, (Button.ButtonStyle)Styles.flatBordert, () -> {
                    BaseDialog sel = new BaseDialog(mod.name);
                    sel.cont.pane((Table p) -> p.add(mod.description + "\n\n[accent]" + Core.bundle.get("editor.author") + "[lightgray] " + mod.author).width(Vars.mobile ? 400.0f : 500.0f).wrap().pad(4.0f).labelAlign(1, 8)).grow();
                    sel.buttons.defaults().size(150.0f, 54.0f).pad(2.0f);
                    sel.buttons.button("@back", Icon.left, () -> {
                        sel.clear();
                        sel.hide();
                    });
                    Mods.LoadedMod found = Vars.mods.list().find((T l) -> mod.repo != null && mod.repo.equals(l.getRepo()));
                    sel.buttons.button(found == null ? "@mods.browser.add" : "@mods.browser.reinstall", Icon.download, () -> {
                        sel.hide();
                        this.githubImportMod(mod.repo, mod.hasJava, null);
                    });
                    if (Core.graphics.isPortrait()) {
                        sel.buttons.row();
                    }
                    sel.buttons.button("@mods.github.open", Icon.link, () -> Core.app.openURI("https://github.com/" + mod.repo));
                    sel.buttons.button("@mods.browser.view-releases", Icon.zoom, () -> {
                        BaseDialog load = new BaseDialog("");
                        load.cont.add("[accent]Fetching Releases...");
                        load.show();
                        Http.get("https://api.github.com/repos/" + mod.repo + "/releases", res -> {
                            Jval json = Jval.read(res.getResultAsString());
                            Jval.JsonArray releases = json.asArray();
                            Core.app.post(() -> {
                                load.hide();
                                if (releases.size == 0) {
                                    Vars.ui.showInfo("@mods.browser.noreleases");
                                } else {
                                    sel.hide();
                                    BaseDialog downloads = new BaseDialog("@mods.browser.releases");
                                    downloads.cont.pane((Table p) -> {
                                        for (int j = 0; j < releases.size; ++j) {
                                            Jval release = (Jval)releases.get(j);
                                            int index = j;
                                            p.table(((TextureRegionDrawable)Tex.whiteui).tint(Pal.darkestGray), t -> {
                                                t.add("[accent]" + release.getString("name") + (index == 0 ? " " + Core.bundle.get("mods.browser.latest") : "")).top().left().growX().wrap().pad(5.0f);
                                                t.row();
                                                t.add(release.getString("published_at").substring(0, 10).replaceAll("-", "/")).top().left().growX().wrap().pad(5.0f).color(Color.gray);
                                                t.row();
                                                t.table((Table b) -> {
                                                    b.defaults().size(150.0f, 54.0f).pad(2.0f);
                                                    b.button("@mods.github.open-release", Icon.link, () -> Core.app.openURI(release.getString("html_url")));
                                                    b.button("@mods.browser.add", Icon.download, () -> {
                                                        String releaseUrl = release.getString("url");
                                                        this.githubImportMod(mod.repo, mod.hasJava, releaseUrl.substring(releaseUrl.lastIndexOf("/") + 1));
                                                    });
                                                }).right();
                                            }).margin(5.0f).growX().pad(5.0f);
                                            if (j >= releases.size - 1) continue;
                                            p.row();
                                        }
                                    }).width(500.0f).scrollX(false).fillY();
                                    downloads.buttons.button("@back", Icon.left, () -> {
                                        downloads.clear();
                                        downloads.hide();
                                        sel.show();
                                    }).size(150.0f, 54.0f).pad(2.0f);
                                    downloads.keyDown(KeyCode.escape, downloads::hide);
                                    downloads.keyDown(KeyCode.back, downloads::hide);
                                    downloads.hidden(sel::show);
                                    downloads.show();
                                }
                            });
                        }, t -> Core.app.post(() -> {
                            this.modError((Throwable)t);
                            load.hide();
                        }));
                    });
                    sel.keyDown(KeyCode.escape, sel::hide);
                    sel.keyDown(KeyCode.back, sel::hide);
                    sel.show();
                }).width(438.0f).pad(4.0f).growX().left().height(s + 16.0f).fillY();
                if (++i % cols != 0) continue;
                this.browserTable.row();
            }
        });
    }

    private void handleMod(String repo, Http.HttpResponse result) {
        try {
            Fi file = Vars.tmpDirectory.child(repo.replace("/", "") + ".zip");
            long len = result.getContentLength();
            Floatc cons = len <= 0L ? f -> {} : p -> {
                this.modImportProgress = p;
            };
            try (OutputStream stream = file.write(false);){
                Streams.copyProgress(result.getResultAsStream(), stream, len, 4096, cons);
            }
            Mods.LoadedMod mod = Vars.mods.importMod(file);
            mod.setRepo(repo);
            file.delete();
            Core.app.post(() -> {
                try {
                    this.setup();
                    Vars.ui.loadfrag.hide();
                }
                catch (Throwable e) {
                    Vars.ui.showException(e);
                }
            });
        }
        catch (Throwable e) {
            this.modError(e);
        }
    }

    private void importFail(Throwable t) {
        Core.app.post(() -> this.modError(t));
    }

    public void githubImportMod(String repo, boolean isJava) {
        this.githubImportMod(repo, isJava, null);
    }

    public void githubImportMod(String repo, boolean isJava, @Nullable String release) {
        this.modImportProgress = 0.0f;
        Vars.ui.loadfrag.show("@downloading");
        Vars.ui.loadfrag.setProgress(() -> this.modImportProgress);
        if (isJava) {
            this.githubImportJavaMod(repo, release);
        } else {
            Http.get("https://api.github.com/repos/" + repo, res -> {
                Jval json = Jval.read(res.getResultAsString());
                String mainBranch = json.getString("default_branch");
                String language = json.getString("language", "<none>");
                if (language.equals("Java") || language.equals("Kotlin") || language.equals("Groovy") || language.equals("Scala")) {
                    this.githubImportJavaMod(repo, release);
                } else {
                    this.githubImportBranch(mainBranch, repo, release);
                }
            }, this::importFail);
        }
    }

    public void importDependencies(Seq<String> dependencies, Runnable done) {
        this.getModList(listings -> {
            listings.each(l -> dependencies.contains(l.internalName), l -> {
                dependencies.remove(l.internalName);
                this.githubImportMod(l.repo, l.hasJava);
            });
            done.run();
        });
    }

    private void githubImportJavaMod(String repo, @Nullable String release) {
        Http.get("https://api.github.com/repos/" + repo + "/releases/" + (release == null ? "latest" : release), res -> {
            Jval asset;
            Jval json = Jval.read(res.getResultAsString());
            Jval.JsonArray assets = json.get("assets").asArray();
            Jval dexedAsset = assets.find((T j) -> j.getString("name").startsWith("dexed") && j.getString("name").endsWith(".jar"));
            Jval jval = asset = dexedAsset == null ? assets.find((T j) -> j.getString("name").endsWith(".jar")) : dexedAsset;
            if (asset == null) {
                throw new ArcRuntimeException("No JAR file found in releases. Make sure you have a valid jar file in the mod's latest Github Release.");
            }
            String url = asset.getString("browser_download_url");
            Http.get(url, result -> this.handleMod(repo, (Http.HttpResponse)result), this::importFail);
        }, this::importFail);
    }

    private void githubImportBranch(String branch, String repo, @Nullable String release) {
        if (release != null) {
            Http.get("https://api.github.com/repos/" + repo + "/releases/" + release, res -> {
                String zipUrl = Jval.read(res.getResultAsString()).getString("zipball_url");
                Http.get(zipUrl, loc -> {
                    if (loc.getHeader("Location") != null) {
                        Http.get(loc.getHeader("Location"), result -> this.handleMod(repo, (Http.HttpResponse)result), this::importFail);
                    } else {
                        this.handleMod(repo, (Http.HttpResponse)loc);
                    }
                }, this::importFail);
            });
        } else {
            Http.get("https://api.github.com/repos/" + repo + "/zipball/" + branch, loc -> {
                if (loc.getHeader("Location") != null) {
                    Http.get(loc.getHeader("Location"), result -> this.handleMod(repo, (Http.HttpResponse)result), this::importFail);
                } else {
                    this.handleMod(repo, (Http.HttpResponse)loc);
                }
            }, this::importFail);
        }
    }
}

