/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.graphics.Color;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Dialog;
import arc.scene.ui.Image;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Scaling;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.game.Gamemode;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.maps.Map;
import mindustry.ui.BorderImage;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public abstract class MapListDialog
extends BaseDialog {
    BaseDialog activeDialog;
    private String searchString;
    private Seq<Gamemode> modes = new Seq();
    private Table mapTable = new Table();
    private TextField searchField;
    private boolean showBuiltIn = Core.settings.getBool("editorshowbuiltinmaps", true);
    private boolean showCustom = Core.settings.getBool("editorshowcustommaps", true);
    private boolean searchAuthor = Core.settings.getBool("editorsearchauthor", false);
    private boolean searchDescription = Core.settings.getBool("editorsearchdescription", false);
    private boolean displayType;

    public MapListDialog(String title, boolean displayType) {
        super(title);
        this.displayType = displayType;
        this.buttons.remove();
        this.addCloseListener();
        this.shown(this::setup);
        this.onResize(() -> {
            if (this.activeDialog != null) {
                this.activeDialog.hide();
            }
            this.setup();
        });
    }

    void buildButtons() {
    }

    abstract void showMap(Map var1);

    void setup() {
        this.makeButtonOverlay();
        this.buttons.clearChildren();
        this.searchString = null;
        if (Core.graphics.isPortrait() && this.displayType) {
            this.buttons.button("@back", Icon.left, this::hide).size(420.0f, 64.0f).colspan(2);
            this.buttons.row();
        } else {
            this.buttons.button("@back", Icon.left, this::hide).size(210.0f, 64.0f);
        }
        this.buildButtons();
        this.cont.clear();
        this.rebuildMaps();
        ScrollPane pane = new ScrollPane((Element)this.mapTable);
        pane.setFadeScrollBars(false);
        pane.setScrollingDisabledX(true);
        Table search = new Table();
        search.image(Icon.zoom);
        this.searchField = search.field("", t -> {
            this.searchString = t.length() > 0 ? t.toLowerCase() : null;
            this.rebuildMaps();
        }).maxTextLength(50).growX().get();
        this.searchField.setMessageText("@editor.search");
        search.button((Drawable)Icon.filter, Styles.emptyi, this::showMapFilters).tooltip("@editor.filters");
        this.cont.add(search).growX();
        this.cont.row();
        this.cont.add(pane).padLeft(28.0f).uniformX().growY();
    }

    void rebuildMaps() {
        Seq<Map> mapList;
        this.mapTable.clear();
        this.mapTable.marginRight(12.0f);
        int maxwidth = Math.max((int)((float)Core.graphics.getWidth() / Scl.scl(230.0f)), 1);
        float mapsize = 200.0f;
        boolean noMapsShown = true;
        int i = 0;
        Seq<Map> seq = this.showCustom ? (this.showBuiltIn ? Vars.maps.all() : Vars.maps.customMaps()) : (mapList = this.showBuiltIn ? Vars.maps.defaultMaps() : null);
        if (mapList != null) {
            for (Map map : mapList) {
                boolean invalid = false;
                for (Gamemode mode : this.modes) {
                    invalid |= !mode.valid(map);
                }
                if (invalid || this.searchString != null && !map.plainName().toLowerCase().contains(this.searchString) && (!this.searchAuthor || !map.plainAuthor().toLowerCase().contains(this.searchString)) && (!this.searchDescription || !map.plainDescription().toLowerCase().contains(this.searchString))) continue;
                noMapsShown = false;
                if (i % maxwidth == 0) {
                    this.mapTable.row();
                }
                TextButton button = this.mapTable.button("", Styles.grayt, () -> this.showMap(map)).width(mapsize).bottom().pad(8.0f).get();
                button.clearChildren();
                button.margin(9.0f);
                button.bottom();
                button.table((Table t) -> {
                    t.left();
                    for (Gamemode mode : Gamemode.all) {
                        TextureRegionDrawable icon = Vars.ui.getIcon("mode" + Strings.capitalize(mode.name()) + "Small");
                        if (!mode.valid(map) || !Core.atlas.isFound(icon.getRegion())) continue;
                        t.image(icon).size(16.0f).pad(4.0f);
                    }
                    if (t.getChildren().size == 0) {
                        t.add().size(16.0f).pad(4.0f);
                    }
                }).left().row();
                button.add(map.name()).width(mapsize - 18.0f).center().get().setEllipsis(true);
                button.row();
                button.image().growX().pad(4.0f).color(Pal.gray);
                button.row();
                button.stack(new Image(map.safeTexture()).setScaling(Scaling.fit), new BorderImage(map.safeTexture()).setScaling(Scaling.fit)).size(mapsize - 20.0f);
                if (this.displayType) {
                    button.row();
                    button.add(map.custom ? "@custom" : (map.workshop ? "@workshop" : (map.mod != null ? "[lightgray]" + map.mod.meta.displayName : "@builtin"))).color(Color.gray).padTop(3.0f);
                }
                ++i;
            }
        }
        if (noMapsShown) {
            this.mapTable.add("@maps.none");
        }
    }

    void showMapFilters() {
        this.activeDialog = new BaseDialog("@editor.filters");
        this.activeDialog.addCloseButton();
        this.activeDialog.cont.table((Table menu) -> {
            menu.add("@editor.filters.mode").width(150.0f).left();
            menu.table((Table t) -> {
                for (Gamemode mode : Gamemode.all) {
                    TextureRegionDrawable icon = Vars.ui.getIcon("mode" + Strings.capitalize(mode.name()));
                    if (!Core.atlas.isFound(icon.getRegion())) continue;
                    t.button((Drawable)icon, Styles.emptyTogglei, () -> {
                        if (this.modes.contains(mode)) {
                            this.modes.remove(mode);
                        } else {
                            this.modes.add(mode);
                        }
                        this.rebuildMaps();
                    }).size(60.0f).checked(this.modes.contains(mode)).tooltip("@mode." + mode.name() + ".name");
                }
            }).padBottom(10.0f);
            menu.row();
            menu.add("@editor.filters.type").width(150.0f).left();
            menu.table(Tex.button, t -> {
                t.button("@custom", Styles.flatTogglet, () -> {
                    this.showCustom = !this.showCustom;
                    Core.settings.put("editorshowcustommaps", this.showCustom);
                    this.rebuildMaps();
                }).size(150.0f, 60.0f).checked(this.showCustom);
                t.button("@builtin", Styles.flatTogglet, () -> {
                    this.showBuiltIn = !this.showBuiltIn;
                    Core.settings.put("editorshowbuiltinmaps", this.showBuiltIn);
                    this.rebuildMaps();
                }).size(150.0f, 60.0f).checked(this.showBuiltIn);
            }).padBottom(10.0f);
            menu.row();
            menu.add("@editor.filters.search").width(150.0f).left();
            menu.table(Tex.button, t -> {
                t.button("@editor.filters.author", Styles.flatTogglet, () -> {
                    this.searchAuthor = !this.searchAuthor;
                    Core.settings.put("editorsearchauthor", this.searchAuthor);
                    this.rebuildMaps();
                }).size(150.0f, 60.0f).checked(this.searchAuthor);
                t.button("@editor.filters.description", Styles.flatTogglet, () -> {
                    this.searchDescription = !this.searchDescription;
                    Core.settings.put("editorsearchdescription", this.searchDescription);
                    this.rebuildMaps();
                }).size(150.0f, 60.0f).checked(this.searchDescription);
            });
        });
        this.activeDialog.show();
    }

    @Override
    public Dialog show() {
        super.show();
        if (Core.app.isDesktop() && this.searchField != null) {
            Core.scene.setKeyboardFocus(this.searchField);
        }
        return this;
    }
}

