/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.scene.Element;
import arc.scene.actions.Actions;
import arc.scene.style.Drawable;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.layout.Table;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import arc.util.Scaling;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatCat;
import mindustry.world.meta.StatValue;
import mindustry.world.meta.Stats;

public class ContentInfoDialog
extends BaseDialog {
    public ContentInfoDialog() {
        super("@info.title");
        this.addCloseButton();
        this.keyDown(key -> {
            if (key == Binding.blockInfo.value.key) {
                Core.app.post(this::hide);
            }
        });
    }

    public void show(UnlockableContent content) {
        this.cont.clear();
        Table table = new Table();
        table.margin(10.0f);
        content.checkStats();
        table.table((Table title1) -> {
            title1.image(content.uiIcon).size(48.0f).scaling(Scaling.fit);
            title1.add("[accent]" + content.localizedName + (Core.settings.getBool("console") ? "\n[gray]" + content.name : "")).padLeft(5.0f);
        });
        table.row();
        if (content.description != null) {
            boolean any;
            boolean bl = any = content.stats.toMap().size > 0;
            if (any) {
                table.add("@category.purpose").color(Pal.accent).fillX().padTop(10.0f);
                table.row();
            }
            table.add("[lightgray]" + content.displayDescription()).wrap().fillX().padLeft(any ? 10.0f : 0.0f).width(500.0f).padTop(any ? 0.0f : 10.0f).left();
            table.row();
            if (!content.stats.useCategories && any) {
                table.add("@category.general").fillX().color(Pal.accent);
                table.row();
            }
        }
        Stats stats = content.stats;
        for (StatCat cat : stats.toMap().keys()) {
            OrderedMap map = (OrderedMap)stats.toMap().get(cat);
            if (map.size == 0) continue;
            if (stats.useCategories) {
                table.add("@category." + cat.name).color(Pal.accent).fillX();
                table.row();
            }
            for (Stat stat : map.keys()) {
                table.table((Table inset) -> {
                    inset.left();
                    inset.add("[lightgray]" + stat.localized() + ":[] ").left().top();
                    Seq arr = (Seq)map.get(stat);
                    for (StatValue value : arr) {
                        value.display((Table)inset);
                        inset.add().size(10.0f);
                    }
                }).fillX().padLeft(10.0f);
                table.row();
            }
        }
        if (content.details != null) {
            table.add("[gray]" + (content.unlocked() || !content.hideDetails ? content.details : "\ue88d " + Core.bundle.get("unlock.incampaign"))).pad(6.0f).padTop(20.0f).width(400.0f).wrap().fillX();
            table.row();
        }
        if (Core.settings.getBool("console")) {
            table.button("@viewfields", (Drawable)Icon.link, Styles.grayt, () -> {
                Class<?> contentClass = content.getClass();
                if (contentClass.isAnonymousClass()) {
                    contentClass = contentClass.getSuperclass();
                }
                Core.app.openURI("https://mindustrygame.github.io/wiki/Modding%20Classes/" + contentClass.getSimpleName());
            }).margin(8.0f).pad(4.0f).padTop(8.0f).size(300.0f, 50.0f).row();
        }
        content.displayExtra(table);
        ScrollPane pane = new ScrollPane((Element)table);
        table.marginRight(30.0f);
        this.cont.add(pane);
        if (this.isShown()) {
            this.show(Core.scene, Actions.fadeIn(0.0f));
        } else {
            this.show();
        }
    }
}

