/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.Events;
import arc.scene.ui.Dialog;
import mindustry.Vars;
import mindustry.core.GameState;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.gen.Sounds;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;

public class BaseDialog
extends Dialog {
    protected boolean wasPaused;
    protected boolean shouldPause;

    public BaseDialog(String title, Dialog.DialogStyle style) {
        super(title, style);
        this.setFillParent(true);
        this.title.setAlignment(1);
        this.titleTable.row();
        this.titleTable.image(Tex.whiteui, Pal.accent).growX().height(3.0f).pad(4.0f);
        this.hidden(() -> {
            if (this.shouldPause && Vars.state.isGame() && !Vars.net.active() && !this.wasPaused) {
                Vars.state.set(GameState.State.playing);
            }
            Sounds.uiBack.play();
        });
        this.shown(() -> {
            if (this.shouldPause && Vars.state.isGame() && !Vars.net.active()) {
                this.wasPaused = Vars.state.is(GameState.State.paused);
                Vars.state.set(GameState.State.paused);
            }
        });
    }

    public BaseDialog(String title) {
        this(title, Core.scene.getStyle(Dialog.DialogStyle.class));
    }

    protected void makeButtonOverlay() {
        this.clearChildren();
        this.add(this.titleTable).growX().row();
        this.stack(this.cont, this.buttons).grow();
        this.buttons.bottom();
    }

    protected void onResize(Runnable run) {
        Events.on(EventType.ResizeEvent.class, event -> {
            if (this.isShown() && Core.scene.getDialog() == this) {
                run.run();
                this.updateScrollFocus();
            }
        });
    }

    public void addCloseListener() {
        this.closeOnBack();
    }

    public void addCloseButton(float width) {
        this.buttons.defaults().size(width, 64.0f);
        this.buttons.button("@back", Icon.left, this::hide).size(width, 64.0f);
        this.addCloseListener();
    }

    @Override
    public void addCloseButton() {
        this.addCloseButton(210.0f);
    }
}

