/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.Core;
import arc.audio.Music;
import arc.files.Fi;
import arc.func.Cons;
import arc.func.Prov;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.Gl;
import arc.graphics.Mesh;
import arc.graphics.g3d.Camera3D;
import arc.graphics.g3d.PlaneBatch3D;
import arc.graphics.g3d.VertexBatch3D;
import arc.graphics.gl.Shader;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Intersector3D;
import arc.math.geom.Mat3D;
import arc.math.geom.Ray;
import arc.math.geom.Vec3;
import arc.struct.ObjectIntMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.TechTree;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.game.CampaignRules;
import mindustry.game.Rules;
import mindustry.gen.Musics;
import mindustry.graphics.Shaders;
import mindustry.graphics.g3d.GenericMesh;
import mindustry.graphics.g3d.MeshBuilder;
import mindustry.graphics.g3d.PlanetGrid;
import mindustry.graphics.g3d.PlanetParams;
import mindustry.graphics.g3d.PlanetRenderer;
import mindustry.graphics.g3d.ShaderSphereMesh;
import mindustry.io.JsonIO;
import mindustry.maps.generators.PlanetGenerator;
import mindustry.type.Sector;
import mindustry.type.SectorPreset;
import mindustry.world.Block;
import mindustry.world.blocks.Attributes;

public class Planet
extends UnlockableContent {
    private static final Vec3 intersectResult = new Vec3();
    private static final Mat3D mat = new Mat3D();
    private static final Seq<Vec3> points = new Seq();
    private static final Vec3 tmpNormal = new Vec3();
    @Nullable
    public GenericMesh mesh;
    @Nullable
    public GenericMesh cloudMesh;
    @Nullable
    public Mesh gridMesh;
    public Vec3 position = new Vec3();
    @Nullable
    public PlanetGrid grid;
    @Nullable
    public PlanetGenerator generator;
    public Seq<Sector> sectors = new Seq();
    public float orbitSpacing = 12.0f;
    public float radius;
    public float camRadius;
    public float minZoom = 0.5f;
    public float maxZoom = 2.0f;
    public boolean drawOrbit = true;
    public float atmosphereRadIn = 0.0f;
    public float atmosphereRadOut = 0.3f;
    public float clipRadius = -1.0f;
    public float orbitRadius;
    public float totalRadius;
    public float orbitTime;
    public float rotateTime = 1440.0f;
    public float orbitOffset;
    public float sectorApproxRadius;
    public boolean tidalLock = false;
    public boolean accessible = true;
    public int defaultEnv = 233;
    public Attributes defaultAttributes = new Attributes();
    public boolean updateLighting = true;
    public float lightSrcFrom = 0.0f;
    public float lightSrcTo = 0.8f;
    public float lightDstFrom = 0.2f;
    public float lightDstTo = 1.0f;
    public int startSector = 0;
    public int sectorSeed = -1;
    public float launchCapacityMultiplier = 0.25f;
    public boolean bloom = false;
    public boolean visible = true;
    public Color landCloudColor = new Color(1.0f, 1.0f, 1.0f, 0.5f);
    public Color lightColor = Color.white.cpy();
    public Color atmosphereColor = new Color(0.3f, 0.7f, 1.0f);
    public Color iconColor = Color.white.cpy();
    public boolean hasAtmosphere = true;
    public boolean allowLaunchSchematics = false;
    public boolean allowLaunchLoadout = false;
    public boolean allowSectorInvasion = false;
    public boolean allowLegacyLaunchPads = false;
    public boolean clearSectorOnLose = false;
    public float enemyBuildSpeedMultiplier = 1.0f;
    public boolean enemyInfiniteItems = true;
    public boolean enemyCoreSpawnReplace = false;
    public boolean prebuildBase = true;
    public boolean allowWaves = false;
    public boolean allowLaunchToNumbered = true;
    public boolean allowCampaignRules = false;
    public String icon = "planet";
    public Music launchMusic = Musics.launch;
    public Block defaultCore = Blocks.coreShard;
    @Nullable
    public Planet parent;
    public Planet solarSystem;
    public Seq<Planet> children = new Seq();
    @Nullable
    public TechTree.TechNode techTree;
    public Seq<Planet> launchCandidates = new Seq();
    public boolean allowSelfSectorLaunch;
    public boolean autoAssignPlanet = true;
    public Seq<UnlockableContent> unlockedOnLand = new Seq();
    public Prov<GenericMesh> meshLoader = () -> new ShaderSphereMesh(this, Shaders.unlitWhite, 2);
    public Prov<GenericMesh> cloudMeshLoader = () -> null;
    public Prov<Mesh> gridMeshLoader = () -> MeshBuilder.buildPlanetGrid(this.grid, PlanetRenderer.outlineColor, 1.17f * this.radius);
    public ObjectSet<Planet> updateGroup = new ObjectSet();
    public CampaignRules campaignRules = new CampaignRules();
    public CampaignRules campaignRuleDefaults = new CampaignRules();
    public Cons<Rules> ruleSetter = r -> {};
    public boolean showRtsAIRule = false;
    public boolean loadPlanetData = false;
    @Nullable
    public PlanetData data;

    public Planet(String name, Planet parent, float radius) {
        super(name);
        this.radius = radius;
        this.parent = parent;
        this.orbitOffset = Mathf.randomSeed(this.id + 1, 360.0f);
        this.totalRadius = radius;
        this.orbitRadius = parent == null ? 0.0f : parent.totalRadius + parent.orbitSpacing + this.totalRadius;
        this.orbitTime = Mathf.pow(this.orbitRadius, 1.5f) * 1000.0f;
        if (parent != null) {
            parent.children.add(this);
            parent.updateTotalRadius();
        }
        this.solarSystem = this;
        while (this.solarSystem.parent != null) {
            this.solarSystem = this.solarSystem.parent;
        }
        this.allowCampaignRules = this.isVanilla();
    }

    public Planet(String name, Planet parent, float radius, int sectorSize) {
        this(name, parent, radius);
        if (sectorSize > 0) {
            this.grid = PlanetGrid.create(sectorSize);
            this.sectors.ensureCapacity(this.grid.tiles.length);
            for (int i = 0; i < this.grid.tiles.length; ++i) {
                this.sectors.add(new Sector(this, this.grid.tiles[i]));
            }
            this.sectorApproxRadius = this.sectors.first().tile.v.dst(this.sectors.first().tile.corners[0].v);
        }
    }

    public void saveRules() {
        Core.settings.putJson(this.name + "-campaign-rules", this.campaignRules);
    }

    public void loadRules() {
        this.campaignRules = Core.settings.getJson(this.name + "-campaign-rules", CampaignRules.class, () -> this.campaignRules);
    }

    @Nullable
    public Sector getStartSector() {
        return this.sectors.size == 0 ? null : this.sectors.get(this.startSector);
    }

    public void applyRules(Rules rules) {
        this.applyRules(rules, false);
    }

    public void applyRules(Rules rules, boolean customGame) {
        this.ruleSetter.get(rules);
        rules.attributes.clear();
        rules.attributes.add(this.defaultAttributes);
        rules.env = this.defaultEnv;
        rules.planet = this;
        if (!customGame) {
            this.campaignRules.apply(this, rules);
        }
    }

    public void applyDefaultRules(CampaignRules rules) {
        JsonIO.copy(this.campaignRuleDefaults, rules);
    }

    @Nullable
    public Sector getLastSector() {
        if (this.sectors.isEmpty()) {
            return null;
        }
        return this.sectors.get(Math.min(Core.settings.getInt(this.name + "-last-sector", this.startSector), this.sectors.size - 1));
    }

    public void setLastSector(Sector sector) {
        Core.settings.put(this.name + "-last-sector", sector.id);
    }

    public void preset(int index, SectorPreset preset) {
        this.sectors.get((int)index).preset = preset;
    }

    public boolean hasGrid() {
        return this.grid != null && this.generator != null && this.sectors.size > 0;
    }

    public boolean isLandable() {
        return this.sectors.size > 0;
    }

    public void updateTotalRadius() {
        this.totalRadius = this.radius;
        for (Planet planet : this.children) {
            this.totalRadius = Math.max(this.totalRadius, planet.orbitRadius + planet.totalRadius);
        }
    }

    public Vec3 getLightNormal() {
        return Tmp.v31.set(this.solarSystem.position).sub(this.position).nor();
    }

    public float getOrbitAngle() {
        return (this.orbitOffset + Vars.universe.secondsf() / (this.orbitTime / 360.0f)) % 360.0f;
    }

    public float getRotation() {
        if (this.tidalLock) {
            return -this.getOrbitAngle() + 90.0f;
        }
        float offset = Mathf.randomSeed(this.id + 1, 360.0f);
        return (offset + Vars.universe.secondsf() / (this.rotateTime / 360.0f)) % 360.0f;
    }

    public Vec3 addParentOffset(Vec3 in) {
        if (this.parent == null || Mathf.zero(this.orbitRadius)) {
            return in;
        }
        float angle = this.getOrbitAngle();
        return in.add(Angles.trnsx(angle, this.orbitRadius), 0.0f, Angles.trnsy(angle, this.orbitRadius));
    }

    public Vec3 getWorldPosition(Vec3 in) {
        in.setZero();
        Planet current = this;
        while (current != null) {
            current.addParentOffset(in);
            current = current.parent;
        }
        return in;
    }

    public void updateBaseCoverage() {
        for (Sector sector : this.sectors) {
            float sum = 1.0f;
            for (Sector other : sector.near()) {
                if (!other.generateEnemyBase) continue;
                sum += 0.9f;
            }
            if (sector.hasEnemyBase()) {
                sum += 0.88f;
            }
            sector.threat = sector.preset == null || !sector.preset.requireUnlock ? Math.max(Math.min(sum / 5.0f, 1.2f), 0.3f) : Mathf.clamp(sector.preset.difficulty / 10.0f);
        }
    }

    public Mat3D getTransform(Mat3D mat) {
        return mat.setToTranslation(this.position).rotate(Vec3.Y, this.getRotation());
    }

    public void reloadMesh() {
        if (Vars.headless) {
            return;
        }
        if (this.mesh != null) {
            this.mesh.dispose();
        }
        this.mesh = this.meshLoader.get();
    }

    public void reloadMeshAsync() {
        if (Vars.headless) {
            return;
        }
        Vars.mainExecutor.submit(() -> {
            GenericMesh newMesh = this.meshLoader.get();
            Core.app.post(() -> {
                if (this.mesh != null) {
                    this.mesh.dispose();
                }
                this.mesh = newMesh;
            });
        });
    }

    @Override
    public void load() {
        super.load();
        if (!Vars.headless) {
            this.mesh = this.meshLoader.get();
            this.cloudMesh = this.cloudMeshLoader.get();
            if (this.grid != null) {
                this.gridMesh = this.gridMeshLoader.get();
            }
        }
    }

    @Override
    public void init() {
        this.applyDefaultRules(this.campaignRules);
        this.loadRules();
        if (this.techTree == null) {
            this.techTree = TechTree.roots.find(n -> n.planet == this);
        }
        if (this.techTree != null && this.autoAssignPlanet) {
            this.techTree.addDatabaseTab(this);
            this.techTree.addPlanet(this);
        }
        for (Sector sector : this.sectors) {
            sector.loadInfo();
        }
        if (this.generator != null) {
            for (Sector sector : this.sectors) {
                this.generator.generateSector(sector);
            }
            this.updateBaseCoverage();
        }
        this.clipRadius = Math.max(this.clipRadius, this.radius + this.atmosphereRadOut + 0.5f);
    }

    @Nullable
    public PlanetData getData() {
        Fi file;
        if (this.loadPlanetData && this.data == null && (file = Vars.tree.get("planets/" + this.name + ".json")).exists()) {
            this.data = JsonIO.read(PlanetData.class, file.readString());
            for (int i : this.data.attackSectors) {
                if (i < 0 || i >= this.sectors.size) continue;
                this.sectors.get((int)i).generateEnemyBase = true;
            }
        }
        return this.data;
    }

    public Sector getSector(PlanetGrid.Ptile tile) {
        return this.sectors.get(tile.id);
    }

    @Nullable
    public Sector getSector(Ray ray) {
        return this.getSector(ray, this.radius);
    }

    @Nullable
    public Sector getSector(Ray ray, float radius) {
        Vec3 vec = this.intersect(ray, radius);
        if (vec == null) {
            return null;
        }
        vec.sub(this.position).rotate(Vec3.Y, this.getRotation());
        return this.sectors.min(t -> Tmp.v31.set(t.tile.v).setLength(radius).dst2(vec));
    }

    @Nullable
    public Vec3 intersect(Ray ray, float radius) {
        boolean found = Intersector3D.intersectRaySphere(ray, this.position, radius, intersectResult);
        if (!found) {
            return null;
        }
        return intersectResult;
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.planet;
    }

    public boolean visible() {
        return this.visible;
    }

    public void draw(PlanetParams params, Mat3D projection, Mat3D transform) {
        this.mesh.render(params, projection, transform);
    }

    public void drawAtmosphere(Mesh atmosphere, Camera3D cam) {
        Gl.depthMask(false);
        Blending.additive.apply();
        Shaders.atmosphere.camera = cam;
        Shaders.atmosphere.planet = this;
        Shaders.atmosphere.bind();
        Shaders.atmosphere.apply();
        atmosphere.render(Shaders.atmosphere, 4);
        Blending.normal.apply();
        Gl.depthMask(true);
    }

    public void drawClouds(PlanetParams params, Mat3D projection, Mat3D transform) {
        if (this.cloudMesh != null) {
            this.cloudMesh.render(params, projection, transform);
        }
    }

    public void drawBorders(VertexBatch3D batch, Sector sector, Color base, float alpha) {
        Color color = Tmp.c1.set(base).a((base.a + 0.3f + Mathf.absin(Time.globalTime, 5.0f, 0.3f)) * alpha);
        float r1 = this.radius;
        float r2 = 1.17f * this.radius + 0.001f;
        for (int i = 0; i < sector.tile.corners.length; ++i) {
            PlanetGrid.Corner c = sector.tile.corners[i];
            PlanetGrid.Corner next = sector.tile.corners[(i + 1) % sector.tile.corners.length];
            Tmp.v31.set(c.v).setLength(r2);
            Tmp.v32.set(next.v).setLength(r2);
            Tmp.v33.set(c.v).setLength(r1);
            batch.tri2(Tmp.v31, Tmp.v32, Tmp.v33, color);
            Tmp.v31.set(next.v).setLength(r2);
            Tmp.v32.set(next.v).setLength(r1);
            Tmp.v33.set(c.v).setLength(r1);
            batch.tri2(Tmp.v31, Tmp.v32, Tmp.v33, color);
        }
    }

    public void fill(VertexBatch3D batch, Sector sector, Color color, float offset) {
        float rr = 1.17f * this.radius + offset;
        for (int i = 0; i < sector.tile.corners.length; ++i) {
            PlanetGrid.Corner c = sector.tile.corners[i];
            PlanetGrid.Corner next = sector.tile.corners[(i + 1) % sector.tile.corners.length];
            batch.tri(Tmp.v31.set(c.v).setLength(rr), Tmp.v32.set(next.v).setLength(rr), Tmp.v33.set(sector.tile.v).setLength(rr), color);
        }
    }

    public void drawSelection(VertexBatch3D batch, Sector sector, Color color, float stroke, float length) {
        float arad = (1.17f + length) * this.radius;
        for (int i = 0; i < sector.tile.corners.length; ++i) {
            PlanetGrid.Corner next = sector.tile.corners[(i + 1) % sector.tile.corners.length];
            PlanetGrid.Corner curr = sector.tile.corners[i];
            next.v.scl(arad);
            curr.v.scl(arad);
            sector.tile.v.scl(arad);
            Tmp.v31.set(curr.v).sub(sector.tile.v).setLength(curr.v.dst(sector.tile.v) - stroke).add(sector.tile.v);
            Tmp.v32.set(next.v).sub(sector.tile.v).setLength(next.v.dst(sector.tile.v) - stroke).add(sector.tile.v);
            batch.tri(curr.v, next.v, Tmp.v31, color);
            batch.tri(Tmp.v31, next.v, Tmp.v32, color);
            sector.tile.v.scl(1.0f / arad);
            next.v.scl(1.0f / arad);
            curr.v.scl(1.0f / arad);
        }
    }

    public void renderSectors(VertexBatch3D batch, Camera3D cam, PlanetParams params) {
        batch.proj().mul(this.getTransform(mat));
        if (params.renderer != null) {
            params.renderer.renderSectors(this);
        }
        float scaledOutlineRad = 1.17f * this.radius;
        Mesh mesh = this.gridMesh;
        Shaders.PlanetGridShader shader = Shaders.planetGrid;
        Vec3 tile = this.intersect(cam.getMouseRay(), scaledOutlineRad);
        Shaders.planetGrid.mouse.lerp(tile == null ? Vec3.Zero : tile.sub(this.position).rotate(Vec3.Y, this.getRotation()), 0.2f);
        shader.bind();
        shader.setUniformMatrix4("u_proj", cam.combined.val);
        shader.setUniformMatrix4("u_trans", this.getTransform((Mat3D)Planet.mat).val);
        ((Shader)shader).apply();
        mesh.render(shader, 1);
    }

    public void drawArc(VertexBatch3D batch, Vec3 a, Vec3 b, Color from, Color to, float length, float timeScale, int pointCount) {
        float scaledOutlineRad = 1.17f * this.radius;
        float dot = 1.0f - (Tmp.v32.set(a).nor().dot(Tmp.v33.set(b).nor()) + 1.0f) / 2.0f;
        Vec3 avg = Tmp.v31.set(b).add(a).scl(0.5f);
        avg.setLength(this.radius * (1.0f + length) + dot * 1.35f);
        points.clear();
        points.addAll((Vec3[])new Vec3[]{Tmp.v33.set(b).setLength(scaledOutlineRad), Tmp.v31, Tmp.v34.set(a).setLength(scaledOutlineRad)});
        Tmp.bz3.set(points);
        for (int i = 0; i < pointCount + 1; ++i) {
            float f = (float)i / (float)pointCount;
            Tmp.c1.set(from).lerp(to, (f + Time.globalTime / timeScale) % 1.0f);
            batch.color(Tmp.c1);
            batch.vertex(Tmp.bz3.valueAt(Tmp.v32, f));
        }
        batch.flush(3);
    }

    public void drawArcLine(VertexBatch3D batch, Vec3 a, Vec3 b, Color from, Color to, float length, float timeScale, int pointCount, float stroke) {
        float scaledOutlineRad = 1.17f * this.radius;
        float dot = 1.0f - (Tmp.v32.set(a).nor().dot(Tmp.v33.set(b).nor()) + 1.0f) / 2.0f;
        Vec3 avg = Tmp.v31.set(b).add(a).scl(0.5f);
        avg.setLength(this.radius * (1.0f + length) + dot * 1.35f);
        points.clear();
        points.addAll((Vec3[])new Vec3[]{Tmp.v33.set(b).setLength(scaledOutlineRad), Tmp.v31, Tmp.v34.set(a).setLength(scaledOutlineRad)});
        Tmp.bz3.set(points);
        Vec3 normal = tmpNormal;
        Vec3 point1 = points.get(0);
        Vec3 point2 = points.get(1);
        Vec3 point3 = points.get(2);
        normal.set(point1).sub(point2).crs(point2.x - point3.x, point2.y - point3.y, point2.z - point3.z).nor();
        for (int i = 0; i < pointCount + 1; ++i) {
            float f = (float)i / (float)pointCount;
            Tmp.c1.set(from).lerp(to, (f + Time.globalTime / timeScale) % 1.0f);
            batch.color(Tmp.c1);
            batch.vertex(Tmp.bz3.valueAt(Tmp.v32, f).add(normal, stroke));
            batch.color(Tmp.c1);
            batch.vertex(Tmp.bz3.valueAt(Tmp.v32, f).add(normal, -stroke));
        }
        Gl.disable(2884);
        batch.flush(5);
        Gl.enable(2884);
    }

    public Vec3 lookAt(Sector sector, Vec3 out) {
        return out.set(sector.tile.v).rotate(Vec3.Y, -this.getRotation());
    }

    public Vec3 project(Sector sector, Camera3D cam, Vec3 out) {
        return cam.project(out.set(sector.tile.v).setLength(1.17f * this.radius).rotate(Vec3.Y, -this.getRotation()).add(this.position));
    }

    public void setPlane(Sector sector, PlaneBatch3D projector) {
        float rotation = -this.getRotation();
        float length = 0.01f;
        projector.setPlane(Tmp.v33.set(sector.tile.v).setLength((1.17f + length) * this.radius).rotate(Vec3.Y, rotation).add(this.position), sector.plane.project(Tmp.v32.set(sector.tile.v).add(Vec3.Y)).sub(sector.tile.v, this.radius).rotate(Vec3.Y, rotation).nor(), Tmp.v31.set(Tmp.v32).rotate(Vec3.Y, -rotation).add(sector.tile.v).rotate(sector.tile.v, 90.0f).sub(sector.tile.v).rotate(Vec3.Y, rotation).nor());
    }

    public static class PlanetData {
        public ObjectIntMap<String> presets = new ObjectIntMap();
        public int[] attackSectors = new int[0];
    }
}

