/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.Core;
import arc.audio.Sound;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.geom.Intersector;
import arc.math.geom.Position;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Bullet;
import mindustry.gen.Groups;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;

public class ForceFieldAbility
extends Ability {
    public float radius = 60.0f;
    public float regen = 0.1f;
    public float max = 200.0f;
    public float cooldown = 300.0f;
    public int sides = 6;
    public float rotation = 0.0f;
    public Sound breakSound = Sounds.shieldBreakSmall;
    public Sound hitSound = Sounds.shieldHit;
    public float hitSoundVolume = 0.12f;
    protected float radiusScale;
    protected float alpha;
    protected boolean wasBroken = true;
    private static float realRad;
    private static Unit paramUnit;
    private static ForceFieldAbility paramField;
    private static final Cons<Bullet> shieldConsumer;

    public ForceFieldAbility(float radius, float regen, float max, float cooldown) {
        this.radius = radius;
        this.regen = regen;
        this.max = max;
        this.cooldown = cooldown;
    }

    public ForceFieldAbility(float radius, float regen, float max, float cooldown, int sides, float rotation) {
        this.radius = radius;
        this.regen = regen;
        this.max = max;
        this.cooldown = cooldown;
        this.sides = sides;
        this.rotation = rotation;
    }

    ForceFieldAbility() {
    }

    @Override
    public void addStats(Table t) {
        super.addStats(t);
        t.add(Core.bundle.format("bullet.range", Strings.autoFixed(this.radius / 8.0f, 2)));
        t.row();
        t.add(this.abilityStat("shield", Strings.autoFixed(this.max, 2)));
        t.row();
        t.add(this.abilityStat("repairspeed", Strings.autoFixed(this.regen * 60.0f, 2)));
        t.row();
        t.add(this.abilityStat("cooldown", Strings.autoFixed(this.cooldown / 60.0f, 2)));
    }

    @Override
    public void update(Unit unit) {
        if (unit.shield <= 0.0f && !this.wasBroken) {
            unit.shield -= this.cooldown * this.regen;
            Fx.shieldBreak.at(unit.x, unit.y, this.radius, unit.type.shieldColor(unit), this);
            this.breakSound.at(unit.x, unit.y);
        }
        boolean bl = this.wasBroken = unit.shield <= 0.0f;
        if (unit.shield < this.max) {
            unit.shield += Time.delta * this.regen;
        }
        this.alpha = Math.max(this.alpha - Time.delta / 10.0f, 0.0f);
        if (unit.shield > 0.0f) {
            this.radiusScale = Mathf.lerpDelta(this.radiusScale, 1.0f, 0.06f);
            paramUnit = unit;
            paramField = this;
            this.checkRadius(unit);
            Groups.bullet.intersect(unit.x - realRad, unit.y - realRad, realRad * 2.0f, realRad * 2.0f, shieldConsumer);
        } else {
            this.radiusScale = 0.0f;
        }
    }

    @Override
    public void death(Unit unit) {
        if (unit.shield > 0.0f && !this.wasBroken) {
            Fx.shieldBreak.at(unit.x, unit.y, this.radius, unit.type.shieldColor(unit), this);
            this.breakSound.at(unit.x, unit.y);
        }
    }

    @Override
    public void draw(Unit unit) {
        this.checkRadius(unit);
        if (unit.shield > 0.0f) {
            Draw.color(unit.type.shieldColor(unit), Color.white, Mathf.clamp(this.alpha));
            if (Vars.renderer.animateShields) {
                Draw.z(125.0f + 0.001f * this.alpha);
                Fill.poly(unit.x, unit.y, this.sides, realRad, this.rotation);
            } else {
                Draw.z(125.0f);
                Lines.stroke(1.5f);
                Draw.alpha(0.09f);
                Fill.poly(unit.x, unit.y, this.sides, this.radius, this.rotation);
                Draw.alpha(1.0f);
                Lines.poly(unit.x, unit.y, this.sides, this.radius, this.rotation);
            }
        }
    }

    @Override
    public void displayBars(Unit unit, Table bars) {
        bars.add(new Bar("stat.shieldhealth", Pal.accent, () -> unit.shield / this.max)).row();
    }

    @Override
    public void created(Unit unit) {
        unit.shield = this.max;
    }

    public void checkRadius(Unit unit) {
        realRad = this.radiusScale * this.radius;
    }

    static {
        shieldConsumer = b -> {
            if (b.team != ForceFieldAbility.paramUnit.team && b.type.absorbable && Intersector.isInRegularPolygon(ForceFieldAbility.paramField.sides, ForceFieldAbility.paramUnit.x, ForceFieldAbility.paramUnit.y, realRad, ForceFieldAbility.paramField.rotation, b.x(), b.y()) && ForceFieldAbility.paramUnit.shield > 0.0f) {
                b.absorb();
                Fx.absorb.at((Position)b);
                ForceFieldAbility.paramField.hitSound.at(b.x, b.y, 1.0f + Mathf.range(0.1f), ForceFieldAbility.paramField.hitSoundVolume);
                ForceFieldAbility.paramUnit.shield -= b.type().shieldDamage((Bullet)b);
                ForceFieldAbility.paramField.alpha = 1.0f;
            }
        };
    }
}

