/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Unit;
import mindustry.graphics.Shaders;

public class ArmorPlateAbility
extends Ability {
    public TextureRegion plateRegion;
    public TextureRegion shineRegion;
    public String plateSuffix = "-armor";
    public String shineSuffix = "-shine";
    @Nullable
    public Color color = null;
    public float shineSpeed = 1.0f;
    public float z = -1.0f;
    public boolean drawPlate = true;
    public boolean drawShine = true;
    public float healthMultiplier = 0.2f;
    protected float warmup;

    @Override
    public void update(Unit unit) {
        super.update(unit);
        this.warmup = Mathf.lerpDelta(this.warmup, unit.isShooting() ? 1.0f : 0.0f, 0.1f);
        unit.healthMultiplier += this.warmup * this.healthMultiplier;
    }

    @Override
    public void addStats(Table t) {
        super.addStats(t);
        t.add(this.abilityStat("damagereduction", Strings.autoFixed(-this.healthMultiplier * 100.0f, 1)));
    }

    @Override
    public void draw(Unit unit) {
        if (!this.drawPlate && !this.drawShine) {
            return;
        }
        if (this.warmup > 0.001f) {
            if (this.plateRegion == null) {
                this.plateRegion = Core.atlas.find(unit.type.name + this.plateSuffix, unit.type.region);
                this.shineRegion = Core.atlas.find(unit.type.name + this.shineSuffix, this.plateRegion);
            }
            float pz = Draw.z();
            if (this.z > 0.0f) {
                Draw.z(this.z);
            }
            if (this.drawPlate) {
                Draw.alpha(this.warmup);
                Draw.rect(this.plateRegion, unit.x, unit.y, unit.rotation - 90.0f);
                Draw.alpha(1.0f);
            }
            if (this.drawShine) {
                Draw.draw(Draw.z(), () -> {
                    Shaders.armor.region = this.shineRegion;
                    Shaders.armor.progress = this.warmup;
                    Shaders.armor.time = -Time.time / 20.0f * this.shineSpeed;
                    Draw.color(this.color == null ? unit.team.color : this.color);
                    Draw.shader(Shaders.armor);
                    Draw.rect(this.shineRegion, unit.x, unit.y, unit.rotation - 90.0f);
                    Draw.shader();
                    Draw.reset();
                });
            }
            Draw.z(pz);
        }
    }
}

