/*
 * Decompiled with CFR 0.152.
 */
package mindustry.audio;

import arc.Core;
import arc.Events;
import arc.audio.AudioBus;
import arc.audio.AudioFilter;
import arc.audio.Filters;
import arc.audio.Music;
import arc.audio.Sound;
import arc.files.Fi;
import arc.func.Boolf;
import arc.func.Prov;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.game.EventType;
import mindustry.game.SpawnGroup;
import mindustry.gen.Musics;
import mindustry.gen.Sounds;

public class SoundControl {
    public float finTime = 120.0f;
    public float foutTime = 120.0f;
    public float musicInterval = 10800.0f;
    public float musicChance = 0.8f;
    public float musicWaveChance = 0.46f;
    public Seq<Music> ambientMusic = Seq.with(new Music[0]);
    public Seq<Music> darkMusic = Seq.with(new Music[0]);
    public Seq<Music> bossMusic = Seq.with(new Music[0]);
    protected Music lastRandomPlayed;
    protected Interval timer = new Interval(4);
    protected long lastPlayed;
    @Nullable
    protected Music current;
    protected float fade;
    protected boolean silenced;
    protected AudioBus uiBus = new AudioBus();
    protected boolean wasPlaying;
    protected AudioFilter filter = new Filters.BiquadFilter(){
        {
            this.set(0, 500.0f, 1.0f);
        }
    };
    protected ObjectMap<Sound, SoundData> sounds = new ObjectMap();

    public SoundControl() {
        Events.on(EventType.ClientLoadEvent.class, e -> this.reload());
        Events.on(EventType.WaveEvent.class, e -> Time.run(Mathf.random(8.0f, 15.0f) * 60.0f, () -> {
            boolean boss = Vars.state.rules.spawns.contains((SpawnGroup)((Object)((Boolf<SpawnGroup>)group -> group.getSpawned(Vars.state.wave - 2) > 0 && group.effect == StatusEffects.boss)));
            if (boss) {
                this.playOnce(this.bossMusic.random(this.lastRandomPlayed));
            } else if (Mathf.chance(this.musicWaveChance)) {
                this.playRandom();
            }
        }));
        this.setupFilters();
        Events.on(EventType.ResetEvent.class, e -> {
            this.lastPlayed = Time.millis();
            Core.audio.soundBus.stop();
            Core.audio.soundBus.play();
        });
    }

    protected void setupFilters() {
        Core.audio.soundBus.setFilter(0, this.filter);
        Core.audio.soundBus.setFilterParam(0, 0, 0.0f);
    }

    protected void reload() {
        this.current = null;
        this.fade = 0.0f;
        this.ambientMusic = Seq.with(Musics.game1, Musics.game3, Musics.game6, Musics.game8, Musics.game9, Musics.fine);
        this.darkMusic = Seq.with(Musics.game2, Musics.game5, Musics.game7, Musics.game4);
        this.bossMusic = Seq.with(Musics.boss1, Musics.boss2, Musics.game2, Musics.game5);
        for (Sound sound : Core.assets.getAll(Sound.class, new Seq())) {
            Fi file = Fi.get(Core.assets.getAssetFileName(sound));
            if (!file.parent().name().equals("ui")) continue;
            sound.setBus(this.uiBus);
        }
        Events.fire(new EventType.MusicRegisterEvent());
    }

    public void loop(Sound sound, float volume) {
        if (Vars.headless) {
            return;
        }
        this.loop(sound, Core.camera.position, volume);
    }

    public void loop(Sound sound, Position pos, float volume) {
        this.loop(sound, pos, volume, 1.0f);
    }

    public void loop(Sound sound, Position pos, float volume, float pitch) {
        if (Vars.headless || sound == Sounds.none || volume <= 1.0E-5f) {
            return;
        }
        float baseVol = sound.calcFalloff(pos.getX(), pos.getY());
        float vol = baseVol * volume;
        SoundData data = (SoundData)((Object)this.sounds.get(sound, (SoundData)((Object)((Prov<SoundData>)SoundData::new))));
        data.volume += vol;
        data.pitch += pitch * vol;
        data.volume = Mathf.clamp(data.volume, 0.0f, 1.0f);
        data.total += baseVol;
        data.totalVolume += vol;
        data.sum.add(pos.getX() * baseVol, pos.getY() * baseVol);
    }

    public void stop() {
        this.silenced = true;
        if (this.current != null) {
            this.current.stop();
            this.current = null;
            this.fade = 0.0f;
        }
    }

    public void update() {
        boolean paused = Vars.state.isGame() && Core.scene.hasDialog();
        boolean playing = Vars.state.isGame();
        if (this.current != null && !this.current.isPlaying()) {
            this.current = null;
            this.fade = 0.0f;
        }
        if (this.timer.get(1, 30.0f)) {
            Core.audio.soundBus.fadeFilterParam(0, 0, paused ? 1.0f : 0.0f, 0.4f);
        }
        if (playing != this.wasPlaying) {
            this.wasPlaying = playing;
            if (playing) {
                Core.audio.soundBus.play();
                this.setupFilters();
            } else {
                Core.audio.soundBus.stop();
                Core.audio.musicBus.play();
                Core.audio.soundBus.play();
            }
        }
        Core.audio.setPaused(Core.audio.soundBus.id, Vars.state.isPaused());
        if (Vars.state.isMenu()) {
            this.silenced = false;
            if (Vars.ui.planet.isShown()) {
                this.play(Vars.ui.planet.state.planet.launchMusic);
            } else if (Vars.ui.editor.isShown()) {
                this.play(Musics.editor);
            } else {
                this.play(Musics.menu);
            }
        } else if (Vars.state.rules.editor) {
            this.silenced = false;
            this.play(Musics.editor);
        } else {
            this.silence();
            if (Core.settings.getBool("alwaysmusic")) {
                if (this.current == null) {
                    this.playRandom();
                }
            } else if ((float)Time.timeSinceMillis(this.lastPlayed) > 1000.0f * this.musicInterval / 60.0f && Mathf.chance(this.musicChance)) {
                this.lastPlayed = Time.millis();
                this.playRandom();
            }
        }
        this.updateLoops();
    }

    protected void updateLoops() {
        if (!Vars.state.isGame()) {
            this.sounds.clear();
            return;
        }
        float avol = (float)Core.settings.getInt("ambientvol", 100) / 100.0f;
        this.sounds.each((sound, data) -> {
            float pitch;
            data.curVolume = Mathf.lerpDelta(data.curVolume, data.volume * avol, 0.11f);
            boolean play = data.curVolume > 0.01f;
            float pan = Mathf.zero(data.total, 1.0E-4f) ? 0.0f : sound.calcPan(data.sum.x / data.total, data.sum.y / data.total);
            float f = pitch = Mathf.zero(data.totalVolume, 1.0E-4f) ? 1.0f : data.pitch / data.totalVolume;
            if (data.soundID <= 0 || !Core.audio.isPlaying(data.soundID)) {
                if (play) {
                    data.soundID = sound.loop(data.curVolume, pitch, pan);
                    Core.audio.protect(data.soundID, true);
                }
            } else {
                if (data.curVolume <= 0.001f) {
                    sound.stop();
                    data.soundID = -1;
                    return;
                }
                Core.audio.set(data.soundID, pan, data.curVolume);
                if (!Mathf.equal(pitch, 1.0f, 0.001f)) {
                    Core.audio.setPitch(data.soundID, pitch);
                }
            }
            data.pitch = 0.0f;
            data.volume = 0.0f;
            data.total = 0.0f;
            data.totalVolume = 0.0f;
            data.sum.setZero();
        });
    }

    public void playRandom() {
        if (Vars.state.boss() != null) {
            this.playOnce(this.bossMusic.random(this.lastRandomPlayed));
        } else if (this.isDark()) {
            this.playOnce(this.darkMusic.random(this.lastRandomPlayed));
        } else {
            this.playOnce(this.ambientMusic.random(this.lastRandomPlayed));
        }
    }

    protected boolean isDark() {
        if (Vars.player.team().data().hasCore() && Vars.player.team().data().core().healthf() < 0.85f) {
            return true;
        }
        if (Mathf.chance((float)(Math.log10(((float)Vars.state.wave - 17.0f) / 19.0f) + 1.0) / 4.0f)) {
            return true;
        }
        return Mathf.chance((float)Vars.state.enemies / 70.0f + 0.1f);
    }

    protected void play(@Nullable Music music) {
        if (!this.shouldPlay()) {
            if (this.current != null) {
                this.current.setVolume(0.0f);
            }
            this.fade = 0.0f;
            return;
        }
        if (this.current != null) {
            this.current.setVolume(this.fade * (float)Core.settings.getInt("musicvol") / 100.0f);
        }
        if (this.silenced) {
            return;
        }
        if (this.current == null && music != null) {
            this.current = music;
            this.current.setLooping(true);
            this.fade = 0.0f;
            this.current.setVolume(0.0f);
            this.current.play();
            this.silenced = false;
        } else if (this.current == music && music != null) {
            this.fade = Mathf.clamp(this.fade + Time.delta / this.finTime);
        } else if (this.current != null) {
            this.fade = Mathf.clamp(this.fade - Time.delta / this.foutTime);
            if (this.fade <= 0.01f) {
                this.current.stop();
                this.current = null;
                this.silenced = true;
                if (music != null) {
                    this.current = music;
                    this.fade = 0.0f;
                    this.current.setVolume(0.0f);
                    this.current.setLooping(true);
                    this.current.play();
                    this.silenced = false;
                }
            }
        }
    }

    protected void playOnce(Music music) {
        if (this.current != null || music == null || !this.shouldPlay()) {
            return;
        }
        this.lastRandomPlayed = music;
        this.fade = 1.0f;
        this.current = music;
        this.current.setVolume(1.0f);
        this.current.setLooping(false);
        this.current.play();
    }

    protected boolean shouldPlay() {
        return Core.settings.getInt("musicvol") > 0;
    }

    protected void silence() {
        this.play(null);
    }

    protected static class SoundData {
        float volume;
        float pitch;
        float total;
        Vec2 sum = new Vec2();
        int soundID;
        float curVolume;
        float totalVolume;

        protected SoundData() {
        }
    }
}

