/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai;

import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.func.Prov;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.struct.IntQueue;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.TaskQueue;
import arc.util.Time;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.core.World;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.PathTile;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockStatus;

public class Pathfinder
implements Runnable {
    private static final long maxUpdate = Time.millisToNanos(8L);
    private static final int neverRefresh = Integer.MAX_VALUE;
    private static final int updateFPS = 60;
    private static final int updateInterval = 16;
    static int wwidth;
    static int wheight;
    static final int impassable = -1;
    public static final int fieldCore = 0;
    public static final int maxFields = 10;
    public static final Seq<Prov<Flowfield>> fieldTypes;
    public static final int costGround = 0;
    public static final int costLegs = 1;
    public static final int costNaval = 2;
    public static final int costNeoplasm = 3;
    public static final int costNone = 4;
    public static final int costHover = 5;
    public static final int maxCosts = 8;
    public static final Seq<PathCost> costTypes;
    int[] tiles = new int[0];
    Flowfield[][][] cache;
    Seq<Flowfield> threadList = new Seq();
    Seq<Flowfield> mainList = new Seq();
    TaskQueue queue = new TaskQueue();
    @Nullable
    Thread thread;
    IntSeq tmpArray = new IntSeq();
    boolean needsRefresh;
    private long lastRefreshTime;
    private static final long refreshIntervalMs = 100L;

    public Pathfinder() {
        this.clearCache();
        Events.on(EventType.WorldLoadEvent.class, event -> {
            this.stop();
            this.tiles = new int[Vars.world.width() * Vars.world.height()];
            wwidth = Vars.world.width();
            wheight = Vars.world.height();
            this.threadList = new Seq();
            this.mainList = new Seq();
            this.clearCache();
            for (int i = 0; i < this.tiles.length; ++i) {
                Tile tile = Vars.world.tiles.geti(i);
                this.tiles[i] = this.packTile(tile);
            }
            if (Vars.state.rules.waveTeam.needsFlowField() && !Vars.net.client()) {
                this.preloadPath(this.getField(Vars.state.rules.waveTeam, 0, 0));
                Log.debug("Preloading ground enemy flowfield.");
                if (Vars.spawner.getSpawns().contains((Tile)((Object)((Boolf<Tile>)t -> t.floor().isLiquid)))) {
                    this.preloadPath(this.getField(Vars.state.rules.waveTeam, 2, 0));
                    Log.debug("Preloading naval enemy flowfield.");
                }
            }
            this.start();
        });
        Events.on(EventType.ResetEvent.class, event -> this.stop());
        Events.on(EventType.TileChangeEvent.class, event -> {
            if (Vars.state.isEditor()) {
                return;
            }
            this.updateTile(event.tile);
        });
        Events.on(EventType.TilePreChangeEvent.class, event -> {
            if (Vars.state.isEditor()) {
                return;
            }
            Tile tile = event.tile;
            if (tile.solid()) {
                for (int i = 0; i < 4; ++i) {
                    Tile other = tile.nearby(i);
                    if (other == null || other.solid()) continue;
                    boolean otherNearSolid = false;
                    for (int j = 0; j < 4; ++j) {
                        Tile othernear = other.nearby(j);
                        if (othernear == null || !othernear.solid()) continue;
                        otherNearSolid = true;
                        break;
                    }
                    int arr = other.array();
                    if (otherNearSolid || this.tiles.length <= arr) continue;
                    int n = arr;
                    this.tiles[n] = this.tiles[n] & 0xFFDFFFFF;
                }
            }
        });
        Events.run((Object)EventType.Trigger.afterGameUpdate, () -> {
            if (!this.needsRefresh) {
                return;
            }
            long now = Time.millis();
            if (now - this.lastRefreshTime < 100L) {
                return;
            }
            this.lastRefreshTime = now;
            this.needsRefresh = false;
            for (Flowfield path : this.mainList) {
                if (path == null || !path.needsRefresh()) continue;
                IntSeq intSeq = path.targets;
                synchronized (intSeq) {
                    path.updateTargetPositions();
                }
            }
            this.queue.post(() -> {
                for (Flowfield data : this.threadList) {
                    data.dirty = true;
                }
            });
        });
    }

    private void clearCache() {
        this.cache = new Flowfield[256][8][10];
    }

    public int packTile(Tile tile) {
        Tile other;
        int i;
        boolean allDeep;
        boolean nearLiquid = false;
        boolean nearSolid = false;
        boolean nearLegSolid = false;
        boolean nearGround = false;
        boolean solid = tile.solid();
        boolean nearDeep = allDeep = tile.floor().isDeep();
        for (i = 0; i < 4; ++i) {
            other = tile.nearby(i);
            if (other == null) continue;
            Floor floor = other.floor();
            boolean osolid = other.solid();
            if (floor.isLiquid && floor.isDeep()) {
                nearLiquid = true;
            }
            if (osolid && !other.block().teamPassable) {
                nearSolid = true;
            }
            if (!floor.isLiquid) {
                nearGround = true;
            }
            if (!floor.isDeep()) {
                allDeep = false;
            } else {
                nearDeep = true;
            }
            if (other.legSolid()) {
                nearLegSolid = true;
            }
            if (!solid || tile.block().teamPassable || other.array() >= this.tiles.length) continue;
            int n = other.array();
            this.tiles[n] = this.tiles[n] | 0x200000;
        }
        if (allDeep) {
            for (i = 0; i < 4; ++i) {
                other = tile.nearby(Geometry.d8edge[i]);
                if (other == null || other.floor().isDeep()) continue;
                allDeep = false;
                break;
            }
        }
        int tid = tile.getTeamID();
        return PathTile.get(tile.build == null || !solid || tile.block() instanceof CoreBlock ? 0 : Math.min((int)(tile.build.health / 40.0f), 80), tid == 0 && tile.build != null && Vars.state.rules.coreCapture ? 255 : tid, solid, tile.floor().isLiquid, tile.legSolid(), nearLiquid, nearGround, nearSolid, nearLegSolid, tile.floor().isDeep(), tile.floor().damages(), allDeep, nearDeep, tile.block().teamPassable);
    }

    public int get(int x, int y) {
        return this.tiles[x + y * wwidth];
    }

    private void start() {
        this.stop();
        if (Vars.net.client()) {
            return;
        }
        this.thread = new Thread((Runnable)this, "Pathfinder");
        this.thread.setPriority(1);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        this.queue.clear();
        this.needsRefresh = false;
    }

    public void updateTile(Tile tile) {
        if (Vars.net.client()) {
            return;
        }
        tile.getLinkedTiles(t -> {
            int pos = t.array();
            if (pos < this.tiles.length) {
                this.tiles[pos] = this.packTile((Tile)t);
            }
        });
        Vars.controlPath.updateTile(tile);
        this.needsRefresh = true;
    }

    @Override
    public void run() {
        while (!Vars.net.client()) {
            try {
                if (Vars.state.isPlaying()) {
                    this.queue.run();
                    for (Flowfield data : this.threadList) {
                        if (data.dirty && data.frontier.size == 0) {
                            this.updateTargets(data);
                            data.dirty = false;
                        }
                        this.updateFrontier(data, maxUpdate);
                    }
                }
                try {
                    Thread.sleep(16L);
                    continue;
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        return;
    }

    public Flowfield getField(Team team, int costType, int fieldType) {
        if (this.cache[team.id][costType][fieldType] == null) {
            Flowfield field = fieldTypes.get(fieldType).get();
            field.team = team;
            field.cost = costTypes.get(costType);
            field.targets.clear();
            field.getPositions(field.targets);
            this.cache[team.id][costType][fieldType] = field;
            this.queue.post(() -> this.registerPath(field));
        }
        return this.cache[team.id][costType][fieldType];
    }

    @Nullable
    public Tile getTargetTile(Tile tile, Flowfield path) {
        return this.getTargetTile(tile, path, true);
    }

    @Nullable
    public Tile getTargetTile(Tile tile, Flowfield path, boolean diagonals) {
        return this.getTargetTile(tile, path, diagonals, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Tile getTargetTile(Tile tile, Flowfield path, boolean diagonals, int avoidanceId) {
        if (tile == null) {
            return null;
        }
        if (!path.initialized || path.targets.size == 0) {
            return tile;
        }
        if (path.refreshRate > 0 && path.refreshRate != Integer.MAX_VALUE && Time.timeSinceMillis(path.lastUpdateTime) > (long)path.refreshRate && path.frontier.size == 0) {
            path.lastUpdateTime = Time.millis();
            this.tmpArray.clear();
            path.getPositions(this.tmpArray);
            IntSeq intSeq = path.targets;
            synchronized (intSeq) {
                path.updateTargetPositions();
                this.queue.post(() -> this.updateTargets(path));
            }
        }
        int[] values = path.hasComplete ? path.completeWeights : path.weights;
        int res = path.resolution;
        int ww = path.width;
        int apos = tile.x / res + tile.y / res * ww;
        int value = values[apos];
        Point2[] points = diagonals ? Geometry.d8 : Geometry.d4;
        int[] avoid = avoidanceId <= 0 ? null : Vars.avoidance.getAvoidance();
        Tile current = null;
        int tl = 0;
        for (Point2 point : points) {
            int dx = tile.x + point.x * res;
            int dy = tile.y + point.y * res;
            Tile other = Vars.world.tile(dx, dy);
            if (other == null) continue;
            int packed = dx / res + dy / res * ww;
            int avoidance = avoid == null ? 0 : (avoid[packed] > Integer.MAX_VALUE - avoidanceId ? 1 : 0);
            int cost = values[packed] + avoidance;
            if (cost >= value || avoidance != 0 || current != null && cost >= tl || !path.passable(packed) || point.x != 0 && point.y != 0 && (!path.passable((tile.x + point.x) / res + tile.y / res * ww) || !path.passable(tile.x / res + (tile.y + point.y) / res * ww))) continue;
            current = other;
            tl = cost;
        }
        if (current == null || tl == -1 || path.cost == ((PathCost[])Pathfinder.costTypes.items)[0] && current.dangerous() && !tile.dangerous()) {
            return tile;
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTargets(Flowfield path) {
        ++path.search;
        if (path.search >= Short.MAX_VALUE) {
            Arrays.fill(path.searches, (short)0);
            path.search = 1;
        }
        IntSeq intSeq = path.targets;
        synchronized (intSeq) {
            for (int i = 0; i < path.targets.size; ++i) {
                int pos = path.targets.get(i);
                if (pos >= path.weights.length) continue;
                path.weights[pos] = 0;
                path.searches[pos] = (short)path.search;
                path.frontier.addFirst(pos);
            }
        }
    }

    private void preloadPath(Flowfield path) {
        path.updateTargetPositions();
        this.registerPath(path);
        this.updateFrontier(path, -1L);
    }

    private void registerPath(Flowfield path) {
        path.lastUpdateTime = Time.millis();
        path.setup();
        this.threadList.add(path);
        Core.app.post(() -> this.mainList.add(path));
        Arrays.fill(path.weights, -1);
        for (int i = 0; i < path.targets.size; ++i) {
            int pos = path.targets.get(i);
            path.weights[pos] = 0;
            path.frontier.addFirst(pos);
        }
    }

    private void updateFrontier(Flowfield path, long nsToRun) {
        boolean hadAny = path.frontier.size > 0;
        long start = Time.nanos();
        int counter = 0;
        int w = path.width;
        int h = path.height;
        while (path.frontier.size > 0) {
            int tile = path.frontier.removeLast();
            if (path.weights == null) {
                return;
            }
            int cost = path.weights[tile];
            if (path.frontier.size >= w * h) {
                path.frontier.clear();
                return;
            }
            if (cost != -1) {
                for (Point2 point : Geometry.d4) {
                    int otherCost;
                    int newPos;
                    int dx = tile % w + point.x;
                    int dy = tile / w + point.y;
                    if (dx < 0 || dy < 0 || dx >= w || dy >= h || path.weights[newPos = dx + dy * w] <= cost + (otherCost = path.getCost(this.tiles, newPos)) && path.searches[newPos] >= path.search || otherCost == -1) continue;
                    path.frontier.addFirst(newPos);
                    path.weights[newPos] = cost + otherCost;
                    path.searches[newPos] = (short)path.search;
                }
            }
            if (nsToRun < 0L || counter++ < 200) continue;
            counter = 0;
            if (Time.timeSinceNanos(start) < nsToRun) continue;
            return;
        }
        if (hadAny && path.frontier.size == 0) {
            System.arraycopy(path.weights, 0, path.completeWeights, 0, path.weights.length);
            path.hasComplete = true;
        }
    }

    static {
        fieldTypes = Seq.with(EnemyCoreField::new);
        costTypes = Seq.with((team, tile) -> PathTile.allDeep(tile) || (PathTile.team(tile) == team && !PathTile.teamPassable(tile) || PathTile.team(tile) == 0) && PathTile.solid(tile) ? -1 : 1 + PathTile.health(tile) * 5 + (PathTile.nearSolid(tile) ? 2 : 0) + (PathTile.nearLiquid(tile) ? 6 : 0) + (PathTile.deep(tile) ? 6000 : 0) + (PathTile.damages(tile) ? 30 : 0), (team, tile) -> PathTile.legSolid(tile) ? -1 : 1 + (PathTile.deep(tile) ? 6000 : 0) + (PathTile.solid(tile) ? 5 : 0), (team, tile) -> (!PathTile.liquid(tile) || PathTile.solid(tile) ? 6000 : 1) + PathTile.health(tile) * 5 + (PathTile.nearGround(tile) || PathTile.nearSolid(tile) ? 14 : 0) + (PathTile.deep(tile) ? 0 : 1) + (PathTile.damages(tile) ? 35 : 0), (team, tile) -> PathTile.deep(tile) || PathTile.team(tile) == 0 && PathTile.solid(tile) ? -1 : 1 + PathTile.health(tile) * 3 + (PathTile.nearSolid(tile) ? 2 : 0) + (PathTile.nearLiquid(tile) ? 2 : 0), (team, tile) -> 1, (team, tile) -> (PathTile.team(tile) == team && !PathTile.teamPassable(tile) || PathTile.team(tile) == 0) && PathTile.solid(tile) ? -1 : 1 + PathTile.health(tile) * 5 + (PathTile.nearSolid(tile) ? 2 : 0));
    }

    public static abstract class Flowfield {
        protected int refreshRate;
        protected Team team = Team.derelict;
        protected PathCost cost = costTypes.get(0);
        protected volatile boolean hasComplete;
        protected boolean dirty = false;
        public int[] weights;
        public short[] searches;
        public int[] completeWeights;
        public final int resolution;
        public final int width;
        public final int height;
        final IntQueue frontier = new IntQueue();
        final IntSeq targets = new IntSeq();
        int search = 1;
        long lastUpdateTime;
        boolean initialized;

        public Flowfield() {
            this(1);
        }

        public Flowfield(int resolution) {
            this.resolution = resolution;
            this.width = Mathf.ceil((float)wwidth / (float)resolution);
            this.height = Mathf.ceil((float)wheight / (float)resolution);
        }

        void setup() {
            int length = this.width * this.height;
            this.weights = new int[length];
            this.searches = new short[length];
            this.completeWeights = new int[length];
            this.frontier.ensureCapacity(length / 4);
            this.initialized = true;
        }

        public int getCost(int[] tiles, int pos) {
            return this.cost.getCost(this.team.id, tiles[pos]);
        }

        public boolean hasTargets() {
            return this.targets.size > 0;
        }

        @Nullable
        public Tile getNextTile(Tile from, boolean diagonals) {
            return Vars.pathfinder.getTargetTile(from, this, diagonals);
        }

        @Nullable
        public Tile getNextTile(Tile from) {
            return Vars.pathfinder.getTargetTile(from, this);
        }

        @Nullable
        public Tile getNextTile(Tile from, int unitAvoidanceId) {
            return Vars.pathfinder.getTargetTile(from, this, true, unitAvoidanceId);
        }

        public boolean hasCompleteWeights() {
            return this.hasComplete && this.completeWeights != null;
        }

        public void updateTargetPositions() {
            this.targets.clear();
            this.getPositions(this.targets);
        }

        public boolean needsRefresh() {
            return this.refreshRate == 0;
        }

        protected boolean passable(int pos) {
            int amount = this.cost.getCost(this.team.id, Vars.pathfinder.tiles[pos]);
            return amount != -1 && (this.cost != costTypes.get(2) || amount < 6000);
        }

        protected abstract void getPositions(IntSeq var1);
    }

    public static interface PathCost {
        public int getCost(int var1, int var2);
    }

    class PathTileStruct {
        int health;
        int team;
        boolean solid;
        boolean liquid;
        boolean legSolid;
        boolean nearLiquid;
        boolean nearGround;
        boolean nearSolid;
        boolean nearLegSolid;
        boolean deep;
        boolean damages;
        boolean allDeep;
        boolean nearDeep;
        boolean teamPassable;

        PathTileStruct() {
        }
    }

    public static class PositionTarget
    extends Flowfield {
        public final Position position;

        public PositionTarget(Position position) {
            this.position = position;
            this.refreshRate = 900;
        }

        @Override
        public void getPositions(IntSeq out) {
            out.add(Vars.world.packArray(World.toTile(this.position.getX()), World.toTile(this.position.getY())));
        }
    }

    public static class EnemyCoreField
    extends Flowfield {
        private static final BlockFlag[] randomTargets = new BlockFlag[]{BlockFlag.storage, BlockFlag.generator, BlockFlag.launchPad, BlockFlag.factory, BlockFlag.repair, BlockFlag.battery, BlockFlag.reactor, BlockFlag.drill};
        private Rand rand = new Rand();

        @Override
        protected void getPositions(IntSeq out) {
            if (Vars.state.rules.randomWaveAI && this.team == Vars.state.rules.waveTeam) {
                this.rand.setSeed(Vars.state.rules.waves ? (long)Vars.state.wave : (long)((int)(Vars.state.tick / 5400.0) + this.hashCode()));
                int max = 1;
                for (int attempt = 0; attempt < 5 && max > 0; ++attempt) {
                    Seq<Building> targets = Vars.indexer.getEnemy(this.team, randomTargets[this.rand.random(randomTargets.length - 1)]);
                    if (targets.isEmpty()) continue;
                    boolean any = false;
                    for (Building other : targets) {
                        if ((other.items == null || !other.items.any()) && other.status() == BlockStatus.noInput || !other.block.targetable) continue;
                        out.add(other.tile.array());
                        any = true;
                    }
                    if (!any) continue;
                    --max;
                }
            }
            for (Building other : Vars.indexer.getEnemy(this.team, BlockFlag.core)) {
                out.add(other.tile.array());
            }
            if (Vars.state.rules.waves && this.team == Vars.state.rules.defaultTeam) {
                for (Tile other : Vars.spawner.getSpawns()) {
                    out.add(other.array());
                }
            }
        }
    }
}

