/*
 * Decompiled with CFR 0.152.
 */
package arc.math.geom;

import arc.math.geom.Vec3;

public class Plane {
    public final Vec3 normal = new Vec3();
    public float d = 0.0f;

    public Plane() {
    }

    public Plane(Vec3 normal, float d) {
        this.normal.set(normal).nor();
        this.d = d;
    }

    public Plane(Vec3 normal, Vec3 point) {
        this.normal.set(normal).nor();
        this.d = -this.normal.dot(point);
    }

    public Plane(Vec3 point1, Vec3 point2, Vec3 point3) {
        this.set(point1, point2, point3);
    }

    public void set(Vec3 point1, Vec3 point2, Vec3 point3) {
        this.normal.set(point1).sub(point2).crs(point2.x - point3.x, point2.y - point3.y, point2.z - point3.z).nor();
        this.d = -point1.dot(this.normal);
    }

    public void set(float nx, float ny, float nz, float d) {
        this.normal.set(nx, ny, nz);
        this.d = d;
    }

    public Vec3 project(Vec3 v) {
        float npd = this.normal.dot(v) + this.d;
        return v.sub(npd * this.normal.x, npd * this.normal.y, npd * this.normal.z);
    }

    public float distance(Vec3 point) {
        return this.normal.dot(point) + this.d;
    }

    public PlaneSide testPoint(Vec3 point) {
        float dist = this.normal.dot(point) + this.d;
        if (dist == 0.0f) {
            return PlaneSide.onPlane;
        }
        if (dist < 0.0f) {
            return PlaneSide.back;
        }
        return PlaneSide.front;
    }

    public PlaneSide testPoint(float x, float y, float z) {
        float dist = this.normal.dot(x, y, z) + this.d;
        if (dist == 0.0f) {
            return PlaneSide.onPlane;
        }
        if (dist < 0.0f) {
            return PlaneSide.back;
        }
        return PlaneSide.front;
    }

    public boolean isFrontFacing(Vec3 direction) {
        float dot = this.normal.dot(direction);
        return dot <= 0.0f;
    }

    public Vec3 getNormal() {
        return this.normal;
    }

    public float getD() {
        return this.d;
    }

    public void set(Vec3 point, Vec3 normal) {
        this.normal.set(normal);
        this.d = -point.dot(normal);
    }

    public void set(float pointX, float pointY, float pointZ, float norX, float norY, float norZ) {
        this.normal.set(norX, norY, norZ);
        this.d = -(pointX * norX + pointY * norY + pointZ * norZ);
    }

    public void set(Plane plane) {
        this.normal.set(plane.normal);
        this.d = plane.d;
    }

    public String toString() {
        return this.normal.toString() + ", " + this.d;
    }

    public static enum PlaneSide {
        onPlane,
        back,
        front;

    }
}

