/*
 * Decompiled with CFR 0.152.
 */
package arc.flabel.effects;

import arc.flabel.FEffect;
import arc.flabel.FGlyph;
import arc.flabel.FLabel;
import arc.graphics.Color;
import arc.math.Mathf;
import arc.struct.IntFloatMap;

public class FadeEffect
extends FEffect {
    private Color color1 = null;
    private Color color2 = null;
    public float alpha1 = 0.0f;
    public float alpha2 = 1.0f;
    public float fadeDuration = 1.0f;
    private IntFloatMap timePassedByGlyphIndex = new IntFloatMap();

    @Override
    protected void onApply(FLabel label, FGlyph glyph, int localIndex, float delta) {
        float timePassed = this.timePassedByGlyphIndex.increment(localIndex, 0.0f, delta);
        float progress = timePassed / this.fadeDuration;
        if (progress < 0.0f || progress > 1.0f) {
            return;
        }
        if (glyph.color == null) {
            glyph.color = new Color(glyph.run.color);
        }
        if (this.color1 == null) {
            glyph.color.a = Mathf.lerp(glyph.color.a, this.alpha1, 1.0f - progress);
        } else {
            glyph.color.lerp(this.color1, 1.0f - progress);
        }
        if (this.color2 == null) {
            glyph.color.a = Mathf.lerp(glyph.color.a, this.alpha2, progress);
        } else {
            glyph.color.lerp(this.color2, progress);
        }
    }
}

