/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.loader;

import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Reflect;
import arc.util.io.Streams;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import mindustry.game.EventType;
import mindustryX.loader.LoaderPlatform;
import mindustryX.loader.Main;

public class DesktopImpl
implements LoaderPlatform {
    @Override
    public void withSafeClassloader(String method) {
        URL file = ((URLClassLoader)Main.class.getClassLoader()).getURLs()[0];
        ClassLoader parent = Core.class.getClassLoader();
        try {
            URLClassLoader classLoader = new URLClassLoader(new URL[]{file}, parent);
            Reflect.invoke(classLoader.loadClass(Main.class.getName()), (String)method);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void beforeLaunch() {
        Seq listeners = (Seq)((ObjectMap)Reflect.get(Events.class, (String)"events")).get(EventType.DisposeEvent.class);
        if (listeners != null) {
            listeners.clear();
        }
        for (ApplicationListener l : Core.app.getListeners()) {
            l.pause();
            try {
                l.dispose();
            }
            catch (Throwable e) {
                Log.err((String)"Cleanup", (Throwable)e);
            }
        }
        Core.app.dispose();
        System.setProperty("MDTX-SDL-width", "" + Core.graphics.getWidth());
        System.setProperty("MDTX-SDL-height", "" + Core.graphics.getHeight());
        System.setProperty("MDTX-SDL-window", Reflect.get((Object)Core.app, (String)"window").toString());
        System.setProperty("MDTX-SDL-context", Reflect.get((Object)Core.app, (String)"context").toString());
    }

    @Override
    public ClassLoader createClassloader() {
        URL file = ((URLClassLoader)Main.class.getClassLoader()).getURLs()[0];
        final ClassLoader parent = Core.class.getClassLoader();
        return new URLClassLoader(new URL[]{file}, parent){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                Object object = this.getClassLoadingLock(name);
                synchronized (object) {
                    Class<?> loadedClass = this.findLoadedClass(name);
                    if (loadedClass == null) {
                        try {
                            loadedClass = this.findClass(name);
                        }
                        catch (ClassNotFoundException e) {
                            return parent.loadClass(name);
                        }
                    }
                    if (resolve) {
                        this.resolveClass(loadedClass);
                    }
                    return loadedClass;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                try {
                    return super.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    InputStream res;
                    if (this.overwrite(name).booleanValue() && (res = parent.getResourceAsStream(name.replace('.', '/').concat(".class"))) != null) {
                        try {
                            byte[] bs = Streams.copyBytes((InputStream)res);
                            Class<?> clazz = this.defineClass(name, bs, 0, bs.length);
                            return clazz;
                        }
                        catch (IOException | ClassFormatError e2) {
                            e.addSuppressed(e2);
                        }
                        finally {
                            Streams.close((Closeable)res);
                        }
                    }
                    throw e;
                }
            }

            private Boolean overwrite(String name) {
                if (name.startsWith("arc.backend.sdl.jni")) {
                    return false;
                }
                return name.startsWith("mindustry") || name.startsWith("arc");
            }

            @Override
            public URL getResource(String name) {
                if (name.equals("version.properties")) {
                    return parent.getResource(name);
                }
                URL url = this.findResource(name);
                if (url == null) {
                    url = parent.getResource(name);
                }
                return url;
            }

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                return new LoaderPlatform.CompoundURLEnumeration(this.findResources(name), parent.getResources(name));
            }
        };
    }

    @Override
    public void launch(ClassLoader loader) throws Exception {
        Reflect.invoke(loader.loadClass("mindustry.desktop.DesktopLauncher"), (String)"main", (Object[])new Object[]{new String[0]}, (Class[])new Class[]{String[].class});
        System.exit(0);
    }
}

