/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.loader;

import android.app.Activity;
import android.os.Build;
import android.view.View;
import arc.ApplicationListener;
import arc.Core;
import arc.Files;
import arc.backend.android.AndroidApplicationConfiguration;
import arc.backend.android.AndroidInput;
import arc.files.Fi;
import arc.func.Cons;
import arc.util.Log;
import arc.util.Reflect;
import dalvik.system.BaseDexClassLoader;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import mindustry.ClientLauncher;
import mindustry.Vars;
import mindustry.android.AndroidLauncher;
import mindustry.android.AndroidRhinoContext;
import mindustryX.loader.LoaderPlatform;
import mindustryX.loader.Main;
import rhino.Context;

public class AndroidImpl
implements LoaderPlatform {
    private AndroidLauncher app = (AndroidLauncher)Core.app;

    private Object[] getDexElements(ClassLoader classLoader) {
        Object pathList = Reflect.get(BaseDexClassLoader.class, (Object)classLoader, (String)"pathList");
        return (Object[])Reflect.get((Object)pathList, (String)"dexElements");
    }

    private File findFirstJar() {
        return (File)Reflect.get((Object)this.getDexElements(Main.class.getClassLoader())[0], (String)"path");
    }

    @Override
    public void withSafeClassloader(String method) {
        try {
            DexClassLoader classLoader = new DexClassLoader(this.findFirstJar().getPath(), this.app.getFilesDir().getPath(), null, Core.class.getClassLoader());
            Reflect.invoke(classLoader.loadClass(Main.class.getName()), (String)method);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ClassLoader createClassloader() {
        final ClassLoader parent = Core.class.getClassLoader();
        File apk = (File)Reflect.get((Object)this.getDexElements(parent)[0], (String)"path");
        assert (parent != null);
        DexClassLoader classLoader = new DexClassLoader(this.findFirstJar().getPath() + File.pathSeparator + apk.getPath(), this.app.getFilesDir().getPath(), null, parent){

            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (!this.overwrite(name).booleanValue()) {
                    return super.loadClass(name, resolve);
                }
                Class loadedClass = this.findLoadedClass(name);
                if (loadedClass == null) {
                    try {
                        loadedClass = this.findClass(name);
                    }
                    catch (ClassNotFoundException e) {
                        return parent.loadClass(name);
                    }
                }
                return loadedClass;
            }

            private Boolean overwrite(String name) {
                if (name.startsWith("arc.func")) {
                    return false;
                }
                return name.startsWith("mindustry") || name.startsWith("arc.") || name.startsWith("rhino.");
            }

            public String findLibrary(String name) {
                String file = super.findLibrary(name);
                if (file != null) {
                    Fi newFile = new Fi(AndroidImpl.this.app.getFilesDir()).child(name + ".so");
                    new Fi(file).copyTo(newFile);
                    file = newFile.path();
                }
                return file;
            }

            public URL getResource(String name) {
                if (name.equals("version.properties")) {
                    return parent.getResource(name);
                }
                URL url = this.findResource(name);
                if (url == null) {
                    url = parent.getResource(name);
                }
                return url;
            }

            public Enumeration<URL> getResources(String name) throws IOException {
                return new LoaderPlatform.CompoundURLEnumeration(this.findResources(name), parent.getResources(name));
            }
        };
        Object pathList = Reflect.get(BaseDexClassLoader.class, (Object)classLoader, (String)"pathList");
        Object parentPathList = Reflect.get(BaseDexClassLoader.class, (Object)parent, (String)"pathList");
        Reflect.set((Object)pathList, (String)"nativeLibraryDirectories", (Object)Reflect.get((Object)parentPathList, (String)"nativeLibraryDirectories"));
        Reflect.set((Object)pathList, (String)"nativeLibraryPathElements", (Object)Reflect.get((Object)parentPathList, (String)"nativeLibraryPathElements"));
        return classLoader;
    }

    private static Object[] makeDexElements(Object dexPathList, ArrayList<File> files, File optimizedDirectory) {
        if (Build.VERSION.SDK_INT >= 23) {
            ArrayList suppressedExceptions = new ArrayList();
            return (Object[])Reflect.invoke(dexPathList.getClass(), (String)"makePathElements", (Object[])new Object[]{files, optimizedDirectory, suppressedExceptions}, (Class[])new Class[]{List.class, File.class, List.class});
        }
        return (Object[])Reflect.invoke(dexPathList.getClass(), (String)"makeDexElements", (Object[])new Object[]{files, optimizedDirectory}, (Class[])new Class[]{ArrayList.class, File.class});
    }

    @Override
    public void launch(ClassLoader loader) throws Exception {
        Class<?> cls = loader.loadClass(AndroidImpl.class.getName());
        this.app.handler.post(() -> {
            ((AndroidInput)Core.input).onPause();
            Core.graphics.dispose();
            Core.audio.dispose();
            this.app.setContentView((View)Reflect.invoke((Class)cls, (String)"bootStrapAsView", (Object[])new Object[]{this.app, this.app.getListeners().get(0)}, (Class[])new Class[]{Activity.class, Object.class}));
        });
    }

    public static View bootStrapAsView(final Activity activity, final Object platform) {
        AndroidLauncher newApp = new AndroidLauncher();
        AndroidImpl.copyFields(activity, newApp);
        AndroidApplicationConfiguration config = new AndroidApplicationConfiguration();
        config.useImmersiveMode = true;
        config.hideStatusBar = true;
        View view = newApp.initializeForView((ApplicationListener)new ClientLauncher(){

            public void hide() {
                activity.moveTaskToBack(true);
            }

            public Context getScriptContext() {
                return AndroidRhinoContext.enter((File)activity.getCacheDir());
            }

            public void shareFile(Fi file) {
            }

            public ClassLoader loadJar(Fi jar, final ClassLoader parent) throws Exception {
                return new DexClassLoader(jar.file().getPath(), activity.getFilesDir().getPath(), null, parent){

                    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                        Class loadedClass = this.findLoadedClass(name);
                        if (loadedClass == null) {
                            try {
                                loadedClass = this.findClass(name);
                            }
                            catch (ClassNotFoundException | NoClassDefFoundError e) {
                                return parent.loadClass(name);
                            }
                        }
                        if (resolve) {
                            this.resolveClass(loadedClass);
                        }
                        return loadedClass;
                    }
                };
            }

            public void showFileChooser(boolean open, String title, String extension, Cons<Fi> cons) {
                this.showFileChooser(open, title, cons, extension);
            }

            public void showMultiFileChooser(Cons<Fi> cons, String ... extensions) {
                this.showFileChooser(true, "@open", cons, extensions);
            }

            void showFileChooser(boolean open, String title, Cons<Fi> cons, String ... extensions) {
                Cons consProxy = fi -> {
                    Class<?> cls = fi.getClass();
                    if (cls.isAnonymousClass()) {
                        cons.get((Object)new Fi((File)Reflect.get((Object)fi, (String)"file")){

                            public InputStream read() {
                                return (InputStream)Reflect.invoke((Object)fi, (String)"read");
                            }

                            public OutputStream write(boolean append) {
                                return (OutputStream)Reflect.invoke((Object)fi, (String)"write", (Object[])new Object[]{append}, (Class[])new Class[]{Boolean.TYPE});
                            }
                        });
                    } else if (cls.getSimpleName().equals("Fi")) {
                        cons.get((Object)new Fi((File)Reflect.get((Object)fi, (String)"file")));
                    } else {
                        Vars.ui.showErrorMessage("Not Implement showFileChooser");
                    }
                };
                try {
                    Method m = platform.getClass().getDeclaredMethod("showFileChooser", Boolean.TYPE, String.class, Cons.class, String[].class);
                    m.setAccessible(true);
                    m.invoke(platform, open, title, consProxy, extensions);
                }
                catch (Exception e) {
                    Log.err((Throwable)e);
                }
            }

            public void beginForceLandscape() {
                activity.setRequestedOrientation(6);
            }

            public void endForceLandscape() {
                activity.setRequestedOrientation(2);
            }
        }, config);
        ClassLoader loader = Main.class.getClassLoader();
        assert (loader != null);
        Files origin = Core.files;
        Core.files = (Files)Proxy.newProxyInstance(Main.class.getClassLoader(), new Class[]{Files.class}, (proxy, method, args) -> {
            String path;
            if ((method.getName().equals("internal") || method.getName().equals("get") && args[1] == Files.FileType.internal) && loader.getResource(path = (String)args[0]) != null) {
                return origin.classpath(path);
            }
            return method.invoke((Object)origin, args);
        });
        try {
            Fi data = Core.files.absolute(newApp.getExternalFilesDir(null).getAbsolutePath());
            Core.settings.setDataDirectory(data);
        }
        catch (Exception e) {
            Log.err((Throwable)e);
        }
        return view;
    }

    private static void copyFields(Object a, Object b) {
        Class<?> ca = a.getClass();
        Class<?> cb = b.getClass();
        while (ca != Object.class) {
            if (ca == cb) {
                for (Field f : ca.getDeclaredFields()) {
                    f.setAccessible(true);
                    Reflect.set((Object)b, (Field)f, (Object)Reflect.get((Object)a, (Field)f));
                }
            }
            ca = ca.getSuperclass();
            cb = cb.getSuperclass();
        }
    }
}

