/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features.ui.toolTable.ai;

import arc.math.geom.Position;
import arc.struct.Seq;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.entities.units.AIController;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Player;
import mindustry.type.Item;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;

public class ArcMinerAI
extends AIController {
    public static final Seq<Item> toMine = Vars.content.items().copy();
    public boolean mining = true;
    public Item targetItem;
    public Tile ore;

    private Item updateTargetItem(boolean canMineNonBuildable) {
        return (Item)((Object)toMine.select(i -> this.unit.canMine((Item)((Object)i)) && (this.unit.type.mineFloor ? Vars.indexer.hasOre((Item)((Object)i)) : Vars.indexer.hasWallOre((Item)((Object)i))) && (canMineNonBuildable || i.buildable) && this.unit.core().acceptItem(null, (Item)((Object)i))).reverse().min(i -> this.unit.core().items.get(i)));
    }

    private Tile findClosetOre(Building build) {
        if (this.unit.type.mineFloor) {
            return Vars.indexer.findClosestOre(build.x, build.y, this.targetItem);
        }
        return Vars.indexer.findClosestWallOre(build.x, build.y, this.targetItem);
    }

    public void updateMovement() {
        CoreBlock.CoreBuild targetCore;
        if (!this.unit.canMine() || this.unit.core() == null) {
            return;
        }
        CoreBlock.CoreBuild core = this.unit.closestCore();
        CoreBlock.CoreBuild core2 = (CoreBlock.CoreBuild)this.unit.team.data().cores.select(c -> !((CoreBlock)((Object)((Object)((Object)c.block)))).incinerateNonBuildable).min(c -> this.unit.dst((Position)c));
        CoreBlock.CoreBuild coreBuild = targetCore = this.targetItem == null || this.targetItem.buildable || core2 == null ? core : core2;
        if (this.unit.type.canBoost) {
            Vars.player.boosting = true;
        }
        if (this.mining) {
            if (this.targetItem != null && (!core.acceptItem(null, this.targetItem) || core2 == null && !this.targetItem.buildable)) {
                this.unit.mineTile = null;
                this.targetItem = null;
            }
            if (this.targetItem == null || this.timer.get(1, 300.0f)) {
                this.targetItem = this.updateTargetItem(core2 != null);
                if (this.targetItem == null) {
                    return;
                }
            }
            if (!this.unit.acceptsItem(this.targetItem) || this.unit.stack.amount >= this.unit.type.itemCapacity) {
                this.mining = false;
                return;
            }
            if (this.ore == null || !this.unit.validMine(this.ore, false) || this.ore.drop() != this.targetItem || this.timer.get(2, 120.0f)) {
                this.ore = this.findClosetOre(targetCore);
                if (this.ore == null) {
                    return;
                }
            }
            Tmp.v1.setLength(this.unit.type.mineRange * 0.9f).limit(this.ore.dst((Position)targetCore) - 0.5f).setAngle(this.ore.angleTo((Position)targetCore)).add((Position)this.ore);
            this.moveTo((Position)Tmp.v1, 0.1f);
            if (this.unit.validMine(this.ore)) {
                this.unit.mineTile = this.ore;
            }
        } else {
            this.unit.mineTile = null;
            if (this.unit.stack.amount == 0) {
                this.mining = true;
                return;
            }
            if (!core.acceptItem(null, this.unit.stack.item)) {
                this.unit.clearItem();
            }
            this.moveTo((Position)targetCore, core.hitSize());
            if (this.unit.within((Position)targetCore, 220.0f) && targetCore.acceptItem(null, this.targetItem)) {
                Call.transferInventory((Player)Vars.player, (Building)core);
                this.targetItem = this.updateTargetItem(core2 != null);
            }
        }
    }

    public void updateVisuals() {
    }
}

