/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features.ui.toolTable;

import arc.Core;
import arc.Events;
import arc.graphics.g2d.TextureRegion;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.ImageButton;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import mindustry.Vars;
import mindustry.ai.types.BuilderAI;
import mindustry.ai.types.DefenderAI;
import mindustry.ai.types.RepairAI;
import mindustry.content.Blocks;
import mindustry.content.Items;
import mindustry.content.UnitTypes;
import mindustry.entities.units.AIController;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Icon;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustryX.features.AutoFill;
import mindustryX.features.SettingsV2;
import mindustryX.features.UIExt;
import mindustryX.features.ui.toolTable.ai.ArcMinerAI;

public class AuxiliaryTools
extends Table {
    private AIController selectAI;

    public AuxiliaryTools() {
        this.background(Styles.black6);
        this.rebuild();
        Events.run((Object)EventType.Trigger.update, () -> {
            if (this.selectAI != null && !Vars.player.dead()) {
                AIController patt817$temp = this.selectAI;
                if (patt817$temp instanceof BuilderAI) {
                    BuilderAI builder = (BuilderAI)patt817$temp;
                    builder.rebuildPeriod = 10.0f;
                }
                this.selectAI.unit(Vars.player.unit());
                this.selectAI.updateUnit();
                Vars.player.boosting = Vars.player.unit().isShooting;
            }
        });
    }

    protected void rebuild() {
        this.defaults().size(40.0f);
        this.aiButton(new ArcMinerAI(), UnitTypes.mono.region, "\u77ff\u673aAI");
        this.aiButton((AIController)new BuilderAI(), UnitTypes.poly.region, "\u91cd\u5efaAI");
        this.aiButton((AIController)new RepairAI(), UnitTypes.mega.region, "\u4fee\u590dAI");
        this.aiButton((AIController)new DefenderAI(), UnitTypes.oct.region, "\u4fdd\u62a4AI");
        this.button((Drawable)Icon.settingsSmall, Styles.clearNonei, 32.0f, this::showAiSettingDialog);
        this.row();
        this.button((Drawable)new TextureRegionDrawable(Blocks.buildTower.uiIcon), Styles.clearNonei, 32.0f, () -> {
            if (!Vars.player.isBuilder()) {
                return;
            }
            int count = 0;
            for (Teams.BlockPlan plan : Vars.player.team().data().plans) {
                if (!Vars.player.within(plan.x * 8, plan.y * 8, 220.0f)) continue;
                Vars.player.unit().addBuild(new BuildPlan((int)plan.x, (int)plan.y, (int)plan.rotation, plan.block, plan.config));
                if (++count < 255) continue;
                break;
            }
        }).tooltip("\u5728\u5efa\u9020\u5217\u8868\u52a0\u5165\u88ab\u6467\u6bc1\u5efa\u7b51");
        ImageButton t = (ImageButton)this.button((Drawable)new TextureRegionDrawable(Items.copper.uiIcon), Styles.clearNoneTogglei, () -> AutoFill.enable ^= true).tooltip("\u4e00\u952e\u88c5\u586b").checked(b -> AutoFill.enable).get();
        SettingsV2.bindQuickSettings((Button)t, AutoFill.INSTANCE.getSettings());
        this.toggleButton((Drawable)Icon.modeAttack, "autotarget", "\u81ea\u52a8\u653b\u51fb");
        this.toggleButton((Drawable)new TextureRegionDrawable(UnitTypes.vela.uiIcon), "forceBoost", "\u5f3a\u5236\u52a9\u63a8");
        this.toggleButton((Drawable)Icon.eyeSmall, "detach-camera", "\u89c6\u89d2\u8131\u79bb\u73a9\u5bb6");
        if (!Vars.mobile) {
            return;
        }
        this.row();
        this.toggleButton((Drawable)Icon.unitsSmall, "\u6307\u6325\u6a21\u5f0f", () -> {
            Vars.control.input.commandMode = !Vars.control.input.commandMode;
        }).checked(b -> Vars.control.input.commandMode);
        this.toggleButton((Drawable)Icon.pause, "\u6682\u505c\u5efa\u9020", () -> {
            Vars.control.input.isBuilding = !Vars.control.input.isBuilding;
        }).checked(b -> Vars.control.input.isBuilding);
        this.scriptButton((Drawable)Icon.up, "\u6361\u8d77\u8f7d\u8377", () -> Vars.control.input.tryPickupPayload());
        this.scriptButton((Drawable)Icon.down, "\u4e22\u4e0b\u8f7d\u8377", () -> Vars.control.input.tryDropPayload());
        this.scriptButton((Drawable)new TextureRegionDrawable(Blocks.payloadConveyor.uiIcon), "\u8fdb\u5165\u4f20\u9001\u5e26", () -> {
            Building build = Vars.player.buildOn();
            if (build == null || Vars.player.dead()) {
                return;
            }
            Call.unitBuildingControlSelect((Unit)Vars.player.unit(), (Building)build);
        });
    }

    private void aiButton(AIController ai, TextureRegion textureRegion, String describe) {
        this.button((Drawable)new TextureRegionDrawable(textureRegion), Styles.clearNoneTogglei, 32.0f, () -> {
            this.selectAI = this.selectAI == ai ? null : ai;
        }).checked(b -> this.selectAI == ai).tooltip(describe);
    }

    protected void toggleButton(Drawable icon, String settingName, String description) {
        this.button(icon, Styles.clearNoneTogglei, 32.0f, () -> {
            boolean setting = Core.settings.getBool(settingName);
            Core.settings.put(settingName, (Object)(!setting ? 1 : 0));
            UIExt.announce("\u5df2" + (setting ? "\u53d6\u6d88" : "\u5f00\u542f") + description);
        }).tooltip(description, true).checked(b -> Core.settings.getBool(settingName));
    }

    protected Cell<ImageButton> toggleButton(Drawable icon, String description, Runnable runnable) {
        return this.button(icon, Styles.clearNonei, 32.0f, runnable).tooltip(description, true);
    }

    protected void scriptButton(Drawable icon, String description, Runnable runnable) {
        this.button(icon, Styles.clearNonei, 32.0f, runnable).tooltip(description, true);
    }

    private void showAiSettingDialog() {
        int cols = (int)Math.max((float)Core.graphics.getWidth() / Scl.scl((float)480.0f), 1.0f);
        BaseDialog dialog = new BaseDialog("ARC-AI\u8bbe\u5b9a\u5668");
        dialog.cont.table(t -> {
            t.add((CharSequence)"minerAI-\u77ff\u7269\u7b5b\u9009\u5668").color(Pal.accent).pad((float)cols / 2.0f).center().row();
            t.image().color(Pal.accent).fillX().row();
            t.table(list -> {
                int i = 0;
                for (Item item : Vars.content.items()) {
                    if (!Vars.indexer.hasOre(item) && !Vars.indexer.hasWallOre(item)) continue;
                    if (i++ % 3 == 0) {
                        list.row();
                    }
                    list.button(item.emoji() + "\n" + Vars.indexer.allOres.get((Object)item) + "/" + Vars.indexer.allWallOres.get((Object)item), Styles.flatToggleMenut, () -> {
                        if (ArcMinerAI.toMine.contains((Object)item)) {
                            ArcMinerAI.toMine.remove((Object)item);
                        } else if (!ArcMinerAI.toMine.contains((Object)item)) {
                            ArcMinerAI.toMine.add((Object)item);
                        }
                    }).tooltip(item.localizedName).checked(k -> ArcMinerAI.toMine.contains((Object)item)).width(100.0f).height(50.0f);
                }
            }).growX();
        }).growX().row();
        dialog.addCloseButton();
        dialog.show();
    }
}

