/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features.ui.toolTable;

import arc.Events;
import arc.func.Cons;
import arc.func.Floatf;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectFloatMap;
import arc.struct.Queue;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Strings;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Liquids;
import mindustry.content.UnitTypes;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.logic.LogicBlock;
import mindustry.world.blocks.power.ThermalGenerator;
import mindustry.world.blocks.production.Drill;
import mindustry.world.blocks.storage.CoreBlock;
import mindustryX.features.UIExt;
import mindustryX.features.func.FuncX;

public class AdvanceBuildTool
extends Table {
    BuildRange placement = BuildRange.player;
    Rect selection = new Rect();
    Block find = Blocks.worldProcessor;
    public Seq<Building> buildingSeq = new Seq();
    private final BuildTiles buildTiles = new BuildTiles();
    private int searchIndex = 0;

    public AdvanceBuildTool() {
        this.background(Styles.black6);
        Events.on(EventType.WorldLoadEvent.class, e -> this.rebuild());
        Events.run((Object)EventType.Trigger.draw, () -> {
            if (this.placement == BuildRange.zone) {
                Draw.z((float)119.0f);
                Draw.color((Color)Pal.stat, (float)0.7f);
                Lines.stroke(Math.min(Math.abs(this.width), Math.abs(this.height)) / 8.0f / 10.0f);
                Lines.rect(this.selection.x * 8.0f - 4.0f, this.selection.y * 8.0f - 4.0f, this.selection.width * 8.0f + 8.0f, this.selection.height * 8.0f + 8.0f);
                Draw.color();
                FuncX.drawText((Position)this.selection.getCenter(Tmp.v1).scl(8.0f), "\u5efa\u9020\u533a\u57df", Scl.scl((float)1.25f), Color.white);
            }
            if (this.placement == BuildRange.find && this.find != null) {
                Draw.z((float)41.0f);
                Draw.color((Color)Pal.negativeStat);
                for (Building it : this.buildingSeq) {
                    Lines.stroke(it.block.size);
                    it.hitbox(Tmp.r1);
                    Lines.rect(Tmp.r1);
                }
                Draw.color();
            }
        });
    }

    protected void rebuild() {
        this.clear();
        this.center();
        Block target = Vars.control.input.block;
        this.update(() -> {
            if (Vars.control.input.selectedBlock() && target != Vars.control.input.block) {
                this.rebuild();
            }
        });
        this.add().height(40.0f);
        this.button("\ue827", Styles.clearTogglet, () -> {
            this.placement = BuildRange.global;
        }).checked(b -> this.placement == BuildRange.global).tooltip("\u5168\u5c40\u68c0\u67e5").size(30.0f);
        this.button("\ue818", Styles.clearTogglet, () -> {
            this.selection = Vars.control.input.lastSelection;
            if (this.selection.area() < 10.0f) {
                UIExt.announce("\u5f53\u524d\u9009\u5b9a\u533a\u57df\u4e3a\u7a7a\uff0c\u8bf7\u901a\u8fc7F\u89c4\u5212\u533a\u57df");
                return;
            }
            this.placement = BuildRange.zone;
        }).checked(b -> this.placement == BuildRange.zone).tooltip("\u9009\u62e9\u8303\u56f4").size(30.0f);
        this.button(Blocks.coreShard.emoji(), Styles.clearTogglet, () -> {
            this.placement = BuildRange.team;
            this.rebuild();
        }).checked(b -> this.placement == BuildRange.team).tooltip("\u961f\u4f0d\u533a\u57df").size(30.0f);
        this.button(UnitTypes.gamma.emoji(), Styles.clearTogglet, () -> {
            this.placement = BuildRange.player;
        }).checked(b -> this.placement == BuildRange.player).tooltip("\u73a9\u5bb6\u5efa\u9020\u533a").size(30.0f);
        TextButton findButton = (TextButton)this.add((Element)new TextButton("", Styles.clearTogglet)).update(b -> {
            this.buildingSeq.clear();
            if (this.find.privileged) {
                for (Team team : Team.all) {
                    this.buildingSeq.add(team.data().getBuildings(this.find));
                }
            } else {
                this.buildingSeq.add(Vars.player.team().data().getBuildings(this.find));
            }
            b.setText(this.find.emoji() + " " + this.buildingSeq.size);
            b.setChecked(this.placement == BuildRange.find);
        }).height(30.0f).tooltip("\u67e5\u627e\u65b9\u5757").wrapLabel(false).get();
        findButton.clicked(() -> {
            if (findButton.childrenPressed()) {
                return;
            }
            if (this.placement != BuildRange.find) {
                this.placement = BuildRange.find;
                if (this.find == Blocks.worldProcessor) {
                    AdvanceBuildTool.showWorldProcessorInfo();
                }
            } else {
                if (this.buildingSeq.isEmpty()) {
                    return;
                }
                this.searchIndex %= this.buildingSeq.size;
                Vars.control.input.panCamera(Tmp.v1.set((Position)this.buildingSeq.get(this.searchIndex)));
                ++this.searchIndex;
                UIExt.announce(Strings.format((String)"@[grey]/[]@ @@", (Object[])new Object[]{this.searchIndex, this.buildingSeq.size, this.find.emoji(), this.find.localizedName}));
            }
        });
        findButton.getLabelCell().padLeft(2.0f);
        findButton.button((Drawable)Icon.settingsSmall, Styles.clearTogglei, 24.0f, () -> {
            if (target == null) {
                UIExt.announce("[yellow]\u5f53\u524d\u9009\u4e2d\u7269\u54c1\u4e3a\u7a7a\uff0c\u8bf7\u5728\u7269\u54c1\u680f\u9009\u4e2d\u5efa\u7b51");
                return;
            }
            this.find = target;
            this.searchIndex = 0;
            this.placement = BuildRange.find;
            this.rebuild();
        }).tooltip("\u8bbe\u7f6e\u76ee\u6807").padRight(2.0f);
        this.add().width(16.0f);
        this.button("P", Styles.cleart, () -> {
            if (target == null || Vars.player.dead()) {
                return;
            }
            if (this.placement == BuildRange.find) {
                this.replaceBlock(this.find, target);
                return;
            }
            this.buildTiles.buildBlock(target, (Floatf<Tile>)((Floatf)tile -> {
                if (target instanceof ThermalGenerator) {
                    ThermalGenerator g = (ThermalGenerator)target;
                    if (g.attribute == null || target.floating) {
                        return 0.0f;
                    }
                    float[] res = new float[]{0.0f};
                    tile.getLinkedTilesAs(target, other -> {
                        res[0] = res[0] + (other.floor().isDeep() ? 0.0f : other.floor().attributes.get(g.attribute));
                    });
                    return res[0];
                }
                if (target instanceof Drill) {
                    return ((Drill)target).countOreArc((Tile)tile);
                }
                return 1.0f;
            }));
            Queue<BuildPlan> plans = Vars.player.unit().plans();
            if (plans.size > 1000) {
                while (plans.size > 1000) {
                    plans.removeLast();
                }
                UIExt.announce("[yellow]\u5efa\u7b51\u8fc7\u591a\uff0c\u907f\u514d\u5361\u987f\uff0c\u4ec5\u4fdd\u7559\u524d1000\u4e2a\u89c4\u5212");
            }
        }).tooltip("\u653e\u7f6e/\u66ff\u6362").size(30.0f);
    }

    public static void showWorldProcessorInfo() {
        Log.info((String)"\u5f53\u524d\u5730\u56fe:@", (Object[])new Object[]{Vars.state.map.name()});
        int[] data = new int[3];
        Groups.build.each(b -> {
            if (b instanceof LogicBlock.LogicBuild) {
                LogicBlock.LogicBuild lb = (LogicBlock.LogicBuild)b;
                if (lb.block.privileged) {
                    data[0] = data[0] + 1;
                    data[1] = data[1] + (lb.code.split("\n").length + 1);
                    data[2] = data[2] + lb.code.length();
                }
            }
        });
        Log.info((String)"\u5730\u56fe\u5171\u6709@\u4e2a\u4e16\u5904\uff0c\u603b\u5171@\u884c\u6307\u4ee4\uff0c@\u4e2a\u5b57\u7b26", (Object[])new Object[]{data[0], data[1], data[2]});
        Vars.ui.announce(Strings.format((String)"\u5730\u56fe\u5171\u6709@\u4e2a\u4e16\u5904\uff0c\u603b\u5171@\u884c\u6307\u4ee4\uff0c@\u4e2a\u5b57\u7b26", (Object[])new Object[]{data[0], data[1], data[2]}), 10.0f);
    }

    void replaceBlock(Block ori, Block re) {
        if (Vars.player.dead()) {
            return;
        }
        Vars.player.team().data().buildings.each(building -> building.block == ori && this.contain(building.tile), building -> Vars.player.unit().addBuild(new BuildPlan((int)building.tile.x, (int)building.tile.y, building.rotation, re, building.config())));
    }

    boolean contain(Tile tile) {
        if (this.placement == BuildRange.global) {
            return true;
        }
        if (this.placement == BuildRange.zone) {
            return this.selection.contains((float)tile.x, (float)tile.y);
        }
        if (this.placement == BuildRange.player) {
            return tile.within(Vars.player.x, Vars.player.y, 220.0f);
        }
        if (this.placement == BuildRange.team) {
            if (Vars.state.rules.polygonCoreProtection) {
                float mindst = Float.MAX_VALUE;
                CoreBlock.CoreBuild closest = null;
                for (Teams.TeamData data : Vars.state.teams.active) {
                    for (CoreBlock.CoreBuild tiles : data.cores) {
                        float dst = tiles.dst2(tile.x * 8, tile.y * 8);
                        if (!(dst < mindst)) continue;
                        closest = tiles;
                        mindst = dst;
                    }
                }
                return closest == null || closest.team == Vars.player.team();
            }
            return !Vars.state.teams.anyEnemyCoresWithin(Vars.player.team(), (float)(tile.x * 8), (float)(tile.y * 8), Vars.state.rules.enemyCoreBuildRadius + 8.0f);
        }
        return true;
    }

    static enum BuildRange {
        global,
        zone,
        team,
        player,
        find;

    }

    class BuildTiles {
        private final ObjectFloatMap<Tile> buildEff = new ObjectFloatMap();
        public int minx;
        public int miny;
        public int maxx;
        public int maxy;
        public int width;
        public int height;
        Seq<Tile> validTile = new Seq();
        Seq<Float> eff = new Seq();
        float efficiency = 0.0f;
        Block block;
        boolean canBuild = true;

        void buildBlock(Block buildBlock, Floatf<Tile> tilef) {
            this.block = buildBlock;
            this.updateTiles();
            this.checkValid();
            this.calBlockEff(tilef);
            this.eff.sort().reverse().remove((Object)Float.valueOf(0.0f));
            this.eff.each(this::buildEff);
        }

        public void updateTiles() {
            this.minx = 9999;
            this.miny = 9999;
            this.maxx = -999;
            this.maxy = -999;
            this.validTile.clear();
            this.eff.clear();
            Vars.world.tiles.eachTile(tile -> {
                if (tile == null) {
                    return;
                }
                if (!AdvanceBuildTool.this.contain((Tile)tile)) {
                    return;
                }
                this.validTile.add(tile);
                this.minx = Math.min(this.minx, tile.x);
                this.miny = Math.min(this.miny, tile.y);
                this.maxx = Math.max(this.maxx, tile.x);
                this.maxy = Math.max(this.maxy, tile.y);
            });
            this.buildEff.clear();
            this.width = this.maxx - this.minx;
            this.height = this.maxy - this.miny;
        }

        void checkValid() {
            this.validTile.each(tile -> {
                block4: {
                    block2: {
                        block3: {
                            if (this.block.size == 2 && Vars.world.getDarkness(tile.x, tile.y) >= 3.0f || Vars.state.rules.staticFog && Vars.state.rules.fog && !Vars.fogControl.isDiscovered(Vars.player.team(), tile.x, tile.y) || tile.floor().isDeep() && !this.block.floating && !this.block.requiresWater && !this.block.placeableLiquid || this.block == tile.block() && tile.build != null && AdvanceBuildTool.this.rotation == (float)tile.build.rotation && this.block.rotate || !tile.interactable(Vars.player.team()) || !tile.floor().placeableOn) break block2;
                            if (this.block.canReplace(tile.block())) break block3;
                            Building patt10503$temp = tile.build;
                            if (!(patt10503$temp instanceof ConstructBlock.ConstructBuild)) break block2;
                            ConstructBlock.ConstructBuild build = (ConstructBlock.ConstructBuild)patt10503$temp;
                            if (build.current != this.block || tile.centerX() != tile.x || tile.centerY() != tile.y) break block2;
                        }
                        if (this.block.bounds(tile.x, tile.y, Tmp.r1).grow(0.01f).contains(tile.block().bounds(tile.centerX(), tile.centerY(), Tmp.r2)) && (!this.block.requiresWater || tile.floor().liquidDrop == Liquids.water)) break block4;
                    }
                    this.buildEff.put(tile, -1.0f);
                }
            });
        }

        void calBlockEff(Floatf<Tile> tilef) {
            this.validTile.each(tile -> {
                this.canBuild = true;
                this.getLinkedTiles((Tile)tile, (Cons<Tile>)((Cons)tile1 -> {
                    this.canBuild = this.buildEff.get(tile, 0.0f) != -1.0f && this.canBuild;
                }));
                if (this.canBuild) {
                    this.efficiency = tilef.get(tile);
                    this.buildEff.put(tile, this.efficiency);
                    if (!this.eff.contains((Object)Float.valueOf(this.efficiency))) {
                        this.eff.add((Object)Float.valueOf(this.efficiency));
                    }
                } else {
                    this.buildEff.remove(tile, 0.0f);
                }
            });
        }

        void buildEff(float e) {
            if (e == 0.0f || Vars.player.dead()) {
                return;
            }
            this.validTile.each(tile -> {
                if (this.buildEff.get(tile, 0.0f) != e) {
                    return;
                }
                if (!this.block.canPlaceOn((Tile)tile, Vars.player.team(), 0)) {
                    return;
                }
                Vars.player.unit().addBuild(new BuildPlan((int)tile.x, (int)tile.y, 0, this.block));
                this.getFullLinkedTiles((Tile)tile, (Cons<Tile>)((Cons)tile1 -> this.buildEff.remove(tile1, 0.0f)));
            });
        }

        private void getLinkedTiles(Tile tile, Cons<Tile> cons) {
            if (this.block.isMultiblock()) {
                int size = this.block.size;
                int o = this.block.sizeOffset;
                for (int dx = 0; dx < size; ++dx) {
                    for (int dy = 0; dy < size; ++dy) {
                        Tile other = Vars.world.tile(tile.x + dx + o, tile.y + dy + o);
                        if (other == null) continue;
                        cons.get((Object)other);
                    }
                }
            } else {
                cons.get((Object)tile);
            }
        }

        private void getFullLinkedTiles(Tile tile, Cons<Tile> cons) {
            if (this.block.isMultiblock()) {
                int size = this.block.size;
                int o = 0;
                for (int dx = -size + 1; dx < size; ++dx) {
                    for (int dy = -size + 1; dy < size; ++dy) {
                        Tile other = Vars.world.tile(tile.x + dx + o, tile.y + dy + o);
                        if (other == null) continue;
                        cons.get((Object)other);
                    }
                }
            } else {
                cons.get((Object)tile);
            }
        }
    }
}

