/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features.ui;

import arc.Core;
import arc.Events;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.util.Scaling;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.content.Items;
import mindustry.content.StatusEffects;
import mindustry.editor.WaveInfoDialog;
import mindustry.game.EventType;
import mindustry.game.SpawnGroup;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustryX.features.ArcWaveSpawner;
import mindustryX.features.UIExt;
import mindustryX.features.ui.ArcMessageDialog;
import mindustryX.features.ui.FormatDefault;
import mindustryX.features.ui.OverlayUI;

public class WaveInfoDisplay
extends Table {
    public static final float fontScl = 0.8f;
    private int waveOffset = 0;
    private final WaveInfoDialog waveInfoDialog = new WaveInfoDialog();
    private final Table waveInfo;

    public WaveInfoDisplay() {
        super(Tex.pane);
        Events.on(EventType.WorldLoadEvent.class, e -> {
            this.waveOffset = 0;
            this.rebuildWaveInfo();
        });
        Events.on(EventType.WaveEvent.class, e -> this.rebuildWaveInfo());
        this.margin(0.0f, 4.0f, 0.0f, 4.0f);
        this.table(buttons -> {
            buttons.defaults().size(32.0f);
            buttons.add().growX();
            buttons.button((Drawable)Icon.waves, Styles.clearNonei, 32.0f, () -> ((WaveInfoDialog)this.waveInfoDialog).show()).tooltip("\u6ce2\u6b21\u4fe1\u606f");
            buttons.button("<", Styles.cleart, () -> this.shiftWaveOffset(-1));
            TextButton i = (TextButton)buttons.button("", Styles.cleart, this::setWaveOffsetDialog).minHeight(48.0f).maxWidth(160.0f).get();
            i.getLabel().setAlignment(1);
            i.getLabel().setText(() -> "" + (Vars.state.wave + this.waveOffset));
            buttons.button(">", Styles.cleart, () -> this.shiftWaveOffset(1));
            buttons.button("R", Styles.cleart, () -> this.setWaveOffset(0)).tooltip("\u6062\u590d\u5f53\u524d\u6ce2\u6b21");
            buttons.button("J", Styles.cleart, () -> Vars.ui.showConfirm("[red]\u8fd9\u662f\u4e00\u4e2a\u4f5c\u5f0a\u529f\u80fd[]\n\u5feb\u901f\u8df3\u8f6c\u5230\u76ee\u6807\u6ce2\u6b21(\u4e0d\u5237\u5175)", () -> {
                Vars.state.wave += this.waveOffset;
                this.setWaveOffset(0);
            })).tooltip("\u5f3a\u5236\u8df3\u6ce2").disabled(b -> Vars.net.client());
            buttons.add().growX();
            buttons.add((CharSequence)"\u2650>");
            buttons.button((Drawable)Icon.wavesSmall, Styles.clearNonei, 32.0f, () -> this.shareWaveInfo(Vars.state.wave + this.waveOffset)).tooltip("\u5206\u4eab\u6ce2\u6b21\u4fe1\u606f");
            buttons.button((Drawable)Icon.powerSmall, Styles.clearNonei, 32.0f, () -> UIExt.coreItems.sharePowerInfo()).tooltip("\u5206\u4eab\u7535\u529b\u60c5\u51b5");
            buttons.button((Drawable)new TextureRegionDrawable(Items.copper.uiIcon), Styles.clearNonei, 24.0f, () -> UIExt.coreItems.shareItemInfo()).tooltip("\u5206\u4eab\u5e93\u5b58\u60c5\u51b5");
            buttons.button((Drawable)Icon.unitsSmall, Styles.clearNonei, 32.0f, () -> UIExt.coreItems.shareUnitInfo()).tooltip("\u5206\u4eab\u5355\u4f4d\u6570\u91cf");
        }).fillX().row();
        this.waveInfo = new Table().left().top();
        this.add((Element)new ScrollPane((Element)this.waveInfo, Styles.noBarPane){
            {
                this.setScrollingDisabledY(true);
                this.setForceScroll(true, false);
                this.update(() -> {
                    if (this.hasScroll() && !this.hasMouse()) {
                        Core.scene.setScrollFocus(null);
                    }
                });
            }

            public float getPrefWidth() {
                return 0.0f;
            }

            public float getMinHeight() {
                return this.getPrefHeight();
            }
        }).growX().fillY().row();
        this.add(new OverlayUI.PreferAnyWidth()).fillX().row();
    }

    public void shareWaveInfo(int wave) {
        if (!Vars.state.rules.waves) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\u7b2c").append(wave).append("\u6ce2");
        if (wave >= Vars.state.wave) {
            builder.append("(");
            if (wave > Vars.state.wave) {
                builder.append("\u8fd8\u6709").append(wave - Vars.state.wave).append("\u6ce2, ");
            }
            int timer = (int)(Vars.state.wavetime + (float)(wave - Vars.state.wave) * Vars.state.rules.waveSpacing);
            builder.append(FormatDefault.duration((float)timer / 60.0f)).append(")");
        }
        builder.append("\uff1a");
        builder.append(ArcMessageDialog.getWaveInfo(wave));
        UIExt.shareMessage('\ue83b', builder.toString());
    }

    private void setWaveOffsetDialog() {
        BaseDialog lsSet = new BaseDialog("\u6ce2\u6b21\u8bbe\u5b9a");
        lsSet.cont.add((CharSequence)"\u8bbe\u5b9a\u67e5\u8be2\u6ce2\u6b21").padRight(5.0f).left();
        TextField field = (TextField)lsSet.cont.field(Vars.state.wave + this.waveOffset + "", text -> {
            this.waveOffset = Integer.parseInt(text) - Vars.state.wave;
        }).size(320.0f, 54.0f).valid(Strings::canParsePositiveInt).maxTextLength(100).get();
        lsSet.cont.row();
        lsSet.cont.slider(1.0f, (float)ArcWaveSpawner.calWinWaveClamped(), 1.0f, res -> {
            this.waveOffset = (int)res - Vars.state.wave;
            field.setText((int)res + "");
        }).fillX().colspan(2);
        lsSet.addCloseButton();
        lsSet.show();
    }

    private void rebuildWaveInfo() {
        this.waveInfo.clearChildren();
        int curInfoWave = Vars.state.wave + this.waveOffset - 1;
        StringBuilder builder = new StringBuilder();
        for (SpawnGroup group : Vars.state.rules.spawns) {
            int amount = group.getSpawned(curInfoWave);
            if (amount == 0) continue;
            this.waveInfo.table(groupT -> {
                float shield;
                groupT.center().image(group.type.uiIcon).scaling(Scaling.fit).size(24.0f);
                if (amount > 1) {
                    groupT.add((CharSequence)("x" + amount), 0.8f);
                }
                groupT.row();
                builder.setLength(0);
                if (group.effect != null && group.effect != StatusEffects.none) {
                    builder.append(group.effect.emoji());
                }
                if ((shield = group.getShield(curInfoWave)) > 0.0f) {
                    builder.append(FormatDefault.format(shield));
                }
                groupT.add((CharSequence)builder.toString()).colspan(groupT.getColumns());
            }).pad(0.0f, 4.0f, 0.0f, 4.0f).left().top();
        }
    }

    private void shiftWaveOffset(int shiftCount) {
        int offset = Math.max(this.waveOffset + shiftCount, -Vars.state.wave + 1);
        this.setWaveOffset(offset);
    }

    private void setWaveOffset(int waveOffset) {
        this.waveOffset = waveOffset;
        this.rebuildWaveInfo();
    }
}

