/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features.ui;

import arc.Core;
import arc.Events;
import arc.flabel.FLabel;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.actions.Actions;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.Image;
import arc.scene.ui.Label;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Timer;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.StatusEffects;
import mindustry.content.UnitTypes;
import mindustry.core.World;
import mindustry.entities.units.StatusEntry;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.gen.PayloadUnit;
import mindustry.gen.Payloadc;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.DesktopInput;
import mindustry.input.InputHandler;
import mindustry.mod.Mods;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Tile;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.meta.BuildVisibility;
import mindustryX.features.UIExt;
import mindustryX.features.func.FuncX;
import mindustryX.features.ui.ContentSelectDialog;
import mindustryX.features.ui.FormatDefault;
import mindustryX.features.ui.comp.Card;

public class UnitFactoryDialog
extends BaseDialog {
    public static final int maxCount = 50;
    UnitStack selected = UnitStack.vanillaStack;
    private int unitCount = 1;
    private float unitRandDst = 4.0f;
    private Unit spawnUnit = UnitTypes.emanate.create(Team.sharded);
    private final Seq<Payload> unitPayloads = new Seq();
    private boolean lookingLocation;
    private Table selection;
    private Table infoTable;
    private Table posTable;
    private Table countTable;
    private Table itemTable;
    private Table propertiesTable;
    private Table teamTable;
    private Table effectTable;
    private Table payloadTable;

    public UnitFactoryDialog() {
        super("\u5355\u4f4d\u5de5\u5382");
        this.getCell((Element)this.cont).setElement((Element)new ScrollPane((Element)this.cont));
        this.closeOnBack();
        this.addCloseButton();
        this.shown(() -> {
            if (this.cont.hasChildren()) {
                return;
            }
            this.setup();
        });
    }

    private void setup() {
        this.cont.top();
        this.selection = new Table();
        this.infoTable = new Table();
        this.posTable = new Table();
        this.countTable = new Table();
        this.itemTable = new Table();
        this.propertiesTable = new Table();
        this.teamTable = new Table();
        this.effectTable = new Table();
        this.payloadTable = new Table();
        this.setupCountTable();
        this.setupPosTable();
        this.rebuildTables();
        this.buttons.button("\u91cd\u7f6e", (Drawable)Icon.refresh, () -> {
            UnitFactoryDialog.resetUnit(this.spawnUnit);
            this.rebuildTables();
        });
        this.buttons.button("[orange]\u751f\u6210\uff01", (Drawable)Icon.modeAttack, this::spawn);
        this.rebuild();
        this.resized(this::rebuild);
        Events.run((Object)EventType.Trigger.draw, () -> {
            if (!this.lookingLocation) {
                return;
            }
            Draw.z((float)120.0f);
            Draw.color((Color)this.spawnUnit.team.color);
            Lines.circle(this.spawnUnit.x, this.spawnUnit.y, 10.0f);
            Draw.rect((TextureRegion)this.spawnUnit.type.uiIcon, (float)this.spawnUnit.x, (float)this.spawnUnit.y, (float)10.0f, (float)10.0f, (float)(Time.time % 360.0f));
            Draw.reset();
            Vec2 mouse = Core.input.mouseWorld();
            Tile tile = Vars.world.tileWorld(mouse.x, mouse.y);
            if (tile != null) {
                Drawf.dashRect((Color)Pal.accent, (float)(tile.drawx() - 4.0f), (float)(tile.drawy() - 4.0f), (float)8.0f, (float)8.0f);
                Vec2 tilePos = Tmp.v1.set((float)tile.x, (float)tile.y);
                Vec2 textPos = Tmp.v2.set((Position)tile).sub(0.0f, 8.0f);
                FuncX.drawText((Position)textPos, "" + tilePos, 1.0f, Pal.accent, 2, Fonts.outline);
                Draw.reset();
            }
        });
    }

    private void spawn() {
        for (int n = 0; n < this.unitCount; ++n) {
            Unit unit = UnitFactoryDialog.cloneUnit(this.spawnUnit);
            Vec2 pos = Tmp.v1.set((Position)unit);
            Vec2 offset = Tmp.v2.rnd(Mathf.random((float)(this.unitRandDst * 8.0f)));
            unit.set((Position)pos.add(offset));
            unit.add();
        }
    }

    private void rebuild() {
        float rightWidth = Math.min(Core.scene.getWidth() * (Core.scene.getWidth() > 700.0f ? 0.6f : 0.9f) / Scl.scl(), 700.0f);
        Table rightTable = new Table();
        rightTable.top();
        rightTable.defaults().growX();
        rightTable.add((Element)this.infoTable).row();
        rightTable.add().height(8.0f).row();
        rightTable.table(Tex.pane, settings -> {
            settings.left().defaults().fillX().padTop(8.0f);
            settings.add((Element)this.posTable).padTop(0.0f).row();
            settings.add((Element)this.countTable).row();
            settings.table(randDstTable -> {
                randDstTable.add((CharSequence)"\u751f\u6210\u8303\u56f4\uff1a");
                randDstTable.field(Strings.autoFixed((float)this.unitRandDst, (int)3), text -> {
                    this.unitRandDst = Float.parseFloat(text);
                }).valid(Strings::canParsePositiveFloat).tooltip("\u5728\u76ee\u6807\u70b9\u9644\u8fd1\u7684\u8fd9\u4e2a\u8303\u56f4\u5185\u968f\u673a\u751f\u6210").maxTextLength(6).padLeft(4.0f);
                randDstTable.add((CharSequence)"\u683c").expandX().left();
            }).row();
            settings.add((Element)this.itemTable).row();
            settings.add((Element)this.propertiesTable).row();
            settings.add((Element)this.teamTable).row();
        }).row();
        rightTable.add().height(8.0f).row();
        rightTable.add((Element)this.effectTable).row();
        rightTable.add().height(8.0f).row();
        rightTable.add((Element)this.payloadTable).row();
        Table main = this.cont;
        main.clearChildren();
        if (Core.graphics.isPortrait()) {
            main.add((Element)this.selection).growX().row();
            main.add((Element)rightTable).padTop(8.0f).growX().row();
        } else {
            main.add((Element)this.selection).width(rightWidth * 0.6f).growY();
            main.add((Element)rightTable).padLeft(8.0f).width(rightWidth).growY().row();
        }
        Core.app.post(this::rebuildUnitSelection);
    }

    private void rebuildTables() {
        this.rebuildInfoTable(this.spawnUnit, this.infoTable);
        this.rebuildPropertiesTable(this.spawnUnit, this.propertiesTable);
        this.rebuildItemTable(this.spawnUnit, this.itemTable);
        this.rebuildTeamTable(this.spawnUnit, this.teamTable);
        this.rebuildEffectsTable(this.spawnUnit, this.effectTable);
        this.rebuildPayloadTable(this.spawnUnit, this.payloadTable);
    }

    private void setSpawnUnitType(UnitType unitType) {
        this.spawnUnit.type = unitType;
        this.spawnUnit = UnitFactoryDialog.cloneUnit(this.spawnUnit);
        this.spawnUnit.health = unitType.health;
        this.spawnUnit.elevation = Mathf.num((boolean)unitType.flying);
        Unit unit = this.spawnUnit;
        if (unit instanceof PayloadUnit) {
            PayloadUnit payloadUnit = (PayloadUnit)unit;
            payloadUnit.payloads = this.unitPayloads;
        }
        this.rebuildTables();
    }

    private void rebuildUnitSelection() {
        this.selection.top();
        this.selection.clearChildren();
        Table unitSelectTable = new Table(Tex.whiteui);
        unitSelectTable.top().setColor(Pal.darkerGray);
        this.selection.table(Tex.whiteui, stackSelectTable -> {
            stackSelectTable.left();
            int[] i = new int[]{0};
            float width = this.selection.getWidth();
            int rows = Math.max(1, (int)(width / 192.0f / Scl.scl()));
            UnitStack.getUnitStacks().each(stack -> {
                stackSelectTable.button(b -> {
                    TextureRegion region = stack.icon();
                    Drawable icon = region == null ? Tex.nomap : new TextureRegionDrawable(region);
                    b.image(icon).scaling(Scaling.fit).size(48.0f).pad(8.0f);
                    b.add((CharSequence)stack.name()).width(128.0f);
                }, (Button.ButtonStyle)Styles.clearTogglei, () -> {
                    this.selected = stack;
                    this.rebuildSelectTable(this.selected, unitSelectTable);
                }).height(64.0f).pad(8.0f).checked(b -> this.selected == stack);
                i[0] = i[0] + 1;
                if (i[0] % rows == 0) {
                    stackSelectTable.row();
                }
            });
        }).color(Pal.gray).fillX().row();
        this.selection.add((Element)unitSelectTable).padLeft(8.0f).padRight(8.0f).grow().row();
        Core.app.post(() -> this.rebuildSelectTable(this.selected, unitSelectTable));
    }

    private void rebuildSelectTable(UnitStack stack, Table table2) {
        int[] i = new int[]{0};
        float width = this.selection.getWidth();
        int rows = Math.max(1, (int)((width - 8.0f) / 68.0f / Scl.scl()) - 1);
        table2.clearChildren();
        stack.units.each(unit -> {
            if (unit == UnitTypes.block) {
                return;
            }
            table2.button((Drawable)new TextureRegionDrawable(unit.uiIcon), Styles.clearTogglei, 32.0f, () -> this.setSpawnUnitType((UnitType)((Object)unit))).margin(3.0f).size(64.0f).pad(4.0f).tooltip(unit.localizedName).checked(b -> this.spawnUnit.type == unit);
            i[0] = i[0] + 1;
            if (i[0] % rows == 0) {
                table2.row();
            }
        });
    }

    private void setupPosTable() {
        this.posTable.add((CharSequence)"\u751f\u6210\u4f4d\u7f6e:");
        this.posTable.label(() -> {
            int tileX = World.toTile(this.spawnUnit.x);
            int tileY = World.toTile(this.spawnUnit.y);
            return "" + Tmp.v1.set((float)tileX, (float)tileY);
        }).left().expandX().padLeft(4.0f);
        this.posTable.defaults().size(48.0f);
        this.posTable.button((Drawable)Icon.pickSmall, Styles.clearNonei, () -> {
            this.lookingLocation = true;
            this.hide();
            UIExt.hitter((cx, cy) -> {
                Vec2 v = Core.camera.unproject(cx, cy);
                this.spawnUnit.set((Position)v);
                Timer.schedule(() -> {
                    this.show();
                    this.lookingLocation = false;
                }, (float)0.5f);
                return true;
            });
            UIExt.announce("[green]\u70b9\u51fb\u5c4f\u5e55\u91c7\u96c6\u5750\u6807", 2.0f);
        });
        this.posTable.button((Drawable)Icon.eyeSmall, Styles.clearNonei, () -> {
            this.lookingLocation = true;
            this.hide();
            Core.camera.position.set((Position)this.spawnUnit);
            InputHandler patt9218$temp = Vars.control.input;
            if (patt9218$temp instanceof DesktopInput) {
                DesktopInput input = (DesktopInput)patt9218$temp;
                input.panning = true;
            }
            UIExt.hitter((cx, cy) -> {
                this.show();
                this.lookingLocation = false;
                return true;
            });
            UIExt.announce("[green]\u70b9\u51fb\u5c4f\u5e55\u8fd4\u56de", 2.0f);
        }).padLeft(4.0f);
        this.posTable.button((Drawable)new TextureRegionDrawable(UnitTypes.gamma.uiIcon), Styles.clearNonei, 24.0f, () -> this.spawnUnit.set((Position)Vars.player)).padLeft(4.0f);
    }

    private void setupCountTable() {
        this.countTable.add((CharSequence)"\u751f\u6210\u6570\u91cf:");
        this.countTable.field("", text -> {
            this.unitCount = Math.min(50, Strings.parseInt((String)text));
        }).update(it -> it.setText("" + this.unitCount)).left().expandX().width(80.0f).valid(Strings::canParseInt);
        this.countTable.button(b -> b.add((CharSequence)"MAX"), (Button.ButtonStyle)Styles.clearNonei, () -> {
            this.unitCount = 50;
        }).size(48.0f).padLeft(4.0f);
        this.countTable.slider(1.0f, 50.0f, 1.0f, 1.0f, n -> {
            this.unitCount = (int)n;
        }).update(it -> it.setValue((float)this.unitCount)).width(128.0f).padLeft(4.0f).get();
    }

    private void rebuildInfoTable(Unit unit, Table infoTable) {
        infoTable.clearChildren();
        infoTable.table(Tex.pane, imageTable -> imageTable.image(unit.type.uiIcon).size(112.0f).scaling(Scaling.fit)).top();
        infoTable.table(null, rightTable -> {
            rightTable.table(Tex.pane, labelTable -> {
                String name = unit.type.name;
                String localizedName = unit.type.localizedName;
                boolean hasLocalized = !name.equals(localizedName);
                String text = localizedName + (hasLocalized ? "(" + name + ")" : "") + "[" + unit.type.id + "]";
                Label label = (Label)labelTable.add((CharSequence)text).labelAlign(8).left().expandX().get();
                labelTable.table(null, buttons -> {
                    buttons.button((Drawable)Icon.copySmall, Styles.clearNonei, 16.0f, () -> {
                        Core.app.setClipboardText("" + label.getText());
                        Vars.ui.announce("\u590d\u5236\u6210\u529f:" + label.getText(), 3.0f);
                    }).size(28.0f);
                    buttons.button("i", () -> Vars.ui.content.show(unit.type)).size(28.0f).padLeft(4.0f);
                }).right();
            }).growX().row();
            rightTable.pane(Styles.noBarPane, describeTable -> {
                describeTable.background(Tex.pane);
                describeTable.label(() -> unit.type.description).labelAlign(8).grow().wrap();
            }).grow().maxHeight(80.0f).padTop(4.0f).scrollX(false);
        }).grow().padLeft(4.0f);
    }

    private void rebuildPropertiesTable(Unit unit, Table propertiesTable) {
        propertiesTable.clearChildren();
        propertiesTable.defaults().expandX().left();
        propertiesTable.table(t -> t.check("\u98de\u884c\u6a21\u5f0f", unit.elevation > 0.0f, a -> {
            unit.elevation = a ? 1.0f : 0.0f;
        }).padBottom(5.0f).padRight(10.0f).tooltip("[orange]\u751f\u6210\u7684\u5355\u4f4d\u4f1a\u98de\u8d77\u6765", true).checked(b -> unit.elevation > 0.0f));
        propertiesTable.row();
        propertiesTable.table(healthTable -> {
            healthTable.add((CharSequence)"[red]\u8840\u91cf\uff1a");
            healthTable.field(Strings.autoFixed((float)unit.health, (int)1), text -> {
                unit.health = Float.parseFloat(text);
            }).valid(Strings::canParsePositiveFloat).padLeft(4.0f);
        });
        propertiesTable.table(shieldTable -> {
            shieldTable.add((CharSequence)"[yellow]\u62a4\u76fe\uff1a");
            shieldTable.field(Strings.autoFixed((float)unit.shield, (int)1), text -> {
                unit.shield = Float.parseFloat(text);
            }).valid(Strings::canParsePositiveFloat).padLeft(4.0f);
        });
    }

    private void rebuildItemTable(Unit unit, Table itemTable) {
        itemTable.clearChildren();
        int itemCapacity = unit.itemCapacity();
        if (itemCapacity == 0) {
            return;
        }
        itemTable.add((CharSequence)"\u643a\u5e26\u7269\u54c1:");
        itemTable.button(b -> b.image(() -> unit.hasItem() ? unit.item().uiIcon : Icon.noneSmall.getRegion()).size(48.0f).scaling(Scaling.fit).padLeft(8.0f), (Button.ButtonStyle)Styles.clearNonei, () -> ContentSelectDialog.once(Vars.content.items(), unit.item(), item -> {
            unit.stack.item = item;
        })).size(48.0f).padLeft(8.0f);
        itemTable.field("" + unit.stack.amount, text -> {
            unit.stack.amount = Mathf.clamp((int)Strings.parseInt((String)text), (int)0, (int)itemCapacity);
        }).update(it -> it.setText("" + unit.stack.amount)).valid(Strings::canParsePositiveInt).padLeft(8.0f).expandX().left().width(80.0f);
        itemTable.button(b -> b.add((CharSequence)"MAX"), (Button.ButtonStyle)Styles.clearNonei, () -> {
            unit.stack.amount = unit.itemCapacity();
        }).size(48.0f).padLeft(4.0f);
        itemTable.button((Drawable)Icon.none, Styles.clearNonei, () -> ((Unit)unit).clearItem()).size(48.0f).padLeft(4.0f);
        itemTable.slider(0.0f, (float)itemCapacity, 1.0f, (float)unit.stack.amount, n -> {
            unit.stack.amount = (int)n;
        }).update(s -> s.setValue((float)unit.stack.amount)).width(128.0f).padLeft(4.0f);
    }

    private void rebuildTeamTable(Unit unit, Table teamTable) {
        teamTable.clearChildren();
        teamTable.add((CharSequence)"\u751f\u6210\u961f\u4f0d:");
        teamTable.label(() -> {
            Team team = unit.team;
            return "[#" + team.color + "]" + team.localized();
        }).minWidth(88.0f).padLeft(8.0f);
        Image image = (Image)teamTable.image().color(unit.team.color).size(48.0f).left().expandX().get();
        Cons changeTeam = team -> {
            unit.team = team;
            image.addAction((Action)Actions.color((Color)team.color, (float)0.25f));
        };
        for (Team team2 : Team.baseTeams) {
            teamTable.button(b -> b.image().grow().color(team.color), (Button.ButtonStyle)Styles.clearNonei, () -> changeTeam.get((Object)team2)).size(36.0f).pad(8.0f);
        }
        teamTable.add((CharSequence)"\u961f\u4f0dID:").padLeft(4.0f);
        teamTable.field("" + unit.team.id, text -> {
            int id = Mathf.clamp((int)Strings.parseInt((String)text), (int)0, (int)(Team.all.length - 1));
            changeTeam.get((Object)Team.all[id]);
        }).update(it -> it.setText("" + unit.team.id)).width(72.0f).valid(Strings::canParseInt).get();
    }

    private void rebuildEffectsTable(Unit unit, Table effectTable) {
        effectTable.clearChildren();
        Seq unitStatus = unit.statuses();
        Table settingTable = new Table(Tex.whiteui);
        Table effectInfo = new Table(Styles.grayPanel);
        settingTable.setColor(Pal.gray);
        Runnable rebuildInfo = () -> {
            float[] status = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f};
            for (StatusEntry entry : unitStatus) {
                status[0] = status[0] * entry.damageMultiplier;
                status[1] = status[1] * entry.healthMultiplier;
                status[2] = status[2] * entry.speedMultiplier;
                status[3] = status[3] * entry.reloadMultiplier;
                status[4] = status[4] * entry.buildSpeedMultiplier;
                status[5] = status[5] * entry.dragMultiplier;
                if (!entry.effect.dynamic) continue;
                status[6] = entry.armorOverride;
            }
            effectInfo.clearChildren();
            effectInfo.defaults().pad(4.0f);
            effectInfo.add((CharSequence)"[red]\u4f24\u5bb3");
            effectInfo.add((CharSequence)FormatDefault.format(status[0])).expandX().right();
            effectInfo.add((CharSequence)"[acid]\u8840\u91cf").padLeft(12.0f);
            effectInfo.add((CharSequence)FormatDefault.format(status[1])).expandX().right();
            effectInfo.row();
            effectInfo.add((CharSequence)"[cyan]\u79fb\u901f");
            effectInfo.add((CharSequence)FormatDefault.format(status[2])).expandX().right();
            effectInfo.add((CharSequence)"[violet]\u653b\u901f").padLeft(12.0f);
            effectInfo.add((CharSequence)FormatDefault.format(status[3])).expandX().right();
            effectInfo.row();
            effectInfo.add((CharSequence)"[accent]\u5efa\u901f");
            effectInfo.add((CharSequence)FormatDefault.format(status[4])).expandX().right();
            effectInfo.add((CharSequence)"[purple]\u963b\u529b").padLeft(12.0f);
            effectInfo.add((CharSequence)FormatDefault.format(status[5])).expandX().right();
            effectInfo.row();
            if (status[6] >= 0.0f) {
                effectInfo.add((CharSequence)"[teal]\u88c5\u7532");
                effectInfo.add((CharSequence)FormatDefault.format(status[6])).expandX().right();
            }
        };
        effectTable.table(Tex.whiteui, leftTable -> {
            leftTable.top();
            leftTable.setColor(Pal.gray);
            leftTable.defaults().fillY();
            leftTable.table(topTable -> {
                topTable.top();
                topTable.table(statusTable -> {
                    statusTable.image(StatusEffects.burning.uiIcon).size(64.0f).scaling(Scaling.fit).expandX().left();
                    statusTable.button((Drawable)Icon.refresh, Styles.cleari, 48.0f, () -> {
                        unitStatus.clear();
                        rebuildInfo.run();
                        this.rebuildEffectSettingTable((Seq<StatusEntry>)unitStatus, settingTable, rebuildInfo);
                    }).size(64.0f).pad(8.0f);
                }).growX();
                topTable.row();
                topTable.add((Element)effectInfo).fill().pad(8.0f);
            });
            leftTable.row();
            leftTable.table(selection -> {
                int i = 0;
                for (StatusEffect effect : Vars.content.statusEffects()) {
                    Cell cell = selection.button((Drawable)new TextureRegionDrawable(effect.uiIcon), Styles.cleari, 32.0f, () -> {
                        float time = unitStatus.isEmpty() ? 36000.0f : ((StatusEntry)unitStatus.peek()).time;
                        unitStatus.add((Object)new StatusEntry().set(effect, time));
                        rebuildInfo.run();
                        this.rebuildEffectSettingTable((Seq<StatusEntry>)unitStatus, settingTable, rebuildInfo);
                    }).size(48.0f).pad(4.0f).tooltip(effect.localizedName);
                    if (effect.dynamic) {
                        cell.disabled(b -> unit.statuses().contains(e -> e.effect == effect));
                    }
                    if (++i % 4 != 0) continue;
                    selection.row();
                }
            }).pad(8.0f).fill().right();
        }).growY();
        effectTable.add((Element)settingTable).grow();
        rebuildInfo.run();
        this.rebuildEffectSettingTable((Seq<StatusEntry>)unitStatus, settingTable, rebuildInfo);
    }

    private void rebuildEffectSettingTable(Seq<StatusEntry> unitStatus, Table table2, Runnable onChanged) {
        table2.clearChildren();
        table2.top().background(Tex.whiteui).setColor(Pal.darkerGray);
        table2.defaults().growX();
        unitStatus.each(entry -> {
            StatusEffect effect = entry.effect;
            table2.table(Tex.whiteui, t -> {
                t.setColor(Pal.lightishGray);
                t.image(effect.uiIcon).pad(4.0f).size(40.0f).scaling(Scaling.fit);
                t.add((CharSequence)effect.localizedName).ellipsis(true).width(64.0f).padLeft(6.0f);
                if (entry.effect.permanent) {
                    t.add((CharSequence)"<\u6c38\u4e45\u72b6\u6001>").expandX();
                } else if (entry.effect.reactive) {
                    t.add((CharSequence)"<\u77ac\u95f4\u72b6\u6001>").expandX();
                } else {
                    t.table(bottom -> {
                        bottom.field("", text -> {
                            entry.time = Strings.parseFloat((String)text) * 60.0f;
                        }).valid(text -> Strings.canParsePositiveFloat((String)text.replaceAll("\u221e", "Infinity"))).update(it -> {
                            if (!it.hasKeyboard()) {
                                it.setText(Float.isInfinite(entry.time) ? "\u221e" : "" + entry.time / 60.0f);
                            }
                        }).width(100.0f);
                        bottom.add((CharSequence)"\u79d2");
                        bottom.button(b -> b.add((Element)new FLabel((CharSequence)"{rainbow}\u221e")), (Button.ButtonStyle)Styles.clearNonei, () -> {
                            entry.time = Float.POSITIVE_INFINITY;
                        }).size(32.0f).padLeft(8.0f).expandX().right();
                    }).padTop(8.0f).expandX().left();
                }
                t.button((Drawable)Icon.copySmall, Styles.clearNonei, 32.0f, () -> {
                    unitStatus.add((Object)UnitFactoryDialog.cloneStatus(entry));
                    onChanged.run();
                    this.rebuildEffectSettingTable(unitStatus, table2, onChanged);
                }).size(32.0f).disabled(effect.dynamic);
                t.button((Drawable)Icon.cancelSmall, Styles.clearNonei, 32.0f, () -> {
                    unitStatus.remove(entry, true);
                    onChanged.run();
                    this.rebuildEffectSettingTable(unitStatus, table2, onChanged);
                }).size(32.0f);
            }).padLeft(8.0f).padRight(8.0f).padTop(12.0f);
            table2.row();
            if (effect.dynamic) {
                table2.add((Element)new Card(Pal.darkestGray, Card.grayOuterDark, (Cons<Table>)((Cons)t -> {
                    t.defaults().pad(4.0f).padLeft(8.0f).left();
                    t.add((CharSequence)"[red]\u4f24\u5bb3").style((Style)Styles.outlineLabel);
                    t.field("" + entry.damageMultiplier, text -> {
                        entry.damageMultiplier = Strings.parseFloat((String)text);
                    }).valid(Strings::canParsePositiveFloat).width(88.0f);
                    t.add().expandX();
                    t.add((CharSequence)"[acid]\u8840\u91cf").style((Style)Styles.outlineLabel);
                    t.field("" + entry.healthMultiplier, text -> {
                        entry.healthMultiplier = Strings.parseFloat((String)text);
                    }).valid(Strings::canParsePositiveFloat).width(88.0f);
                    t.add().expandX().row();
                    t.add((CharSequence)"[cyan]\u79fb\u901f").style((Style)Styles.outlineLabel);
                    t.field("" + entry.speedMultiplier, text -> {
                        entry.speedMultiplier = Strings.parseFloat((String)text);
                    }).valid(Strings::canParsePositiveFloat).width(88.0f);
                    t.add().expandX();
                    t.add((CharSequence)"[violet]\u653b\u901f").style((Style)Styles.outlineLabel);
                    t.field("" + entry.reloadMultiplier, text -> {
                        entry.reloadMultiplier = Strings.parseFloat((String)text);
                    }).valid(Strings::canParsePositiveFloat).width(88.0f);
                    t.add().expandX().row();
                    t.add((CharSequence)"[accent]\u5efa\u901f").style((Style)Styles.outlineLabel);
                    t.field("" + entry.buildSpeedMultiplier, text -> {
                        entry.buildSpeedMultiplier = Strings.parseFloat((String)text);
                    }).valid(Strings::canParsePositiveFloat).width(88.0f);
                    t.add().expandX();
                    t.add((CharSequence)"[purple]\u963b\u529b").style((Style)Styles.outlineLabel);
                    t.field("" + entry.dragMultiplier, text -> {
                        entry.dragMultiplier = Strings.parseFloat((String)text);
                    }).valid(Strings::canParsePositiveFloat).width(88.0f);
                    t.add().expandX().row();
                    t.add((CharSequence)"[teal]\u88c5\u7532").style((Style)Styles.outlineLabel);
                    t.field("" + entry.armorOverride, text -> {
                        entry.armorOverride = Strings.parseFloat((String)text);
                    }).valid(Strings::canParseFloat).width(88.0f);
                    for (Element child : t.getChildren()) {
                        if (!(child instanceof TextField)) continue;
                        TextField field = (TextField)child;
                        field.changed(onChanged);
                    }
                }))).padLeft(8.0f).padRight(8.0f).fillX();
            }
            table2.row();
        });
    }

    private void rebuildPayloadTable(Unit unit, Table payloadTable) {
        payloadTable.clearChildren();
        if (!(unit instanceof PayloadUnit)) {
            return;
        }
        PayloadUnit payloadUnit = (PayloadUnit)unit;
        Seq<Payload> payloads = payloadUnit.payloads;
        Table settingTable = new Table(Tex.whiteui);
        settingTable.setColor(Pal.gray);
        payloadTable.table(Tex.whiteui, table2 -> {
            table2.top();
            table2.setColor(Pal.gray);
            table2.image(Blocks.payloadLoader.uiIcon).size(64.0f).scaling(Scaling.fit).expandX().left();
            table2.button((Drawable)Icon.refresh, Styles.cleari, 48.0f, () -> {
                payloads.clear();
                this.rebuildPayloadSettingTable(payloads, settingTable);
            }).size(64.0f).pad(8.0f);
            table2.row();
            table2.table(Styles.grayPanel, buttons -> {
                buttons.defaults().height(48.0f).pad(4.0f).growX();
                buttons.button("\u88c5\u8f7d\u5efa\u7b51", (Drawable)new TextureRegionDrawable(Blocks.siliconSmelter.uiIcon), Styles.flatt, 32.0f, () -> ContentSelectDialog.once(Vars.content.blocks().select(block -> !block.isFloor() && block.buildVisibility != BuildVisibility.hidden), null, block -> {
                    BuildPayload payload = new BuildPayload(block, payloadUnit.team);
                    payloads.add((Object)payload);
                    this.rebuildPayloadSettingTable(payloads, settingTable);
                })).row();
                buttons.button("\u88c5\u8f7d\u5355\u4f4d", (Drawable)new TextureRegionDrawable(UnitTypes.alpha.uiIcon), Styles.flatt, 32.0f, () -> ContentSelectDialog.once(Vars.content.units(), null, unitType -> {
                    UnitPayload payload = new UnitPayload(unitType.create(payloadUnit.team));
                    payloads.add((Object)payload);
                    this.rebuildPayloadSettingTable(payloads, settingTable);
                })).row();
                buttons.button("\u88c5\u8f7d\u81ea\u5df1", (Drawable)Icon.add, Styles.flatt, () -> {
                    payloads.add((Object)new UnitPayload(UnitFactoryDialog.cloneUnit(payloadUnit)));
                    this.rebuildPayloadSettingTable(payloads, settingTable);
                }).row();
            }).pad(8.0f).colspan(2).fill();
        }).fillY();
        payloadTable.pane(Styles.noBarPane, (Element)settingTable).grow();
        this.rebuildPayloadSettingTable(payloads, settingTable);
    }

    private void rebuildPayloadSettingTable(Seq<Payload> payloads, Table table2) {
        table2.clearChildren();
        table2.top().background(Tex.whiteui).setColor(Pal.darkerGray);
        table2.defaults().pad(8.0f).growX().uniformX();
        int i = 0;
        for (Payload payload : payloads) {
            table2.table(Tex.whiteui, t -> {
                t.setColor(Pal.lightishGray);
                t.image(payload.content().uiIcon).pad(4.0f).size(48.0f).scaling(Scaling.fit);
                t.add((CharSequence)payload.content().localizedName).ellipsis(true).width(64.0f).padLeft(6.0f).expandX().left();
                t.defaults().size(32.0f).pad(4.0f);
                if (payload instanceof UnitPayload) {
                    UnitPayload unitPayload = (UnitPayload)payload;
                    t.button((Drawable)Icon.editSmall, Styles.clearNonei, 24.0f, () -> this.simpleFactory(unitPayload.unit));
                }
                t.button((Drawable)Icon.copySmall, Styles.clearNonei, 24.0f, () -> {
                    Payload copied = UnitFactoryDialog.clonePayload(payload);
                    payloads.add((Object)copied);
                    this.rebuildPayloadSettingTable(payloads, table2);
                });
                t.button((Drawable)Icon.cancelSmall, Styles.clearNonei, 24.0f, () -> {
                    payloads.remove((Object)payload, true);
                    this.rebuildPayloadSettingTable(payloads, table2);
                });
            });
            if (++i % 2 != 0) continue;
            table2.row();
        }
        if (i == 1) {
            table2.add();
        }
    }

    private void simpleFactory(Unit unit) {
        BaseDialog dialog = new BaseDialog("\u5355\u4f4d\u5de5\u5382");
        Table main = new Table();
        float width = Math.min(Core.scene.getWidth() * (Core.scene.getWidth() > 700.0f ? 0.6f : 0.9f) / Scl.scl(), 700.0f);
        dialog.cont.add((Element)main).width(width).growY();
        main.top();
        main.defaults().growX();
        main.table(infoTable -> this.rebuildInfoTable(unit, (Table)infoTable)).row();
        main.defaults().padTop(12.0f);
        main.table(itemTable -> this.rebuildItemTable(unit, (Table)itemTable)).row();
        main.table(propertiesTable -> this.rebuildPropertiesTable(unit, (Table)propertiesTable)).row();
        main.table(teamTable -> this.rebuildTeamTable(unit, (Table)teamTable)).row();
        main.table(bottomTable -> {
            bottomTable.left();
            bottomTable.defaults().grow().uniformY();
            bottomTable.table(effectTable -> this.rebuildEffectsTable(unit, (Table)effectTable)).fillX().row();
            bottomTable.defaults().padTop(16.0f);
            bottomTable.table(payloadTable -> this.rebuildPayloadTable(unit, (Table)payloadTable)).fillX();
        }).padTop(8.0f).growY();
        dialog.addCloseButton();
        dialog.buttons.button("\u91cd\u7f6e", (Drawable)Icon.refresh, () -> {
            UnitFactoryDialog.resetUnit(unit);
            this.rebuildTables();
        });
        dialog.show();
    }

    private static Unit cloneUnit(Unit unit) {
        Unit cloned = unit.type.create(unit.team);
        cloned.health = unit.health;
        cloned.shield = unit.shield;
        cloned.stack.set(unit.stack.item, unit.stack.amount);
        cloned.elevation = unit.elevation;
        cloned.set((Position)unit);
        if (unit instanceof Payloadc) {
            Payloadc payloadUnit = (Payloadc)unit;
            if (cloned instanceof Payloadc) {
                Payloadc clonedPayloadUnit = (Payloadc)cloned;
                for (Payload payload : payloadUnit.payloads()) {
                    Payload copied = UnitFactoryDialog.clonePayload(payload);
                    clonedPayloadUnit.addPayload(copied);
                }
            }
        }
        Seq statusEntries = cloned.statuses();
        statusEntries.set(unit.statuses());
        statusEntries.replace(UnitFactoryDialog::cloneStatus);
        return cloned;
    }

    private static void resetUnit(Unit unit) {
        unit.setType(unit.type);
        unit.elevation = Mathf.num((boolean)unit.type.flying);
        unit.statuses().clear();
        if (unit instanceof Payloadc) {
            Payloadc pay = (Payloadc)unit;
            pay.payloads().clear();
        }
    }

    private static StatusEntry cloneStatus(StatusEntry entry) {
        StatusEntry cloned = new StatusEntry().set(entry.effect, entry.time);
        if (entry.effect.dynamic) {
            cloned.damageMultiplier = entry.damageMultiplier;
            cloned.healthMultiplier = entry.healthMultiplier;
            cloned.speedMultiplier = entry.speedMultiplier;
            cloned.reloadMultiplier = entry.reloadMultiplier;
            cloned.buildSpeedMultiplier = entry.buildSpeedMultiplier;
            cloned.dragMultiplier = entry.dragMultiplier;
            cloned.armorOverride = entry.armorOverride;
        }
        return cloned;
    }

    private static Payload clonePayload(Payload payload) {
        if (payload instanceof BuildPayload) {
            BuildPayload buildPayload = (BuildPayload)payload;
            Building build = buildPayload.build;
            return new BuildPayload(build.block, build.team);
        }
        if (payload instanceof UnitPayload) {
            UnitPayload unitPayload = (UnitPayload)payload;
            Unit unit = UnitFactoryDialog.cloneUnit(unitPayload.unit);
            return new UnitPayload(unit);
        }
        throw new IllegalArgumentException("Unknown payload type: " + payload);
    }

    private static class UnitStack {
        private static Seq<UnitStack> classedUnits;
        public static UnitStack vanillaStack;
        @Nullable
        public Mods.LoadedMod mod;
        public Seq<UnitType> units = new Seq();

        public UnitStack(Mods.LoadedMod mod) {
            this.mod = mod;
        }

        public String name() {
            return this.mod == null ? Core.bundle.get("vanilla", "\u539f\u7248") : this.mod.meta.displayName;
        }

        public TextureRegion icon() {
            return this.mod == null ? Blocks.duo.uiIcon : (this.mod.iconTexture != null ? new TextureRegion(this.mod.iconTexture) : null);
        }

        private static Seq<UnitStack> getUnitStacks() {
            if (classedUnits == null) {
                UnitStack.initClassedUnits();
            }
            return classedUnits;
        }

        private static void initClassedUnits() {
            classedUnits = new Seq();
            classedUnits.add((Object)vanillaStack);
            Vars.content.units().each(unit -> {
                if (unit.isVanilla()) {
                    UnitStack.vanillaStack.units.add((Object)unit);
                } else {
                    Mods.LoadedMod mod = unit.minfo.mod;
                    UnitStack stack = (UnitStack)classedUnits.find(s -> s.mod == mod);
                    if (stack == null) {
                        stack = new UnitStack(mod);
                        classedUnits.add((Object)stack);
                    }
                    stack.units.add((Object)unit);
                }
            });
        }

        static {
            vanillaStack = new UnitStack(null);
        }
    }
}

