/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features.ui;

import arc.Events;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Floatf;
import arc.func.Func;
import arc.graphics.g2d.TextureRegion;
import arc.scene.Element;
import arc.scene.event.Touchable;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Interval;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.UnitTypes;
import mindustry.core.UI;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.type.UnitType;
import mindustry.ui.Styles;
import mindustryX.features.UIExt;
import mindustryX.features.ui.FormatDefault;

public class TeamsStatDisplay
extends Table {
    private final float fontScl = 0.8f;
    private final Interval timer = new Interval();
    public final Seq<Teams.TeamData> teams = new Seq();
    public final Seq<Team> manualDeleted = new Seq();
    private boolean showStat = true;
    private boolean showItem = true;
    private boolean showUnit = true;

    public TeamsStatDisplay() {
        this.background(Styles.black6);
        this.update(() -> {
            if (this.timer.get(120.0f)) {
                this.rebuild();
            }
        });
        Events.on(EventType.ResetEvent.class, e -> {
            this.manualDeleted.clear();
            this.teams.clear();
            this.clearChildren();
        });
    }

    public Table wrapped() {
        Table table2 = new Table();
        table2.button("\u7f16\u8f91\u961f\u4f0d", Styles.flatBordert, () -> UIExt.teamSelect.select((Boolf<Team>)((Boolf)team -> this.teams.contains((Object)team.data())), (Cons<Team>)((Cons)team -> {
            this.manualDeleted.remove(team);
            if (this.teams.contains((Object)team.data())) {
                this.teams.remove((Object)team.data());
                this.manualDeleted.add(team);
            } else {
                this.teams.add((Object)team.data());
            }
            this.rebuild();
        }))).fillX().row();
        table2.add((Element)this).growX().touchable(Touchable.disabled).row();
        table2.table(buttons -> {
            buttons.defaults().size(40.0f);
            buttons.button(Blocks.worldProcessor.emoji(), Styles.flatTogglet, () -> {
                this.showStat = !this.showStat;
                this.rebuild();
            }).checked(a -> this.showStat);
            buttons.button(((Item)((Object)((Object)Vars.content.items().get(0)))).emoji(), Styles.flatTogglet, () -> {
                this.showItem = !this.showItem;
                this.rebuild();
            }).checked(a -> this.showItem);
            buttons.button(UnitTypes.mono.emoji(), Styles.flatTogglet, () -> {
                this.showUnit = !this.showUnit;
                this.rebuild();
            }).checked(a -> this.showUnit);
        }).row();
        return table2;
    }

    private void rebuild() {
        boolean show;
        Vars.state.teams.getActive().each(arg_0 -> this.teams.addUnique(arg_0));
        if (Vars.state.rules.waveTimer) {
            this.teams.addUnique((Object)Vars.state.rules.waveTeam.data());
        }
        this.teams.removeAll(it -> this.manualDeleted.contains((Object)it.team));
        this.teams.sort(teamData -> -teamData.cores.size);
        this.clearChildren();
        this.addTeamData(Icon.players.getRegion(), (Func<Teams.TeamData, CharSequence>)((Func)team -> team.team.id < 6 ? team.team.localized() : String.valueOf(team.team.id)));
        this.addTeamData(Blocks.coreNucleus.uiIcon, (Func<Teams.TeamData, CharSequence>)((Func)team -> UI.formatAmount(team.cores.size)));
        this.addTeamData(UnitTypes.mono.uiIcon, (Func<Teams.TeamData, CharSequence>)((Func)team -> UI.formatAmount(team.units.size)));
        this.addTeamData(UnitTypes.gamma.uiIcon, (Func<Teams.TeamData, CharSequence>)((Func)team -> String.valueOf(team.players.size)));
        if (this.showStat) {
            this.image().color(Pal.accent).fillX().height(1.0f).colspan(999).padTop(3.0f).padBottom(3.0f).row();
            this.addTeamDataCheckB(Blocks.siliconSmelter.uiIcon, (Boolf<Teams.TeamData>)((Boolf)team -> team.team.rules().cheat));
            this.addTeamDataCheck(Blocks.arc.uiIcon, (Floatf<Teams.TeamData>)((Floatf)team -> Vars.state.rules.blockDamage(team.team)));
            this.addTeamDataCheck(Blocks.titaniumWall.uiIcon, (Floatf<Teams.TeamData>)((Floatf)team -> Vars.state.rules.blockHealth(team.team)));
            this.addTeamDataCheck(Blocks.buildTower.uiIcon, (Floatf<Teams.TeamData>)((Floatf)team -> Vars.state.rules.buildSpeed(team.team)));
            this.addTeamDataCheck(UnitTypes.corvus.uiIcon, (Floatf<Teams.TeamData>)((Floatf)team -> Vars.state.rules.unitDamage(team.team)));
            this.addTeamDataCheck(UnitTypes.oct.uiIcon, (Floatf<Teams.TeamData>)((Floatf)team -> Vars.state.rules.unitHealth(team.team)));
            this.addTeamDataCheck(UnitTypes.zenith.uiIcon, (Floatf<Teams.TeamData>)((Floatf)team -> Vars.state.rules.unitCrashDamage(team.team)));
            this.addTeamDataCheck(Blocks.tetrativeReconstructor.uiIcon, (Floatf<Teams.TeamData>)((Floatf)team -> Vars.state.rules.unitBuildSpeed(team.team)));
            this.addTeamDataCheck(Blocks.basicAssemblerModule.uiIcon, (Floatf<Teams.TeamData>)((Floatf)team -> Vars.state.rules.unitCost(team.team)));
        }
        if (this.showItem) {
            this.image().color(Pal.accent).fillX().height(1.0f).colspan(999).padTop(3.0f).padBottom(3.0f).row();
            for (Item item : Vars.content.items()) {
                show = false;
                for (Teams.TeamData team2 : this.teams) {
                    if (!team2.hasCore() || team2.core().items.get(item) <= 0) continue;
                    show = true;
                }
                if (!show) continue;
                this.addTeamData(item.uiIcon, (Func<Teams.TeamData, CharSequence>)((Func)team -> team.hasCore() && team.core().items.get(item) > 0 ? UI.formatAmount(team.core().items.get(item)) : "-"));
            }
        }
        if (this.showUnit) {
            this.image().color(Pal.accent).fillX().height(1.0f).colspan(999).padTop(3.0f).padBottom(3.0f).row();
            for (UnitType unit : Vars.content.units()) {
                show = false;
                for (Teams.TeamData team2 : this.teams) {
                    if (team2.countType(unit) <= 0) continue;
                    show = true;
                }
                if (!show) continue;
                this.addTeamData(unit.uiIcon, (Func<Teams.TeamData, CharSequence>)((Func)team -> team.countType(unit) > 0 ? String.valueOf(team.countType(unit)) : "-"));
            }
        }
    }

    private void addTeamDataCheck(TextureRegion icon, Floatf<Teams.TeamData> checked) {
        if (this.teams.isEmpty() || this.teams.allMatch(it -> checked.get(it) == 1.0f)) {
            return;
        }
        float value = checked.get((Object)((Teams.TeamData)this.teams.get(0)));
        if (this.teams.allMatch(it -> checked.get(it) == value)) {
            this.addTeamData(icon, FormatDefault.format(value));
            return;
        }
        this.addTeamData(icon, (Func<Teams.TeamData, CharSequence>)((Func)team -> FormatDefault.format(checked.get(team))));
    }

    private void addTeamDataCheckB(TextureRegion icon, Boolf<Teams.TeamData> checked) {
        if (this.teams.isEmpty() || this.teams.allMatch(it -> !checked.get(it))) {
            return;
        }
        boolean value = checked.get((Object)((Teams.TeamData)this.teams.get(0)));
        if (this.teams.allMatch(it -> checked.get(it) == value)) {
            this.addTeamData(icon, value ? "+" : "x");
            return;
        }
        this.addTeamData(icon, (Func<Teams.TeamData, CharSequence>)((Func)team -> checked.get(team) ? "+" : "\u00d7"));
    }

    private void addTeamData(TextureRegion icon, String value) {
        this.image(icon).size(15.0f, 15.0f).left();
        this.add(value).color(Pal.accent).align(1).fontScale(0.8f).colspan(this.getColumns() - 1);
        this.row();
    }

    private void addTeamData(TextureRegion icon, Func<Teams.TeamData, CharSequence> teamFunc) {
        this.image(icon).size(15.0f, 15.0f).left();
        for (Teams.TeamData teamData : this.teams) {
            this.label(() -> (CharSequence)teamFunc.get((Object)teamData)).color(teamData.team.color).padLeft(2.0f).expandX().uniformX().fontScale(0.8f);
        }
        this.row();
    }
}

