/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features.ui;

import arc.Core;
import arc.Events;
import arc.func.Cons;
import arc.graphics.Color;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Label;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Collapser;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectIntMap;
import arc.struct.ObjectSet;
import arc.util.Interval;
import arc.util.Scaling;
import java.util.Arrays;
import java.util.List;
import kotlin.collections.CollectionsKt;
import mindustry.Vars;
import mindustry.core.UI;
import mindustry.entities.Units;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.graphics.Pal;
import mindustry.type.Category;
import mindustry.type.Item;
import mindustry.type.ItemSeq;
import mindustry.type.ItemStack;
import mindustry.type.UnitType;
import mindustry.ui.Bar;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.power.BeamNode;
import mindustry.world.blocks.power.PowerGraph;
import mindustry.world.blocks.power.PowerNode;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.modules.ItemModule;
import mindustryX.features.SettingsV2;
import mindustryX.features.UIExt;
import mindustryX.features.UIExtKt;
import mindustryX.features.ui.OverlayUI;
import mindustryX.features.ui.comp.GridTable;

public class NewCoreItemsDisplay
extends Table {
    public static final float COLUMN_WIDTH = 96.0f;
    private Table itemsTable;
    private Table unitsTable;
    private Table plansTable;
    private Table powerTable;
    private static final Interval timer = new Interval(2);
    private final int[] itemDelta;
    private final int[] lastItemAmount;
    private final ObjectSet<Item> usedItems = new ObjectSet();
    private final ObjectSet<UnitType> usedUnits = new ObjectSet();
    private final ItemSeq planItems = new ItemSeq();
    private final ObjectIntMap<Block> planCounter = new ObjectIntMap();
    private final SettingsV2.Data<Boolean> showItem = new SettingsV2.CheckPref("coreItems.showItem", true);
    private final SettingsV2.Data<Boolean> showUnit = new SettingsV2.CheckPref("coreItems.showUnit", true);
    private final SettingsV2.Data<Boolean> showPlan = new SettingsV2.CheckPref("coreItems.showPlan", true);
    private final SettingsV2.Data<Boolean> showPower = new SettingsV2.CheckPref("coreItems.showPower", true);
    public final List<SettingsV2.Data<?>> settings = CollectionsKt.listOf(this.showItem, this.showUnit, this.showPlan, this.showPower);
    private float balance;
    private float stored;
    private float capacity;
    private float produced;
    private float need;
    private float satisfaction;

    public NewCoreItemsDisplay() {
        this.itemDelta = new int[Vars.content.items().size];
        this.lastItemAmount = new int[Vars.content.items().size];
        Events.on(EventType.ResetEvent.class, e -> {
            this.usedItems.clear();
            this.usedUnits.clear();
            Arrays.fill(this.itemDelta, 0);
            Arrays.fill(this.lastItemAmount, 0);
            this.plansTable.clearChildren();
        });
        this.setup();
    }

    private void setup() {
        this.touchable = Touchable.disabled;
        this.add(new OverlayUI.PreferAnyWidth()).fillX().row();
        this.powerTable = new Table(Styles.black3);
        this.add((Element)new MyCollapser(this.powerTable, this.showPower)).growX().row();
        this.itemsTable = new GridTable();
        this.add((Element)new MyCollapser(this.itemsTable, this.showItem)).growX().row();
        this.unitsTable = new GridTable();
        this.add((Element)new MyCollapser(this.unitsTable, this.showUnit)).growX().row();
        Cell emptyLine = this.row().add();
        this.plansTable = new GridTable();
        this.row().add((Element)new MyCollapser(this.plansTable, this.showPlan)).growX().row();
        this.buildItems();
        this.buildUnits();
        this.plansTable.background(Styles.black3);
        this.update(() -> {
            float newHeight;
            float f = newHeight = this.plansTable.hasChildren() ? 12.0f : 0.0f;
            if (emptyLine.maxHeight() != newHeight) {
                emptyLine.height(newHeight);
                emptyLine.getTable().invalidate();
            }
        });
        this.plansTable.update(() -> {
            if (timer.get(1, 10.0f)) {
                this.rebuildPlans();
            }
        });
        this.buildPower();
    }

    private void buildPower() {
        this.powerTable.update(() -> {
            this.balance = 0.0f;
            this.stored = 0.0f;
            this.capacity = 0.0f;
            this.produced = 0.0f;
            this.need = 0.0f;
            Groups.powerGraph.each(item -> {
                PowerGraph graph = item.graph();
                if (graph.all.isEmpty() || ((Building)graph.all.first()).team != Vars.player.team()) {
                    return;
                }
                this.balance += graph.getPowerBalance();
                this.stored += graph.getLastPowerStored();
                this.capacity += graph.getLastCapacity();
                this.produced += graph.getLastPowerProduced();
                this.need += graph.getLastPowerNeeded();
            });
            this.balance *= 60.0f;
            this.satisfaction = this.produced == 0.0f ? 1.0f : (this.need == 0.0f ? 1.0f : Mathf.clamp((float)(this.produced / this.need), (float)0.0f, (float)1.0f));
        });
        this.powerTable.margin(2.0f).stack(new Element[]{new Bar("", Pal.powerBar, () -> this.capacity == 0.0f ? (float)(this.balance > 0.0f ? 1 : 0) : this.stored / this.capacity), new Table(t -> {
            t.add().growX();
            t.label(() -> Core.bundle.format("bar.powerbalance", new Object[]{(this.balance >= 0.0f ? "+" : "") + UI.formatAmount((long)this.balance)}) + (this.satisfaction >= 1.0f ? "" : " [gray]" + (int)(this.satisfaction * 100.0f) + "%[]"));
            t.add().width(16.0f);
            t.label(() -> Core.bundle.format("bar.powerstored", new Object[]{UI.formatAmount((long)this.stored), UI.formatAmount((long)this.capacity)}));
            t.add().growX();
        })}).growX();
    }

    public void sharePowerInfo() {
        UIExt.shareMessage('\ue810', Core.bundle.format("bar.powerbalance", new Object[]{(this.balance >= 0.0f ? "[accent]+" : "[red]") + UI.formatAmount((long)this.balance) + "[]"}) + (this.satisfaction >= 1.0f ? "" : " [gray]" + (int)(this.satisfaction * 100.0f) + "%[]") + "  " + Core.bundle.format("bar.powerstored", new Object[]{UI.formatAmount((long)this.stored), UI.formatAmount((long)this.capacity)}));
    }

    public void shareItemInfo() {
        UIExtKt.showFloatSettingsPanel((Cons<Table>)((Cons)table2 -> {
            GridTable grid = new GridTable();
            grid.defaults().size(32.0f).pad(4.0f);
            for (Item item : Vars.content.items()) {
                if (!this.usedItems.contains((Object)item)) continue;
                grid.button((Drawable)new TextureRegionDrawable(item.uiIcon), Styles.clearNonei, 32.0f, () -> this.shareItemInfo(item));
            }
            table2.add((Element)grid).growX().maxWidth(320.0f).row();
        }));
    }

    public void shareItemInfo(Item item) {
        if (Vars.player.dead() || Vars.player.team().core() == null) {
            return;
        }
        UIExt.shareMessage(item.hasEmoji() ? (char)item.emoji().charAt(0) : (char)'\uf838', Core.bundle.format("mdtx.share.item", new Object[]{item.localizedName, this.lastItemAmount[item.id] > 100 ? UI.formatAmount(this.lastItemAmount[item.id]) : "[red]" + this.lastItemAmount[item.id] + "[]", (this.itemDelta[item.id] > 0 ? "[accent]+" : "[red]") + UI.formatAmount(this.itemDelta[item.id]) + "[]"}));
    }

    public void shareUnitInfo() {
        UIExtKt.showFloatSettingsPanel((Cons<Table>)((Cons)table2 -> {
            GridTable grid = new GridTable();
            grid.defaults().size(32.0f).pad(4.0f);
            for (UnitType unit : Vars.content.units()) {
                if (!this.usedUnits.contains((Object)unit)) continue;
                grid.button((Drawable)new TextureRegionDrawable(unit.uiIcon), Styles.clearNonei, 32.0f, () -> this.shareUnitInfo(unit));
            }
            table2.add((Element)grid).growX().maxWidth(320.0f).row();
        }));
    }

    public void shareUnitInfo(UnitType item) {
        int limit;
        if (Vars.player.dead() || Vars.player.team().core() == null) {
            return;
        }
        int count = Vars.player.team().data().countType(item);
        String color = count == (limit = Units.getCap(Vars.player.team())) ? "orange" : (count < 10 ? "red" : "accent");
        UIExt.shareMessage('\ue86d', Core.bundle.format("mdtx.share.unit", new Object[]{item.emoji() + item.localizedName, "[" + color + "]" + count + "[]", limit}));
    }

    private void updateItemMeans() {
        if (!timer.get(0, 60.0f)) {
            return;
        }
        ItemModule items = Vars.player.team().items();
        for (Item item : this.usedItems) {
            short id = item.id;
            int coreAmount = items.get((int)id);
            int lastAmount = this.lastItemAmount[id];
            this.itemDelta[id] = coreAmount - lastAmount;
            this.lastItemAmount[id] = coreAmount;
        }
    }

    private void buildItems() {
        this.itemsTable.update(this::updateItemMeans);
        this.itemsTable.background(Styles.black3);
        this.itemsTable.defaults().width(96.0f);
        for (Item item : Vars.content.items()) {
            this.itemsTable.table(amountTable -> {
                amountTable.visible(() -> this.usedItems.contains((Object)item) || Vars.player.team().items().get(item) > 0 && this.usedItems.add((Object)item));
                amountTable.stack(new Element[]{new Table(t -> t.image(item.uiIcon).size(28.0f).scaling(Scaling.fit).pad(2.0f).tooltip(tooltip -> tooltip.background(Styles.black6).margin(4.0f).add((CharSequence)item.localizedName).style((Style)Styles.outlineLabel))), new Table(t -> t.label(() -> {
                    int update = this.itemDelta[item.id];
                    if (update == 0) {
                        return "";
                    }
                    return (update < 0 ? "[red]" : "[green]+") + UI.formatAmount(update);
                }).fontScale(0.85f)).top().left()});
                amountTable.defaults().expand().left();
                Table right = (Table)amountTable.table().get();
                Label amountLabel = (Label)right.add((CharSequence)"").growY().get();
                right.row();
                Cell planLabel = right.add((CharSequence)"").fontScale(0.6f).height(0.01f);
                amountTable.update(() -> {
                    int planAmount = this.planItems.get(item);
                    int amount = Vars.player.team().items().get(item);
                    float newFontScale = 1.0f;
                    Color amountColor = Color.white;
                    if (planAmount == 0) {
                        CoreBlock.CoreBuild core = Vars.player.team().core();
                        if (core != null && (double)amount >= (double)core.storageCapacity * 0.99) {
                            amountColor = Pal.accent;
                        }
                        planLabel.height(0.01f);
                        ((Label)planLabel.get()).setText((CharSequence)"");
                    } else {
                        amountColor = amount > planAmount ? Color.green : (amount > planAmount / 2 ? Pal.stat : Color.scarlet);
                        planLabel.height(Float.NEGATIVE_INFINITY);
                        planLabel.color(planAmount > 0 ? Color.scarlet : Color.green);
                        ((Label)planLabel.get()).setText((CharSequence)UI.formatAmount(planAmount));
                        newFontScale = 0.7f;
                    }
                    if (amountLabel.getFontScaleX() != newFontScale) {
                        amountLabel.setFontScale(newFontScale);
                    }
                    amountLabel.setColor(amountColor);
                    amountLabel.setText((CharSequence)UI.formatAmount(amount));
                });
            }).expandX().left();
        }
    }

    private void buildUnits() {
        this.unitsTable.background(Styles.black3);
        this.unitsTable.defaults().width(96.0f);
        for (UnitType unit : Vars.content.units()) {
            this.unitsTable.table(tt -> {
                tt.visible(() -> this.usedUnits.contains((Object)unit) || Vars.player.team().data().countType(unit) > 0 && this.usedUnits.add((Object)unit));
                tt.image(unit.uiIcon).size(24.0f).scaling(Scaling.fit).pad(2.0f).tooltip(t -> t.background(Styles.black6).margin(4.0f).add((CharSequence)unit.localizedName).style((Style)Styles.outlineLabel));
                tt.label(() -> {
                    int typeCount = Vars.player.team().data().countType(unit);
                    return (typeCount == Units.getCap(Vars.player.team()) ? "[stat]" : "") + typeCount;
                }).expandX().left();
            });
        }
    }

    private void rebuildPlans() {
        this.planItems.clear();
        this.planCounter.clear();
        Vars.control.input.allPlans().each(plan -> {
            Block block = plan.block;
            if (block instanceof CoreBlock) {
                return;
            }
            Building patt11962$temp = plan.build();
            if (patt11962$temp instanceof ConstructBlock.ConstructBuild) {
                ConstructBlock.ConstructBuild build = (ConstructBlock.ConstructBuild)patt11962$temp;
                block = build.current;
            }
            this.planCounter.increment((Object)block, plan.breaking ? -1 : 1);
            for (ItemStack stack : block.requirements) {
                int planAmount = (int)(plan.breaking ? -Vars.state.rules.buildCostMultiplier * Vars.state.rules.deconstructRefundMultiplier * (float)stack.amount * plan.progress : Vars.state.rules.buildCostMultiplier * (float)stack.amount * (1.0f - plan.progress));
                this.planItems.add(stack.item, planAmount);
            }
        });
        this.plansTable.clearChildren();
        if (this.planCounter.isEmpty()) {
            return;
        }
        this.plansTable.defaults().width(96.0f);
        for (Block block : Vars.content.blocks()) {
            int count = this.planCounter.get((Object)block, 0);
            if (count == 0 || block.category == Category.distribution && block.size < 3 || block.category == Category.liquid && block.size < 3 || block instanceof PowerNode || block instanceof BeamNode) continue;
            this.plansTable.table(t -> {
                t.image(block.uiIcon).size(24.0f).scaling(Scaling.fit).pad(2.0f);
                t.label(() -> (count > 0 ? "[green]+" : "[red]") + count).expandX().left();
            });
        }
    }

    public boolean hadItem(Item item) {
        return this.usedItems.contains((Object)item);
    }

    static class MyCollapser
    extends Collapser {
        Table table;

        MyCollapser(Table table2, SettingsV2.Data<Boolean> visible) {
            super(table2, (Boolean)visible.get() == false);
            this.table = table2;
            this.setCollapsed(() -> (Boolean)visible.get() == false);
        }

        public float getMinWidth() {
            return this.isCollapsed() ? 0.0f : this.table.getMinWidth();
        }
    }
}

