/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features.ui;

import arc.Core;
import arc.Events;
import arc.flabel.FLabel;
import arc.func.Cons;
import arc.func.ConsT;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.g2d.TextureRegion;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.actions.Actions;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Label;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Http;
import arc.util.Log;
import arc.util.Reflect;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.io.JsonIO;
import mindustry.mod.ModListing;
import mindustry.ui.BorderImage;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustryX.features.ui.comp.Card;

public class ModsRecommendDialog
extends BaseDialog {
    private static final TextureRegion defaultModIcon = ((TextureRegionDrawable)Tex.nomap).getRegion();
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    public static Color lightBlue = Color.valueOf((String)"#a5dee5");
    public static Color pink = Color.valueOf((String)"#ffcfdf");
    private ObjectMap<String, TextureRegion> textureCache;
    private RecommendMeta meta;
    private boolean fetchModList;

    public ModsRecommendDialog() {
        super("");
        this.setup();
        this.shown(this::rebuild);
        this.addCloseButton();
        Events.run((Object)EventType.Trigger.importMod, () -> Core.app.post(this::rebuild));
    }

    private void setup() {
        this.titleTable.clearChildren();
    }

    private void rebuild() {
        if (this.textureCache == null) {
            this.textureCache = (ObjectMap)Reflect.get((Object)((Object)Vars.ui.mods), (String)"textureCache");
        }
        if (this.meta == null) {
            String json = Core.files.internal("recommendMods.json").readString();
            this.meta = (RecommendMeta)JsonIO.json.fromJson(RecommendMeta.class, json);
        }
        if (!this.fetchModList) {
            ModsRecommendDialog.setLoading(this.cont);
            Vars.ui.mods.getModList(0, (Cons<Seq<ModListing>>)((Cons)modListings -> {
                if (modListings == null) {
                    ModsRecommendDialog.setLoadFailed(this.cont);
                    return;
                }
                for (RecommendModMeta modMeta : this.meta.modRecommend) {
                    modMeta.listing = (ModListing)modListings.find(modListing -> modMeta.repo.equals(modListing.repo));
                }
                this.fetchModList = true;
                this.rebuildCont();
            }));
            return;
        }
        this.rebuildCont();
    }

    private void rebuildCont() {
        float width = Math.min((float)Core.graphics.getWidth() / Scl.scl((float)1.05f), 556.0f);
        this.cont.top().clearChildren();
        this.cont.add((Element)new Card(Pal.lightishGray, Card.grayOuterDark, (Cons<Table>)((Cons)info -> {
            info.top();
            info.defaults().expandX().center();
            info.add((CharSequence)"@mods.recommend").pad(12.0f).row();
            info.add((CharSequence)Core.bundle.format("mods.recommend.lastUpdated", new Object[]{this.meta.lastUpdated})).pad(6.0f).row();
            info.add((CharSequence)"@mods.recommend.info").pad(6.0f);
            for (Element child : info.getChildren()) {
                if (!(child instanceof Label)) continue;
                Label label = (Label)child;
                label.setColor(Pal.accent);
                label.setStyle(Styles.outlineLabel);
            }
        }))).fillX();
        this.cont.row();
        this.cont.pane(Styles.noBarPane, t -> {
            t.background(Tex.whiteui).setColor(Pal.lightishGray);
            for (RecommendModMeta modMeta : this.meta.modRecommend) {
                if (modMeta.listing == null) {
                    Log.warn((String)"Recommend Mod '@' not found in github.", (Object[])new Object[]{modMeta.repo});
                    continue;
                }
                t.table(Tex.whiteui, card -> this.setupModCard((Table)card, modMeta)).color(Pal.darkerGray).width(width).pad(12.0f).with(card -> {
                    if (this.installed(modMeta)) {
                        card.addAction((Action)Actions.color((Color)Pal.accent, (float)1.5f));
                    }
                });
                Card.cardShadow(t);
                t.row();
            }
        }).scrollX(false);
    }

    private void setupModCard(Table table2, RecommendModMeta modMeta) {
        table2.defaults().growX();
        ModListing modListing = modMeta.listing;
        table2.table(title -> {
            title.add((Element)new Card(Pal.gray, Card.grayOuterDark, (Cons<Table>)((Cons)info -> {
                info.top();
                info.defaults().padTop(2.0f).expandX().left();
                this.addInfo((Table)info, "name", modListing.name).color(Pal.accent).pad(8.0f);
                this.addInfo((Table)info, "author", modListing.author).color(pink).padTop(4.0f);
                this.addInfo((Table)info, "minGameVersion", modListing.minGameVersion).color(lightBlue);
                this.addInfo((Table)info, "lastUpdated", this.getLastUpdatedTime(modListing)).color(lightBlue);
                this.addInfo((Table)info, "stars", modListing.stars).color(lightBlue);
                for (Element child : info.getChildren()) {
                    if (!(child instanceof Label)) continue;
                    Label label = (Label)child;
                    label.setStyle(Styles.outlineLabel);
                }
            }))).pad(4.0f).padRight(12.0f).grow();
            title.add((Element)new BorderImage(){
                {
                    this.border(Pal.darkestGray);
                }
            }).size(128.0f).pad(4.0f).with(image -> this.getModIcon(modMeta.repo, (Cons<TextureRegion>)((Cons)arg_0 -> ((Object)((Object)image)).setDrawable(arg_0))));
        });
        table2.row();
        table2.add((Element)new Card(Pal.gray, Card.grayOuterDark, (Cons<Table>)((Cons)body -> {
            body.add((CharSequence)modMeta.reason).pad(4.0f).grow().wrap();
            body.addChild((Element)new Table(buttons -> {
                buttons.setFillParent(true);
                buttons.right().bottom();
                buttons.defaults().size(32.0f);
                buttons.button((Drawable)Icon.download, Styles.cleari, 24.0f, () -> Vars.ui.mods.githubImportMod(modListing.repo, modListing.hasJava));
            }));
        }))).minHeight(48.0f).pad(8.0f);
    }

    private Cell<?> addInfo(Table table2, String bundle, Object value) {
        Cell cell = table2.add((CharSequence)Core.bundle.format("mods.recommend.mod." + bundle, new Object[]{value})).color(pink);
        table2.row();
        return cell;
    }

    private boolean installed(RecommendModMeta modMeta) {
        return Vars.mods.list().find(mod -> modMeta.repo.equals(mod.getRepo())) != null;
    }

    private String getLastUpdatedTime(ModListing listing) {
        try {
            Date date = dateFormat.parse(listing.lastUpdated);
            return DateFormat.getInstance().format(date);
        }
        catch (ParseException e) {
            return "Unknown";
        }
    }

    private void getModIcon(String repo, Cons<TextureRegion> callback) {
        TextureRegion cache = (TextureRegion)this.textureCache.get((Object)repo);
        if (cache != null) {
            callback.get((Object)cache);
            return;
        }
        Http.get("https://raw.githubusercontent.com/Anuken/MindustryMods/master/icons/" + repo.replace("/", "_"), (ConsT<Http.HttpResponse, Exception>)((ConsT)res -> {
            Pixmap pix = new Pixmap(res.getResult());
            Core.app.post(() -> {
                try {
                    Texture texture = new Texture(pix);
                    texture.setFilter(Texture.TextureFilter.linear);
                    TextureRegion region = new TextureRegion(texture);
                    this.textureCache.put((Object)repo, (Object)region);
                    pix.dispose();
                    callback.get((Object)region);
                }
                catch (Exception e) {
                    Log.err((Throwable)e);
                    this.textureCache.put((Object)repo, (Object)defaultModIcon);
                    callback.get((Object)defaultModIcon);
                }
            });
        }), (Cons<Throwable>)((Cons)err -> {
            this.textureCache.put((Object)repo, (Object)defaultModIcon);
            callback.get((Object)defaultModIcon);
        }));
    }

    private static void setLoading(Table table2) {
        table2.clearChildren();
        table2.add((Element)new FLabel((CharSequence)"@alphaLoading")).style((Style)Styles.outlineLabel).expand().center();
    }

    private static void setLoadFailed(Table table2) {
        table2.clearChildren();
        table2.add((Element)new FLabel((CharSequence)"@alphaLoadFailed")).style((Style)Styles.outlineLabel).expand().center();
    }

    private static class RecommendMeta {
        public String lastUpdated;
        public Seq<RecommendModMeta> modRecommend;

        private RecommendMeta() {
        }
    }

    private static class RecommendModMeta {
        public String repo;
        public String reason;
        public ModListing listing;

        private RecommendModMeta() {
        }
    }
}

