/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features.ui;

import arc.Core;
import arc.math.Rand;
import arc.scene.Element;
import arc.scene.ui.Label;
import arc.scene.ui.layout.WidgetGroup;
import arc.util.Time;
import arc.util.Timer;
import mindustryX.features.SettingsV2;

public class MenuFloatLabel
extends WidgetGroup {
    private static final SettingsV2.CheckPref enable = new SettingsV2.CheckPref("gameUI.menuFloatText", true);
    private static final float period = 75.0f;
    private static final float varSize = 0.8f;
    private final Label textLabel;
    private final String[] labels;
    public float baseScale = 1.0f;
    private long lastVisible;

    public MenuFloatLabel() {
        this.setTransform(true);
        this.setRotation(20.0f);
        this.textLabel = new Label((CharSequence)"");
        this.addChild((Element)this.textLabel);
        this.visible(enable::get);
        this.textLabel.setAlignment(1);
        this.update(() -> {
            this.textLabel.setFontScale(this.baseScale * Math.abs(Time.time % 75.0f / 75.0f - 0.5f) * 0.8f + 1.0f);
            if (Core.graphics.getFrameId() - this.lastVisible > 1L) {
                this.randomLabel();
            }
            this.lastVisible = Core.graphics.getFrameId();
        });
        this.labels = Core.files.internal("labels").readString("UTF-8").replace("\r", "").replace("\\n", "\n").replace("/n", "\n").split("\n");
        this.randomLabel();
    }

    public void randomLabel() {
        Timer.schedule(() -> this.textLabel.setText((CharSequence)("[yellow]" + this.labels[new Rand().random(0, this.labels.length - 1)])), (float)0.11f);
    }

    static {
        enable.addFallbackName("menuFloatText");
    }
}

