/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features.ui;

import arc.Core;
import arc.func.Cons;
import arc.graphics.Color;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.ui.Label;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.Slider;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.core.GameState;
import mindustry.game.Schematic;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.logic.LCanvas;
import mindustry.logic.LExecutor;
import mindustry.logic.LVar;
import mindustry.logic.LogicDialog;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.blocks.logic.LogicBlock;
import mindustry.world.blocks.logic.MemoryBlock;
import mindustryX.features.SettingsV2;
import mindustryX.features.UIExt;
import mindustryX.features.ui.Format;

public class LogicSupport {
    public static final SettingsV2.CheckPref visible = new SettingsV2.CheckPref("logicSupport.visible", true);
    public static final SettingsV2.CheckPref changeSplash = new SettingsV2.CheckPref("logicSupport.changeSplash", true);
    public static final SettingsV2.SliderPref memoryColumns = new SettingsV2.SliderPref("logicSupport.memoryColumns", 10, 2, 15);
    public static final SettingsV2.SliderPref memoryDecimal = new SettingsV2.SliderPref("logicSupport.memoryDecimal", 0, 0, 8);
    private static float refreshTime = 15.0f;
    private static final Table varsTable = new Table();
    private static boolean refresh;
    private static boolean autoRefresh;
    @Nullable
    private static Runnable refreshExecutor;
    @Nullable
    private static LExecutor executor;
    private static boolean showVars;

    public static void init() {
        LogicDialog logic = Vars.ui.logic;
        if (Core.graphics.isPortrait()) {
            visible.set(false);
        }
        Table main = new Table(Styles.grayPanel);
        main.margin(4.0f);
        main.add((CharSequence)"\u903b\u8f91\u8f85\u52a9\u5668[gold]X[]").style((Style)Styles.outlineLabel).pad(8.0f).padBottom(12.0f).row();
        main.fill(tt -> tt.top().right().button((Drawable)Icon.cancel, Styles.clearNonei, 32.0f, visible::toggle).tooltip("\u9690\u85cf\u903b\u8f91\u8f85\u52a9\u5668"));
        main.table(LogicSupport::buildConfigTable).fillX().row();
        main.pane(Styles.noBarPane, (Element)varsTable).minHeight(450.0f).fillX().scrollX(false).width(400.0f).padTop(8.0f);
        Interval interval = new Interval();
        main.update(() -> {
            refresh = autoRefresh && interval.get(refreshTime);
        });
        logic.fill(t -> {
            t.name = "logicSupportX-toggle";
            t.visible(() -> (Boolean)visible.get() == false);
            t.left().button((Drawable)Icon.rightOpen, Styles.clearNonei, 32.0f, visible::toggle).height(150.0f);
        });
        logic.fill(t -> {
            t.name = "logicSupportX";
            t.visibility = visible::get;
            t.left().add((Element)main).pad(4.0f);
        });
    }

    public static void build(LCanvas canvas, LExecutor executor, Cons<String> consumer) {
        LogicSupport.executor = executor;
        LogicSupport.rebuildVarsTable();
        refreshExecutor = () -> {
            consumer.get((Object)canvas.save());
            LogicSupport.rebuildVarsTable();
        };
    }

    private static void buildConfigTable(Table table2) {
        table2.defaults().size(40.0f);
        table2.button((Drawable)Icon.downloadSmall, Styles.cleari, () -> {
            if (refreshExecutor != null) {
                refreshExecutor.run();
                UIExt.announce("[orange]\u5df2\u66f4\u65b0\u7f16\u8f91\u7684\u903b\u8f91\uff01");
            }
        }).tooltip("\u66f4\u65b0\u7f16\u8f91\u7684\u903b\u8f91").disabled(b -> refreshExecutor == null);
        table2.button((Drawable)Icon.eyeSmall, Styles.clearTogglei, () -> {
            changeSplash.toggle();
            String text = "[orange]\u5df2" + ((Boolean)changeSplash.get() != false ? "\u5f00\u542f" : "\u5173\u95ed") + "\u53d8\u52a8\u95ea\u70c1";
            UIExt.announce(text);
        }).checked(b -> (Boolean)changeSplash.get()).tooltip("\u53d8\u91cf\u53d8\u52a8\u95ea\u70c1");
        table2.button((Drawable)Icon.refreshSmall, Styles.clearTogglei, () -> {
            autoRefresh = !autoRefresh;
            String text = "[orange]\u5df2" + (autoRefresh ? "\u5f00\u542f" : "\u5173\u95ed") + "\u53d8\u91cf\u81ea\u52a8\u66f4\u65b0";
            UIExt.announce(text);
        }).checked(b -> autoRefresh).tooltip("\u81ea\u52a8\u5237\u65b0\u53d8\u91cf");
        table2.button((Drawable)Icon.pause, Styles.clearTogglei, () -> {
            if (Vars.state.isPaused()) {
                Vars.state.set(GameState.State.playing);
            } else {
                Vars.state.set(GameState.State.paused);
            }
            String text = Vars.state.isPaused() ? "\u5df2\u6682\u505c" : "\u5df2\u7ee7\u7eed\u6e38\u620f";
            UIExt.announce(text);
        }).checked(b -> Vars.state.isPaused()).tooltip("\u6682\u505c\u903b\u8f91(\u6e38\u620f)\u8fd0\u884c");
        table2.defaults().reset();
        Slider slider = new Slider(1.0f, 60.0f, 1.0f, false);
        slider.setValue(refreshTime);
        slider.moved(res -> {
            refreshTime = res;
        });
        Label label = new Label(() -> "\u5237\u65b0\u95f4\u9694" + (int)refreshTime);
        label.touchable = Touchable.disabled;
        table2.stack(new Element[]{slider, label}).padLeft(8.0f).growX();
    }

    private static void rebuildVarsTable() {
        varsTable.top().clearChildren();
        if (executor == null) {
            return;
        }
        varsTable.defaults().padTop(10.0f).growX();
        for (LVar v : LogicSupport.executor.allVars) {
            if (v.name.startsWith("___")) continue;
            varsTable.table(Tex.paneSolid, table2 -> {
                Label nameLabel = LogicSupport.createCopyableLabel(v.name, null, "\u590d\u5236\u53d8\u91cf\u540d\n@");
                Label valueLabel = LogicSupport.createCopyableLabel(LogicSupport.arcVarsText(v), null, "\u590d\u5236\u53d8\u91cf\u5c5e\u6027\n@");
                table2.add((Element)nameLabel).color(LogicSupport.arcVarsColor(v)).ellipsis(true).wrap().expand(3, 1).fill().get();
                table2.add((Element)valueLabel).ellipsis(true).wrap().padLeft(16.0f).expand(2, 1).fill().get();
                float[] heat = new float[]{1.0f};
                valueLabel.update(() -> {
                    String text;
                    if (refresh && !valueLabel.textEquals((CharSequence)(text = LogicSupport.arcVarsText(v)))) {
                        heat[0] = 1.0f;
                        nameLabel.setColor(LogicSupport.arcVarsColor(v));
                        valueLabel.setText((CharSequence)text);
                    }
                    table2.color.set(LogicSupport.splashColor(heat));
                });
            }).row();
        }
        varsTable.table(Tex.paneSolid, table2 -> {
            Label label = LogicSupport.createCopyableLabel("", (Element)table2, "\u590d\u5236\u4fe1\u606f\u7248\n@");
            table2.add((CharSequence)"@printbuffer").color(Color.goldenrod).center().row();
            table2.add((Element)label).labelAlign(10).wrap().minHeight(150.0f).growX();
            float[] heat = new float[]{1.0f};
            label.update(() -> {
                StringBuilder text;
                if (refresh && !label.textEquals((CharSequence)(text = LogicSupport.executor.textBuffer))) {
                    label.setText((CharSequence)text);
                    heat[0] = 1.0f;
                }
                table2.color.set(LogicSupport.splashColor(heat));
            });
        }).fillX().row();
    }

    private static Color splashColor(float[] heat) {
        if (!((Boolean)changeSplash.get()).booleanValue()) {
            return Color.white;
        }
        heat[0] = Mathf.lerpDelta((float)heat[0], (float)0.0f, (float)0.1f);
        return Tmp.c1.set(Color.white).lerp(Color.yellow, heat[0]);
    }

    private static Label createCopyableLabel(String text, @Nullable Element hitter, String hint) {
        Label label = new Label((CharSequence)text);
        hitter = hitter == null ? label : hitter;
        hitter.touchable = Touchable.enabled;
        hitter.tapped(() -> {
            String t = label.getText().toString();
            Core.app.setClipboardText(t);
            UIExt.announce(Strings.format((String)hint, (Object[])new Object[]{t}));
        });
        return label;
    }

    public static String arcVarsText(LVar s) {
        return s.isobj ? LExecutor.PrintI.toString(s.objval) : (Math.abs(s.numval - (double)((long)s.numval)) < 1.0E-5 ? (long)s.numval + "" : s.numval + "");
    }

    public static Color arcVarsColor(LVar s) {
        if (s.constant && s.name.startsWith("@")) {
            return Color.goldenrod;
        }
        if (s.constant) {
            return Pal.accent;
        }
        return LogicDialog.typeColor(s, Tmp.c1).lerp(Color.white, 0.5f);
    }

    public static void buildMemoryTools(Table table2, MemoryBlock.MemoryBuild build) {
        Table vars = new Table();
        table2.background(Styles.black3);
        table2.table(t -> {
            t.add(memoryColumns.uiElement()).minWidth(200.0f).padLeft(4.0f);
            t.add(memoryDecimal.uiElement()).minWidth(200.0f).padLeft(4.0f);
            t.button((Drawable)Icon.refresh, Styles.clearNonei, () -> {
                vars.clearChildren();
                LogicSupport.buildMemoryPane(vars, build.memory);
            });
        }).row();
        LogicSupport.buildMemoryPane(vars, build.memory);
        ((ScrollPane)table2.pane(Styles.noBarPane, (Element)vars).touchable(Touchable.disabled).maxHeight(500.0f).fillX().pad(4.0f).get()).setScrollingDisabledX(true);
        vars.update(() -> {
            vars.getCells().each(cell -> {
                if (cell.prefWidth() > cell.maxWidth()) {
                    cell.width(cell.prefWidth());
                    vars.invalidateHierarchy();
                }
            });
            if (vars.needsLayout()) {
                table2.pack();
            }
        });
    }

    public static void buildMemoryPane(Table t, double[] memory) {
        Format format = new Format((Integer)memoryDecimal.get());
        for (int i = 0; i < memory.length; ++i) {
            int finalI = i;
            t.add((CharSequence)("[" + i + "]")).color(Color.lightGray).align(8);
            t.add().width(8.0f);
            ((Label)t.label(() -> format.format((float)memory[finalI])).growX().align(16).labelAlign(16).touchable(Touchable.enabled).get()).tapped(() -> {
                Core.app.setClipboardText(memory[finalI] + "");
                UIExt.announce("[cyan]\u590d\u5236\u5185\u5b58[white]\n " + memory[finalI]);
            });
            if ((i + 1) % (Integer)memoryColumns.get() == 0) {
                t.row();
                continue;
            }
            t.add((CharSequence)"|").color(i % (Integer)memoryColumns.get() % 2 == 0 ? Color.cyan : Color.acid).padLeft(12.0f).padRight(12.0f);
        }
    }

    public static void buildLogicTools(Table table2, LogicBlock.LogicBuild build) {
        LogicBlock block = (LogicBlock)build.block;
        table2.setBackground(Styles.black3);
        Table vars = new Table();
        table2.table(t -> {
            t.defaults().size(40.0f);
            t.button((Drawable)Icon.pencil, Styles.cleari, () -> {
                if (!block.accessible()) {
                    UIExt.announce("[yellow]\u5f53\u524d\u65e0\u6743\u7f16\u8f91\uff0c\u4ec5\u4f9b\u67e5\u9605");
                }
                build.showEditDialog();
            });
            t.button((Drawable)Icon.info, Styles.cleari, () -> {
                showVars = !showVars;
                vars.clear();
                if (showVars) {
                    LogicSupport.buildLogicVarTable(vars, build.executor);
                }
            });
            t.button((Drawable)Icon.trash, Styles.cleari, () -> {
                build.links.clear();
                build.updateCode(build.code, true, null);
            }).disabled(b -> Vars.net.client()).tooltip("\u91cd\u7f6e\u6240\u6709\u94fe\u63a5");
            t.button((Drawable)Icon.paste, Styles.cleari, () -> LogicSupport.showLogicCodePickDialog(block, build)).tooltip("\u4ece\u84dd\u56fe\u4e2d\u9009\u62e9\u4ee3\u7801");
        });
        ((ScrollPane)table2.row().pane(Styles.noBarPane, (Element)vars).pad(4.0f).maxHeight(400.0f).touchable(Touchable.disabled).get()).setScrollingDisabledX(true);
        if (showVars) {
            LogicSupport.buildLogicVarTable(vars, build.executor);
        }
    }

    private static void showLogicCodePickDialog(final LogicBlock block, final LogicBlock.LogicBuild build) {
        final Seq all = Vars.schematics.all().select(it -> it.tiles.contains(s -> s.block instanceof LogicBlock));
        new BaseDialog("\u9009\u62e9\u4ee3\u7801"){
            {
                super(title);
                this.addCloseButton();
                this.closeOnBack();
                this.cont.add((CharSequence)"TIP: \u6240\u6709\u5305\u542b\u5904\u7406\u5668\u7684\u84dd\u56fe").row();
                this.cont.pane(tt -> {
                    for (Schematic schem : all) {
                        tt.button(schem.name(), () -> {
                            Seq blocks = schem.tiles.select(s -> s.block instanceof LogicBlock);
                            this.cont.clear();
                            LogicBlock.LogicBuild tmp = new LogicBlock.LogicBuild();
                            for (Schematic.Stile block2 : blocks) {
                                tmp.readCompressed((byte[])block2.config, false);
                                String code = tmp.code;
                                this.cont.button(block2.block.emoji(), () -> {
                                    build.configure(block2.config);
                                    this.hide();
                                }).tooltip(Strings.truncate((String)code, (int)300, (String)"\n...")).size(32.0f);
                            }
                            if (blocks.size == 1) {
                                ((Element)this.cont.getChildren().pop()).change();
                            }
                        }).growX().row();
                    }
                }).growX().maxWidth(600.0f);
            }
        }.show();
    }

    private static void buildLogicVarTable(Table table2, LExecutor executor) {
        LVar[] vars = executor.vars;
        table2.update(() -> {
            if (vars != executor.vars) {
                table2.clear();
                LogicSupport.buildLogicVarTable(table2, executor);
                return;
            }
            table2.getCells().each(cell -> {
                if (cell.prefWidth() > cell.maxWidth()) {
                    cell.width(cell.prefWidth());
                    table2.invalidateHierarchy();
                }
            });
            if (table2.needsLayout()) {
                table2.parent.parent.pack();
            }
        });
        table2.setColor(Color.lightGray);
        for (LVar s : vars) {
            if (s.name.startsWith("___")) continue;
            table2.add((CharSequence)s.name).color(LogicSupport.arcVarsColor(s)).align(8);
            table2.label(() -> LogicSupport.arcVarsText(s)).align(16).labelAlign(16);
            table2.row();
        }
    }

    static {
        autoRefresh = true;
        visible.addFallbackName("gameUI.logicSupport");
        visible.addFallbackName("logicSupport");
        changeSplash.addFallbackName("logicSupportChangeSplash");
        showVars = false;
    }
}

