/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features.ui;

import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Strings;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import mindustry.core.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0086\b\u0018\u0000 *2\u00020\u0001:\u0001*B\u001d\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0013J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0018J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00132\b\b\u0002\u0010\u001e\u001a\u00020\u0005J,\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00132\b\b\u0002\u0010\u001f\u001a\u00020\u00132\b\b\u0002\u0010\"\u001a\u00020\u0005H\u0007J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010&\u001a\u00020\u00052\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001J\t\u0010)\u001a\u00020\u0011H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006+"}, d2={"LmindustryX/features/ui/Format;", "", "decimal", "", "fixDecimals", "", "<init>", "(IZ)V", "getDecimal", "()I", "setDecimal", "(I)V", "getFixDecimals", "()Z", "setFixDecimals", "(Z)V", "fixedPrecision", "", "v", "", "scienceFormat", "number", "format0", "format", "", "pos", "Larc/math/geom/Position;", "formatTile", "duration", "seconds", "unit", "percent", "cur", "max", "showPercent", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "Companion", "core"})
public final class Format {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int decimal;
    private boolean fixDecimals;
    @NotNull
    private static final Format default = new Format(0, false, 3, null);

    @JvmOverloads
    public Format(int decimal, boolean fixDecimals) {
        this.decimal = decimal;
        this.fixDecimals = fixDecimals;
    }

    public /* synthetic */ Format(int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        this(n, bl);
    }

    public final int getDecimal() {
        return this.decimal;
    }

    public final void setDecimal(int n) {
        this.decimal = n;
    }

    public final boolean getFixDecimals() {
        return this.fixDecimals;
    }

    public final void setFixDecimals(boolean bl) {
        this.fixDecimals = bl;
    }

    @NotNull
    public final String fixedPrecision(float v) {
        int exponent = RangesKt.coerceAtLeast(Mathf.floor((float)Mathf.log((float)10.0f, (float)Math.abs(v))), 0);
        if (exponent >= this.decimal) {
            return String.valueOf((int)v);
        }
        String string = Strings.fixed((float)v, (int)(this.decimal - exponent));
        Intrinsics.checkNotNullExpressionValue(string, "fixed(...)");
        return string;
    }

    @NotNull
    public final String scienceFormat(float number) {
        int exponent = Mathf.floor((float)Mathf.log((float)10.0f, (float)Math.abs(number)));
        float mantissa = number / Mathf.pow((float)10.0f, (float)exponent);
        return Strings.fixed((float)mantissa, (int)this.decimal) + "[gray]E" + exponent + "[]";
    }

    private final String format0(float number) {
        if (this.fixDecimals) {
            String string = Strings.fixed((float)number, (int)this.decimal);
            Intrinsics.checkNotNullExpressionValue(string, "fixed(...)");
            return string;
        }
        return this.fixedPrecision(number);
    }

    @NotNull
    public final String format(float number) {
        if (Float.isNaN(number)) {
            return "NaN";
        }
        if (number == Float.POSITIVE_INFINITY) {
            return "Inf";
        }
        if (number == Float.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        float abs = Math.abs(number);
        return abs <= Float.MIN_NORMAL ? this.format0(0.0f) : (abs < Mathf.pow((float)10.0f, (float)(-((float)this.decimal))) ? this.scienceFormat(number) : (abs < 1000.0f || abs < Mathf.pow((float)10.0f, (float)(1.0f + (float)this.decimal)) ? this.format0(number) : (abs < 1000000.0f ? this.format0(number / 1000.0f) + "[gray]K[]" : (abs < 1.0E9f ? this.format0(number / 1000000.0f) + "[gray]M[]" : (abs < 1.0E12f ? this.format0(number / 1.0E9f) + "[gray]B[]" : this.scienceFormat(number))))));
    }

    @NotNull
    public final String format(long number) {
        if (number == Long.MAX_VALUE) {
            return "\u221e";
        }
        if (number == Long.MIN_VALUE) {
            return "-\u221e";
        }
        if (-1000L < number && number < 1000L) {
            return String.valueOf(number);
        }
        return this.format((float)number);
    }

    @NotNull
    public final String format(@NotNull Position pos) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        return '(' + this.format0(pos.getX()) + ',' + this.format0(pos.getY()) + ')';
    }

    @NotNull
    public final String formatTile(@NotNull Position pos) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        return "" + '(' + World.toTile(pos.getX()) + ',' + World.toTile(pos.getY()) + ')';
    }

    @NotNull
    public final String duration(float seconds, boolean unit) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder $this$duration_u24lambda_u240 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        $this$duration_u24lambda_u240.append(seconds > 0.0f ? "[orange]" : "[acid]");
        float s = Math.abs(seconds);
        if (s >= 60.0f) {
            $this$duration_u24lambda_u240.append((int)(seconds / (float)60));
            $this$duration_u24lambda_u240.append(" : ");
            stringBuilder = $this$duration_u24lambda_u240.append((int)(s % (float)60));
        } else {
            stringBuilder = $this$duration_u24lambda_u240.append(this.format0(seconds));
        }
        $this$duration_u24lambda_u240.append("[]");
        if (unit) {
            $this$duration_u24lambda_u240.append(s >= 60.0f ? "min" : "s");
        }
        return stringBuilder2.toString();
    }

    public static /* synthetic */ String duration$default(Format format, float f, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return format.duration(f, bl);
    }

    @JvmOverloads
    @NotNull
    public final String percent(float cur, float max, float percent, boolean showPercent) {
        StringBuilder stringBuilder;
        StringBuilder $this$percent_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$percent_u24lambda_u241.append(this.format(cur));
        if (percent < 0.99f) {
            $this$percent_u24lambda_u241.append('/');
            $this$percent_u24lambda_u241.append(this.format(max));
        }
        if (showPercent) {
            $this$percent_u24lambda_u241.append(" [lightgray]| ");
            $this$percent_u24lambda_u241.append((int)(percent * (float)100));
            $this$percent_u24lambda_u241.append('%');
        }
        return stringBuilder.toString();
    }

    public static /* synthetic */ String percent$default(Format format, float f, float f2, float f3, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            f3 = f / f2;
        }
        if ((n & 8) != 0) {
            bl = f3 < 0.95f;
        }
        return format.percent(f, f2, f3, bl);
    }

    public final int component1() {
        return this.decimal;
    }

    public final boolean component2() {
        return this.fixDecimals;
    }

    @NotNull
    public final Format copy(int decimal, boolean fixDecimals) {
        return new Format(decimal, fixDecimals);
    }

    public static /* synthetic */ Format copy$default(Format format, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = format.decimal;
        }
        if ((n2 & 2) != 0) {
            bl = format.fixDecimals;
        }
        return format.copy(n, bl);
    }

    @NotNull
    public String toString() {
        return "Format(decimal=" + this.decimal + ", fixDecimals=" + this.fixDecimals + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.decimal);
        result = result * 31 + Boolean.hashCode(this.fixDecimals);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Format)) {
            return false;
        }
        Format format = (Format)other;
        if (this.decimal != format.decimal) {
            return false;
        }
        return this.fixDecimals == format.fixDecimals;
    }

    @JvmOverloads
    public Format(int decimal) {
        this(decimal, false, 2, null);
    }

    @JvmOverloads
    public Format() {
        this(0, false, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final String percent(float cur, float max, float percent) {
        return Format.percent$default(this, cur, max, percent, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final String percent(float cur, float max) {
        return Format.percent$default(this, cur, max, 0.0f, false, 12, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"LmindustryX/features/ui/Format$Companion;", "", "<init>", "()V", "default", "LmindustryX/features/ui/Format;", "getDefault", "()LmindustryX/features/ui/Format;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Format getDefault() {
            return default;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

