/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features.ui;

import arc.Core;
import arc.func.Cons;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.TextField;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Strings;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustryX.features.ui.comp.GridTable;

public class ContentSelectDialog
extends BaseDialog {
    private String query = "";
    private final GridTable contentTable = new GridTable();

    public ContentSelectDialog() {
        super("@contentSelector");
        this.cont.table(queryTable -> {
            queryTable.image((Drawable)Icon.zoom).size(64.0f);
            TextField field = (TextField)queryTable.field(this.query, text -> {
                this.query = text;
            }).pad(8.0f).growX().get();
            queryTable.button((Drawable)Icon.cancel, Styles.clearNonei, () -> {
                this.query = "";
                field.setText(this.query);
            }).size(64.0f);
            queryTable.update(() -> {
                Element first;
                if (Core.scene.getKeyboardFocus() == this) {
                    Core.scene.setKeyboardFocus((Element)field);
                }
                if (Core.input.keyTap(Binding.chat) && Core.scene.getKeyboardFocus() == field && (first = this.contentTable.firstElement()) != null) {
                    first.fireClick();
                }
            });
        }).growX().row();
        this.contentTable.defaults().width(300.0f);
        this.contentTable.top();
        this.cont.pane((Element)this.contentTable).scrollX(false).grow();
        this.addCloseButton();
    }

    public Button addContent(Drawable icon, String name, String localizedName, Runnable action) {
        return (Button)this.contentTable.button(table2 -> {
            table2.image(icon).scaling(Scaling.fit).size(48.0f).pad(8.0f).expandX().left();
            table2.table(infoTable -> {
                infoTable.defaults().width(this.width * 0.7f).pad(4.0f);
                infoTable.add((CharSequence)localizedName).ellipsis(true).labelAlign(16);
                infoTable.row();
                infoTable.add((CharSequence)name).ellipsis(true).labelAlign(16).color(Pal.lightishGray);
            }).fillX();
        }, action).pad(8.0f).width(this.width).visible(() -> Strings.matches((String)this.query, (String)name) || Strings.matches((String)this.query, (String)localizedName)).get();
    }

    public Button addContent(UnlockableContent content, Runnable action) {
        return this.addContent((Drawable)new TextureRegionDrawable(content.uiIcon), content.name, content.localizedName, action);
    }

    public Button addNull(Runnable action) {
        return this.addContent((Drawable)Icon.none, "none", "@settings.resetKey", action);
    }

    public <T extends UnlockableContent> void addContents(Iterable<T> contents, @Nullable T current, @Nullable Cons<T> cons) {
        for (UnlockableContent content : contents) {
            this.addContent(content, () -> {
                if (cons != null) {
                    cons.get((Object)content);
                }
            }).setChecked(content == current);
        }
    }

    public static <T extends UnlockableContent> void once(Seq<T> contents, Cons<T> consumer) {
        ContentSelectDialog.once(contents, null, consumer);
    }

    public static <T extends UnlockableContent> void once(Seq<T> contents, @Nullable T current, Cons<T> consumer) {
        ContentSelectDialog dialog = new ContentSelectDialog();
        dialog.addContents((Iterable<T>)contents, current, (Cons<T>)((Cons)it -> {
            consumer.get((Object)it);
            dialog.hide();
        }));
        dialog.show();
    }
}

