/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features.ui;

import arc.Core;
import arc.Events;
import arc.func.Cons;
import arc.func.ConsT;
import arc.graphics.Color;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.ui.CheckBox;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectSet;
import arc.struct.Queue;
import arc.util.Http;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Tmp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.ctype.UnlockableContent;
import mindustry.game.EventType;
import mindustry.game.SpawnGroup;
import mindustry.gen.Icon;
import mindustry.gen.Player;
import mindustry.gen.Tex;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustryX.VarsX;
import mindustryX.features.MarkerType;
import mindustryX.features.UIExt;
import mindustryX.features.ui.FormatDefault;
import mindustryX.features.ui.comp.GridTable;

public class ArcMessageDialog
extends BaseDialog {
    public static final Queue<Msg> msgList = new Queue();
    private final ObjectSet<Type> hiddenTypes = new ObjectSet();
    private int maxMsgRecorded;
    private static int id = 0;
    private static final GridTable msgTable = new GridTable();
    private static final GridTable chooseTable = new GridTable();

    public ArcMessageDialog() {
        super("ARC-\u4e2d\u592e\u76d1\u63a7\u5ba4");
        if (Core.settings.getInt("maxMsgRecorded") == 0) {
            Core.settings.put("maxMsgRecorded", (Object)500);
        }
        this.maxMsgRecorded = Core.settings.getInt("maxMsgRecorded");
        this.cont.add((Element)chooseTable).fillX().row();
        chooseTable.background(Tex.pane);
        chooseTable.defaults().width(180.0f).left().padRight(4.0f);
        for (Type type : Type.values()) {
            ((CheckBox)chooseTable.check("[#" + type.color.toString() + "]" + type.name, b -> {
                if (!b) {
                    this.hiddenTypes.add((Object)type);
                } else {
                    this.hiddenTypes.remove((Object)type);
                }
            }).checked(b -> !this.hiddenTypes.contains((Object)type)).get()).left();
        }
        this.cont.pane((Element)msgTable).maxWidth(1199.0f).fillX().growY().scrollX(false).row();
        msgTable.defaults().minWidth(600.0f).growX().padBottom(15.0f);
        this.cont.table(t -> {
            t.add((CharSequence)"\u6700\u5927\u50a8\u5b58\u804a\u5929\u8bb0\u5f55(\u8fc7\u9ad8\u53ef\u80fd\u5bfc\u81f4\u5361\u987f)\uff1a");
            t.field(this.maxMsgRecorded + "", text -> {
                int record;
                this.maxMsgRecorded = record = Math.min(Math.max(Integer.parseInt(text), 1), 9999);
                Core.settings.put("maxMsgRecorded", (Object)record);
            }).valid(Strings::canParsePositiveInt).width(200.0f).get();
            t.row();
            t.add((CharSequence)"\u8d85\u51fa\u9650\u5236\u7684\u804a\u5929\u8bb0\u5f55\u5c06\u5728\u8f7d\u5165\u5730\u56fe\u65f6\u6e05\u9664").color(Color.lightGray).colspan(2);
        }).row();
        this.addCloseButton();
        this.buttons.button("\u6e05\u7a7a", (Drawable)Icon.trash, () -> ((GridTable)msgTable).clearChildren());
        this.buttons.button("\u5bfc\u51fa", (Drawable)Icon.upload, this::exportMsg).name("\u5bfc\u51fa\u804a\u5929\u8bb0\u5f55");
        Events.on(EventType.WorldLoadEvent.class, e -> {
            this.addMsg(new Msg(Type.eventWorldLoad, "\u8f7d\u5165\u5730\u56fe\uff1a " + Vars.state.map.name()));
            this.addMsg(new Msg(Type.eventWorldLoad, "\u7b80\u4ecb\uff1a " + Vars.state.map.description()));
            while (ArcMessageDialog.msgTable.getChildren().size >= this.maxMsgRecorded) {
                ((Element)msgTable.getChildren().get(0)).remove();
            }
        });
        Events.on(EventType.WaveEvent.class, e -> {
            if (Vars.state.wavetime < 60.0f) {
                return;
            }
            this.addMsg(new Msg(Type.eventWave, "\u6ce2\u6b21\uff1a " + Vars.state.wave + " | " + ArcMessageDialog.getWaveInfo(Vars.state.wave - 1)));
        });
    }

    public static void share(String type, String content) {
        UIExt.sendChatMessage("<ARCxMDTX><" + type + ">" + content);
    }

    public static void shareContent(UnlockableContent content, boolean description) {
        StringBuilder builder = new StringBuilder();
        builder.append(content.localizedName).append(content.emoji());
        builder.append("(").append(content.name).append(")");
        if (content.description != null && description) {
            builder.append(": ").append(content.description);
        }
        UIExt.shareMessage('\uf129', builder.toString());
    }

    public static void uploadPasteBin(String content, Cons<String> callback) {
        Http.HttpRequest req = Http.post("https://pastebin.com/api/api_post.php", "api_dev_key=sdBDjI5mWBnHl9vBEDMNiYQ3IZe0LFEk&api_option=paste&api_paste_expire_date=10M&api_paste_code=" + content);
        req.submit((ConsT<Http.HttpResponse, Exception>)((ConsT)r -> {
            String code = r.getResultAsString();
            Core.app.post(() -> callback.get((Object)code));
        }));
        req.error((Cons<Throwable>)((Cons)e -> Core.app.post(() -> {
            Vars.ui.showException("\u4e0a\u4f20\u5931\u8d25\uff0c\u518d\u91cd\u8bd5\u4e00\u4e0b\uff1f", (Throwable)e);
            Core.app.post(() -> callback.get(null));
        })));
    }

    public static String getWaveInfo(int waves) {
        StringBuilder builder = new StringBuilder();
        if (Vars.state.rules.attackMode) {
            int sum = Math.max(Vars.state.teams.present.sum(t -> t.team != Vars.player.team() ? t.cores.size : 0), 1) + Vars.spawner.countSpawns();
            builder.append("\u5305\u542b(\u00d7").append(sum).append(")");
        } else {
            builder.append("\u5305\u542b(\u00d7").append(Vars.spawner.countSpawns()).append("):");
        }
        for (SpawnGroup group : Vars.state.rules.spawns) {
            if (group.getSpawned(waves - 1) <= 0) continue;
            builder.append((char)Fonts.getUnicode(group.type.name)).append("(");
            if (group.effect != StatusEffects.invincible && group.effect != StatusEffects.none && group.effect != null) {
                builder.append((char)Fonts.getUnicode(group.effect.name)).append("|");
            }
            if (group.getShield(waves - 1) > 0.0f) {
                builder.append(FormatDefault.format(group.getShield(waves - 1))).append("|");
            }
            builder.append(group.getSpawned(waves - 1)).append(")");
        }
        return builder.toString();
    }

    public String formatTime(Date time) {
        return new SimpleDateFormat("HH:mm:ss", Locale.US).format(time);
    }

    public static void resolveMsg(String message, @Nullable Player sender) {
        Type type = message.contains("<AT>") ? Type.markPlayer : (sender != null ? Type.chat : Type.serverMsg);
        new Msg(type, message, sender != null ? sender.name() : null, sender != null ? new Vec2(sender.x, sender.y) : null).add();
        if (type == Type.markPlayer) {
            if (!message.split("AT")[1].contains(Vars.player.name)) {
                return;
            }
            if (sender != null) {
                Vars.ui.announce("[gold]\u4f60\u88ab[white] " + sender.name + " [gold]\u6233\u4e86\u4e00\u4e0b\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\u4fe1\u606f\u6846\u54e6~", 10.0f);
            } else {
                Vars.ui.announce("[orange]\u4f60\u88ab\u6233\u4e86\u4e00\u4e0b\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\u4fe1\u606f\u6846\u54e6~", 10.0f);
            }
        }
    }

    public void addMsg(Msg msg) {
        ++id;
        msgTable.table(Tex.whitePane, t -> {
            t.setColor(msg.msgType.color);
            t.marginTop(5.0f);
            t.visible(() -> !this.hiddenTypes.contains((Object)msg.msgType));
            t.table(Tex.whiteui, tt -> {
                tt.color.set(msg.msgType.color);
                if (msg.msgType == Type.chat) {
                    tt.add((CharSequence)(msg.sender != null ? msg.sender : msg.msgType.name)).style((Style)Styles.outlineLabel).left().width(300.0f);
                } else {
                    tt.add((CharSequence)msg.msgType.name).style((Style)Styles.outlineLabel).color(msg.msgType.color).left().width(300.0f);
                }
                tt.add((CharSequence)this.formatTime(msg.time)).style((Style)Styles.outlineLabel).color(msg.msgType.color).left().padLeft(20.0f).width(100.0f);
                if (msg.msgLoc != null) {
                    tt.button("\u2650\uff1a " + (int)(msg.msgLoc.x / 8.0f) + "," + (int)(msg.msgLoc.y / 8.0f), Styles.logict, () -> {
                        Vars.control.input.panCamera(msg.msgLoc);
                        MarkerType.mark.at((Position)Tmp.v1.scl((float)msg.msgLoc.x, (float)msg.msgLoc.y)).color = this.color;
                        this.hide();
                    }).padLeft(50.0f).height(24.0f).width(150.0f);
                }
                tt.add().growX();
                tt.add((CharSequence)("    " + id)).style((Style)Styles.outlineLabel).color(msg.msgType.color).padRight(10.0f);
                tt.button((Drawable)Icon.copy, Styles.logici, () -> {
                    Core.app.setClipboardText(msg.message);
                    Vars.ui.announce("\u5df2\u5bfc\u51fa\u672c\u6761\u804a\u5929\u8bb0\u5f55");
                }).size(24.0f).padRight(6.0f);
                tt.button((Drawable)Icon.cancel, Styles.logici, () -> ((Table)t).remove()).size(24.0f);
            }).growX().height(30.0f);
            t.row();
            t.table(tt -> {
                tt.left();
                tt.marginLeft(4.0f);
                tt.setColor(msg.msgType.color);
                tt.labelWrap(msg.message).growX();
            }).pad(4.0f).padTop(2.0f).growX().grow();
            t.marginBottom(7.0f);
        });
    }

    void exportMsg() {
        StringBuilder messageHis = new StringBuilder();
        messageHis.append("\u4e0b\u9762\u662f[MDTX-").append(VarsX.version).append("] \u5bfc\u51fa\u7684\u6e38\u620f\u5185\u804a\u5929\u8bb0\u5f55").append("\n");
        messageHis.append("*** \u5f53\u524d\u5730\u56fe\u540d\u79f0: ").append(Vars.state.map.name()).append("\uff08\u6a21\u5f0f\uff1a").append(Vars.state.rules.modeName).append("\uff09\n");
        messageHis.append("*** \u5f53\u524d\u6ce2\u6b21: ").append(Vars.state.wave).append("\n");
        messageHis.append("\u6210\u529f\u9009\u53d6\u5171 ").append(ArcMessageDialog.msgList.size).append(" \u6761\u8bb0\u5f55\uff0c\u5982\u4e0b\uff1a\n");
        for (Msg msg : msgList) {
            messageHis.append(Strings.stripColors((CharSequence)msg.message)).append("\n");
        }
        Core.app.setClipboardText(Strings.stripGlyphs((CharSequence)Strings.stripColors((CharSequence)messageHis.toString())));
    }

    public static enum Type {
        chat("\u804a\u5929", Color.gray),
        serverMsg("\u670d\u52a1\u5668\u4fe1\u606f", Color.valueOf((String)"#cefdce")),
        markLoc("\u6807\u8bb0~\u5750\u6807", Color.valueOf((String)"#7FFFD4")),
        markPlayer("\u6807\u8bb0~\u73a9\u5bb6", Color.valueOf((String)"#7FFFD4")),
        console("\u6307\u4ee4", Color.gold),
        logicNotify("\u903b\u8f91~\u901a\u62a5", Color.valueOf((String)"#ffccff")),
        logicAnnounce("\u903b\u8f91~\u516c\u544a", Color.valueOf((String)"#ffccff")),
        eventWorldLoad("\u4e8b\u4ef6~\u8f7d\u5165\u5730\u56fe", Color.valueOf((String)"#ff9999")),
        eventWave("\u4e8b\u4ef6~\u6ce2\u6b21", Color.valueOf((String)"#ffcc99"));

        public final String name;
        public final Color color;

        private Type(String name, Color color) {
            this.name = name;
            this.color = color;
        }
    }

    public static class Msg {
        public final Type msgType;
        public final String message;
        public final Date time = new Date();
        @Nullable
        public final String sender;
        @Nullable
        public final Vec2 msgLoc;

        public Msg(Type msgType, String message, @Nullable String sender, @Nullable Vec2 msgLoc) {
            this.msgType = msgType;
            this.message = message;
            this.sender = sender;
            this.msgLoc = msgLoc;
        }

        public Msg(Type msgType, String message, Vec2 msgLoc) {
            this(msgType, message, null, msgLoc);
        }

        public Msg(Type msgType, String message) {
            this(msgType, message, null);
        }

        public void add() {
            UIExt.arcMessageDialog.addMsg(this);
        }
    }
}

