/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features.draw;

import arc.func.Boolf;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Tmp;
import mindustry.core.World;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Units;
import mindustry.gen.Building;
import mindustry.gen.Payloadc;
import mindustry.gen.Player;
import mindustry.gen.Unit;
import mindustry.gen.Unitc;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;
import mindustry.world.Block;
import mindustry.world.Build;
import mindustry.world.Tile;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.meta.BuildVisibility;

public class PayloadDropHint {
    public static void draw(Player player) {
        Unit target;
        BuildPayload b;
        Unit unit;
        Unit unit2 = unit = player.unit() instanceof Payloadc ? (Unit)((Payloadc)player.unit()) : null;
        if (unit == null) {
            return;
        }
        Tile on = unit.tileOn();
        if (on == null) {
            return;
        }
        Draw.z((float)115.1f);
        if (((Payloadc)unit).payloads().any()) {
            Payload payload = (Payload)((Payloadc)unit).payloads().peek();
            if (on.build != null && on.build.acceptPayload(on.build, payload)) {
                float f;
                Building building = on.build;
                UnlockableContent unlockableContent = payload.content();
                if (payload instanceof BuildPayload) {
                    b = (BuildPayload)payload;
                    f = b.build.rotation * 90;
                } else {
                    f = payload.rotation() - 90.0f;
                }
                PayloadDropHint.draw((Position)building, unlockableContent, f);
            } else if (payload instanceof BuildPayload) {
                BuildPayload p = (BuildPayload)payload;
                Building build = p.build;
                Block block = build.block;
                int tx = World.toTile(build.x - block.offset);
                int ty = World.toTile(build.y - block.offset);
                boolean valid = Build.validPlace(block, build.team, tx, ty, build.rotation, false);
                Vec2 center = block.bounds(tx, ty, Tmp.r1).getCenter(Tmp.v1);
                PayloadDropHint.draw((Position)center, block, build.rotation * 90, valid);
            } else if (payload instanceof UnitPayload) {
                UnitPayload p = (UnitPayload)payload;
                Unit u2 = p.unit;
                boolean valid = u2.canPass(on.x, on.y) && Units.count(u2.x, u2.y, u2.physicSize(), (Boolf<Unit>)((Boolf)Unitc::isGrounded)) <= 1;
                PayloadDropHint.draw((Position)payload, payload.content(), u2.rotation - 90.0f, valid);
            }
        }
        if ((target = Units.closest(unit.team(), unit.x, unit.y, unit.type.hitSize * 2.0f, (Boolf<Unit>)((Boolf)u -> u.isAI() && u.isGrounded() && ((Payloadc)unit).canPickup(u) && u.within((Position)unit, u.hitSize + unit.hitSize)))) != null) {
            PayloadDropHint.draw((Position)target, target.type, target.rotation - 90.0f);
            return;
        }
        Building build = on.build;
        if (build == null || build.interactable(unit.team)) {
            return;
        }
        Payload payload = build.getPayload();
        if (payload != null && ((Payloadc)unit).canPickupPayload(payload)) {
            float f;
            UnlockableContent unlockableContent = payload.content();
            if (payload instanceof BuildPayload) {
                b = (BuildPayload)payload;
                f = b.build.rotation * 90;
            } else {
                f = payload.rotation();
            }
            PayloadDropHint.draw((Position)payload, unlockableContent, f);
            return;
        }
        if (build.block.buildVisibility != BuildVisibility.hidden && build.canPickup() && ((Payloadc)unit).canPickup(build)) {
            PayloadDropHint.draw((Position)build, build.block, build.rotation * 90);
        }
    }

    private static void draw(Position pos, UnlockableContent type, float rotation) {
        PayloadDropHint.draw(pos, type, rotation, true);
    }

    private static void draw(Position pos, UnlockableContent type, float rotation, boolean valid) {
        Draw.color((Color)(!valid ? Color.red : Pal.accent), (float)0.6f);
        if (type instanceof Block) {
            Block block = (Block)type;
            float size = block.size * 8;
            Draw.rect((TextureRegion)block.fullIcon, (float)pos.getX(), (float)pos.getY(), (float)size, (float)size, (float)rotation);
            Lines.square(pos.getX(), pos.getY(), size * 0.9f, 20.0f);
        } else if (type instanceof UnitType) {
            UnitType unit = (UnitType)type;
            Draw.rect((TextureRegion)type.fullIcon, (float)pos.getX(), (float)pos.getY(), (float)rotation);
            Lines.square(pos.getX(), pos.getY(), unit.hitSize, 20.0f);
        }
        Draw.color();
    }
}

