/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features.draw;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ai.types.CommandAI;
import mindustry.ai.types.LogicAI;
import mindustry.entities.units.BuildPlan;
import mindustry.entities.units.StatusEntry;
import mindustry.entities.units.UnitController;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.gen.Payloadc;
import mindustry.gen.Unit;
import mindustry.gen.Unitc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.world.blocks.payloads.Payload;
import mindustryX.features.RenderExt;

public class ArcUnits {
    private static final int maxBuildPlans = 100;
    private static boolean alwaysShowUnitRTSAi;
    private static boolean unitHealthBar;
    private static boolean unitLogicMoveLine;
    private static boolean unitLogicTimerBars;
    private static boolean unitBuildPlan;
    private static float unitWeaponRange;
    private static float unitWeaponRangeAlpha;
    public static boolean selectedUnitsFlyer;
    public static boolean selectedUnitsLand;
    private static float curStroke;
    private static int unitTargetType;
    private static int superUnitEffect;
    private static boolean arcBuildInfo;

    public static void draw(Unit unit) {
        if (unit.isPlayer()) {
            if (superUnitEffect > 0 && (unit.isLocal() || superUnitEffect == 2)) {
                ArcUnits.drawAimRange(unit);
            }
            if (unitTargetType > 0) {
                ArcUnits.drawAimTarget(unit);
            }
            if (arcBuildInfo && unit.isLocal()) {
                ArcUnits.drawBuildRange(unit);
            }
        }
        Draw.z((float)(Draw.z() + 0.1f));
        if (unitWeaponRange > 0.0f) {
            ArcUnits.drawWeaponRange(unit);
        }
        if (unit.team() == Vars.player.team() || RenderExt.showOtherInfo) {
            UnitController unitController;
            if (alwaysShowUnitRTSAi) {
                ArcUnits.drawRTSAI(unit);
            }
            if (unitHealthBar) {
                ArcUnits.drawHealthBar(unit);
            }
            if ((unitController = unit.controller()) instanceof LogicAI) {
                LogicAI ai = (LogicAI)unitController;
                if (unitLogicMoveLine) {
                    ArcUnits.drawLogicMove(unit, ai);
                }
                if (unitLogicTimerBars) {
                    ArcUnits.drawLogicTimer(unit, ai);
                }
            }
            if (unitBuildPlan) {
                ArcUnits.drawBuildPlan(unit);
            }
        }
    }

    private static void drawAimRange(Unit unit) {
        if (curStroke <= 0.0f) {
            return;
        }
        Color effectColor = unit.controller() == Vars.player ? RenderExt.playerEffectColor : unit.team.color;
        float z = Draw.z();
        Draw.z((float)108.0f);
        Draw.color((Color)effectColor);
        Lines.stroke(curStroke);
        for (int i = 0; i < 5; ++i) {
            float rot = unit.rotation + (float)i * 360.0f / 5.0f + Time.time * 0.5f;
            Lines.arc(unit.x, unit.y, unit.type.maxRange, 0.14f, rot, (int)(50.0f + unit.type.maxRange / 10.0f));
        }
        Draw.reset();
        Draw.z((float)z);
    }

    private static void drawAimTarget(Unit unit) {
        Color effectColor = unit.controller() == Vars.player ? RenderExt.playerEffectColor : unit.team.color;
        float z = Draw.z();
        Draw.z((float)110.0f);
        Draw.color((Color)effectColor, (float)0.8f);
        Lines.line(unit.x, unit.y, unit.aimX, unit.aimY);
        switch (unitTargetType) {
            case 1: {
                Lines.dashCircle(unit.aimX, unit.aimY, 8.0f);
                break;
            }
            case 2: {
                Drawf.target((float)unit.aimX, (float)unit.aimY, (float)6.0f, (float)0.7f, (Color)effectColor);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                Draw.color((Color)effectColor, (float)0.7f);
                if (unitTargetType == 3) {
                    Lines.poly(unit.aimX, unit.aimY, 4, 6.0f, Time.time * 1.5f);
                }
                if (unitTargetType == 4) {
                    Lines.circle(unit.aimX, unit.aimY, 6.0f);
                }
                Lines.spikes(unit.aimX, unit.aimY, 2.5714285f, 5.142857f, 4, Time.time * 1.5f);
            }
        }
        Draw.color();
        Draw.z((float)z);
    }

    private static void drawWeaponRange(Unit unit) {
        if (unitWeaponRange == 0.0f || unitWeaponRangeAlpha == 0.0f) {
            return;
        }
        if (unitWeaponRange == 240.0f) {
            ArcUnits.drawWeaponRange(unit, unitWeaponRangeAlpha);
        } else if (unit.team != Vars.player.team()) {
            boolean canHitPlayer = !Vars.player.dead() && Vars.player.unit().hittable() && (Vars.player.unit().isFlying() ? unit.type.targetAir : unit.type.targetGround) && unit.within(Vars.player.unit().x, Vars.player.unit().y, unit.type.maxRange + unitWeaponRange);
            boolean canHitCommand = Vars.control.input.commandMode && (selectedUnitsFlyer && unit.type.targetAir || selectedUnitsLand && unit.type.targetGround);
            boolean canHitPlans = (Vars.control.input.block != null || Vars.control.input.selectPlans.size > 0) && unit.type.targetGround;
            boolean canHitMouse = unit.within(Core.input.mouseWorldX(), Core.input.mouseWorldY(), unit.type.maxRange + unitWeaponRange);
            if (canHitPlayer || canHitMouse && (canHitCommand || canHitPlans)) {
                ArcUnits.drawWeaponRange(unit, unitWeaponRangeAlpha);
            }
        }
    }

    private static void drawWeaponRange(Unit unit, float alpha) {
        Draw.color((Color)unit.team.color);
        Draw.alpha((float)alpha);
        Lines.dashCircle(unit.x, unit.y, unit.type.maxRange);
        Draw.reset();
    }

    private static void drawRTSAI(Unit unit) {
        if (!Vars.control.input.commandMode && unit.isCommandable() && unit.command().command != null) {
            Draw.z((float)110.0f);
            CommandAI ai = unit.command();
            if (ai.attackTarget != null) {
                Draw.color((Color)unit.team.color);
                if (ai.targetPos != null) {
                    Drawf.limitLine((Position)unit, (Position)ai.attackTarget, (float)(unit.hitSize / 2.0f), (float)3.5f, (Color)unit.team.color);
                }
                Drawf.target((float)ai.attackTarget.getX(), (float)ai.attackTarget.getY(), (float)6.0f, (Color)unit.team.color);
            } else if (ai.targetPos != null) {
                Draw.color((Color)unit.team.color);
                Drawf.limitLine((Position)unit, (Position)ai.targetPos, (float)(unit.hitSize / 2.0f), (float)3.5f, (Color)unit.team.color);
                Draw.color((Color)unit.team.color);
                Drawf.square((float)ai.targetPos.getX(), (float)ai.targetPos.getY(), (float)3.5f, (Color)unit.team.color);
            }
            Draw.reset();
        }
    }

    private static void drawHealthBar(Unit unit) {
        Payloadc payload;
        Draw.z((float)131.0f);
        float y_corr = 0.0f;
        if (!Vars.player.dead() && unit.hitSize < 30.0f && unit.hitSize > 20.0f && unit.isPlayer()) {
            y_corr = 2.0f;
        }
        if (unit.health < unit.maxHealth) {
            Lines.stroke(4.0f);
            Draw.color((Color)unit.team.color, (float)0.5f);
            Lines.line(unit.x - unit.hitSize() * 0.6f, unit.y + unit.hitSize() / 2.0f + y_corr, unit.x + unit.hitSize() * 0.6f, unit.y + unit.hitSize() / 2.0f + y_corr);
            Lines.stroke(2.0f);
            Draw.color((Color)Pal.health, (float)0.8f);
            Lines.line(unit.x - unit.hitSize() * 0.6f, unit.y + unit.hitSize() / 2.0f + y_corr, unit.x + unit.hitSize() * (Math.min(Mathf.maxZero((float)unit.health), unit.maxHealth) * 1.2f / unit.maxHealth - 0.6f), unit.y + unit.hitSize() / 2.0f + y_corr);
            Lines.stroke(2.0f);
            Draw.reset();
        }
        if (unit.shield > 0.0f && (double)unit.shield < 1.0E20) {
            for (int didgt = 1; didgt <= Mathf.digits((int)((int)(unit.shield / unit.maxHealth))) + 1; ++didgt) {
                Draw.color((Color)Pal.shield, (float)0.8f);
                float shieldAmountScale = unit.shield / (unit.maxHealth * Mathf.pow((float)10.0f, (float)((float)didgt - 1.0f)));
                if (didgt > 1) {
                    Lines.line(unit.x - unit.hitSize() * 0.6f, unit.y + unit.hitSize() / 2.0f + (float)didgt * 2.0f + y_corr, unit.x + unit.hitSize() * (((float)Mathf.ceil((float)((shieldAmountScale - (float)Mathf.floor((float)shieldAmountScale)) * 10.0f)) - 1.0f + 1.0E-4f) * 1.2f * 0.11111111f - 0.6f), unit.y + unit.hitSize() / 2.0f + (float)didgt * 2.0f + y_corr);
                    continue;
                }
                Lines.line(unit.x - unit.hitSize() * 0.6f, unit.y + unit.hitSize() / 2.0f + (float)didgt * 2.0f + y_corr, unit.x + unit.hitSize() * ((shieldAmountScale - (float)Mathf.floor((float)shieldAmountScale) - 0.001f) * 1.2f - 0.6f), unit.y + unit.hitSize() / 2.0f + (float)didgt * 2.0f + y_corr);
            }
            Draw.color();
        }
        float index = 0.0f;
        float iconSize = 4.0f;
        int iconColumns = Math.max((int)(unit.hitSize() / (iconSize + 1.0f)), 4);
        float iconWidth = Math.min(unit.hitSize() / (float)iconColumns, iconSize + 1.0f);
        for (StatusEntry entry : unit.statuses()) {
            Draw.color((Color)entry.effect.color);
            Draw.rect((TextureRegion)entry.effect.fullIcon, (float)(unit.x - unit.hitSize() * 0.6f + iconWidth * (index % (float)iconColumns)), (float)(unit.y + unit.hitSize() / 2.0f + 3.0f + iconSize * (float)Mathf.floor((float)(index / (float)iconColumns))), (float)iconSize, (float)iconSize);
            index += 1.0f;
        }
        Draw.color();
        index = 0.0f;
        if (unit instanceof Payloadc && (payload = (Payloadc)unit).payloads().any()) {
            for (Payload p : payload.payloads()) {
                Draw.rect((TextureRegion)p.content().fullIcon, (float)(unit.x - unit.hitSize() * 0.6f + 0.5f * iconSize * index), (float)(unit.y + unit.hitSize() / 2.0f - 4.0f), (float)4.0f, (float)4.0f);
                index += 1.0f;
            }
        }
    }

    private static void drawLogicMove(Unit unit, LogicAI ai) {
        if (Mathf.len((float)(ai.moveX - unit.x), (float)(ai.moveY - unit.y)) > 1200.0f) {
            return;
        }
        Draw.color((float)0.2f, (float)0.2f, (float)1.0f, (float)0.9f);
        Lines.dashLine(unit.x, unit.y, ai.moveX, ai.moveY, (int)(Mathf.len((float)(ai.moveX - unit.x), (float)(ai.moveY - unit.y)) / 8.0f));
        Lines.dashCircle(ai.moveX, ai.moveY, ai.moveRad);
        Draw.color();
    }

    private static void drawLogicTimer(Unit unit, LogicAI ai) {
        Draw.color((Color)Pal.heal);
        Lines.stroke(2.0f);
        Lines.line(unit.x - unit.hitSize() / 2.0f, unit.y - unit.hitSize() / 2.0f, unit.x - unit.hitSize() / 2.0f, unit.y + unit.hitSize() * (ai.controlTimer / 600.0f - 0.5f));
        Draw.reset();
    }

    private static void drawBuildPlan(Unit unit) {
        if (unit.plans().isEmpty()) {
            return;
        }
        if (unit != Vars.player.unit()) {
            int counter = 100;
            for (BuildPlan b : unit.plans()) {
                unit.drawPlan(b, 0.5f);
                if (--counter >= 0) continue;
                break;
            }
        }
        Draw.color((Color)Pal.gray);
        Lines.stroke(2.0f);
        ArcUnits.drawBuildPlan0(unit);
        Draw.color((Color)unit.team.color);
        Lines.stroke(0.75f);
        ArcUnits.drawBuildPlan0(unit);
        Draw.color();
        Lines.stroke(1.0f);
    }

    private static void drawBuildPlan0(Unit unit) {
        int counter = 100;
        float x = unit.x;
        float y = unit.y;
        float s = unit.hitSize / 2.0f;
        for (BuildPlan b : unit.plans()) {
            Tmp.v2.trns(Angles.angle((float)x, (float)y, (float)b.drawx(), (float)b.drawy()), s);
            Tmp.v3.trns(Angles.angle((float)x, (float)y, (float)b.drawx(), (float)b.drawy()), (float)b.block.size * 2.0f);
            Lines.circle(b.drawx(), b.drawy(), (float)b.block.size * 2.0f);
            Lines.line(x + Tmp.v2.x, y + Tmp.v2.y, b.drawx() - Tmp.v3.x, b.drawy() - Tmp.v3.y);
            x = b.drawx();
            y = b.drawy();
            s = (float)b.block.size * 2.0f;
            if (--counter >= 0) continue;
            break;
        }
    }

    private static void drawBuildRange(Unit unit) {
        Draw.z((float)108.0f);
        if (Vars.control.input.droppingItem) {
            Color color = Vars.player.within((Position)Core.input.mouseWorld(Vars.control.input.getMouseX(), Vars.control.input.getMouseY()), 220.0f) ? Color.gold : Color.red;
            Draw.color((Color)color);
            ArcUnits.drawNSideRegionArc(unit.x, unit.y, 3, unit.type.buildRange, 90.0f, 0.25f);
            Draw.color();
            ArcUnits.drawNSideRegionIcon(unit.x, unit.y, 3, unit.type.buildRange, 90.0f, 0.25f, unit.stack.item.fullIcon);
        } else if (Vars.control.input.isBuilding || Vars.control.input.selectedBlock() || !unit.plans().isEmpty()) {
            Draw.color((Color)Pal.heal);
            ArcUnits.drawNSideRegionArc(unit.x, unit.y, 3, unit.type.buildRange, 90.0f, 0.25f);
            ArcUnits.drawNSideRegionIcon(unit.x, unit.y, 3, unit.type.buildRange, 90.0f, 0.25f, Icon.wrench.getRegion());
            Draw.color();
        }
    }

    public static void drawNSideRegionArc(float x, float y, int n, float range, float rotation, float fraction) {
        Lines.stroke(2.0f);
        for (int i = 0; i < n; ++i) {
            float frac = 360.0f * (1.0f - fraction * (float)n) / (float)n / 2.0f;
            float rot = rotation + (float)i * 360.0f / (float)n + frac;
            Lines.arc(x, y, range, 0.25f, rot, (int)(50.0f + range / 10.0f));
        }
        Lines.stroke(1.0f);
    }

    public static void drawNSideRegionIcon(float x, float y, int n, float range, float rotation, float fraction, TextureRegion region) {
        for (int i = 0; i < n; ++i) {
            float frac = 360.0f * (1.0f - fraction * (float)n) / (float)n / 2.0f;
            float rot = rotation + (float)i * 360.0f / (float)n + frac;
            Draw.rect((TextureRegion)region, (float)(x + range * Mathf.cos((float)((float)Math.toRadians(rot - frac)))), (float)(y + range * Mathf.sin((float)((float)Math.toRadians(rot - frac)))), (float)12.0f, (float)12.0f);
        }
    }

    static {
        Events.run((Object)EventType.Trigger.update, () -> {
            alwaysShowUnitRTSAi = Core.settings.getBool("alwaysShowUnitRTSAi");
            unitHealthBar = Core.settings.getBool("unitHealthBar");
            unitLogicMoveLine = Core.settings.getBool("unitLogicMoveLine");
            unitLogicTimerBars = Core.settings.getBool("unitLogicTimerBars");
            unitBuildPlan = Core.settings.getBool("unitbuildplan");
            unitWeaponRange = Core.settings.getInt("unitWeaponRange") * 8;
            unitWeaponRangeAlpha = (float)Core.settings.getInt("unitWeaponRangeAlpha") / 100.0f;
            selectedUnitsFlyer = Vars.control.input.selectedUnits.contains(Unitc::isFlying);
            selectedUnitsLand = Vars.control.input.selectedUnits.contains(unit -> !unit.isFlying());
            curStroke = (float)Core.settings.getInt("playerEffectCurStroke") / 10.0f;
            unitTargetType = Core.settings.getInt("unitTargetType");
            superUnitEffect = Core.settings.getInt("superUnitEffect");
            arcBuildInfo = Core.settings.getBool("arcBuildInfo");
        });
    }
}

