/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features;

import arc.Events;
import arc.func.Floatp;
import arc.math.WindowedMean;
import arc.scene.ui.layout.Table;
import arc.util.Reflect;
import arc.util.Strings;
import arc.util.Time;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.ui.Styles;

public class TimeControl {
    public static float gameSpeed = 1.0f;
    public static int targetFps = 60;
    public static boolean fpsLock = false;
    private static final WindowedMean gameSpeedBalance = new WindowedMean(120);
    private static Floatp origin;
    private static final Floatp deltaProvider;

    public static void init() {
        origin = (Floatp)Reflect.get(Time.class, (String)"deltaimpl");
        Events.on(EventType.ResetEvent.class, e -> {
            gameSpeed = 1.0f;
            targetFps = 60;
            fpsLock = false;
        });
    }

    public static void setGameSpeed(float speed) {
        gameSpeed = speed;
        if (fpsLock) {
            fpsLock = false;
            Vars.ui.announce(Strings.format((String)"\u5df2\u5173\u95ed\u5e27\u7387\u9501\u5b9a\u6a21\u5f0f\n\u5f53\u524d\u6e38\u620f\u901f\u5ea6\uff1a@\u500d", (Object[])new Object[]{Float.valueOf(gameSpeed)}));
        } else {
            Vars.ui.announce(Strings.format((String)"\u5f53\u524d\u6e38\u620f\u901f\u5ea6\uff1a@\u500d", (Object[])new Object[]{Float.valueOf(gameSpeed)}));
        }
        Time.setDeltaProvider((Floatp)(gameSpeed == 1.0f ? origin : deltaProvider));
    }

    public static void setFpsLock() {
        gameSpeedBalance.clear();
        fpsLock = true;
        Vars.ui.announce(Strings.format((String)"\u5df2\u5f00\u542f\u5e27\u7387\u9501\u5b9a\u6a21\u5f0f\n\u5f53\u524d\u5e27\u7387\u9501\u5b9a\uff1a@", (Object[])new Object[]{targetFps}));
        Time.setDeltaProvider((Floatp)deltaProvider);
    }

    public static float getGameSpeed() {
        if (fpsLock) {
            return gameSpeedBalance.rawMean();
        }
        return gameSpeed;
    }

    public static void draw(Table table2) {
        table2.label(() -> "x" + Strings.autoFixed((float)TimeControl.getGameSpeed(), (int)2)).width(54.0f);
        table2.button("/2", Styles.cleart, () -> TimeControl.setGameSpeed(gameSpeed * 0.5f)).tooltip("\u5c06\u65f6\u95f4\u6d41\u901f\u653e\u6162\u5230\u4e00\u534a").size(40.0f, 30.0f);
        table2.button("\u00d72", Styles.cleart, () -> TimeControl.setGameSpeed(gameSpeed * 2.0f)).tooltip("\u5c06\u65f6\u95f4\u6d41\u901f\u52a0\u5feb\u5230\u4e24\u500d").size(40.0f, 30.0f);
        table2.button("[red]S", Styles.cleart, () -> TimeControl.setGameSpeed(0.0f)).tooltip("\u6682\u505c\u65f6\u95f4").size(30.0f, 30.0f);
        table2.button("[green]N", Styles.cleart, () -> TimeControl.setGameSpeed(1.0f)).tooltip("\u6062\u590d\u539f\u901f").size(30.0f, 30.0f);
        table2.button("[white]F", Styles.cleart, TimeControl::setFpsLock).tooltip("\u5e27\u7387\u6a21\u62df").size(30.0f, 30.0f);
        table2.field(Integer.toString(targetFps), s -> {
            int num = Integer.parseInt(s);
            if (num < 2 || num > 10000) {
                return;
            }
            targetFps = num;
            if (fpsLock) {
                Vars.ui.announce(Strings.format((String)"\u5f53\u524d\u5e27\u7387\u9501\u5b9a\uff1a@", (Object[])new Object[]{targetFps}));
            }
        }).valid(s -> {
            if (!Strings.canParsePositiveInt((String)s)) {
                return false;
            }
            int num = Integer.parseInt(s);
            return 2 <= num && num < 10000;
        }).tooltip("\u5141\u8bb8\u7684\u8303\u56f4\uff1a2~9999").size(80.0f, 30.0f);
    }

    static {
        deltaProvider = () -> {
            float delta = origin.get();
            if (fpsLock) {
                gameSpeedBalance.add(60.0f / (delta * (float)targetFps));
                return 60.0f / (float)targetFps;
            }
            return delta * gameSpeed;
        };
    }
}

