/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features;

import arc.Core;
import arc.graphics.Color;
import arc.input.KeyCode;
import arc.scene.Element;
import arc.scene.event.ClickListener;
import arc.scene.event.EventListener;
import arc.scene.event.InputEvent;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.ui.Button;
import arc.scene.ui.CheckBox;
import arc.scene.ui.ImageButton;
import arc.scene.ui.Slider;
import arc.scene.ui.TextArea;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Stack;
import arc.scene.ui.layout.Table;
import arc.util.Log;
import arc.util.Reflect;
import arc.util.Time;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import mindustry.Vars;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.io.JsonIO;
import mindustry.ui.Styles;
import mindustryX.features.SettingsV2;
import mindustryX.features.UIExtKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\t\u001e\u001f !\"#$%&B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0013\u001a\u00020\u0012J$\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0012\b\u0002\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u0018H\u0007J\"\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0010\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u001dH\u0007R5\u0010\u0004\u001a&\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005j\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"LmindustryX/features/SettingsV2;", "", "<init>", "()V", "ALL", "Ljava/util/LinkedHashMap;", "", "LmindustryX/features/SettingsV2$DataCore;", "Lkotlin/collections/LinkedHashMap;", "getALL", "()Ljava/util/LinkedHashMap;", "categoryOverride", "", "getCategoryOverride", "()Ljava/util/Map;", "lateInit", "", "Lkotlin/Function0;", "", "init", "buildSettingsTable", "table", "Larc/scene/ui/layout/Table;", "settings", "", "LmindustryX/features/SettingsV2$Data;", "bindQuickSettings", "button", "Larc/scene/ui/Button;", "", "DataCore", "WithUI", "Data", "PersistentProvider", "CheckPref", "SliderPref", "ChoosePref", "TextPref", "CategoryUI", "core"})
@SourceDebugExtension(value={"SMAP\nSettingsV2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsV2.kt\nmindustryX/features/SettingsV2\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,332:1\n1863#2,2:333\n808#2,11:335\n1863#2:346\n1864#2:354\n1053#2:355\n1863#2,2:356\n381#3,7:347\n*S KotlinDebug\n*F\n+ 1 SettingsV2.kt\nmindustryX/features/SettingsV2\n*L\n248#1:333,2\n269#1:335,11\n280#1:346\n280#1:354\n289#1:355\n289#1:356,2\n281#1:347,7\n*E\n"})
public final class SettingsV2 {
    @NotNull
    public static final SettingsV2 INSTANCE = new SettingsV2();
    @NotNull
    private static final LinkedHashMap<String, DataCore<?>> ALL = new LinkedHashMap();
    @NotNull
    private static final Map<String, String> categoryOverride = new LinkedHashMap();
    @NotNull
    private static final List<Function0<Unit>> lateInit = new ArrayList();

    private SettingsV2() {
    }

    @NotNull
    public final LinkedHashMap<String, DataCore<?>> getALL() {
        return ALL;
    }

    @NotNull
    public final Map<String, String> getCategoryOverride() {
        return categoryOverride;
    }

    public final void init() {
        Iterable $this$forEach$iv = lateInit;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
        lateInit.clear();
    }

    @JvmStatic
    @JvmOverloads
    public static final void buildSettingsTable(@NotNull Table table2, @NotNull List<? extends Data<?>> settings) {
        Table table3;
        Intrinsics.checkNotNullParameter(table2, "table");
        Intrinsics.checkNotNullParameter(settings, "settings");
        table2.clearChildren();
        Table searchTable = (Table)table2.table().growX().get();
        table2.row();
        Table contentTable = (Table)table2.table().growX().get();
        table2.row();
        Ref.ObjectRef<String> settingSearch = new Ref.ObjectRef<String>();
        settingSearch.element = "";
        Table $this$buildSettingsTable_u24lambda_u246 = table3 = searchTable;
        boolean bl = false;
        $this$buildSettingsTable_u24lambda_u246.image((Drawable)Icon.zoom);
        $this$buildSettingsTable_u24lambda_u246.field((String)settingSearch.element, arg_0 -> SettingsV2.buildSettingsTable$lambda$6$lambda$5(settingSearch, contentTable, settings, arg_0)).growX();
        SettingsV2.buildSettingsTable$rebuildContent(contentTable, settings, settingSearch);
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ void buildSettingsTable$default(Table table2, List list, int n, Object object) {
        if ((n & 2) != 0) {
            void $this$filterIsInstanceTo$iv$iv;
            Collection<DataCore<?>> collection = ALL.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$filterIsInstance$iv = collection;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Data)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        SettingsV2.buildSettingsTable(table2, list);
    }

    @JvmStatic
    public static final void bindQuickSettings(@NotNull Button button2, @NotNull Iterable<? extends Data<?>> settings) {
        Intrinsics.checkNotNullParameter(button2, "button");
        Intrinsics.checkNotNullParameter(settings, "settings");
        button2.removeListener((EventListener)button2.getClickListener());
        Reflect.set(Button.class, (Object)button2, (String)"clickListener", (Object)new ClickListener(button2, settings){
            private long startTime;
            final /* synthetic */ Button $button;
            final /* synthetic */ Iterable<Data<?>> $settings;
            {
                this.$button = $button;
                this.$settings = $settings;
                this.startTime = Long.MAX_VALUE;
            }

            public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button2) {
                if (super.touchDown(event, x, y, pointer, button2)) {
                    this.startTime = Time.millis();
                    return true;
                }
                return false;
            }

            public void clicked(InputEvent event, float x, float y) {
                Intrinsics.checkNotNullParameter(event, "event");
                if (Core.input.keyDown(KeyCode.shiftLeft) || Time.timeSinceMillis((long)this.startTime) > 500L) {
                    UIExtKt.showFloatSettingsPanel(arg_0 -> bindQuickSettings.1.clicked$lambda$1(this.$settings, arg_0));
                } else {
                    if (this.$button.isDisabled()) {
                        return;
                    }
                    this.$button.setProgrammaticChangeEvents(true);
                    this.$button.toggle();
                }
            }

            private static final Unit clicked$lambda$1(Iterable $settings, Table $this$showFloatSettingsPanel) {
                Intrinsics.checkNotNullParameter($this$showFloatSettingsPanel, "$this$showFloatSettingsPanel");
                Iterable $this$forEach$iv = $settings;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Data it = (Data)element$iv;
                    boolean bl = false;
                    $this$showFloatSettingsPanel.add((Element)it.buildUI()).growX().padBottom(4.0f).row();
                }
                return Unit.INSTANCE;
            }
        });
        button2.addListener((EventListener)button2.getClickListener());
    }

    @JvmStatic
    @JvmOverloads
    public static final void buildSettingsTable(@NotNull Table table2) {
        Intrinsics.checkNotNullParameter(table2, "table");
        SettingsV2.buildSettingsTable$default(table2, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final void buildSettingsTable$rebuildContent(Table contentTable, List<? extends Data<?>> $settings, Ref.ObjectRef<String> settingSearch) {
        contentTable.clearChildren();
        Map categories = new LinkedHashMap();
        Iterable $this$forEach$iv = $settings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CategoryUI category;
            boolean match;
            Object object;
            void $this$getOrPut$iv;
            Data setting = (Data)element$iv;
            boolean bl = false;
            Map map = categories;
            String key$iv = setting.getCategory();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                CategoryUI answer$iv = new CategoryUI(setting.getCategory());
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            if (!(match = StringsKt.contains((CharSequence)(category = (CategoryUI)object).getKey(), (CharSequence)settingSearch.element, true) || StringsKt.contains((CharSequence)category.getTitle(), (CharSequence)settingSearch.element, true) || StringsKt.contains$default((CharSequence)settingSearch.element, "@modified", false, 2, null) && !Intrinsics.areEqual(setting.getValue(), setting.getDef()) || StringsKt.contains((CharSequence)setting.getName(), (CharSequence)settingSearch.element, true) || StringsKt.contains((CharSequence)setting.getTitle(), (CharSequence)settingSearch.element, true))) continue;
            category.getChildren().add(setting);
        }
        Iterable $this$sortedBy$iv = categories.entrySet();
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)((String)it.getKey())));
            }
        });
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            contentTable.add((Element)((CategoryUI)it.getValue()).buildUI()).growX().padBottom(8.0f).row();
        }
    }

    private static final void buildSettingsTable$lambda$6$lambda$5(Ref.ObjectRef $settingSearch, Table $contentTable, List $settings, String it) {
        $settingSearch.element = it;
        SettingsV2.buildSettingsTable$rebuildContent($contentTable, $settings, $settingSearch);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"LmindustryX/features/SettingsV2$CategoryUI;", "LmindustryX/features/SettingsV2$WithUI;", "key", "", "<init>", "(Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "title", "getTitle", "children", "", "getChildren", "()Ljava/util/List;", "buildUI", "Larc/scene/ui/layout/Table;", "core"})
    @SourceDebugExtension(value={"SMAP\nSettingsV2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsV2.kt\nmindustryX/features/SettingsV2$CategoryUI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,332:1\n1863#2,2:333\n*S KotlinDebug\n*F\n+ 1 SettingsV2.kt\nmindustryX/features/SettingsV2$CategoryUI\n*L\n261#1:333,2\n*E\n"})
    public static final class CategoryUI
    implements WithUI {
        @NotNull
        private final String key;
        @NotNull
        private final String title;
        @NotNull
        private final List<WithUI> children;

        public CategoryUI(@NotNull String key) {
            Intrinsics.checkNotNullParameter(key, "key");
            this.key = key;
            String string = Core.bundle.get("settingV2." + this.key + ".category", this.key);
            Intrinsics.checkNotNullExpressionValue(string, "get(...)");
            this.title = string;
            this.children = new ArrayList();
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final List<WithUI> getChildren() {
            return this.children;
        }

        @Override
        @NotNull
        public Table buildUI() {
            Table table2;
            Table $this$buildUI_u24lambda_u241 = table2 = new Table();
            boolean bl = false;
            if (((CharSequence)this.key).length() > 0 && !((Collection)this.children).isEmpty()) {
                $this$buildUI_u24lambda_u241.add((CharSequence)this.title).color(Pal.accent).padTop(10.0f).padBottom(5.0f).center().row();
                $this$buildUI_u24lambda_u241.image().color(Pal.accent).growX().height(3.0f).padBottom(10.0f).row();
            }
            Iterable $this$forEach$iv = this.children;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WithUI it = (WithUI)element$iv;
                boolean bl2 = false;
                $this$buildUI_u24lambda_u241.add((Element)it.buildUI()).growX().padBottom(4.0f).row();
            }
            return table2;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"LmindustryX/features/SettingsV2$CheckPref;", "LmindustryX/features/SettingsV2$Data;", "", "name", "", "def", "<init>", "(Ljava/lang/String;Z)V", "toggle", "", "uiElement", "Larc/scene/Element;", "buildUI", "Larc/scene/ui/layout/Table;", "core"})
    public static final class CheckPref
    extends Data<Boolean> {
        @JvmOverloads
        public CheckPref(@NotNull String name, boolean def) {
            Intrinsics.checkNotNullParameter(name, "name");
            super(name, def);
        }

        public /* synthetic */ CheckPref(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(string, bl);
        }

        public final void toggle() {
            this.set((Boolean)this.getValue() == false);
        }

        @NotNull
        public final Element uiElement() {
            CheckBox box = new CheckBox(this.getTitle());
            box.changed(() -> CheckPref.uiElement$lambda$0(this, box));
            box.update(() -> CheckPref.uiElement$lambda$1(box, this));
            return (Element)box;
        }

        @Override
        @NotNull
        public Table buildUI() {
            Table table2;
            Table $this$buildUI_u24lambda_u242 = table2 = new Table();
            boolean bl = false;
            $this$buildUI_u24lambda_u242.add(this.uiElement());
            $this$buildUI_u24lambda_u242.add().expandX();
            this.addTools($this$buildUI_u24lambda_u242);
            return table2;
        }

        @JvmOverloads
        public CheckPref(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            this(name, false, 2, null);
        }

        private static final void uiElement$lambda$0(CheckPref this$0, CheckBox $box) {
            this$0.set($box.isChecked());
        }

        private static final void uiElement$lambda$1(CheckBox $box, CheckPref this$0) {
            $box.setChecked(((Boolean)this$0.getValue()).booleanValue());
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\f\u001a\u00020\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"LmindustryX/features/SettingsV2$ChoosePref;", "LmindustryX/features/SettingsV2$SliderPref;", "name", "", "values", "", "def", "", "<init>", "(Ljava/lang/String;Ljava/util/List;I)V", "getValues", "()Ljava/util/List;", "cycle", "", "core"})
    public static final class ChoosePref
    extends SliderPref {
        @NotNull
        private final List<String> values;

        @JvmOverloads
        public ChoosePref(@NotNull String name, @NotNull List<String> values2, int def) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(values2, "values");
            super(name, def, 0, values2.size() - 1, 0, arg_0 -> ChoosePref._init_$lambda$0(values2, arg_0), 16, null);
            this.values = values2;
        }

        public /* synthetic */ ChoosePref(String string, List list, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            this(string, list, n);
        }

        @NotNull
        public final List<String> getValues() {
            return this.values;
        }

        public final void cycle() {
            this.set((((Number)this.getValue()).intValue() + 1) % this.values.size());
        }

        @JvmOverloads
        public ChoosePref(@NotNull String name, @NotNull List<String> values2) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(values2, "values");
            this(name, values2, 0, 4, null);
        }

        private static final String _init_$lambda$0(List $values, int it) {
            return (String)$values.get(it);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0011H\u0004R\u0011\u0010\t\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0014"}, d2={"LmindustryX/features/SettingsV2$Data;", "T", "LmindustryX/features/SettingsV2$DataCore;", "LmindustryX/features/SettingsV2$WithUI;", "name", "", "def", "<init>", "(Ljava/lang/String;Ljava/lang/Object;)V", "category", "getCategory", "()Ljava/lang/String;", "title", "getTitle", "description", "getDescription", "buildUI", "Larc/scene/ui/layout/Table;", "addTools", "", "core"})
    public static class Data<T>
    extends DataCore<T>
    implements WithUI {
        public Data(@NotNull String name, T def) {
            Intrinsics.checkNotNullParameter(name, "name");
            super(name, def);
        }

        @NotNull
        public final String getCategory() {
            String string = INSTANCE.getCategoryOverride().get(this.getName());
            if (string == null) {
                string = StringsKt.substringBefore(this.getName(), '.', "");
            }
            return string;
        }

        @NotNull
        public final String getTitle() {
            String string = Core.bundle.get("settingV2." + this.getName() + ".name", this.getName());
            Intrinsics.checkNotNullExpressionValue(string, "get(...)");
            return string;
        }

        @Nullable
        public final String getDescription() {
            return Core.bundle.getOrNull("settingV2." + this.getName() + ".description");
        }

        @Override
        @NotNull
        public Table buildUI() {
            Table table2;
            Table $this$buildUI_u24lambda_u241 = table2 = new Table();
            boolean bl = false;
            $this$buildUI_u24lambda_u241.add((CharSequence)this.getTitle()).padRight(8.0f);
            $this$buildUI_u24lambda_u241.label(() -> Data.buildUI$lambda$1$lambda$0(this)).ellipsis(true).color(Color.gray).labelAlign(8).growX();
            this.addTools($this$buildUI_u24lambda_u241);
            return table2;
        }

        protected final void addTools(@NotNull Table $this$addTools) {
            Intrinsics.checkNotNullParameter($this$addTools, "<this>");
            String help = this.getDescription();
            Cell cell = $this$addTools.button((Drawable)Icon.info, Styles.clearNonei, () -> Data.addTools$lambda$2(help));
            String string = help;
            if (string == null) {
                string = "@none";
            }
            cell.tooltip(string).fillY().padLeft(8.0f).disabled(arg_0 -> Data.addTools$lambda$3(help, arg_0));
            $this$addTools.button((Drawable)Icon.undo, Styles.clearNonei, () -> Data.addTools$lambda$4(this)).tooltip("@settingV2.reset").fillY().disabled(arg_0 -> Data.addTools$lambda$5(this, arg_0));
        }

        private static final CharSequence buildUI$lambda$1$lambda$0(Data this$0) {
            return String.valueOf(this$0.getValue());
        }

        private static final void addTools$lambda$2(String $help) {
            Vars.ui.showInfo($help);
        }

        private static final boolean addTools$lambda$3(String $help, ImageButton it) {
            return $help == null;
        }

        private static final void addTools$lambda$4(Data this$0) {
            this$0.resetDefault();
        }

        private static final boolean addTools$lambda$5(Data this$0, ImageButton it) {
            return Intrinsics.areEqual(this$0.getValue(), this$0.getDef());
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u001d\u001a\u00020\u00162\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u0007J\u0006\u0010\u001e\u001a\u00020\u001bJ\u0014\u0010\u001f\u001a\u00020\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u000eJ\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR \u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u00008F@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\u0014\u0010\u000bR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"LmindustryX/features/SettingsV2$DataCore;", "T", "", "name", "", "def", "<init>", "(Ljava/lang/String;Ljava/lang/Object;)V", "getName", "()Ljava/lang/String;", "getDef", "()Ljava/lang/Object;", "Ljava/lang/Object;", "persistentProvider", "LmindustryX/features/SettingsV2$PersistentProvider;", "getPersistentProvider", "()LmindustryX/features/SettingsV2$PersistentProvider;", "setPersistentProvider", "(LmindustryX/features/SettingsV2$PersistentProvider;)V", "value", "getValue", "init", "", "changedSet", "", "get", "set", "", "(Ljava/lang/Object;)V", "changed", "resetDefault", "addFallback", "provider", "addFallbackName", "core"})
    @SourceDebugExtension(value={"SMAP\nSettingsV2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsV2.kt\nmindustryX/features/SettingsV2$DataCore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,332:1\n1#2:333\n*E\n"})
    public static class DataCore<T> {
        @NotNull
        private final String name;
        private final T def;
        @NotNull
        private PersistentProvider<? extends T> persistentProvider;
        private T value;
        private boolean init;
        @NotNull
        private final Set<String> changedSet;

        public DataCore(@NotNull String name, T def) {
            Intrinsics.checkNotNullParameter(name, "name");
            this.name = name;
            this.def = def;
            this.persistentProvider = new PersistentProvider.Arc(this.name);
            this.value = this.def;
            this.changedSet = new LinkedHashSet();
            if (((Map)INSTANCE.getALL()).containsKey(this.name)) {
                Log.warn((String)("Settings initialized!: " + this.name), (Object[])new Object[0]);
            }
            ((Map)INSTANCE.getALL()).put(this.name, this);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final T getDef() {
            return this.def;
        }

        @NotNull
        public final PersistentProvider<T> getPersistentProvider() {
            return this.persistentProvider;
        }

        public final void setPersistentProvider(@NotNull PersistentProvider<? extends T> persistentProvider) {
            Intrinsics.checkNotNullParameter(persistentProvider, "<set-?>");
            this.persistentProvider = persistentProvider;
        }

        public final T getValue() {
            if (!this.init) {
                T t = this.persistentProvider.get();
                if (t != null) {
                    T it = t;
                    boolean bl = false;
                    this.value = it;
                }
                this.init = true;
            }
            return this.value;
        }

        public final T get() {
            return this.getValue();
        }

        public void set(T value) {
            if (Intrinsics.areEqual(value, this.getValue())) {
                return;
            }
            this.value = value;
            PersistentProvider<? extends T> persistentProvider = this.persistentProvider;
            PersistentProvider.Savable savable = persistentProvider instanceof PersistentProvider.Savable ? (PersistentProvider.Savable)persistentProvider : null;
            if (savable != null) {
                savable.set(value);
            }
            this.changedSet.clear();
        }

        @JvmOverloads
        public final boolean changed(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return this.changedSet.add(name);
        }

        public static /* synthetic */ boolean changed$default(DataCore dataCore, String string, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: changed");
            }
            if ((n & 1) != 0) {
                string = "DEFAULT";
            }
            return dataCore.changed(string);
        }

        public final void resetDefault() {
            this.value = this.def;
            this.changedSet.clear();
            this.persistentProvider.reset();
        }

        public final void addFallback(@NotNull PersistentProvider<? extends T> provider) {
            Intrinsics.checkNotNullParameter(provider, "provider");
            if (Intrinsics.areEqual(this.getValue(), this.def)) {
                T t = provider.get();
                if (t == null) {
                    t = this.def;
                }
                this.set(t);
            }
            provider.reset();
        }

        public final void addFallbackName(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            if (Core.settings == null) {
                lateInit.add(() -> DataCore.addFallbackName$lambda$1(this, name));
                return;
            }
            this.addFallback(new PersistentProvider.Arc(name));
        }

        @JvmOverloads
        public final boolean changed() {
            return DataCore.changed$default(this, null, 1, null);
        }

        private static final Unit addFallbackName$lambda$1(DataCore this$0, String $name) {
            this$0.addFallbackName($name);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002:\u0004\u0007\b\t\nJ\u000f\u0010\u0003\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u000b"}, d2={"LmindustryX/features/SettingsV2$PersistentProvider;", "T", "", "get", "()Ljava/lang/Object;", "reset", "", "Savable", "Noop", "Arc", "AsUBJson", "core"})
    public static interface PersistentProvider<T> {
        @Nullable
        public T get();

        public void reset();

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\n\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\rH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"LmindustryX/features/SettingsV2$PersistentProvider$Arc;", "T", "LmindustryX/features/SettingsV2$PersistentProvider;", "LmindustryX/features/SettingsV2$PersistentProvider$Savable;", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "get", "()Ljava/lang/Object;", "set", "", "value", "(Ljava/lang/Object;)V", "reset", "core"})
        public static final class Arc<T>
        implements PersistentProvider<T>,
        Savable<T> {
            @NotNull
            private final String name;

            public Arc(@NotNull String name) {
                Intrinsics.checkNotNullParameter(name, "name");
                this.name = name;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @Override
            @Nullable
            public T get() {
                return (T)Core.settings.get(this.name, null);
            }

            @Override
            public void set(T value) {
                Core.settings.put(this.name, value);
            }

            @Override
            public void reset() {
                Core.settings.remove(this.name);
            }

            @Override
            public void setOrReset(@Nullable T value) {
                Savable.DefaultImpls.setOrReset(this, value);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B1\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0002\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\r\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0014"}, d2={"LmindustryX/features/SettingsV2$PersistentProvider$AsUBJson;", "T", "LmindustryX/features/SettingsV2$PersistentProvider$Savable;", "base", "", "cls", "Ljava/lang/Class;", "elementClass", "<init>", "(LmindustryX/features/SettingsV2$PersistentProvider$Savable;Ljava/lang/Class;Ljava/lang/Class;)V", "getCls", "()Ljava/lang/Class;", "getElementClass", "get", "()Ljava/lang/Object;", "set", "", "value", "(Ljava/lang/Object;)V", "reset", "core"})
        public static final class AsUBJson<T>
        implements Savable<T> {
            @NotNull
            private final Savable<byte[]> base;
            @NotNull
            private final Class<?> cls;
            @Nullable
            private final Class<?> elementClass;

            public AsUBJson(@NotNull Savable<byte[]> base, @NotNull Class<?> cls, @Nullable Class<?> elementClass) {
                Intrinsics.checkNotNullParameter(base, "base");
                Intrinsics.checkNotNullParameter(cls, "cls");
                this.base = base;
                this.cls = cls;
                this.elementClass = elementClass;
            }

            public /* synthetic */ AsUBJson(Savable savable, Class clazz, Class clazz2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    clazz2 = null;
                }
                this(savable, clazz, clazz2);
            }

            @NotNull
            public final Class<?> getCls() {
                return this.cls;
            }

            @Nullable
            public final Class<?> getElementClass() {
                return this.elementClass;
            }

            @Override
            @Nullable
            public T get() {
                byte[] byArray = (byte[])this.base.get();
                if (byArray == null) {
                    return null;
                }
                byte[] bs = byArray;
                Class<?> clazz = this.cls;
                Intrinsics.checkNotNull(clazz, "null cannot be cast to non-null type java.lang.Class<T of mindustryX.features.SettingsV2.PersistentProvider.AsUBJson>");
                return (T)JsonIO.readBytes(clazz, this.elementClass, (DataInputStream)new DataInputStream(new ByteArrayInputStream(bs)));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(T value) {
                byte[] byArray;
                Closeable closeable = new ByteArrayOutputStream();
                Throwable throwable = null;
                try {
                    ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
                    boolean bl = false;
                    JsonIO.writeBytes(value, this.elementClass, (DataOutputStream)new DataOutputStream(it));
                    byArray = it.toByteArray();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
                byte[] bs = byArray;
                Intrinsics.checkNotNull(bs);
                this.base.set(bs);
            }

            @Override
            public void reset() {
                this.base.reset();
            }

            @Override
            public void setOrReset(@Nullable T value) {
                Savable.DefaultImpls.setOrReset(this, value);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001\u00a8\u0006\u0010"}, d2={"LmindustryX/features/SettingsV2$PersistentProvider$Noop;", "LmindustryX/features/SettingsV2$PersistentProvider;", "", "<init>", "()V", "get", "reset", "", "equals", "", "other", "", "hashCode", "", "toString", "", "core"})
        public static final class Noop
        implements PersistentProvider {
            @NotNull
            public static final Noop INSTANCE = new Noop();

            private Noop() {
            }

            @Nullable
            public Void get() {
                return null;
            }

            @Override
            public void reset() {
            }

            @NotNull
            public String toString() {
                return "Noop";
            }

            public int hashCode() {
                return -1457580951;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Noop)) {
                    return false;
                }
                Noop cfr_ignored_0 = (Noop)other;
                return true;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u0007\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\b"}, d2={"LmindustryX/features/SettingsV2$PersistentProvider$Savable;", "T", "LmindustryX/features/SettingsV2$PersistentProvider;", "set", "", "value", "(Ljava/lang/Object;)V", "setOrReset", "core"})
        public static interface Savable<T>
        extends PersistentProvider<T> {
            public void set(T var1);

            public void setOrReset(@Nullable T var1);

            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public static final class DefaultImpls {
                public static <T> void setOrReset(@NotNull Savable<T> $this, @Nullable T value) {
                    T t = value;
                    if (t == null) {
                        $this.reset();
                    } else {
                        $this.set(t);
                    }
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BI\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\u0002\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"LmindustryX/features/SettingsV2$SliderPref;", "LmindustryX/features/SettingsV2$Data;", "", "name", "", "def", "min", "max", "step", "labelMap", "Lkotlin/Function1;", "<init>", "(Ljava/lang/String;IIIILkotlin/jvm/functions/Function1;)V", "getMin", "()I", "getMax", "getStep", "getLabelMap", "()Lkotlin/jvm/functions/Function1;", "set", "", "value", "uiElement", "Larc/scene/Element;", "buildUI", "Larc/scene/ui/layout/Table;", "core"})
    public static class SliderPref
    extends Data<Integer> {
        private final int min;
        private final int max;
        private final int step;
        @NotNull
        private final Function1<Integer, String> labelMap;

        @JvmOverloads
        public SliderPref(@NotNull String name, int def, int min, int max, int step, @NotNull Function1<? super Integer, String> labelMap) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(labelMap, "labelMap");
            super(name, def);
            this.min = min;
            this.max = max;
            this.step = step;
            this.labelMap = labelMap;
        }

        public /* synthetic */ SliderPref(String string, int n, int n2, int n3, int n4, Function1 function1, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 0x10) != 0) {
                n4 = 1;
            }
            if ((n5 & 0x20) != 0) {
                function1 = SliderPref::_init_$lambda$0;
            }
            this(string, n, n2, n3, n4, function1);
        }

        public final int getMin() {
            return this.min;
        }

        public final int getMax() {
            return this.max;
        }

        public final int getStep() {
            return this.step;
        }

        @NotNull
        public final Function1<Integer, String> getLabelMap() {
            return this.labelMap;
        }

        @Override
        public void set(int value) {
            super.set(RangesKt.coerceIn(value, this.min, this.max));
        }

        @NotNull
        public final Element uiElement() {
            Element[] elementArray;
            Slider elem = new Slider((float)this.min, (float)this.max, (float)this.step, false);
            elem.changed(() -> SliderPref.uiElement$lambda$1(this, elem));
            elem.update(() -> SliderPref.uiElement$lambda$2(elem, this));
            Element[] $this$uiElement_u24lambda_u244 = elementArray = new Table();
            boolean bl = false;
            $this$uiElement_u24lambda_u244.touchable = Touchable.disabled;
            $this$uiElement_u24lambda_u244.add((CharSequence)this.getTitle(), Styles.outlineLabel).left().growX().wrap();
            $this$uiElement_u24lambda_u244.label(() -> SliderPref.uiElement$lambda$4$lambda$3(this)).style((Style)Styles.outlineLabel).padLeft(10.0f).right().get();
            Element[] content = elementArray;
            elementArray = new Element[]{elem, content};
            return (Element)new Stack(elementArray);
        }

        @Override
        @NotNull
        public Table buildUI() {
            Table table2;
            Table $this$buildUI_u24lambda_u245 = table2 = new Table();
            boolean bl = false;
            $this$buildUI_u24lambda_u245.add(this.uiElement()).minWidth(220.0f).growX();
            this.addTools($this$buildUI_u24lambda_u245);
            return table2;
        }

        @JvmOverloads
        public SliderPref(@NotNull String name, int def, int min, int max, int step) {
            Intrinsics.checkNotNullParameter(name, "name");
            this(name, def, min, max, step, null, 32, null);
        }

        @JvmOverloads
        public SliderPref(@NotNull String name, int def, int min, int max) {
            Intrinsics.checkNotNullParameter(name, "name");
            this(name, def, min, max, 0, null, 48, null);
        }

        private static final String _init_$lambda$0(int it) {
            return String.valueOf(it);
        }

        private static final void uiElement$lambda$1(SliderPref this$0, Slider $elem) {
            this$0.set((int)$elem.getValue());
        }

        private static final void uiElement$lambda$2(Slider $elem, SliderPref this$0) {
            $elem.setValue((float)((Number)this$0.getValue()).intValue());
        }

        private static final CharSequence uiElement$lambda$4$lambda$3(SliderPref this$0) {
            return this$0.labelMap.invoke((Integer)this$0.getValue());
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"LmindustryX/features/SettingsV2$TextPref;", "LmindustryX/features/SettingsV2$Data;", "", "name", "def", "prefRows", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;I)V", "getPrefRows", "()I", "set", "", "value", "uiElement", "Larc/scene/Element;", "buildUI", "Larc/scene/ui/layout/Table;", "core"})
    public static final class TextPref
    extends Data<String> {
        private final int prefRows;

        @JvmOverloads
        public TextPref(@NotNull String name, @NotNull String def, int prefRows) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(def, "def");
            super(name, def);
            this.prefRows = prefRows;
        }

        public /* synthetic */ TextPref(String string, String string2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                string2 = "";
            }
            if ((n2 & 4) != 0) {
                n = 1;
            }
            this(string, string2, n);
        }

        public final int getPrefRows() {
            return this.prefRows;
        }

        @Override
        public void set(@NotNull String value) {
            Intrinsics.checkNotNullParameter(value, "value");
            super.set(((Object)StringsKt.trim((CharSequence)value)).toString());
        }

        @NotNull
        public final Element uiElement() {
            TextField textField;
            if (this.prefRows <= 1) {
                textField = new TextField("");
            } else {
                TextArea textArea;
                TextArea $this$uiElement_u24lambda_u240 = textArea = new TextArea("");
                boolean bl = false;
                $this$uiElement_u24lambda_u240.setPrefRows((float)this.prefRows);
                textField = (TextField)textArea;
            }
            TextField elem = textField;
            elem.changed(() -> TextPref.uiElement$lambda$1(this, elem));
            elem.update(() -> TextPref.uiElement$lambda$2(elem, this));
            return (Element)elem;
        }

        @Override
        @NotNull
        public Table buildUI() {
            Table table2;
            Table $this$buildUI_u24lambda_u243 = table2 = new Table();
            boolean bl = false;
            if (this.prefRows > 1) {
                $this$buildUI_u24lambda_u243.add((CharSequence)this.getTitle()).left().expandX();
                this.addTools($this$buildUI_u24lambda_u243);
                $this$buildUI_u24lambda_u243.row().add(this.uiElement()).colspan($this$buildUI_u24lambda_u243.getColumns()).growX();
            } else {
                $this$buildUI_u24lambda_u243.add((CharSequence)this.getTitle()).padRight(8.0f);
                $this$buildUI_u24lambda_u243.add(this.uiElement()).growX();
                this.addTools($this$buildUI_u24lambda_u243);
            }
            return table2;
        }

        @JvmOverloads
        public TextPref(@NotNull String name, @NotNull String def) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(def, "def");
            this(name, def, 0, 4, null);
        }

        @JvmOverloads
        public TextPref(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            this(name, null, 0, 6, null);
        }

        private static final void uiElement$lambda$1(TextPref this$0, TextField $elem) {
            String string = $elem.getText();
            Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
            this$0.set(string);
        }

        private static final void uiElement$lambda$2(TextField $elem, TextPref this$0) {
            if (!$elem.hasKeyboard()) {
                $elem.setText((String)this$0.getValue());
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"LmindustryX/features/SettingsV2$WithUI;", "", "buildUI", "Larc/scene/ui/layout/Table;", "core"})
    public static interface WithUI {
        @NotNull
        public Table buildUI();
    }
}

