/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features;

import arc.Core;
import arc.Files;
import arc.files.Fi;
import arc.struct.IntIntMap;
import arc.struct.ObjectIntMap;
import arc.struct.Seq;
import arc.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mindustry.net.Net;
import mindustry.net.Packet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006$"}, d2={"LmindustryX/features/ProtocolMap;", "", "version", "", "<init>", "(Ljava/lang/String;)V", "getVersion", "()Ljava/lang/String;", "loaded", "", "getLoaded", "()Z", "setLoaded", "(Z)V", "mapping", "", "getMapping", "()Ljava/util/List;", "setMapping", "(Ljava/util/List;)V", "packetToId", "Larc/struct/ObjectIntMap;", "getPacketToId", "()Larc/struct/ObjectIntMap;", "idMapping", "Larc/struct/IntIntMap;", "getIdMapping", "()Larc/struct/IntIntMap;", "load", "", "getId", "", "packet", "Lmindustry/net/Packet;", "mapId", "oldId", "core"})
@SourceDebugExtension(value={"SMAP\nProtocolMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolMap.kt\nmindustryX/features/ProtocolMap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1557#2:51\n1628#2,3:52\n774#2:55\n865#2,2:56\n1872#2,3:58\n*S KotlinDebug\n*F\n+ 1 ProtocolMap.kt\nmindustryX/features/ProtocolMap\n*L\n23#1:51\n23#1:52,3\n23#1:55\n23#1:56,2\n27#1:58,3\n*E\n"})
public final class ProtocolMap {
    @NotNull
    private final String version;
    private boolean loaded;
    @NotNull
    private List<String> mapping;
    @NotNull
    private final ObjectIntMap<String> packetToId;
    @NotNull
    private final IntIntMap idMapping;

    public ProtocolMap(@NotNull String version) {
        Intrinsics.checkNotNullParameter(version, "version");
        this.version = version;
        this.mapping = CollectionsKt.emptyList();
        this.packetToId = new ObjectIntMap();
        this.idMapping = new IntIntMap();
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    public final boolean getLoaded() {
        return this.loaded;
    }

    public final void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    @NotNull
    public final List<String> getMapping() {
        return this.mapping;
    }

    public final void setMapping(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.mapping = list;
    }

    @NotNull
    public final ObjectIntMap<String> getPacketToId() {
        return this.packetToId;
    }

    @NotNull
    public final IntIntMap getIdMapping() {
        return this.idMapping;
    }

    /*
     * WARNING - void declaration
     */
    public final void load() {
        void $this$filterTo$iv$iv;
        Iterator<String> $this$filter$iv;
        String it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        Log.info((String)("Initializing " + this.version + " packets mapping..."), (Object[])new Object[0]);
        Fi fi = Core.files != null ? Core.files.internal("packets_" + this.version + ".txt") : new Fi("packets_" + this.version + ".txt", Files.FileType.internal);
        String string = fi.readString();
        Intrinsics.checkNotNullExpressionValue(string, "readString(...)");
        Iterable iterable = StringsKt.lines(string);
        ProtocolMap protocolMap = this;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        protocolMap.mapping = (List)destination$iv$iv;
        for (String name : this.mapping) {
            this.packetToId.put((Object)name, this.packetToId.size);
        }
        Seq<Class<? extends Packet>> seq = Net.allPacketClasses();
        Intrinsics.checkNotNullExpressionValue(seq, "allPacketClasses(...)");
        Iterable $this$forEachIndexed$iv = (Iterable)seq;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void packetClass;
            int n;
            Object element$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (Class)item$iv;
            int curId = n;
            boolean bl = false;
            int oldId = this.packetToId.get((Object)packetClass.getSimpleName(), -1);
            if (oldId != -1) {
                this.idMapping.put(oldId, curId);
                continue;
            }
            Log.warn((String)("New packet type: " + packetClass.getSimpleName()), (Object[])new Object[0]);
        }
        int n = ((Collection)this.mapping).size();
        for (int i = 0; i < n; ++i) {
            if (this.idMapping.containsKey(i)) continue;
            Log.warn((String)("Deleted packet: " + this.mapping.get(i)), (Object[])new Object[0]);
        }
        Log.info((String)("== End load " + this.version + " packets mapping =="), (Object[])new Object[0]);
    }

    public final int getId(@NotNull Packet packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        this.load();
        return this.packetToId.get((Object)packet.getClass().getSimpleName(), -1);
    }

    public final int mapId(int oldId) {
        this.load();
        return this.idMapping.get(oldId, -1);
    }
}

