/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.IntSet;
import arc.struct.Seq;
import arc.util.Strings;
import arc.util.Tmp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mindustry.Vars;
import mindustry.content.Items;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.ItemStack;
import mindustry.type.LiquidStack;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.campaign.LandingPad;
import mindustry.world.blocks.distribution.ArmoredConveyor;
import mindustry.world.blocks.distribution.Conveyor;
import mindustry.world.blocks.distribution.DirectionBridge;
import mindustry.world.blocks.distribution.DirectionLiquidBridge;
import mindustry.world.blocks.distribution.DirectionalUnloader;
import mindustry.world.blocks.distribution.Duct;
import mindustry.world.blocks.distribution.DuctBridge;
import mindustry.world.blocks.distribution.DuctJunction;
import mindustry.world.blocks.distribution.DuctRouter;
import mindustry.world.blocks.distribution.ItemBridge;
import mindustry.world.blocks.distribution.Junction;
import mindustry.world.blocks.distribution.MassDriver;
import mindustry.world.blocks.distribution.OverflowDuct;
import mindustry.world.blocks.distribution.OverflowGate;
import mindustry.world.blocks.distribution.Router;
import mindustry.world.blocks.distribution.Sorter;
import mindustry.world.blocks.distribution.StackConveyor;
import mindustry.world.blocks.liquid.ArmoredConduit;
import mindustry.world.blocks.liquid.Conduit;
import mindustry.world.blocks.liquid.LiquidBridge;
import mindustry.world.blocks.liquid.LiquidJunction;
import mindustry.world.blocks.liquid.LiquidRouter;
import mindustry.world.blocks.production.BeamDrill;
import mindustry.world.blocks.production.Drill;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.blocks.production.Incinerator;
import mindustry.world.blocks.production.Pump;
import mindustry.world.blocks.production.WallCrafter;
import mindustry.world.blocks.sandbox.ItemSource;
import mindustry.world.blocks.sandbox.ItemVoid;
import mindustry.world.blocks.sandbox.LiquidSource;
import mindustry.world.blocks.sandbox.LiquidVoid;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.blocks.storage.StorageBlock;
import mindustry.world.blocks.storage.Unloader;
import mindustry.world.blocks.units.UnitCargoUnloadPoint;
import mindustryX.features.func.FuncX;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0011)*+,-./0123456789B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00102\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0002J\u001c\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00102\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0002J*\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00052\b\b\u0002\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u0017\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020$0&H\u0082\bJ\u0017\u0010'\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020$0&H\u0082\bJ\u000e\u0010(\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u0010R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\n\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"LmindustryX/features/NewTransferScanMode;", "", "<init>", "()V", "itemInputColor", "Larc/graphics/Color;", "kotlin.jvm.PlatformType", "Larc/graphics/Color;", "itemOutputColor", "liquidInputColor", "liquidOutputColor", "draw", "", "maxStack", "", "startBuild", "Lmindustry/gen/Building;", "type", "LmindustryX/features/NewTransferScanMode$TransportType;", "drawColor", "visited", "Larc/struct/IntSet;", "stack", "Lkotlin/collections/ArrayDeque;", "drawOutput", "build", "previous", "drawInput", "drawConnection", "from", "to", "color", "alpha", "", "drawStackOverflow", "itemOnly", "LmindustryX/features/NewTransferScanMode$BuildingAdaptor;", "body", "Lkotlin/Function0;", "liquidOnly", "getWrapper", "TransportType", "BuildingAdaptor", "ConveyorAdaptor", "StackConveyorAdaptor", "RouterAdaptor", "InstantAdaptor", "UnloaderAdaptor", "DirectionalUnloaderAdaptor", "BridgeAdaptor", "JunctionAdaptor", "MassDriverAdaptor", "DirectionBridgeAdaptor", "GenericCrafterAdaptor", "SourceAdaptor", "VoidAdaptor", "DefaultAdaptor", "NoopAdaptor", "core"})
@SourceDebugExtension(value={"SMAP\nNewTransferScanMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewTransferScanMode.kt\nmindustryX/features/NewTransferScanMode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,427:1\n210#1:433\n210#1:434\n210#1:435\n210#1:436\n210#1:437\n210#1:438\n210#1:439\n209#1:440\n209#1:441\n209#1:442\n209#1:443\n209#1:444\n209#1:445\n209#1:446\n209#1:447\n209#1:448\n209#1:449\n209#1:450\n209#1:451\n209#1:452\n209#1:453\n209#1:454\n209#1:455\n1#2:428\n1863#3,2:429\n1863#3,2:431\n*S KotlinDebug\n*F\n+ 1 NewTransferScanMode.kt\nmindustryX/features/NewTransferScanMode\n*L\n218#1:433\n219#1:434\n220#1:435\n221#1:436\n222#1:437\n223#1:438\n224#1:439\n226#1:440\n227#1:441\n228#1:442\n229#1:443\n230#1:444\n231#1:445\n232#1:446\n233#1:447\n234#1:448\n235#1:449\n236#1:450\n237#1:451\n238#1:452\n239#1:453\n240#1:454\n241#1:455\n109#1:429,2\n135#1:431,2\n*E\n"})
public final class NewTransferScanMode {
    @NotNull
    public static final NewTransferScanMode INSTANCE = new NewTransferScanMode();
    private static final Color itemInputColor = Color.valueOf((String)"ff8000");
    private static final Color itemOutputColor = Color.valueOf((String)"80ff00");
    private static final Color liquidInputColor = Color.valueOf((String)"4080ff");
    private static final Color liquidOutputColor = Color.valueOf((String)"00ffff");
    private static final int maxStack = 128;
    @Nullable
    private static Building startBuild;
    @NotNull
    private static TransportType type;
    @NotNull
    private static Color drawColor;
    @NotNull
    private static final IntSet visited;
    @NotNull
    private static ArrayDeque<Building> stack;

    private NewTransferScanMode() {
    }

    public final void draw() {
        Draw.z((float)120.01f);
        Vec2 pos = Core.input.mouseWorld();
        Object[] objectArray = new Object[]{(int)(pos.x / (float)8), (int)(pos.y / (float)8), (int)(Vars.player.dst((Position)pos) / (float)8)};
        String text = Strings.format((String)"@,@\n\u8ddd\u79bb: @", (Object[])objectArray);
        Intrinsics.checkNotNull(pos);
        Position position = (Position)pos;
        Intrinsics.checkNotNull(text);
        FuncX.drawText$default(position, text, 0.0f, null, 0, null, false, 124, null);
        Draw.z((float)120.0f);
        Object object = Vars.world.tileWorld(Core.input.mouseWorld().x, Core.input.mouseWorld().y);
        if (object == null || (object = ((Tile)object).build) == null) {
            return;
        }
        Object build = object;
        if (!((Building)build).isDiscovered(Vars.player.team())) {
            return;
        }
        Drawf.selected((Building)build, (Color)Pal.accent);
        startBuild = build;
        type = TransportType.ITEM;
        drawColor = itemOutputColor;
        NewTransferScanMode.drawOutput$default(this, (Building)build, null, 2, null);
        visited.clear();
        type = TransportType.LIQUID;
        drawColor = liquidOutputColor;
        NewTransferScanMode.drawOutput$default(this, (Building)build, null, 2, null);
        visited.clear();
        type = TransportType.ITEM;
        drawColor = itemInputColor;
        NewTransferScanMode.drawInput$default(this, (Building)build, null, 2, null);
        visited.clear();
        type = TransportType.LIQUID;
        drawColor = liquidInputColor;
        NewTransferScanMode.drawInput$default(this, (Building)build, null, 2, null);
        visited.clear();
    }

    private final void drawOutput(Building build, Building previous) {
        Object object;
        List<Building> $this$drawOutput_u24lambda_u242;
        List<Building> list;
        block10: {
            BuildingAdaptor wrapper;
            block9: {
                Building building = previous;
                if (!visited.add(build.id * 10007 + (building != null ? building.id : 0))) {
                    return;
                }
                if (stack.size() == 128) {
                    this.drawStackOverflow(build);
                    return;
                }
                wrapper = this.getWrapper(build);
                if (wrapper.isEndPoint() && !Intrinsics.areEqual(build, startBuild)) {
                    Drawf.selected((Building)build, (Color)drawColor);
                    return;
                }
                list = CollectionsKt.createListBuilder();
                $this$drawOutput_u24lambda_u242 = list;
                boolean bl = false;
                object = previous;
                if (object == null) break block9;
                Building it = object;
                boolean bl2 = false;
                List<Building> list2 = wrapper.getOutputs(it);
                object = list2;
                if (list2 != null) break block10;
            }
            object = wrapper.getOutputs();
        }
        List<Building> outputs = object;
        for (Building output : outputs) {
            if (!INSTANCE.getWrapper(output).canInput(build)) continue;
            $this$drawOutput_u24lambda_u242.add(output);
        }
        Seq<Building> seq = build.proximity;
        Intrinsics.checkNotNullExpressionValue(seq, "proximity");
        Iterable $this$forEach$iv = (Iterable)seq;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Building it = (Building)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!INSTANCE.getWrapper(it).activeInput(build)) continue;
            $this$drawOutput_u24lambda_u242.add(it);
        }
        List<Building> validReceiver = CollectionsKt.build(list);
        stack.addLast(build);
        for (Building output : validReceiver) {
            Intrinsics.checkNotNull(output);
            NewTransferScanMode.drawConnection$default(this, build, output, drawColor, 0.0f, 8, null);
            this.drawOutput(output, build);
        }
        stack.removeLast();
    }

    static /* synthetic */ void drawOutput$default(NewTransferScanMode newTransferScanMode, Building building, Building building2, int n, Object object) {
        if ((n & 2) != 0) {
            building2 = null;
        }
        newTransferScanMode.drawOutput(building, building2);
    }

    private final void drawInput(Building build, Building previous) {
        Building building = previous;
        if (!visited.add(build.id * 10007 + (building != null ? building.id : 0))) {
            return;
        }
        if (stack.size() == 128) {
            this.drawStackOverflow(build);
            return;
        }
        BuildingAdaptor wrapper = this.getWrapper(build);
        if (wrapper.isEndPoint() && !Intrinsics.areEqual(build, startBuild)) {
            Drawf.selected((Building)build, (Color)drawColor);
            return;
        }
        List<Building> list = CollectionsKt.createListBuilder();
        List<Building> $this$drawInput_u24lambda_u245 = list;
        boolean bl = false;
        $this$drawInput_u24lambda_u245.addAll((Collection)wrapper.activeInputs());
        Seq<Building> seq = build.proximity;
        Intrinsics.checkNotNullExpressionValue(seq, "proximity");
        Iterable $this$forEach$iv = (Iterable)seq;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean canInput;
            boolean bl2;
            Building receiver = (Building)element$iv;
            boolean bl3 = false;
            if (previous != null) {
                Building it;
                boolean bl4 = false;
                Intrinsics.checkNotNull(receiver);
                bl2 = wrapper.canInput(receiver, it);
            } else {
                Intrinsics.checkNotNull(receiver);
                bl2 = wrapper.canInput(receiver);
            }
            if (!(canInput = bl2) || !INSTANCE.getWrapper(receiver).canOutput(build)) continue;
            $this$drawInput_u24lambda_u245.add(receiver);
        }
        List<Building> validSource = CollectionsKt.build(list);
        stack.addLast(build);
        for (Building source : validSource) {
            Intrinsics.checkNotNull(source);
            NewTransferScanMode.drawConnection$default(this, source, build, drawColor, 0.0f, 8, null);
            this.drawInput(source, build);
        }
        stack.removeLast();
    }

    static /* synthetic */ void drawInput$default(NewTransferScanMode newTransferScanMode, Building building, Building building2, int n, Object object) {
        if ((n & 2) != 0) {
            building2 = null;
        }
        newTransferScanMode.drawInput(building, building2);
    }

    private final void drawConnection(Building from, Building to, Color color, float alpha) {
        float x1 = from.tile.drawx();
        float y1 = from.tile.drawy();
        float x2 = to.tile.drawx();
        float y2 = to.tile.drawy();
        Draw.color((Color)color, (float)(alpha * (Mathf.absin((float)4.0f, (float)1.0f) * 0.4f + 0.6f)));
        Lines.stroke(1.5f);
        Lines.line(x1, y1, x2, y2);
        Draw.reset();
        float dst = Mathf.dst((float)x1, (float)y1, (float)x2, (float)y2);
        if (dst > 8.0f) {
            Draw.color((Color)color, (float)alpha);
            Fill.circle((float)x1, (float)y1, (float)1.8f);
            Vec2 fromPos = Tmp.v1.set(x1, y1);
            Vec2 toPos = Tmp.v2.set(x2, y2);
            Vec2 midPoint = Tmp.v3.set(fromPos).lerp(toPos, 0.5f);
            float angle = fromPos.angleTo((Position)toPos);
            Fill.poly((float)midPoint.x, (float)midPoint.y, (int)3, (float)3.0f, (float)angle);
            Draw.reset();
        }
    }

    static /* synthetic */ void drawConnection$default(NewTransferScanMode newTransferScanMode, Building building, Building building2, Color color, float f, int n, Object object) {
        if ((n & 8) != 0) {
            f = 1.0f;
        }
        newTransferScanMode.drawConnection(building, building2, color, f);
    }

    private final void drawStackOverflow(Building build) {
        Draw.color((Color)Color.orange);
        Draw.rect((TextureRegion)Icon.none.getRegion(), (float)build.x, (float)build.y);
        Draw.color();
    }

    private final BuildingAdaptor itemOnly(Function0<? extends BuildingAdaptor> body) {
        boolean $i$f$itemOnly = false;
        return type == TransportType.ITEM ? body.invoke() : (BuildingAdaptor)NoopAdaptor.INSTANCE;
    }

    private final BuildingAdaptor liquidOnly(Function0<? extends BuildingAdaptor> body) {
        boolean $i$f$liquidOnly = false;
        return type == TransportType.LIQUID ? body.invoke() : (BuildingAdaptor)NoopAdaptor.INSTANCE;
    }

    @NotNull
    public final BuildingAdaptor getWrapper(@NotNull Building build) {
        BuildingAdaptor buildingAdaptor;
        Intrinsics.checkNotNullParameter(build, "build");
        Building building = build;
        if (building instanceof Conduit.ConduitBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$liquidOnly = false;
            if (type == TransportType.LIQUID) {
                boolean bl = false;
                buildingAdaptor = new ConveyorAdaptor(build);
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof LiquidRouter.LiquidRouterBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$liquidOnly = false;
            if (type == TransportType.LIQUID) {
                boolean bl = false;
                buildingAdaptor = new RouterAdaptor(build);
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof LiquidBridge.LiquidBridgeBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$liquidOnly = false;
            if (type == TransportType.LIQUID) {
                boolean bl = false;
                buildingAdaptor = new BridgeAdaptor((ItemBridge.ItemBridgeBuild)build);
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof LiquidJunction.LiquidJunctionBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$liquidOnly = false;
            if (type == TransportType.LIQUID) {
                boolean bl = false;
                buildingAdaptor = new JunctionAdaptor(build);
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof DirectionLiquidBridge.DuctBridgeBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$liquidOnly = false;
            if (type == TransportType.LIQUID) {
                boolean bl = false;
                buildingAdaptor = new DirectionBridgeAdaptor((DirectionBridge.DirectionBridgeBuild)build);
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof Pump.PumpBuild || building instanceof LiquidSource.LiquidSourceBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$liquidOnly = false;
            if (type == TransportType.LIQUID) {
                boolean bl = false;
                buildingAdaptor = new SourceAdaptor(build);
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof LiquidVoid.LiquidVoidBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$liquidOnly = false;
            if (type == TransportType.LIQUID) {
                boolean bl = false;
                buildingAdaptor = new VoidAdaptor();
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof Conveyor.ConveyorBuild || building instanceof Duct.DuctBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$itemOnly = false;
            if (type == TransportType.ITEM) {
                boolean bl = false;
                buildingAdaptor = new ConveyorAdaptor(build);
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof Router.RouterBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$itemOnly = false;
            if (type == TransportType.ITEM) {
                boolean bl = false;
                buildingAdaptor = new RouterAdaptor(build);
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof Sorter.SorterBuild || building instanceof OverflowGate.OverflowGateBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$itemOnly = false;
            if (type == TransportType.ITEM) {
                boolean bl = false;
                buildingAdaptor = new InstantAdaptor(build);
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof ItemBridge.ItemBridgeBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$itemOnly = false;
            if (type == TransportType.ITEM) {
                boolean bl = false;
                buildingAdaptor = new BridgeAdaptor((ItemBridge.ItemBridgeBuild)build);
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof StackConveyor.StackConveyorBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$itemOnly = false;
            if (type == TransportType.ITEM) {
                boolean bl = false;
                buildingAdaptor = new StackConveyorAdaptor((StackConveyor.StackConveyorBuild)build);
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof Junction.JunctionBuild || building instanceof DuctJunction.DuctJunctionBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$itemOnly = false;
            if (type == TransportType.ITEM) {
                boolean bl = false;
                buildingAdaptor = new JunctionAdaptor(build);
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof DuctBridge.DuctBridgeBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$itemOnly = false;
            if (type == TransportType.ITEM) {
                boolean bl = false;
                buildingAdaptor = new DirectionBridgeAdaptor((DirectionBridge.DirectionBridgeBuild)build);
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof Unloader.UnloaderBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$itemOnly = false;
            if (type == TransportType.ITEM) {
                boolean bl = false;
                buildingAdaptor = new UnloaderAdaptor(build);
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof DirectionalUnloader.DirectionalUnloaderBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$itemOnly = false;
            if (type == TransportType.ITEM) {
                boolean bl = false;
                buildingAdaptor = new DirectionalUnloaderAdaptor(build);
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof MassDriver.MassDriverBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$itemOnly = false;
            if (type == TransportType.ITEM) {
                boolean bl = false;
                buildingAdaptor = new MassDriverAdaptor((MassDriver.MassDriverBuild)build);
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof OverflowDuct.OverflowDuctBuild || building instanceof DuctRouter.DuctRouterBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$itemOnly = false;
            if (type == TransportType.ITEM) {
                boolean bl = false;
                buildingAdaptor = new RouterAdaptor(build);
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof ItemSource.ItemSourceBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$itemOnly = false;
            if (type == TransportType.ITEM) {
                boolean bl = false;
                buildingAdaptor = new SourceAdaptor(build);
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof UnitCargoUnloadPoint.UnitCargoUnloadPointBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$itemOnly = false;
            if (type == TransportType.ITEM) {
                boolean bl = false;
                buildingAdaptor = new SourceAdaptor(build);
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof LandingPad.LandingPadBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$itemOnly = false;
            if (type == TransportType.ITEM) {
                boolean bl = false;
                buildingAdaptor = new SourceAdaptor(build);
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof Drill.DrillBuild || building instanceof BeamDrill.BeamDrillBuild || building instanceof WallCrafter.WallCrafterBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$itemOnly = false;
            if (type == TransportType.ITEM) {
                boolean bl = false;
                buildingAdaptor = new SourceAdaptor(build);
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else if (building instanceof ItemVoid.ItemVoidBuild || building instanceof CoreBlock.CoreBuild) {
            NewTransferScanMode this_$iv = this;
            boolean $i$f$itemOnly = false;
            if (type == TransportType.ITEM) {
                boolean bl = false;
                buildingAdaptor = new VoidAdaptor();
            } else {
                buildingAdaptor = NoopAdaptor.INSTANCE;
            }
        } else {
            buildingAdaptor = building instanceof GenericCrafter.GenericCrafterBuild ? (BuildingAdaptor)new GenericCrafterAdaptor((GenericCrafter.GenericCrafterBuild)build) : (building instanceof Incinerator.IncineratorBuild ? (BuildingAdaptor)new VoidAdaptor() : (BuildingAdaptor)new DefaultAdaptor(build));
        }
        return buildingAdaptor;
    }

    static {
        type = TransportType.ITEM;
        Color color = itemOutputColor;
        Intrinsics.checkNotNullExpressionValue(color, "itemOutputColor");
        drawColor = color;
        visited = new IntSet();
        stack = new ArrayDeque(128);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"LmindustryX/features/NewTransferScanMode$BridgeAdaptor;", "LmindustryX/features/NewTransferScanMode$BuildingAdaptor;", "build", "Lmindustry/world/blocks/distribution/ItemBridge$ItemBridgeBuild;", "Lmindustry/world/blocks/distribution/ItemBridge;", "<init>", "(Lmindustry/world/blocks/distribution/ItemBridge$ItemBridgeBuild;)V", "getBuild", "()Lmindustry/world/blocks/distribution/ItemBridge$ItemBridgeBuild;", "block", "getBlock", "()Lmindustry/world/blocks/distribution/ItemBridge;", "linkValid", "", "getLinkValid", "()Z", "getOutputs", "", "Lmindustry/gen/Building;", "canInput", "from", "activeInputs", "core"})
    @SourceDebugExtension(value={"SMAP\nNewTransferScanMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewTransferScanMode.kt\nmindustryX/features/NewTransferScanMode$BridgeAdaptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,427:1\n774#2:428\n865#2,2:429\n*S KotlinDebug\n*F\n+ 1 NewTransferScanMode.kt\nmindustryX/features/NewTransferScanMode$BridgeAdaptor\n*L\n318#1:428\n318#1:429,2\n*E\n"})
    private static final class BridgeAdaptor
    extends BuildingAdaptor {
        @NotNull
        private final ItemBridge.ItemBridgeBuild build;
        @NotNull
        private final ItemBridge block;

        public BridgeAdaptor(@NotNull ItemBridge.ItemBridgeBuild build) {
            Intrinsics.checkNotNullParameter(build, "build");
            super(false, 1, null);
            this.build = build;
            Block block = this.build.block;
            Intrinsics.checkNotNull((Object)block, "null cannot be cast to non-null type mindustry.world.blocks.distribution.ItemBridge");
            this.block = (ItemBridge)block;
        }

        @NotNull
        public final ItemBridge.ItemBridgeBuild getBuild() {
            return this.build;
        }

        @NotNull
        public final ItemBridge getBlock() {
            return this.block;
        }

        private final boolean getLinkValid() {
            return this.block.linkValid(this.build.tile, Vars.world.tile(this.build.link));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<Building> getOutputs() {
            void $this$filterTo$iv$iv;
            if (this.getLinkValid()) {
                return CollectionsKt.listOf(Vars.world.build(this.build.link));
            }
            Seq seq = this.build.proximity;
            Intrinsics.checkNotNullExpressionValue(seq, "proximity");
            Iterable $this$filter$iv = (Iterable)seq;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Building it = (Building)element$iv$iv;
                boolean bl = false;
                if (!this.build.canDump(it, Items.copper)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        public boolean canInput(@NotNull Building from) {
            Intrinsics.checkNotNullParameter(from, "from");
            return this.build.arcCheckAccept(from);
        }

        @Override
        @NotNull
        public List<Building> activeInputs() {
            List list;
            List $this$activeInputs_u24lambda_u242 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            this.build.incoming.each(arg_0 -> BridgeAdaptor.activeInputs$lambda$2$lambda$1($this$activeInputs_u24lambda_u242, arg_0));
            return CollectionsKt.build(list);
        }

        private static final void activeInputs$lambda$2$lambda$1(List $this_buildList, int pos) {
            Building source = Vars.world.tile((int)pos).build;
            if (source != null) {
                $this_buildList.add(source);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\tH\u0016J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\tH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u0010"}, d2={"LmindustryX/features/NewTransferScanMode$BuildingAdaptor;", "", "isEndPoint", "", "<init>", "(Z)V", "()Z", "canOutput", "to", "Lmindustry/gen/Building;", "getOutputs", "", "from", "canInput", "activeInput", "activeInputs", "core"})
    public static abstract class BuildingAdaptor {
        private final boolean isEndPoint;

        public BuildingAdaptor(boolean isEndPoint) {
            this.isEndPoint = isEndPoint;
        }

        public /* synthetic */ BuildingAdaptor(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public final boolean isEndPoint() {
            return this.isEndPoint;
        }

        public boolean canOutput(@NotNull Building to) {
            Intrinsics.checkNotNullParameter(to, "to");
            return this.getOutputs().contains(to);
        }

        @NotNull
        public List<Building> getOutputs() {
            return CollectionsKt.emptyList();
        }

        @NotNull
        public List<Building> getOutputs(@NotNull Building from) {
            Intrinsics.checkNotNullParameter(from, "from");
            return this.getOutputs();
        }

        public boolean canInput(@NotNull Building from) {
            Intrinsics.checkNotNullParameter(from, "from");
            return false;
        }

        public boolean canInput(@NotNull Building from, @NotNull Building to) {
            Intrinsics.checkNotNullParameter(from, "from");
            Intrinsics.checkNotNullParameter(to, "to");
            return this.canInput(from);
        }

        public boolean activeInput(@NotNull Building from) {
            Intrinsics.checkNotNullParameter(from, "from");
            return this.activeInputs().contains(from);
        }

        @NotNull
        public List<Building> activeInputs() {
            return CollectionsKt.emptyList();
        }

        public BuildingAdaptor() {
            this(false, 1, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"LmindustryX/features/NewTransferScanMode$ConveyorAdaptor;", "LmindustryX/features/NewTransferScanMode$BuildingAdaptor;", "build", "Lmindustry/gen/Building;", "<init>", "(Lmindustry/gen/Building;)V", "getBuild", "()Lmindustry/gen/Building;", "getOutputs", "", "canInput", "", "from", "core"})
    private static final class ConveyorAdaptor
    extends BuildingAdaptor {
        @NotNull
        private final Building build;

        public ConveyorAdaptor(@NotNull Building build) {
            Intrinsics.checkNotNullParameter(build, "build");
            super(false, 1, null);
            this.build = build;
        }

        @NotNull
        public final Building getBuild() {
            return this.build;
        }

        @Override
        @NotNull
        public List<Building> getOutputs() {
            return CollectionsKt.listOfNotNull(this.build.front());
        }

        @Override
        public boolean canInput(@NotNull Building from) {
            boolean bl;
            Intrinsics.checkNotNullParameter(from, "from");
            if (Intrinsics.areEqual(from, this.build.front())) {
                return false;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    if (from instanceof Conveyor.ConveyorBuild || !(this.build instanceof ArmoredConveyor.ArmoredConveyorBuild)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if (from instanceof Conduit.ConduitBuild || !(this.build instanceof ArmoredConduit.ArmoredConduitBuild)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return bl;
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TransportType.values().length];
                try {
                    nArray[TransportType.ITEM.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TransportType.LIQUID.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"LmindustryX/features/NewTransferScanMode$DefaultAdaptor;", "LmindustryX/features/NewTransferScanMode$BuildingAdaptor;", "build", "Lmindustry/gen/Building;", "<init>", "(Lmindustry/gen/Building;)V", "getBuild", "()Lmindustry/gen/Building;", "canInput", "", "from", "core"})
    @SourceDebugExtension(value={"SMAP\nNewTransferScanMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewTransferScanMode.kt\nmindustryX/features/NewTransferScanMode$DefaultAdaptor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,427:1\n12637#2,2:428\n12637#2,2:430\n*S KotlinDebug\n*F\n+ 1 NewTransferScanMode.kt\nmindustryX/features/NewTransferScanMode$DefaultAdaptor\n*L\n421#1:428,2\n422#1:430,2\n*E\n"})
    private static final class DefaultAdaptor
    extends BuildingAdaptor {
        @NotNull
        private final Building build;

        public DefaultAdaptor(@NotNull Building build) {
            Intrinsics.checkNotNullParameter(build, "build");
            super(false, 1, null);
            this.build = build;
        }

        @NotNull
        public final Building getBuild() {
            return this.build;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean canInput(@NotNull Building from) {
            Intrinsics.checkNotNullParameter(from, "from");
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    if (!this.build.block.hasItems) return false;
                    Intrinsics.checkNotNullExpressionValue(this.build.block.itemFilter, "itemFilter");
                    boolean[] $this$any$iv = this.build.block.itemFilter;
                    boolean $i$f$any = false;
                    int n = 0;
                    int n2 = $this$any$iv.length;
                    while (n < n2) {
                        boolean element$iv;
                        boolean it = element$iv = $this$any$iv[n];
                        boolean bl = false;
                        if (it) {
                            return true;
                        }
                        ++n;
                    }
                    return false;
                }
                case 2: {
                    if (!this.build.block.hasLiquids) return false;
                    Intrinsics.checkNotNullExpressionValue(this.build.block.liquidFilter, "liquidFilter");
                    boolean[] $this$any$iv = this.build.block.liquidFilter;
                    boolean $i$f$any = false;
                    int n = 0;
                    int n3 = $this$any$iv.length;
                    while (n < n3) {
                        boolean element$iv;
                        boolean it = element$iv = $this$any$iv[n];
                        boolean bl = false;
                        if (it) {
                            return true;
                        }
                        ++n;
                    }
                    return false;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TransportType.values().length];
                try {
                    nArray[TransportType.ITEM.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TransportType.LIQUID.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"LmindustryX/features/NewTransferScanMode$DirectionBridgeAdaptor;", "LmindustryX/features/NewTransferScanMode$BuildingAdaptor;", "build", "Lmindustry/world/blocks/distribution/DirectionBridge$DirectionBridgeBuild;", "Lmindustry/world/blocks/distribution/DirectionBridge;", "<init>", "(Lmindustry/world/blocks/distribution/DirectionBridge$DirectionBridgeBuild;)V", "getBuild", "()Lmindustry/world/blocks/distribution/DirectionBridge$DirectionBridgeBuild;", "getOutputs", "", "Lmindustry/gen/Building;", "activeInputs", "canInput", "", "from", "core"})
    private static final class DirectionBridgeAdaptor
    extends BuildingAdaptor {
        @NotNull
        private final DirectionBridge.DirectionBridgeBuild build;

        public DirectionBridgeAdaptor(@NotNull DirectionBridge.DirectionBridgeBuild build) {
            Intrinsics.checkNotNullParameter(build, "build");
            super(false, 1, null);
            this.build = build;
        }

        @NotNull
        public final DirectionBridge.DirectionBridgeBuild getBuild() {
            return this.build;
        }

        @Override
        @NotNull
        public List<Building> getOutputs() {
            DirectionBridge.DirectionBridgeBuild link;
            DirectionBridge.DirectionBridgeBuild directionBridgeBuild = link = this.build.findLink();
            return directionBridgeBuild != null ? CollectionsKt.listOf(directionBridgeBuild) : CollectionsKt.listOfNotNull(this.build.front());
        }

        @Override
        @NotNull
        public List<Building> activeInputs() {
            Intrinsics.checkNotNullExpressionValue(this.build.occupied, "occupied");
            return ArraysKt.filterNotNull((Object[])this.build.occupied);
        }

        @Override
        public boolean canInput(@NotNull Building from) {
            Intrinsics.checkNotNullParameter(from, "from");
            Intrinsics.checkNotNullExpressionValue(this.build.occupied, "occupied");
            if (ArraysKt.contains((Object[])this.build.occupied, from)) {
                return true;
            }
            byte dir = from.relativeTo((Building)this.build);
            return this.build.findLink() != null && this.build.occupied[dir] == null;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"LmindustryX/features/NewTransferScanMode$DirectionalUnloaderAdaptor;", "LmindustryX/features/NewTransferScanMode$BuildingAdaptor;", "build", "Lmindustry/gen/Building;", "<init>", "(Lmindustry/gen/Building;)V", "getBuild", "()Lmindustry/gen/Building;", "getOutputs", "", "activeInput", "", "from", "activeInputs", "core"})
    @SourceDebugExtension(value={"SMAP\nNewTransferScanMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewTransferScanMode.kt\nmindustryX/features/NewTransferScanMode$DirectionalUnloaderAdaptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,427:1\n1#2:428\n*E\n"})
    private static final class DirectionalUnloaderAdaptor
    extends BuildingAdaptor {
        @NotNull
        private final Building build;

        public DirectionalUnloaderAdaptor(@NotNull Building build) {
            Intrinsics.checkNotNullParameter(build, "build");
            super(false, 1, null);
            this.build = build;
        }

        @NotNull
        public final Building getBuild() {
            return this.build;
        }

        @Override
        @NotNull
        public List<Building> getOutputs() {
            return CollectionsKt.listOfNotNull(this.build.front());
        }

        @Override
        public boolean activeInput(@NotNull Building from) {
            Intrinsics.checkNotNullParameter(from, "from");
            return from.items != null && from.canUnload() && Intrinsics.areEqual(from, this.build.back());
        }

        @Override
        @NotNull
        public List<Building> activeInputs() {
            Building building;
            Building building2 = this.build.back();
            if (building2 != null) {
                Building building3;
                Building it = building3 = building2;
                boolean bl = false;
                building = this.activeInput(it) ? building3 : null;
            } else {
                building = null;
            }
            return CollectionsKt.listOfNotNull(building);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"LmindustryX/features/NewTransferScanMode$GenericCrafterAdaptor;", "LmindustryX/features/NewTransferScanMode$BuildingAdaptor;", "build", "Lmindustry/world/blocks/production/GenericCrafter$GenericCrafterBuild;", "Lmindustry/world/blocks/production/GenericCrafter;", "<init>", "(Lmindustry/world/blocks/production/GenericCrafter$GenericCrafterBuild;)V", "getBuild", "()Lmindustry/world/blocks/production/GenericCrafter$GenericCrafterBuild;", "block", "getBlock", "()Lmindustry/world/blocks/production/GenericCrafter;", "getOutputs", "", "Lmindustry/gen/Building;", "canInput", "", "from", "core"})
    @SourceDebugExtension(value={"SMAP\nNewTransferScanMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewTransferScanMode.kt\nmindustryX/features/NewTransferScanMode$GenericCrafterAdaptor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,427:1\n12567#2,2:428\n12637#2,2:430\n12567#2,2:432\n12637#2,2:434\n*S KotlinDebug\n*F\n+ 1 NewTransferScanMode.kt\nmindustryX/features/NewTransferScanMode$GenericCrafterAdaptor\n*L\n393#1:428,2\n395#1:430,2\n401#1:432,2\n403#1:434,2\n*E\n"})
    private static final class GenericCrafterAdaptor
    extends BuildingAdaptor {
        @NotNull
        private final GenericCrafter.GenericCrafterBuild build;
        @NotNull
        private final GenericCrafter block;

        public GenericCrafterAdaptor(@NotNull GenericCrafter.GenericCrafterBuild build) {
            Intrinsics.checkNotNullParameter(build, "build");
            super(true);
            this.build = build;
            Block block = this.build.block;
            Intrinsics.checkNotNull((Object)block, "null cannot be cast to non-null type mindustry.world.blocks.production.GenericCrafter");
            this.block = (GenericCrafter)block;
        }

        @NotNull
        public final GenericCrafter.GenericCrafterBuild getBuild() {
            return this.build;
        }

        @NotNull
        public final GenericCrafter getBlock() {
            return this.block;
        }

        @Override
        @NotNull
        public List<Building> getOutputs() {
            if (type == TransportType.ITEM && this.block.outputItems == null) {
                return CollectionsKt.emptyList();
            }
            if (type == TransportType.LIQUID && this.block.outputLiquids == null) {
                return CollectionsKt.emptyList();
            }
            Seq seq = this.build.proximity;
            Intrinsics.checkNotNullExpressionValue(seq, "proximity");
            return CollectionsKt.toList((Iterable)seq);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean canInput(@NotNull Building from) {
            Intrinsics.checkNotNullParameter(from, "from");
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    GenericCrafter genericCrafter;
                    if (!this.block.hasItems) {
                        return false;
                    }
                    Block block = from.block;
                    GenericCrafter genericCrafter2 = genericCrafter = block instanceof GenericCrafter ? (GenericCrafter)block : null;
                    if (genericCrafter != null) {
                        GenericCrafter b = genericCrafter;
                        boolean bl = false;
                        if (b.outputItems == null) return false;
                        Intrinsics.checkNotNullExpressionValue(b.outputItems, "outputItems");
                        Object[] $this$any$iv = b.outputItems;
                        boolean $i$f$any = false;
                        int n = 0;
                        int n2 = $this$any$iv.length;
                        while (n < n2) {
                            Object element$iv = $this$any$iv[n];
                            ItemStack it = (ItemStack)element$iv;
                            boolean bl2 = false;
                            if (this.block.itemFilter[it.item.id]) {
                                return true;
                            }
                            ++n;
                        }
                        return false;
                    }
                    Intrinsics.checkNotNullExpressionValue(this.build.block.itemFilter, "itemFilter");
                    boolean[] blArray = this.build.block.itemFilter;
                    boolean $i$f$any = false;
                    int b = 0;
                    int bl = blArray.length;
                    while (b < bl) {
                        boolean element$iv;
                        boolean it = element$iv = blArray[b];
                        boolean bl3 = false;
                        if (it) {
                            return true;
                        }
                        ++b;
                    }
                    return false;
                }
                case 2: {
                    GenericCrafter genericCrafter;
                    if (!this.block.hasLiquids) {
                        return false;
                    }
                    Block $i$f$any = from.block;
                    GenericCrafter genericCrafter3 = genericCrafter = $i$f$any instanceof GenericCrafter ? (GenericCrafter)$i$f$any : null;
                    if (genericCrafter != null) {
                        GenericCrafter b = genericCrafter;
                        boolean bl = false;
                        if (b.outputLiquids == null) return false;
                        Intrinsics.checkNotNullExpressionValue(b.outputLiquids, "outputLiquids");
                        Object[] $this$any$iv = b.outputLiquids;
                        boolean $i$f$any2 = false;
                        int bl3 = 0;
                        int n = $this$any$iv.length;
                        while (bl3 < n) {
                            Object element$iv = $this$any$iv[bl3];
                            LiquidStack it = (LiquidStack)element$iv;
                            boolean bl4 = false;
                            if (this.block.liquidFilter[it.liquid.id]) {
                                return true;
                            }
                            ++bl3;
                        }
                        return false;
                    }
                    Intrinsics.checkNotNullExpressionValue(this.build.block.liquidFilter, "liquidFilter");
                    boolean[] blArray = this.build.block.liquidFilter;
                    boolean $i$f$any2 = false;
                    int n = 0;
                    int n3 = blArray.length;
                    while (n < n3) {
                        boolean element$iv;
                        boolean it = element$iv = blArray[n];
                        boolean bl = false;
                        if (it) {
                            return true;
                        }
                        ++n;
                    }
                    return false;
                }
            }
            return false;
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TransportType.values().length];
                try {
                    nArray[TransportType.ITEM.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TransportType.LIQUID.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"LmindustryX/features/NewTransferScanMode$InstantAdaptor;", "LmindustryX/features/NewTransferScanMode$BuildingAdaptor;", "build", "Lmindustry/gen/Building;", "<init>", "(Lmindustry/gen/Building;)V", "getBuild", "()Lmindustry/gen/Building;", "getOutputs", "", "from", "canInput", "", "to", "core"})
    @SourceDebugExtension(value={"SMAP\nNewTransferScanMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewTransferScanMode.kt\nmindustryX/features/NewTransferScanMode$InstantAdaptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,427:1\n774#2:428\n865#2,2:429\n*S KotlinDebug\n*F\n+ 1 NewTransferScanMode.kt\nmindustryX/features/NewTransferScanMode$InstantAdaptor\n*L\n296#1:428\n296#1:429,2\n*E\n"})
    private static final class InstantAdaptor
    extends BuildingAdaptor {
        @NotNull
        private final Building build;

        public InstantAdaptor(@NotNull Building build) {
            Intrinsics.checkNotNullParameter(build, "build");
            super(false, 1, null);
            this.build = build;
        }

        @NotNull
        public final Building getBuild() {
            return this.build;
        }

        @Override
        @NotNull
        public List<Building> getOutputs() {
            Seq<Building> seq = this.build.proximity;
            Intrinsics.checkNotNullExpressionValue(seq, "proximity");
            return CollectionsKt.toList((Iterable)seq);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<Building> getOutputs(@NotNull Building from) {
            List list;
            Intrinsics.checkNotNullParameter(from, "from");
            if (from.block.instantTransfer) {
                void $this$filterTo$iv$iv;
                Seq<Building> seq = this.build.proximity;
                Intrinsics.checkNotNullExpressionValue(seq, "proximity");
                Iterable $this$filter$iv = (Iterable)seq;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Building it = (Building)element$iv$iv;
                    boolean bl = false;
                    if (!(!it.block.instantTransfer)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = this.getOutputs();
            }
            return list;
        }

        @Override
        public boolean canInput(@NotNull Building from) {
            Intrinsics.checkNotNullParameter(from, "from");
            return true;
        }

        @Override
        public boolean canInput(@NotNull Building from, @NotNull Building to) {
            Intrinsics.checkNotNullParameter(from, "from");
            Intrinsics.checkNotNullParameter(to, "to");
            return !from.block.instantTransfer || !to.block.instantTransfer;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"LmindustryX/features/NewTransferScanMode$JunctionAdaptor;", "LmindustryX/features/NewTransferScanMode$BuildingAdaptor;", "build", "Lmindustry/gen/Building;", "<init>", "(Lmindustry/gen/Building;)V", "getBuild", "()Lmindustry/gen/Building;", "otherSide", "a", "getOutputs", "", "from", "canOutput", "", "to", "canInput", "core"})
    @SourceDebugExtension(value={"SMAP\nNewTransferScanMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewTransferScanMode.kt\nmindustryX/features/NewTransferScanMode$JunctionAdaptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,427:1\n1#2:428\n*E\n"})
    private static final class JunctionAdaptor
    extends BuildingAdaptor {
        @NotNull
        private final Building build;

        public JunctionAdaptor(@NotNull Building build) {
            Intrinsics.checkNotNullParameter(build, "build");
            super(false, 1, null);
            this.build = build;
        }

        @NotNull
        public final Building getBuild() {
            return this.build;
        }

        private final Building otherSide(Building a) {
            byte it = a.relativeTo(this.build);
            boolean bl = false;
            return this.build.nearby(it);
        }

        @Override
        @NotNull
        public List<Building> getOutputs() {
            Seq<Building> seq = this.build.proximity;
            Intrinsics.checkNotNullExpressionValue(seq, "proximity");
            return CollectionsKt.toList((Iterable)seq);
        }

        @Override
        @NotNull
        public List<Building> getOutputs(@NotNull Building from) {
            Intrinsics.checkNotNullParameter(from, "from");
            return CollectionsKt.listOfNotNull(this.otherSide(from));
        }

        @Override
        public boolean canOutput(@NotNull Building to) {
            Intrinsics.checkNotNullParameter(to, "to");
            Building building = this.otherSide(to);
            if (building == null) {
                return false;
            }
            Building from = building;
            return INSTANCE.getWrapper(from).canOutput(this.build);
        }

        @Override
        public boolean canInput(@NotNull Building from, @NotNull Building to) {
            Intrinsics.checkNotNullParameter(from, "from");
            Intrinsics.checkNotNullParameter(to, "to");
            return Intrinsics.areEqual(from, this.otherSide(to)) && INSTANCE.getWrapper(to).canInput(from);
        }

        @Override
        public boolean canInput(@NotNull Building from) {
            Intrinsics.checkNotNullParameter(from, "from");
            Building building = this.otherSide(from);
            if (building == null) {
                return false;
            }
            Building to = building;
            return INSTANCE.getWrapper(to).canInput(this.build);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"LmindustryX/features/NewTransferScanMode$MassDriverAdaptor;", "LmindustryX/features/NewTransferScanMode$BuildingAdaptor;", "build", "Lmindustry/world/blocks/distribution/MassDriver$MassDriverBuild;", "Lmindustry/world/blocks/distribution/MassDriver;", "<init>", "(Lmindustry/world/blocks/distribution/MassDriver$MassDriverBuild;)V", "getBuild", "()Lmindustry/world/blocks/distribution/MassDriver$MassDriverBuild;", "getOutputs", "", "Lmindustry/gen/Building;", "canInput", "", "from", "core"})
    private static final class MassDriverAdaptor
    extends BuildingAdaptor {
        @NotNull
        private final MassDriver.MassDriverBuild build;

        public MassDriverAdaptor(@NotNull MassDriver.MassDriverBuild build) {
            Intrinsics.checkNotNullParameter(build, "build");
            super(false, 1, null);
            this.build = build;
        }

        @NotNull
        public final MassDriver.MassDriverBuild getBuild() {
            return this.build;
        }

        @Override
        @NotNull
        public List<Building> getOutputs() {
            List<Building> list;
            if (this.build.arcLinkValid()) {
                Building target;
                Building building = target = Vars.world.build(this.build.link);
                list = building != null ? CollectionsKt.listOf(building) : CollectionsKt.emptyList();
            } else {
                Seq seq = this.build.proximity;
                Intrinsics.checkNotNullExpressionValue(seq, "proximity");
                list = CollectionsKt.toList((Iterable)seq);
            }
            return list;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean canInput(@NotNull Building from) {
            Intrinsics.checkNotNullParameter(from, "from");
            if (this.build.arcLinkValid()) return true;
            if (!(from instanceof MassDriver.MassDriverBuild)) return false;
            MassDriver.MassDriverBuild massDriverBuild = (MassDriver.MassDriverBuild)from;
            if (massDriverBuild == null) return false;
            if (massDriverBuild.link != this.build.pos()) return false;
            return true;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"LmindustryX/features/NewTransferScanMode$NoopAdaptor;", "LmindustryX/features/NewTransferScanMode$BuildingAdaptor;", "<init>", "()V", "core"})
    private static final class NoopAdaptor
    extends BuildingAdaptor {
        @NotNull
        public static final NoopAdaptor INSTANCE = new NoopAdaptor();

        private NoopAdaptor() {
            super(false, 1, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"LmindustryX/features/NewTransferScanMode$RouterAdaptor;", "LmindustryX/features/NewTransferScanMode$BuildingAdaptor;", "build", "Lmindustry/gen/Building;", "<init>", "(Lmindustry/gen/Building;)V", "getBuild", "()Lmindustry/gen/Building;", "getOutputs", "", "canInput", "", "from", "core"})
    private static final class RouterAdaptor
    extends BuildingAdaptor {
        @NotNull
        private final Building build;

        public RouterAdaptor(@NotNull Building build) {
            Intrinsics.checkNotNullParameter(build, "build");
            super(false, 1, null);
            this.build = build;
        }

        @NotNull
        public final Building getBuild() {
            return this.build;
        }

        @Override
        @NotNull
        public List<Building> getOutputs() {
            Seq<Building> seq = this.build.proximity;
            Intrinsics.checkNotNullExpressionValue(seq, "proximity");
            return CollectionsKt.toList((Iterable)seq);
        }

        @Override
        public boolean canInput(@NotNull Building from) {
            Intrinsics.checkNotNullParameter(from, "from");
            return true;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"LmindustryX/features/NewTransferScanMode$SourceAdaptor;", "LmindustryX/features/NewTransferScanMode$BuildingAdaptor;", "build", "Lmindustry/gen/Building;", "<init>", "(Lmindustry/gen/Building;)V", "getBuild", "()Lmindustry/gen/Building;", "getOutputs", "", "core"})
    private static final class SourceAdaptor
    extends BuildingAdaptor {
        @NotNull
        private final Building build;

        public SourceAdaptor(@NotNull Building build) {
            Intrinsics.checkNotNullParameter(build, "build");
            super(true);
            this.build = build;
        }

        @NotNull
        public final Building getBuild() {
            return this.build;
        }

        @Override
        @NotNull
        public List<Building> getOutputs() {
            Seq<Building> seq = this.build.proximity;
            Intrinsics.checkNotNullExpressionValue(seq, "proximity");
            return CollectionsKt.toList((Iterable)seq);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"LmindustryX/features/NewTransferScanMode$StackConveyorAdaptor;", "LmindustryX/features/NewTransferScanMode$BuildingAdaptor;", "build", "Lmindustry/world/blocks/distribution/StackConveyor$StackConveyorBuild;", "Lmindustry/world/blocks/distribution/StackConveyor;", "<init>", "(Lmindustry/world/blocks/distribution/StackConveyor$StackConveyorBuild;)V", "getBuild", "()Lmindustry/world/blocks/distribution/StackConveyor$StackConveyorBuild;", "getOutputs", "", "Lmindustry/gen/Building;", "canInput", "", "from", "core"})
    @SourceDebugExtension(value={"SMAP\nNewTransferScanMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewTransferScanMode.kt\nmindustryX/features/NewTransferScanMode$StackConveyorAdaptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,427:1\n774#2:428\n865#2,2:429\n808#2,11:431\n*S KotlinDebug\n*F\n+ 1 NewTransferScanMode.kt\nmindustryX/features/NewTransferScanMode$StackConveyorAdaptor\n*L\n268#1:428\n268#1:429,2\n275#1:431,11\n*E\n"})
    private static final class StackConveyorAdaptor
    extends BuildingAdaptor {
        @NotNull
        private final StackConveyor.StackConveyorBuild build;

        public StackConveyorAdaptor(@NotNull StackConveyor.StackConveyorBuild build) {
            Intrinsics.checkNotNullParameter(build, "build");
            super(false, 1, null);
            this.build = build;
        }

        @NotNull
        public final StackConveyor.StackConveyorBuild getBuild() {
            return this.build;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<Building> getOutputs() {
            List list;
            Building front = this.build.front();
            Building back = this.build.back();
            switch (this.build.state) {
                case 2: {
                    Block block = this.build.block;
                    Intrinsics.checkNotNull((Object)block, "null cannot be cast to non-null type mindustry.world.blocks.distribution.StackConveyor");
                    if (((StackConveyor)block).outputRouter) {
                        void $this$filterTo$iv$iv;
                        Seq seq = this.build.proximity;
                        Intrinsics.checkNotNullExpressionValue(seq, "proximity");
                        Iterable $this$filter$iv = (Iterable)seq;
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            Building it = (Building)element$iv$iv;
                            boolean bl = false;
                            if (!(!Intrinsics.areEqual(it, back))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        list = (List)destination$iv$iv;
                        break;
                    }
                    list = CollectionsKt.listOfNotNull(front);
                    break;
                }
                case 1: {
                    list = CollectionsKt.listOfNotNull(front);
                    break;
                }
                default: {
                    void $this$filterIsInstanceTo$iv$iv;
                    Seq seq = this.build.proximity;
                    Intrinsics.checkNotNullExpressionValue(seq, "proximity");
                    Iterable $this$filterIsInstance$iv = (Iterable)seq;
                    boolean $i$f$filterIsInstance = false;
                    Iterable $this$filterTo$iv$iv = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof StackConveyor.StackConveyorBuild)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                }
            }
            return list;
        }

        @Override
        public boolean canInput(@NotNull Building from) {
            boolean bl;
            Intrinsics.checkNotNullParameter(from, "from");
            switch (this.build.state) {
                case 2: {
                    if (from instanceof StackConveyor.StackConveyorBuild && Intrinsics.areEqual(from, this.build.back())) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 1: {
                    if (!Intrinsics.areEqual(from, this.build.front())) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = from instanceof StackConveyor.StackConveyorBuild && Intrinsics.areEqual(from.front(), this.build);
                }
            }
            return bl;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"LmindustryX/features/NewTransferScanMode$TransportType;", "", "<init>", "(Ljava/lang/String;I)V", "ITEM", "LIQUID", "core"})
    public static final class TransportType
    extends Enum<TransportType> {
        public static final /* enum */ TransportType ITEM = new TransportType();
        public static final /* enum */ TransportType LIQUID = new TransportType();
        private static final /* synthetic */ TransportType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TransportType[] values() {
            return (TransportType[])$VALUES.clone();
        }

        public static TransportType valueOf(String value) {
            return Enum.valueOf(TransportType.class, value);
        }

        @NotNull
        public static EnumEntries<TransportType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = transportTypeArray = new TransportType[]{TransportType.ITEM, TransportType.LIQUID};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"LmindustryX/features/NewTransferScanMode$UnloaderAdaptor;", "LmindustryX/features/NewTransferScanMode$BuildingAdaptor;", "build", "Lmindustry/gen/Building;", "<init>", "(Lmindustry/gen/Building;)V", "getBuild", "()Lmindustry/gen/Building;", "getOutputs", "", "activeInput", "", "from", "activeInputs", "core"})
    @SourceDebugExtension(value={"SMAP\nNewTransferScanMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewTransferScanMode.kt\nmindustryX/features/NewTransferScanMode$UnloaderAdaptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,427:1\n774#2:428\n865#2,2:429\n774#2:431\n865#2,2:432\n*S KotlinDebug\n*F\n+ 1 NewTransferScanMode.kt\nmindustryX/features/NewTransferScanMode$UnloaderAdaptor\n*L\n302#1:428\n302#1:429,2\n304#1:431\n304#1:432,2\n*E\n"})
    private static final class UnloaderAdaptor
    extends BuildingAdaptor {
        @NotNull
        private final Building build;

        public UnloaderAdaptor(@NotNull Building build) {
            Intrinsics.checkNotNullParameter(build, "build");
            super(false, 1, null);
            this.build = build;
        }

        @NotNull
        public final Building getBuild() {
            return this.build;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<Building> getOutputs() {
            void $this$filterTo$iv$iv;
            Seq<Building> seq = this.build.proximity;
            Intrinsics.checkNotNullExpressionValue(seq, "proximity");
            Iterable $this$filter$iv = (Iterable)seq;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Building it = (Building)element$iv$iv;
                boolean bl = false;
                if (!(!(it.block instanceof StorageBlock))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        public boolean activeInput(@NotNull Building from) {
            Intrinsics.checkNotNullParameter(from, "from");
            return from.items != null && from.canUnload();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<Building> activeInputs() {
            void $this$filterTo$iv$iv;
            Seq<Building> seq = this.build.proximity;
            Intrinsics.checkNotNullExpressionValue(seq, "proximity");
            Iterable $this$filter$iv = (Iterable)seq;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Building it = (Building)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (!this.activeInput(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"LmindustryX/features/NewTransferScanMode$VoidAdaptor;", "LmindustryX/features/NewTransferScanMode$BuildingAdaptor;", "<init>", "()V", "canInput", "", "from", "Lmindustry/gen/Building;", "core"})
    private static final class VoidAdaptor
    extends BuildingAdaptor {
        public VoidAdaptor() {
            super(false, 1, null);
        }

        @Override
        public boolean canInput(@NotNull Building from) {
            Intrinsics.checkNotNullParameter(from, "from");
            return true;
        }
    }
}

