/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features;

import arc.Core;
import arc.func.Boolf;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.event.Touchable;
import arc.scene.ui.layout.Table;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.game.SpawnGroup;
import mindustry.ui.Styles;
import mindustry.world.Tile;
import mindustryX.features.ArcWaveSpawner;
import mindustryX.features.ui.FormatDefault;

public class ArcSpawnerShow {
    private static final Table spawnerTable = new Table();
    private static final Table flyerTable = new Table();

    public static void update(boolean enabled) {
        spawnerTable.clear();
        flyerTable.clear();
        if (!enabled || !Vars.state.isPlaying() || Vars.state.wave < 1) {
            return;
        }
        ArcWaveSpawner.WaveInfo thisWave = ArcWaveSpawner.getOrInit(Vars.state.wave - 1);
        for (Tile tile : Vars.spawner.getSpawns()) {
            if (!(Mathf.dst((float)tile.worldx(), (float)tile.worldy(), (float)Core.input.mouseWorldX(), (float)Core.input.mouseWorldY()) < Vars.state.rules.dropZoneRadius)) continue;
            float curve = Mathf.curve((float)(Time.time % 240.0f), (float)120.0f, (float)240.0f);
            Draw.z((float)108.0f);
            Draw.color((Color)Vars.state.rules.waveTeam.color);
            Lines.stroke(4.0f);
            float flyerAngle = Angles.angle((float)((float)Vars.world.width() / 2.0f), (float)((float)Vars.world.height() / 2.0f), (float)tile.x, (float)tile.y);
            float trns = (float)Math.max(Vars.world.width(), Vars.world.height()) * Mathf.sqrt2 * 8.0f;
            float spawnX = Mathf.clamp((float)((float)(Vars.world.width() * 8) / 2.0f + Angles.trnsx((float)flyerAngle, (float)trns)), (float)0.0f, (float)(Vars.world.width() * 8));
            float spawnY = Mathf.clamp((float)((float)(Vars.world.height() * 8) / 2.0f + Angles.trnsy((float)flyerAngle, (float)trns)), (float)0.0f, (float)(Vars.world.height() * 8));
            if (ArcWaveSpawner.hasFlyer) {
                Lines.line(tile.worldx(), tile.worldy(), spawnX, spawnY);
                Tmp.v1.set(spawnX - tile.worldx(), spawnY - tile.worldy());
                Tmp.v1.setLength(Tmp.v1.len() * curve);
                Fill.circle((float)(tile.worldx() + Tmp.v1.x), (float)(tile.worldy() + Tmp.v1.y), (float)8.0f);
                Vec2 v = Core.camera.project(spawnX, spawnY);
                flyerTable.setPosition(v.x, v.y);
                flyerTable.table(Styles.black3, tt -> {
                    tt.add((CharSequence)FormatDefault.duration(Vars.state.wavetime / 60.0f, false)).row();
                    tt.add((Element)thisWave.proTable(false, tile.pos(), (Boolf<SpawnGroup>)((Boolf)group -> group.type.flying)));
                    tt.row();
                    tt.add((Element)thisWave.unitTable(tile.pos(), (Boolf<SpawnGroup>)((Boolf)group -> group.type.flying))).maxWidth(Vars.mobile ? 400.0f : 750.0f).growX();
                });
            }
            if (curve > 0.0f) {
                Lines.circle(tile.worldx(), tile.worldy(), Vars.state.rules.dropZoneRadius * Interp.pow3Out.apply(curve));
            }
            Lines.circle(tile.worldx(), tile.worldy(), Vars.state.rules.dropZoneRadius);
            float fraction = Mathf.clamp((float)(Vars.state.wavetime / Vars.state.rules.waveSpacing));
            Lines.arc(tile.worldx(), tile.worldy(), Vars.state.rules.dropZoneRadius - 3.0f, fraction, 90.0f);
            float angle = 1.5707964f + fraction * 2.0f * (float)Math.PI;
            Draw.color((Color)Vars.state.rules.waveTeam.color);
            Fill.circle((float)(tile.worldx() + Vars.state.rules.dropZoneRadius * Mathf.cos((float)angle)), (float)(tile.worldy() + Vars.state.rules.dropZoneRadius * Mathf.sin((float)angle)), (float)8.0f);
            Vec2 v = Core.camera.project(tile.worldx(), tile.worldy());
            spawnerTable.setPosition(v.x, v.y);
            spawnerTable.table(Styles.black3, tt -> {
                tt.add((CharSequence)FormatDefault.duration(Vars.state.wavetime / 60.0f, false)).row();
                tt.add((Element)thisWave.proTable(false, tile.pos(), (Boolf<SpawnGroup>)((Boolf)group -> !group.type.flying)));
                tt.row();
                tt.add((Element)thisWave.unitTable(tile.pos(), (Boolf<SpawnGroup>)((Boolf)group -> !group.type.flying))).maxWidth(Vars.mobile ? 400.0f : 750.0f).growX();
            });
            return;
        }
    }

    static {
        ArcSpawnerShow.spawnerTable.touchable = ArcSpawnerShow.flyerTable.touchable = Touchable.disabled;
        Vars.ui.hudGroup.addChild((Element)spawnerTable);
        Vars.ui.hudGroup.addChild((Element)flyerTable);
    }
}

