/*
 * Decompiled with CFR 0.152.
 */
package mindustryX.features;

import arc.Core;
import arc.files.Fi;
import arc.func.Boolf;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.TextureData;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.PixmapTextureData;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.style.Drawable;
import arc.scene.ui.Image;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.content.Items;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Predict;
import mindustry.entities.Units;
import mindustry.gen.BlockUnitUnit;
import mindustry.gen.Building;
import mindustry.gen.Healthc;
import mindustry.gen.Icon;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.input.DesktopInput;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.ui.dialogs.SettingsMenuDialog;
import mindustry.world.Tile;
import mindustry.world.blocks.ControlBlock;
import mindustryX.features.RenderExt;
import mindustryX.features.SettingsV2;

public class ArcOld {
    public static final SettingsV2.CheckPref colorizedContent = new SettingsV2.CheckPref("arcExtra.colorizedContent");
    public static final SettingsV2.TextPref backgroundPath = new SettingsV2.TextPref("arcExtra.backgroundPath");
    public static final SettingsV2.CheckPref showPlacementEffect = new SettingsV2.CheckPref("block.arcPlacementEffect");
    public static final SettingsV2.CheckPref schematicShare = new SettingsV2.CheckPref("arcExtra.schematicShare", true);
    private static Seq<Fi> backgrounds;
    @Nullable
    private static Teamc autoTarget;

    public static void nextBackground(Image image) {
        if (backgroundPath.changed()) {
            backgrounds = Core.files.absolute((String)backgroundPath.get()).findAll(f -> !f.isDirectory() && (f.extEquals("png") || f.extEquals("jpg") || f.extEquals("jpeg")));
        }
        image.setDrawable((Drawable)null);
        if (ArcOld.backgrounds.size == 0) {
            return;
        }
        Fi file = (Fi)backgrounds.random();
        Vars.mainExecutor.submit(() -> {
            try {
                PixmapTextureData pixmap = new PixmapTextureData(new Pixmap(file), false, true);
                Core.app.post(() -> {
                    TextureRegion texture = new TextureRegion(new Texture((TextureData)pixmap));
                    if (image.getDrawable() != null) {
                        ((TextureRegion)image.getDrawable()).texture.dispose();
                    }
                    image.setDrawable(texture);
                });
            }
            catch (Exception e) {
                Core.app.post(() -> Vars.ui.showException("\u80cc\u666f\u56fe\u7247\u65e0\u6548:" + file.path(), e));
            }
        });
    }

    public static void doOreAdsorption() {
        Unit unit = Vars.player.unit();
        if (Core.scene.hasMouse() || unit == null) {
            return;
        }
        Tile center = unit.tileOn();
        if (center == null) {
            return;
        }
        center.circle(Mathf.ceil((float)(unit.type.mineRange / 8.0f)), tile -> {
            Tile ptile = unit.mineTile;
            if ((ptile == null || Vars.player.dst((Position)ptile) > Vars.player.dst((Position)tile) || ptile.drop() == Items.sand) && unit.validMine((Tile)tile) && unit.acceptsItem(unit.getMineResult((Tile)tile)) && tile.drop() != Items.sand) {
                unit.mineTile = tile;
            }
        });
    }

    public static void addSettings() {
        Vars.ui.settings.addCategory("@settings.arc", (Drawable)Icon.star, (Cons<SettingsMenuDialog.SettingsTable>)((Cons)c -> {
            c.addCategory("arcCgameview");
            c.checkPref("hoveredTileInfo", false);
            c.checkPref("arcAlwaysTeamColor", false);
            c.addCategory("arcCDisplayBlock");
            c.checkPref("blockdisabled", false);
            c.checkPref("blockBars", false);
            c.checkPref("blockBars_mend", false);
            c.checkPref("arcdrillmode", false);
            c.checkPref("mass_driver_line", true);
            c.sliderPref("mass_driver_line_interval", 40, 8, 400, 4, i -> (float)i / 8.0f + "\u683c");
            Cons changed = t -> {
                try {
                    RenderExt.massDriverLineColor = Color.valueOf((String)t);
                }
                catch (Exception e) {
                    RenderExt.massDriverLineColor = Color.valueOf((String)"ff8c66");
                }
            };
            c.textPref("mass_driver_line_color", "ff8c66", (Cons<String>)changed);
            changed.get((Object)Core.settings.getString("mass_driver_line_color"));
            c.addCategory("arcAddTurretInfo");
            c.checkPref("showTurretAmmo", false);
            c.checkPref("showTurretAmmoAmount", false);
            c.sliderPref("turretShowRange", 0, 0, 3, 1, s -> {
                String string;
                switch (s) {
                    case 0: {
                        string = "\u5173\u95ed";
                        break;
                    }
                    case 1: {
                        string = "\u4ec5\u5bf9\u5730";
                        break;
                    }
                    case 2: {
                        string = "\u4ec5\u5bf9\u7a7a";
                        break;
                    }
                    case 3: {
                        string = "\u5168\u90e8";
                        break;
                    }
                    default: {
                        string = "";
                    }
                }
                return string;
            });
            c.checkPref("turretForceShowRange", false);
            c.sliderPref("turretAlertRange", 0, 0, 30, 1, i -> i > 0 ? i + "\u683c" : "\u5173\u95ed");
            c.checkPref("blockWeaponTargetLine", false);
            c.checkPref("blockWeaponTargetLineWhenIdle", false);
            c.addCategory("arcAddUnitInfo");
            c.checkPref("unitHealthBar", false);
            c.sliderPref("unitWeaponRange", Core.settings.getInt("unitAlertRange", 0), 0, 30, 1, s -> {
                String string;
                switch (s) {
                    case 0: {
                        string = "\u5173\u95ed";
                        break;
                    }
                    case 30: {
                        string = "\u4e00\u76f4\u5f00\u542f";
                        break;
                    }
                    default: {
                        string = s + "\u683c";
                    }
                }
                return string;
            });
            c.sliderPref("unitWeaponRangeAlpha", Core.settings.getInt("unitweapon_range", 0), 0, 100, 1, i -> i > 0 ? i + "%" : "\u5173\u95ed");
            c.checkPref("unitWeaponTargetLine", false);
            c.checkPref("unitItemCarried", true);
            c.checkPref("unitLogicMoveLine", false);
            c.checkPref("unitLogicTimerBars", false);
            c.checkPref("arcBuildInfo", false);
            c.checkPref("unitbuildplan", false);
            c.checkPref("alwaysShowUnitRTSAi", false);
            c.sliderPref("rtsWoundUnit", 0, 0, 100, 2, s -> s + "%");
            c.addCategory("arcPlayerEffect");
            changed = t -> {
                try {
                    RenderExt.playerEffectColor = Color.valueOf((String)t);
                }
                catch (Exception e) {
                    RenderExt.playerEffectColor = Pal.accent;
                }
            };
            c.textPref("playerEffectColor", "ffd37f", (Cons<String>)changed);
            changed.get((Object)Core.settings.getString("playerEffectColor"));
            c.sliderPref("unitTargetType", 0, 0, 5, 1, s -> {
                String string;
                switch (s) {
                    case 0: {
                        string = "\u5173\u95ed";
                        break;
                    }
                    case 1: {
                        string = "\u865a\u5706";
                        break;
                    }
                    case 2: {
                        string = "\u653b\u51fb";
                        break;
                    }
                    case 3: {
                        string = "\u653b\u51fb\u53bb\u8fb9\u6846";
                        break;
                    }
                    case 4: {
                        string = "\u5706\u5341\u5b57";
                        break;
                    }
                    case 5: {
                        string = "\u5341\u5b57";
                        break;
                    }
                    default: {
                        string = s + "";
                    }
                }
                return string;
            });
            c.sliderPref("superUnitEffect", 0, 0, 2, 1, s -> {
                String string;
                switch (s) {
                    case 0: {
                        string = "\u5173\u95ed";
                        break;
                    }
                    case 1: {
                        string = "\u72ec\u4e00\u65e0\u4e8c";
                        break;
                    }
                    case 2: {
                        string = "\u5168\u90e8\u73a9\u5bb6";
                        break;
                    }
                    default: {
                        string = s + "";
                    }
                }
                return string;
            });
            c.sliderPref("playerEffectCurStroke", 0, 1, 30, 1, i -> (float)i / 10.0f + "Pixel(s)");
            c.addCategory("arcWeakCheat");
            c.checkPref("save_more_map", false);
            c.checkPref("overrideSkipWave", false);
            c.checkPref("playerNeedShooting", false);
        }));
    }

    public static void colorizeContent() {
        if (!((Boolean)colorizedContent.get()).booleanValue()) {
            return;
        }
        Vars.content.items().each(c -> ArcOld.colorizeContent(c, c.color));
        Vars.content.liquids().each(c -> ArcOld.colorizeContent(c, c.color));
        Vars.content.statusEffects().each(c -> ArcOld.colorizeContent(c, c.color));
        Vars.content.planets().each(c -> ArcOld.colorizeContent((UnlockableContent)((Object)c), c.atmosphereColor));
        Vars.content.blocks().each(c -> {
            if (c.hasColor) {
                ArcOld.colorizeContent(c, c.mapColor.cpy().mul(1.2f));
            } else if (c.itemDrop != null) {
                ArcOld.colorizeContent(c, c.itemDrop.color);
            }
        });
    }

    private static void colorizeContent(UnlockableContent c, Color color) {
        c.localizedName = "[#" + color + "]" + c.localizedName + "[]";
    }

    public static void updatePlayer() {
        Unit unit = Vars.player.unit();
        if (unit == null) {
            return;
        }
        if (Core.settings.getBool("forceBoost")) {
            Vars.player.boosting = true;
        }
        if (Vars.control.input instanceof DesktopInput && !Core.input.keyDown(Binding.select) && Core.settings.getBool("autotarget")) {
            UnitType type = unit.type;
            if (autoTarget != null) {
                Building b;
                Teamc teamc;
                boolean validHealTarget;
                boolean bl = validHealTarget = type.canHeal && (teamc = autoTarget) instanceof Building && (b = (Building)teamc).isValid() && autoTarget.team() == unit.team && b.damaged() && autoTarget.within((Position)unit, type.range);
                if (Units.invalidateTarget(autoTarget, unit, type.range) && !validHealTarget || Vars.state.isEditor()) {
                    autoTarget = null;
                }
            }
            if (autoTarget == null) {
                ControlBlock c;
                BlockUnitUnit u2;
                float range = unit.hasWeapons() ? unit.range() : 0.0f;
                Vars.player.shooting = false;
                Healthc healthc = Vars.player.unit();
                if (!(healthc instanceof BlockUnitUnit) || !((healthc = (u2 = (BlockUnitUnit)healthc).tile()) instanceof ControlBlock) || (c = (ControlBlock)healthc).shouldAutoTarget()) {
                    boolean targetBuilding = type.targetGround && type.hasWeapons() && ((Weapon)type.weapons.first()).bullet.buildingDamageMultiplier > 0.05f;
                    autoTarget = Units.closestTarget(unit.team, unit.x, unit.y, range, (Boolf<Unit>)((Boolf)u -> u.checkTarget(type.targetAir, type.targetGround)), (Boolf<Building>)((Boolf)u -> targetBuilding));
                    if (type.canHeal && autoTarget == null && (autoTarget = (Teamc)Geometry.findClosest((float)unit.x, (float)unit.y, Vars.indexer.getDamaged(unit.team))) != null && !unit.within((Position)autoTarget, range)) {
                        autoTarget = null;
                    }
                }
            }
            if (autoTarget != null) {
                Vec2 intercept = Predict.intercept((Position)unit, (Position)autoTarget, (float)(unit.hasWeapons() ? ((Weapon)type.weapons.first()).bullet.speed : 0.0f));
                Vars.player.shooting = true;
                unit.aim((Position)intercept);
            }
        } else {
            autoTarget = null;
        }
    }

    static {
        colorizedContent.addFallbackName("colorizedContent");
        backgroundPath.addFallbackName("arcBackgroundPath");
        showPlacementEffect.addFallbackName("arcPlacementEffect");
        backgrounds = Seq.with((Object[])new Fi[0]);
        autoTarget = null;
    }
}

