/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.units;

import arc.Core;
import arc.audio.Sound;
import arc.func.Boolf;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.ui.layout.Table;
import arc.struct.EnumSet;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.ai.types.AssemblerAI;
import mindustry.content.Fx;
import mindustry.content.UnitTypes;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.EntityCollisions;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.BuildingTetherc;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Icon;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.gen.Unitc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.graphics.Shaders;
import mindustry.io.TypeIO;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.LiquidStack;
import mindustry.type.PayloadSeq;
import mindustry.type.PayloadStack;
import mindustry.type.UnitType;
import mindustry.ui.Bar;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.PayloadBlock;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.blocks.units.UnitAssemblerModule;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeItemDynamic;
import mindustry.world.consumers.ConsumeLiquidsDynamic;
import mindustry.world.consumers.ConsumePayloadDynamic;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;

public class UnitAssembler
extends PayloadBlock {
    public TextureRegion sideRegion1;
    public TextureRegion sideRegion2;
    public int areaSize = 11;
    public UnitType droneType = UnitTypes.assemblyDrone;
    public int dronesCreated = 4;
    public float droneConstructTime = 240.0f;
    public int[] capacities = new int[0];
    public Seq<AssemblerUnitPlan> plans = new Seq(4);
    public Sound createSound = Sounds.unitCreateBig;
    public float createSoundVolume = 1.0f;
    @Nullable
    protected ConsumePayloadDynamic consPayload;
    @Nullable
    protected ConsumeItemDynamic consItem;

    public UnitAssembler(String name) {
        super(name);
        this.solid = true;
        this.update = true;
        this.rotate = true;
        this.rotateDraw = false;
        this.hasItems = true;
        this.acceptsPayload = true;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.unitAssembler});
        this.regionRotated1 = 1;
        this.sync = true;
        this.group = BlockGroup.units;
        this.commandable = true;
        this.quickRotate = false;
        this.ambientSound = Sounds.loopUnitBuilding;
        this.ambientSoundVolume = 0.13f;
    }

    public Rect getRect(Rect rect, float x, float y, int rotation) {
        rect.setCentered(x, y, (float)(this.areaSize * 8));
        float len = (float)(8 * (this.areaSize + this.size)) / 2.0f;
        rect.x += (float)Geometry.d4x((int)rotation) * len;
        rect.y += (float)Geometry.d4y((int)rotation) * len;
        return rect;
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        x *= 8;
        y *= 8;
        x = (int)((float)x + this.offset);
        y = (int)((float)y + this.offset);
        Rect rect = this.getRect(Tmp.r1, x, y, rotation);
        Drawf.dashRect((Color)(valid ? Pal.accent : Pal.remove), (Rect)rect);
    }

    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        Rect rect = this.getRect(Tmp.r1, tile.worldx() + this.offset, tile.worldy() + this.offset, rotation).grow(0.1f);
        return !Vars.indexer.getFlagged(team, BlockFlag.unitAssembler).contains(b -> this.getRect(Tmp.r2, b.x, b.y, b.rotation).overlaps(rect)) && !team.data().getBuildings((Block)ConstructBlock.get(this.size)).contains(b -> ((ConstructBlock.ConstructBuild)b).current instanceof UnitAssembler && this.getRect(Tmp.r2, b.x, b.y, b.rotation).overlaps(rect));
    }

    public void setBars() {
        super.setBars();
        boolean planLiquids = false;
        for (int i = 0; i < this.plans.size; ++i) {
            LiquidStack[] req = ((AssemblerUnitPlan)this.plans.get((int)i)).liquidReq;
            if (req == null || req.length <= 0) continue;
            for (LiquidStack stack : req) {
                this.addLiquidBar(stack.liquid);
            }
            planLiquids = true;
        }
        if (planLiquids) {
            this.removeBar("liquid");
        }
        this.addBar("progress", e -> new Bar("bar.progress", Pal.ammo, () -> e.progress));
        this.addBar("progress", e -> new Bar(() -> "\ue86d " + (int)(e.progress * 100.0f) + "% | " + Strings.fixed((float)(e.plan().time * (1.0f - e.progress) / (60.0f * Vars.state.rules.unitBuildSpeed(e.team) * e.timeScale())), (int)0) + " s", () -> Pal.ammo, () -> e.progress));
        this.addBar("units", e -> new Bar(() -> Core.bundle.format("bar.unitcap", new Object[]{Fonts.getUnicodeStr(e.unit().name), e.team.data().countType(e.unit()), e.unit().useUnitCap ? Units.getStringCap(e.team) : "\u221e"}), () -> Pal.power, () -> e.unit().useUnitCap ? (float)e.team.data().countType(e.unit()) / (float)Units.getCap(e.team) : 1.0f));
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.region, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)(plan.rotation >= 2 ? this.sideRegion2 : this.sideRegion1), (float)plan.drawx(), (float)plan.drawy(), (float)(plan.rotation * 90));
        Draw.rect((TextureRegion)this.topRegion, (float)plan.drawx(), (float)plan.drawy());
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.sideRegion1, this.topRegion};
    }

    public void init() {
        this.updateClipRadius((this.areaSize + 1) * 8);
        this.consPayload = new ConsumePayloadDynamic(build -> build.plan().requirements);
        this.consume(this.consPayload);
        this.consItem = new ConsumeItemDynamic(build -> build.plan().itemReq != null ? build.plan().itemReq : ItemStack.empty);
        this.consume(this.consItem);
        this.consume((Consume)new ConsumeLiquidsDynamic(build -> build.plan().liquidReq != null ? build.plan().liquidReq : LiquidStack.empty));
        super.init();
        this.initCapacities();
    }

    public void afterPatch() {
        this.initCapacities();
        super.afterPatch();
    }

    public void initCapacities() {
        this.consumeBuilder.each(c -> {
            c.multiplier = b -> Vars.state.rules.unitCost(b.team);
        });
        this.itemCapacity = 10;
        this.capacities = new int[Vars.content.items().size];
        for (AssemblerUnitPlan plan : this.plans) {
            if (plan.itemReq != null) {
                for (ItemStack stack : plan.itemReq) {
                    this.capacities[stack.item.id] = Math.max(this.capacities[stack.item.id], stack.amount * 2);
                    this.itemCapacity = Math.max(this.itemCapacity, stack.amount * 2);
                }
            }
            if (plan.liquidReq == null) continue;
            for (ItemStack stack : plan.liquidReq) {
                this.liquidFilter[stack.liquid.id] = true;
            }
        }
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.output, table2 -> {
            table2.row();
            int tier = 0;
            for (AssemblerUnitPlan plan : this.plans) {
                int ttier = tier++;
                table2.table(Styles.grayPanel, t -> {
                    if (plan.unit.isBanned()) {
                        t.image((Drawable)Icon.cancel).color(Pal.remove).size(40.0f).pad(10.0f);
                        return;
                    }
                    if (plan.unit.unlockedNow()) {
                        t.image(plan.unit.uiIcon).scaling(Scaling.fit).size(40.0f).pad(10.0f).left().with(i -> StatValues.withTooltip(i, plan.unit));
                        t.table(info -> {
                            info.defaults().left();
                            info.add((CharSequence)plan.unit.localizedName);
                            info.row();
                            info.add((CharSequence)(Strings.autoFixed((float)(plan.time / 60.0f), (int)1) + " " + Core.bundle.get("unit.seconds"))).color(Color.lightGray);
                            if (ttier > 0) {
                                info.row();
                                info.add((CharSequence)(Stat.moduleTier.localized() + ": " + ttier)).color(Color.lightGray);
                            }
                        }).left();
                        t.table(req -> {
                            req.add().grow();
                            req.table(solid -> {
                                int i;
                                int length = 0;
                                if (plan.itemReq != null) {
                                    for (i = 0; i < plan.itemReq.length; ++i) {
                                        if (length % 6 == 0) {
                                            solid.row();
                                        }
                                        solid.add((Element)StatValues.stack(plan.itemReq[i])).pad(5.0f);
                                        ++length;
                                    }
                                }
                                for (i = 0; i < plan.requirements.size; ++i) {
                                    if (length % 6 == 0) {
                                        solid.row();
                                    }
                                    solid.add((Element)StatValues.stack((PayloadStack)plan.requirements.get(i))).pad(5.0f);
                                    ++length;
                                }
                            }).right();
                            LiquidStack[] stacks = plan.liquidReq;
                            if (stacks != null) {
                                for (int i = 0; i < plan.liquidReq.length; ++i) {
                                    req.row();
                                    req.add().grow();
                                    req.add((Element)StatValues.displayLiquid(stacks[i].liquid, stacks[i].amount * 60.0f, true)).right();
                                }
                            }
                        }).grow().pad(10.0f);
                    } else {
                        t.image((Drawable)Icon.lock).color(Pal.darkerGray).size(40.0f).pad(10.0f);
                    }
                }).growX().pad(5.0f);
                table2.row();
            }
        });
    }

    public static void assemblerUnitSpawned(Tile tile) {
        Building building;
        if (tile == null || !((building = tile.build) instanceof UnitAssemblerBuild)) {
            return;
        }
        UnitAssemblerBuild build = (UnitAssemblerBuild)((Object)building);
        build.spawned();
    }

    public static void assemblerDroneSpawned(Tile tile, int id) {
        Building building;
        if (tile == null || !((building = tile.build) instanceof UnitAssemblerBuild)) {
            return;
        }
        UnitAssemblerBuild build = (UnitAssemblerBuild)((Object)building);
        build.droneSpawned(id);
    }

    public static class AssemblerUnitPlan {
        public UnitType unit;
        @Nullable
        public Seq<PayloadStack> requirements;
        @Nullable
        public ItemStack[] itemReq;
        @Nullable
        public LiquidStack[] liquidReq;
        public float time;

        public AssemblerUnitPlan(UnitType unit, float time, Seq<PayloadStack> requirements) {
            this.unit = unit;
            this.time = time;
            this.requirements = requirements;
        }

        AssemblerUnitPlan() {
        }
    }

    public class UnitAssemblerBuild
    extends PayloadBlock.PayloadBlockBuild<Payload> {
        protected IntSeq readUnits;
        protected IntSeq whenSyncedUnits;
        @Nullable
        public Vec2 commandPos;
        public Seq<Unit> units;
        public Seq<UnitAssemblerModule.UnitAssemblerModuleBuild> modules;
        public PayloadSeq blocks;
        public float progress;
        public float warmup;
        public float droneWarmup;
        public float powerWarmup;
        public float sameTypeWarmup;
        public float invalidWarmup;
        public int currentTier;
        public int lastTier;
        public boolean wasOccupied;
        public float droneProgress;
        public float totalDroneProgress;

        public UnitAssemblerBuild() {
            super((PayloadBlock)UnitAssembler.this);
            this.readUnits = new IntSeq();
            this.whenSyncedUnits = new IntSeq();
            this.units = new Seq();
            this.modules = new Seq();
            this.blocks = new PayloadSeq();
            this.invalidWarmup = 0.0f;
            this.currentTier = 0;
            this.lastTier = -2;
            this.wasOccupied = false;
        }

        public Vec2 getUnitSpawn() {
            float len = (float)(8 * (UnitAssembler.this.areaSize + UnitAssembler.this.size)) / 2.0f;
            float unitX = this.x + (float)Geometry.d4x((int)this.rotation) * len;
            float unitY = this.y + (float)Geometry.d4y((int)this.rotation) * len;
            return Tmp.v4.set(unitX, unitY);
        }

        public boolean moduleFits(Block other, float ox, float oy, int rotation) {
            float dx = ox + (float)Geometry.d4x((int)rotation) * ((float)other.size / 2.0f + 0.5f) * 8.0f;
            float dy = oy + (float)Geometry.d4y((int)rotation) * ((float)other.size / 2.0f + 0.5f) * 8.0f;
            Vec2 spawn = this.getUnitSpawn();
            if (Tile.relativeTo((float)ox, (float)oy, (float)spawn.x, (float)spawn.y) != rotation) {
                return false;
            }
            float dst = Math.max(Math.abs(dx - spawn.x), Math.abs(dy - spawn.y));
            return Mathf.equal((float)dst, (float)((float)(8 * UnitAssembler.this.areaSize) / 2.0f - 4.0f));
        }

        public void updateModules(UnitAssemblerModule.UnitAssemblerModuleBuild build) {
            this.modules.addUnique((Object)build);
            this.checkTier();
        }

        public void removeModule(UnitAssemblerModule.UnitAssemblerModuleBuild build) {
            this.modules.remove((Object)build);
            this.checkTier();
        }

        public void checkTier() {
            UnitAssemblerModule.UnitAssemblerModuleBuild mod;
            this.modules.sort(b -> b.tier());
            int max = 0;
            for (int i = 0; i < this.modules.size && ((mod = (UnitAssemblerModule.UnitAssemblerModuleBuild)this.modules.get(i)).tier() == max || mod.tier() == max + 1); ++i) {
                max = mod.tier();
            }
            this.currentTier = max;
        }

        public UnitType unit() {
            return this.plan().unit;
        }

        public AssemblerUnitPlan plan() {
            return (AssemblerUnitPlan)UnitAssembler.this.plans.get(Math.min(this.currentTier, UnitAssembler.this.plans.size - 1));
        }

        public boolean shouldConsume() {
            return this.enabled && !this.wasOccupied && Units.canCreate(this.team, this.plan().unit) && UnitAssembler.this.consPayload.efficiency((Building)((Object)this)) > 0.0f && UnitAssembler.this.consItem.efficiency((Building)((Object)this)) > 0.0f;
        }

        public void drawSelect() {
            for (UnitAssemblerModule.UnitAssemblerModuleBuild module : this.modules) {
                Drawf.selected((Building)module, (Color)Pal.accent);
            }
            Drawf.dashRect((Color)Tmp.c1.set(Pal.accent).lerp(Pal.remove, this.invalidWarmup), (Rect)UnitAssembler.this.getRect(Tmp.r1, this.x, this.y, this.rotation));
        }

        public void display(Table table2) {
            super.display(table2);
            if (this.team != Vars.player.team()) {
                return;
            }
            table2.row();
            table2.table(t -> {
                t.left().defaults().left();
                Block prev = null;
                for (int i = 0; i < this.modules.size; ++i) {
                    UnitAssemblerModule.UnitAssemblerModuleBuild mod = (UnitAssemblerModule.UnitAssemblerModuleBuild)this.modules.get(i);
                    if (prev == mod.block) continue;
                    t.image(mod.block.uiIcon).size(32.0f).padRight(4.0f);
                    prev = mod.block;
                }
                t.label(() -> "[accent] -> []" + this.unit().emoji() + " " + this.unit().localizedName);
            }).pad(4.0f).padLeft(0.0f).fillX().left();
        }

        public void updateTile() {
            if (!this.readUnits.isEmpty()) {
                this.units.clear();
                this.readUnits.each(i -> {
                    Unit unit = (Unit)Groups.unit.getByID(i);
                    if (unit != null) {
                        this.units.add((Object)unit);
                    }
                });
                this.readUnits.clear();
            }
            if (this.lastTier != this.currentTier) {
                if ((float)this.lastTier >= 0.0f) {
                    this.progress = 0.0f;
                }
                int n = this.lastTier = this.lastTier == -2 ? -1 : this.currentTier;
            }
            if (this.units.size < UnitAssembler.this.dronesCreated && this.whenSyncedUnits.size > 0) {
                this.whenSyncedUnits.each(id -> {
                    Unit unit = (Unit)Groups.unit.getByID(id);
                    if (unit != null) {
                        this.units.addUnique((Object)unit);
                    }
                });
            }
            this.units.removeAll(u -> !u.isAdded() || u.dead || !(u.controller() instanceof AssemblerAI));
            if (!this.allowUpdate()) {
                this.progress = 0.0f;
                this.units.each(Unitc::kill);
                this.units.clear();
            }
            float powerStatus = !this.enabled ? 0.0f : (this.power == null ? 1.0f : this.power.status);
            this.powerWarmup = Mathf.lerpDelta((float)powerStatus, (float)(powerStatus > 1.0E-4f ? 1.0f : 0.0f), (float)0.1f);
            this.droneWarmup = Mathf.lerpDelta((float)this.droneWarmup, (float)(this.units.size < UnitAssembler.this.dronesCreated ? powerStatus : 0.0f), (float)0.1f);
            this.totalDroneProgress += this.droneWarmup * this.delta();
            if (this.units.size < UnitAssembler.this.dronesCreated && this.enabled) {
                float f;
                this.droneProgress += this.delta() * Vars.state.rules.unitBuildSpeed(this.team) * powerStatus / UnitAssembler.this.droneConstructTime;
                if (f >= 1.0f && !Vars.net.client()) {
                    Unit unit = UnitAssembler.this.droneType.create(this.team);
                    if (unit instanceof BuildingTetherc) {
                        BuildingTetherc bt = (BuildingTetherc)unit;
                        bt.building((Building)((Object)this));
                    }
                    unit.set(this.x, this.y);
                    unit.rotation = 90.0f;
                    unit.add();
                    this.units.add((Object)unit);
                    Call.assemblerDroneSpawned((Tile)this.tile, (int)unit.id);
                }
            }
            if (this.units.size >= UnitAssembler.this.dronesCreated) {
                this.droneProgress = 0.0f;
            }
            Vec2 spawn = this.getUnitSpawn();
            if (this.moveInPayload() && !this.wasOccupied) {
                this.yeetPayload(this.payload);
                this.payload = null;
            }
            for (int i2 = 0; i2 < this.units.size; ++i2) {
                Unit unit = (Unit)this.units.get(i2);
                AssemblerAI ai = (AssemblerAI)unit.controller();
                ai.targetPos.trns((float)i2 * 90.0f + 45.0f, (float)UnitAssembler.this.areaSize / 2.0f * Mathf.sqrt2 * 8.0f).add(spawn);
                ai.targetAngle = (float)i2 * 90.0f + 45.0f + 180.0f;
            }
            this.wasOccupied = this.checkSolid(spawn, false);
            boolean visualOccupied = this.checkSolid(spawn, true);
            float eff = (float)this.units.count(u -> ((AssemblerAI)u.controller()).inPosition()) / (float)UnitAssembler.this.dronesCreated;
            this.sameTypeWarmup = Mathf.lerpDelta((float)this.sameTypeWarmup, (float)(this.wasOccupied && !visualOccupied ? 0.0f : 1.0f), (float)0.1f);
            this.invalidWarmup = Mathf.lerpDelta((float)this.invalidWarmup, (float)(visualOccupied ? 1.0f : 0.0f), (float)0.1f);
            AssemblerUnitPlan plan = this.plan();
            if (!this.wasOccupied && this.efficiency > 0.0f && Units.canCreate(this.team, plan.unit)) {
                float f;
                this.warmup = Mathf.lerpDelta((float)this.warmup, (float)this.efficiency, (float)0.1f);
                this.progress += this.edelta() * Vars.state.rules.unitBuildSpeed(this.team) * eff / plan.time;
                if (f >= 1.0f) {
                    Call.assemblerUnitSpawned((Tile)this.tile);
                }
            } else {
                this.warmup = Mathf.lerpDelta((float)this.warmup, (float)0.0f, (float)0.1f);
            }
        }

        public void droneSpawned(int id) {
            Fx.spawn.at(this.x, this.y);
            this.droneProgress = 0.0f;
            if (Vars.net.client()) {
                this.whenSyncedUnits.add(id);
            }
        }

        public void spawned() {
            AssemblerUnitPlan plan = this.plan();
            Vec2 spawn = this.getUnitSpawn();
            this.consume();
            Unit unit = plan.unit.create(this.team);
            if (unit.isCommandable() && this.commandPos != null) {
                unit.command().commandPosition(this.commandPos);
            }
            unit.set(spawn.x + Mathf.range((float)0.001f), spawn.y + Mathf.range((float)0.001f));
            unit.rotation = this.rotdeg();
            Building targetBuild = unit.buildOn();
            UnitPayload payload = new UnitPayload(unit);
            if (targetBuild != null && targetBuild.team == this.team && targetBuild.acceptPayload(targetBuild, (Payload)payload)) {
                targetBuild.handlePayload(targetBuild, (Payload)payload);
            } else if (!Vars.net.client()) {
                unit.add();
                Units.notifyUnitSpawn(unit);
            }
            UnitAssembler.this.createSound.at(spawn.x, spawn.y, 1.0f + Mathf.range((float)0.06f), UnitAssembler.this.createSoundVolume);
            this.progress = 0.0f;
            Fx.unitAssemble.at(spawn.x, spawn.y, this.rotdeg() - 90.0f, (Object)plan.unit);
            this.blocks.clear();
        }

        public void draw() {
            Draw.rect((TextureRegion)UnitAssembler.this.region, (float)this.x, (float)this.y);
            for (int i = 0; i < 4; ++i) {
                if (!this.blends(i) || i == this.rotation) continue;
                Draw.rect((TextureRegion)UnitAssembler.this.inRegion, (float)this.x, (float)this.y, (float)(i * 90 - 180));
            }
            Draw.rect((TextureRegion)(this.rotation >= 2 ? UnitAssembler.this.sideRegion2 : UnitAssembler.this.sideRegion1), (float)this.x, (float)this.y, (float)this.rotdeg());
            Draw.z((float)35.0f);
            this.payRotation = this.rotdeg();
            this.drawPayload();
            Draw.z((float)35.1f);
            Draw.rect((TextureRegion)UnitAssembler.this.topRegion, (float)this.x, (float)this.y);
            if (this.isPayload()) {
                return;
            }
            if (this.droneWarmup > 0.001f) {
                Draw.draw((float)35.2f, () -> Drawf.construct((Building)((Object)this), (TextureRegion)UnitAssembler.this.droneType.fullIcon, (Color)Pal.accent, (float)0.0f, (float)this.droneProgress, (float)this.droneWarmup, (float)this.totalDroneProgress, (float)14.0f));
            }
            Vec2 spawn = this.getUnitSpawn();
            float sx = spawn.x;
            float sy = spawn.y;
            AssemblerUnitPlan plan = this.plan();
            Draw.draw((float)40.0f, () -> {
                Draw.color((Color)Pal.accent, (float)this.warmup);
                Shaders.blockbuild.region = plan.unit.fullIcon;
                Shaders.blockbuild.time = Time.time;
                Shaders.blockbuild.alpha = this.warmup;
                Shaders.blockbuild.progress = Mathf.clamp((float)(this.progress + 0.05f));
                Draw.rect((TextureRegion)plan.unit.fullIcon, (float)sx, (float)sy, (float)(this.rotdeg() - 90.0f));
                Draw.flush();
                Draw.color();
                Shaders.blockbuild.alpha = 1.0f;
            });
            Draw.reset();
            Draw.z((float)122.0f);
            Draw.mixcol((Color)Tmp.c1.set(Pal.accent).lerp(Pal.remove, this.invalidWarmup), (float)1.0f);
            Draw.alpha((float)Math.min(this.powerWarmup, this.sameTypeWarmup));
            Draw.rect((TextureRegion)plan.unit.fullIcon, (float)spawn.x, (float)spawn.y, (float)(this.rotdeg() - 90.0f));
            Draw.alpha((float)Math.min(1.0f - this.invalidWarmup, this.warmup));
            for (Unit unit : this.units) {
                if (!((AssemblerAI)unit.controller()).inPosition()) continue;
                float px = unit.x + Angles.trnsx((float)unit.rotation, (float)unit.type.buildBeamOffset);
                float py = unit.y + Angles.trnsy((float)unit.rotation, (float)unit.type.buildBeamOffset);
                Drawf.buildBeam((float)px, (float)py, (float)spawn.x, (float)spawn.y, (float)(plan.unit.hitSize / 2.0f));
            }
            Fill.square((float)spawn.x, (float)spawn.y, (float)(plan.unit.hitSize / 2.0f));
            Draw.reset();
            Draw.z((float)122.0f);
            float fulls = (float)(UnitAssembler.this.areaSize * 8) / 2.0f;
            Lines.stroke(2.0f, Pal.accent);
            Draw.alpha((float)this.powerWarmup);
            Drawf.dashRectBasic((float)(spawn.x - fulls), (float)(spawn.y - fulls), (float)(fulls * 2.0f), (float)(fulls * 2.0f));
            Draw.reset();
            float outSize = plan.unit.hitSize + 9.0f;
            if (this.invalidWarmup > 0.0f) {
                Lines.stroke(2.0f, Tmp.c3.set(Pal.accent).lerp(Pal.remove, this.invalidWarmup).a(this.invalidWarmup));
                Drawf.dashSquareBasic((float)spawn.x, (float)spawn.y, (float)outSize);
            }
            Draw.reset();
        }

        public boolean checkSolid(Vec2 v, boolean same) {
            UnitType output = this.unit();
            float hsize = output.hitSize * 1.4f;
            return !output.flying && Vars.collisions.overlapsTile(Tmp.r1.setCentered(v.x, v.y, output.hitSize), EntityCollisions::solid) || Units.anyEntities(v.x - hsize / 2.0f, v.y - hsize / 2.0f, hsize, hsize, (Boolf<Unit>)((Boolf)u -> (!same || u.type != output) && !u.spawnedByCore && (u.type.allowLegStep && output.allowLegStep || output.flying && u.isFlying() || !output.flying && u.isGrounded())));
        }

        public boolean ready() {
            return this.efficiency > 0.0f && !this.wasOccupied;
        }

        public void yeetPayload(Payload payload) {
            Vec2 spawn = this.getUnitSpawn();
            this.blocks.add(payload.content(), 1);
            float rot = payload.angleTo((Position)spawn);
            Fx.shootPayloadDriver.at(payload.x(), payload.y(), rot);
            Fx.payloadDeposit.at(payload.x(), payload.y(), rot, (Object)new YeetData(spawn.cpy(), payload.content()));
            Sounds.shootPayload.at(this.x, this.y, 1.0f + Mathf.range((float)0.1f), 1.0f);
        }

        public double sense(LAccess sensor) {
            if (sensor == LAccess.progress) {
                return this.progress;
            }
            return super.sense(sensor);
        }

        public PayloadSeq getPayloads() {
            return this.blocks;
        }

        public boolean acceptPayload(Building source, Payload payload) {
            AssemblerUnitPlan plan = this.plan();
            return (this.payload == null || source instanceof UnitAssemblerModule.UnitAssemblerModuleBuild) && plan.requirements.contains(b -> b.item == payload.content() && this.blocks.get(payload.content()) < Mathf.round((float)((float)b.amount * Vars.state.rules.unitCost(this.team))) - (source instanceof UnitAssemblerModule.UnitAssemblerModuleBuild && this.payload != null && this.payload.contentEquals(payload) ? 1 : 0));
        }

        public int getMaximumAccepted(Item item) {
            return Mathf.round((float)((float)UnitAssembler.this.capacities[item.id] * Vars.state.rules.unitCost(this.team)));
        }

        public boolean acceptItem(Building source, Item item) {
            return this.plan().itemReq != null && this.items.get(item) < this.getMaximumAccepted(item) && Structs.contains((Object[])this.plan().itemReq, stack -> stack.item == item);
        }

        public Vec2 getCommandPosition() {
            return this.commandPos;
        }

        public void onCommand(Vec2 target) {
            this.commandPos = target;
        }

        public byte version() {
            return 1;
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
            write.b(this.units.size);
            for (Unit unit : this.units) {
                write.i(unit.id);
            }
            this.blocks.write(write);
            TypeIO.writeVecNullable(write, this.commandPos);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.progress = read.f();
            int count = read.b();
            this.readUnits.clear();
            for (int i = 0; i < count; ++i) {
                this.readUnits.add(read.i());
            }
            this.whenSyncedUnits.clear();
            this.blocks.read(read);
            if (revision >= 1) {
                this.commandPos = TypeIO.readVecNullable(read);
            }
        }
    }

    public static class YeetData {
        public Vec2 target;
        public UnlockableContent item;

        public YeetData(Vec2 target, UnlockableContent item) {
            this.target = target;
            this.item = item;
        }
    }
}

