/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.units;

import arc.Core;
import arc.Events;
import arc.Graphics;
import arc.audio.Sound;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.style.Drawable;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.ImageButton;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.ai.UnitCommand;
import mindustry.content.Fx;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.gen.Player;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.io.TypeIO;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.UnitType;
import mindustry.ui.Bar;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.blocks.units.UnitBlock;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;

public class Reconstructor
extends UnitBlock {
    public float constructTime = 120.0f;
    public Seq<UnitType[]> upgrades = new Seq();
    public int[] capacities = new int[0];
    public Sound createSound = Sounds.unitCreate;
    public float createSoundVolume = 1.0f;

    public Reconstructor(String name) {
        super(name);
        this.regionRotated1 = 1;
        this.regionRotated2 = 2;
        this.commandable = true;
        this.ambientSound = Sounds.loopUnitBuilding;
        this.configurable = true;
        this.config(UnitCommand.class, (build, command) -> {
            build.command = command;
        });
        this.configClear(build -> {
            build.command = null;
        });
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.region, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)this.inRegion, (float)plan.drawx(), (float)plan.drawy(), (float)(plan.rotation * 90));
        Draw.rect((TextureRegion)this.outRegion, (float)plan.drawx(), (float)plan.drawy(), (float)(plan.rotation * 90));
        Draw.rect((TextureRegion)this.topRegion, (float)plan.drawx(), (float)plan.drawy());
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.inRegion, this.outRegion, this.topRegion};
    }

    public void setBars() {
        super.setBars();
        this.addBar("progress", e -> new Bar(() -> "\ue86d " + Strings.fixed((float)(e.progress * 100.0f / this.constructTime), (int)0) + "% | " + Strings.fixed((float)((this.constructTime - e.progress) / (60.0f * Vars.state.rules.unitBuildSpeed(e.team) * e.timeScale())), (int)0) + " s", () -> Pal.ammo, e::fraction));
        this.addBar("units", e -> new Bar(() -> e.unit() == null ? "[lightgray]\ue815" : Core.bundle.format("bar.unitcap", new Object[]{Fonts.getUnicodeStr(e.unit().name), e.team.data().countType(e.unit()), e.unit() == null || e.unit().useUnitCap ? Units.getStringCap(e.team) : "\u221e"}), () -> Pal.power, () -> e.unit() == null ? 0.0f : (e.unit().useUnitCap ? (float)e.team.data().countType(e.unit()) / (float)Units.getCap(e.team) : 1.0f)));
    }

    public void setStats() {
        this.stats.timePeriod = this.constructTime;
        super.setStats();
        this.stats.add(Stat.productionTime, this.constructTime / 60.0f, StatUnit.seconds);
        this.stats.add(Stat.output, table2 -> {
            table2.row();
            for (UnitType[] upgrade : this.upgrades) {
                if (!upgrade[0].unlockedNow() || !upgrade[1].unlockedNow()) continue;
                table2.table(Styles.grayPanel, t -> {
                    t.left();
                    t.image(upgrade[0].uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit).with(i -> StatValues.withTooltip(i, upgrade[0]));
                    t.table(info -> {
                        info.add((CharSequence)upgrade[0].localizedName).left();
                        info.row();
                    }).pad(10.0f).left();
                }).fill().padTop(5.0f).padBottom(5.0f);
                table2.table(Styles.grayPanel, t -> t.image((Drawable)Icon.right).color(Pal.darkishGray).size(40.0f).pad(10.0f)).fill().padTop(5.0f).padBottom(5.0f);
                table2.table(Styles.grayPanel, t -> {
                    t.left();
                    t.image(upgrade[1].uiIcon).size(40.0f).pad(10.0f).right().scaling(Scaling.fit).with(i -> StatValues.withTooltip(i, upgrade[1]));
                    t.table(info -> {
                        info.add((CharSequence)upgrade[1].localizedName).right();
                        info.row();
                    }).pad(10.0f).right();
                }).fill().padTop(5.0f).padBottom(5.0f);
                table2.row();
            }
        });
    }

    public void init() {
        this.initCapacities();
        super.init();
    }

    public void afterPatch() {
        this.initCapacities();
        super.afterPatch();
    }

    public void initCapacities() {
        this.capacities = new int[Vars.content.items().size];
        this.itemCapacity = 10;
        ConsumeItems cons = (ConsumeItems)this.findConsumer(c -> c instanceof ConsumeItems);
        if (cons != null) {
            for (ItemStack stack : cons.items) {
                this.capacities[stack.item.id] = Math.max(this.capacities[stack.item.id], stack.amount * 2);
                this.itemCapacity = Math.max(this.itemCapacity, stack.amount * 2);
            }
        }
        this.consumeBuilder.each(c -> {
            c.multiplier = b -> Vars.state.rules.unitCost(b.team);
        });
    }

    public void addUpgrade(UnitType from, UnitType to) {
        this.upgrades.add((Object)new UnitType[]{from, to});
    }

    public class ReconstructorBuild
    extends UnitBlock.UnitBuild {
        @Nullable
        public Vec2 commandPos;
        @Nullable
        public UnitCommand command;
        boolean constructing;

        public ReconstructorBuild() {
            super((UnitBlock)Reconstructor.this);
        }

        public float fraction() {
            return this.progress / Reconstructor.this.constructTime;
        }

        public Vec2 getCommandPosition() {
            return this.commandPos;
        }

        public void onCommand(Vec2 target) {
            this.commandPos = target;
        }

        public boolean acceptUnitPayload(Unit unit) {
            return this.hasUpgrade(unit.type) && !this.upgrade(unit.type).isBanned();
        }

        public boolean canSetCommand() {
            UnitType output = this.unit();
            return output == null || output.commands.size > 1 && output.allowChangeCommands;
        }

        public Graphics.Cursor getCursor() {
            return this.canSetCommand() ? super.getCursor() : Graphics.Cursor.SystemCursor.arrow;
        }

        public boolean shouldShowConfigure(Player player) {
            return this.canSetCommand();
        }

        public void buildConfiguration(Table table2) {
            UnitType unit = this.unit();
            ButtonGroup group = new ButtonGroup();
            group.setMinCheckCount(0);
            int i = 0;
            int columns = 4;
            table2.background(Styles.black6);
            Seq<UnitCommand> list = unit == null ? Vars.content.unitCommands() : unit.commands;
            for (UnitCommand item : list) {
                ImageButton button2 = (ImageButton)table2.button((Drawable)item.getIcon(), Styles.clearNoneTogglei, 40.0f, () -> {
                    this.configure(item);
                    this.deselect();
                }).tooltip(item.localized()).group(group).get();
                button2.update(() -> button2.setChecked(this.command == item || this.command == null && unit != null && unit.defaultCommand == item));
                if (++i % columns != 0) continue;
                table2.row();
            }
        }

        public boolean acceptPayload(Building source, Payload payload) {
            if (this.payload != null || !this.enabled && source != this || this.relativeTo(source) == this.rotation || !(payload instanceof UnitPayload)) {
                return false;
            }
            UnitPayload pay = (UnitPayload)payload;
            UnitType upgrade = this.upgrade(pay.unit.type);
            if (upgrade != null) {
                if (!upgrade.unlockedNowHost() && !this.team.isAI()) {
                    pay.showOverlay(Icon.tree);
                    Events.fire((Enum)EventType.Trigger.cannotUpgrade);
                }
                if (upgrade.isBanned()) {
                    pay.showOverlay(Icon.cancel);
                }
            }
            return upgrade != null && (this.team.isAI() || upgrade.unlockedNowHost()) && !upgrade.isBanned();
        }

        public int getMaximumAccepted(Item item) {
            return Mathf.round((float)((float)Reconstructor.this.capacities[item.id] * Vars.state.rules.unitCost(this.team)));
        }

        public void overwrote(Seq<Building> builds) {
            if (((Building)builds.first()).block == this.block) {
                this.items.add(((Building)builds.first()).items);
            }
        }

        public void draw() {
            Draw.rect((TextureRegion)Reconstructor.this.region, (float)this.x, (float)this.y);
            boolean fallback = true;
            for (int i = 0; i < 4; ++i) {
                if (!this.blends(i) || i == this.rotation) continue;
                Draw.rect((TextureRegion)Reconstructor.this.inRegion, (float)this.x, (float)this.y, (float)(i * 90 - 180));
                fallback = false;
            }
            if (fallback) {
                Draw.rect((TextureRegion)Reconstructor.this.inRegion, (float)this.x, (float)this.y, (float)(this.rotation * 90));
            }
            Draw.rect((TextureRegion)Reconstructor.this.outRegion, (float)this.x, (float)this.y, (float)this.rotdeg());
            if (this.constructing() && this.hasArrived()) {
                Draw.draw((float)35.0f, () -> {
                    Draw.alpha((float)(1.0f - this.progress / Reconstructor.this.constructTime));
                    Draw.rect((TextureRegion)((UnitPayload)this.payload).unit.type.fullIcon, (float)this.x, (float)this.y, (float)(((UnitPayload)this.payload).rotation() - 90.0f));
                    Draw.reset();
                    Drawf.construct((Building)((Object)this), (UnlockableContent)this.upgrade(((UnitPayload)this.payload).unit.type), (float)(((UnitPayload)this.payload).rotation() - 90.0f), (float)(this.progress / Reconstructor.this.constructTime), (float)this.speedScl, (float)this.time);
                });
            } else {
                Draw.z((float)35.0f);
                this.drawPayload();
            }
            Draw.z((float)35.1f);
            Draw.rect((TextureRegion)Reconstructor.this.topRegion, (float)this.x, (float)this.y);
        }

        public Object senseObject(LAccess sensor) {
            if (sensor == LAccess.config) {
                return this.unit();
            }
            return super.senseObject(sensor);
        }

        public void updateTile() {
            this.constructing = this.constructing();
            boolean valid = false;
            if (this.payload != null) {
                if (!this.hasUpgrade(((UnitPayload)this.payload).unit.type)) {
                    this.moveOutPayload();
                } else if (this.moveInPayload()) {
                    if (this.efficiency > 0.0f) {
                        valid = true;
                        this.progress += this.edelta() * Vars.state.rules.unitBuildSpeed(this.team);
                    }
                    if (this.progress >= Reconstructor.this.constructTime) {
                        ((UnitPayload)this.payload).unit = this.upgrade(((UnitPayload)this.payload).unit.type).create(((UnitPayload)this.payload).unit.team());
                        if (((UnitPayload)this.payload).unit.isCommandable()) {
                            if (this.commandPos != null) {
                                ((UnitPayload)this.payload).unit.command().commandPosition(this.commandPos);
                            }
                            ((UnitPayload)this.payload).unit.command().command(this.command == null && ((UnitPayload)this.payload).unit.type.defaultCommand != null ? ((UnitPayload)this.payload).unit.type.defaultCommand : this.command);
                        }
                        Reconstructor.this.createSound.at((Position)this, 1.0f + Mathf.range((float)0.06f), Reconstructor.this.createSoundVolume);
                        this.progress %= 1.0f;
                        Effect.shake((float)2.0f, (float)3.0f, (Position)this);
                        Fx.producesmoke.at((Position)this);
                        this.consume();
                        Events.fire((Object)new EventType.UnitCreateEvent(((UnitPayload)this.payload).unit, (Building)((Object)this)));
                    }
                }
            }
            this.speedScl = Mathf.lerpDelta((float)this.speedScl, (float)Mathf.num((boolean)valid), (float)0.05f);
            this.time += this.edelta() * this.speedScl * Vars.state.rules.unitBuildSpeed(this.team);
        }

        public double sense(LAccess sensor) {
            if (sensor == LAccess.progress) {
                return Mathf.clamp((float)this.fraction());
            }
            if (sensor == LAccess.itemCapacity) {
                return Mathf.round((float)((float)Reconstructor.this.itemCapacity * Vars.state.rules.unitCost(this.team)));
            }
            return super.sense(sensor);
        }

        public boolean shouldConsume() {
            return this.constructing && this.enabled;
        }

        public Object config() {
            return this.command;
        }

        public UnitType unit() {
            if (this.payload == null) {
                return null;
            }
            UnitType t = this.upgrade(((UnitPayload)this.payload).unit.type);
            return t != null && (t.unlockedNowHost() || this.team.isAI()) ? t : null;
        }

        public boolean constructing() {
            return this.payload != null && this.hasUpgrade(((UnitPayload)this.payload).unit.type);
        }

        public boolean hasUpgrade(UnitType type) {
            UnitType t = this.upgrade(type);
            return t != null && (t.unlockedNowHost() || this.team.isAI()) && !type.isBanned();
        }

        public UnitType upgrade(UnitType type) {
            UnitType[] r = (UnitType[])Reconstructor.this.upgrades.find(u -> u[0] == type);
            return r == null ? null : r[1];
        }

        public byte version() {
            return 3;
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
            TypeIO.writeVecNullable(write, this.commandPos);
            TypeIO.writeCommand(write, this.command);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 1) {
                this.progress = read.f();
            }
            if (revision >= 2) {
                this.commandPos = TypeIO.readVecNullable(read);
            }
            if (revision >= 3) {
                this.command = TypeIO.readCommand(read);
            }
        }
    }
}

