/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.storage;

import arc.Core;
import arc.Events;
import arc.audio.Music;
import arc.audio.Sound;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.actions.Actions;
import arc.scene.event.Touchable;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Scl;
import arc.struct.EnumSet;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.UnitTypes;
import mindustry.core.UI;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.units.UnitController;
import mindustry.entities.units.WeaponMount;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Musics;
import mindustry.gen.Player;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.io.TypeIO;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.UnitType;
import mindustry.ui.Bar;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.LaunchAnimator;
import mindustry.world.blocks.storage.StorageBlock;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.modules.ItemModule;

public class CoreBlock
extends StorageBlock {
    public static final float cloudScaling = 1700.0f;
    public static final float cfinScl = -2.0f;
    public static final float cfinOffset = 0.3f;
    public static final float calphaFinOffset = 0.25f;
    public static final float cloudAlpha = 0.81f;
    public static final float[] cloudAlphas = new float[]{0.0f, 0.5f, 1.0f, 0.1f, 0.0f, 0.0f};
    private static ItemModule nextItems;
    public static final float[] thrusterSizes;
    public TextureRegion thruster1;
    public TextureRegion thruster2;
    public float thrusterLength = 3.5f;
    public float thrusterOffset = 0.0f;
    public boolean isFirstTier;
    public boolean allowSpawn = true;
    public boolean requiresCoreZone;
    public boolean incinerateNonBuildable = false;
    public UnitType unitType = UnitTypes.alpha;
    public float landDuration = 160.0f;
    public Music landMusic = Musics.land;
    public float launchSoundVolume = 1.0f;
    public float landSoundVolume = 1.0f;
    public Sound launchSound = Sounds.coreLaunch;
    public Sound landSound = Sounds.coreLand;
    public Effect launchEffect = Fx.launch;
    public Interp landZoomInterp = Interp.pow3;
    public float landZoomFrom = 0.02f;
    public float landZoomTo = 4.0f;
    public float captureInvicibility = 900.0f;

    public CoreBlock(String name) {
        super(name);
        this.solid = true;
        this.update = true;
        this.hasItems = true;
        this.alwaysAllowDeposit = true;
        this.priority = 2.0f;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.core});
        this.unitCapModifier = 10;
        this.sync = false;
        this.drawDisabled = false;
        this.canOverdrive = false;
        this.commandable = true;
        this.envEnabled |= 2;
        this.replaceable = false;
        this.destroySound = Sounds.explosionCore;
        this.destroySoundVolume = 1.6f;
    }

    public static void playerSpawn(Tile tile, Player player) {
        Building building;
        if (player == null || tile == null || !((building = tile.build) instanceof CoreBuild)) {
            return;
        }
        CoreBuild core = (CoreBuild)building;
        UnitType spawnType = ((CoreBlock)((Object)core.block)).unitType;
        if (core.wasVisible) {
            Fx.spawn.at((Position)core);
        }
        player.set((Position)core);
        if (!Vars.net.client()) {
            player.team(tile.team());
            Unit unit = spawnType.create(tile.team());
            for (WeaponMount mount : unit.mounts) {
                mount.reload = mount.weapon.reload;
            }
            unit.set((Position)core);
            unit.rotation(90.0f);
            unit.impulse(0.0f, 3.0f);
            unit.spawnedByCore(true);
            unit.controller((UnitController)player);
            unit.add();
        }
        if (Vars.state.isCampaign() && player == Vars.player) {
            spawnType.unlock();
        }
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.unitType, table2 -> {
            table2.row();
            table2.table(Styles.grayPanel, b -> {
                b.image(this.unitType.uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit);
                b.table(info -> {
                    info.add((CharSequence)this.unitType.localizedName).left();
                    if (Core.settings.getBool("console")) {
                        info.row();
                        info.add((CharSequence)this.unitType.name).left().color(Color.lightGray);
                    }
                });
                b.button("?", Styles.flatBordert, () -> Vars.ui.content.show(this.unitType)).size(40.0f).pad(10.0f).right().grow().visible(() -> this.unitType.unlockedNow());
            }).growX().pad(5.0f).row();
        });
    }

    public void setBars() {
        super.setBars();
        this.addBar("capacity", e -> new Bar(() -> Core.bundle.format("bar.capacity", new Object[]{UI.formatAmount(e.storageCapacity)}), () -> Pal.items, () -> (float)e.items.total() / ((float)e.storageCapacity * (float)Vars.content.items().count(UnlockableContent::unlockedNow))));
    }

    public void init() {
        this.lightRadius = 30.0f + 20.0f * (float)this.size;
        this.fogRadius = Math.max(this.fogRadius, (int)(this.lightRadius / 8.0f * 3.0f) + 13);
        this.emitLight = true;
        super.init();
    }

    public void postInit() {
        super.postInit();
        this.unitType.shownPlanets.addAll(this.shownPlanets);
    }

    public boolean canBreak(Tile tile) {
        return Vars.state.isEditor();
    }

    public boolean canReplace(Block other) {
        return super.canReplace(other) || other instanceof CoreBlock && this.size >= other.size && other != this;
    }

    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        if (tile == null) {
            return false;
        }
        if (Vars.state.isEditor()) {
            return true;
        }
        CoreBuild core = team.core();
        tile.getLinkedTilesAs((Block)((Object)this), tempTiles);
        if (!tempTiles.contains(o -> !o.floor().allowCorePlacement || o.block() instanceof CoreBlock)) {
            return true;
        }
        if (core == null || !Vars.state.rules.infiniteResources && !core.items.has(this.requirements, Vars.state.rules.buildCostMultiplier)) {
            return false;
        }
        return tile.block() instanceof CoreBlock && this.size > tile.block().size && (!this.requiresCoreZone || tempTiles.allMatch(o -> o.floor().allowCorePlacement));
    }

    public void placeBegan(Tile tile, Block previous, Unit builder) {
        if (previous instanceof CoreBlock) {
            tile.setBlock((Block)((Object)this), tile.team());
            tile.block().placeEffect.at((Position)tile, (float)tile.block().size);
            Fx.upgradeCore.at(tile.drawx(), tile.drawy(), 0.0f, (Object)tile.block());
            Fx.upgradeCoreBloom.at((Position)tile, (float)tile.block().size);
            if (nextItems != null) {
                if (tile.team().core() != null) {
                    tile.team().core().items.set(nextItems);
                }
                nextItems = null;
            }
            Events.fire((Object)new EventType.BlockBuildEndEvent(tile, builder, tile.team(), false, null));
        }
    }

    public void beforePlaceBegan(Tile tile, Block previous) {
        if (tile.build instanceof CoreBuild) {
            ItemModule items = tile.build.items.copy();
            if (!Vars.state.rules.infiniteResources) {
                items.remove(ItemStack.mult((ItemStack[])this.requirements, (float)Vars.state.rules.buildCostMultiplier));
            }
            nextItems = items;
        }
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        if (Vars.world.tile(x, y) == null) {
            return;
        }
        if (!this.canPlaceOn(Vars.world.tile(x, y), Vars.player.team(), rotation)) {
            this.drawPlaceText(Core.bundle.get(this.isFirstTier ? "bar.corefloor" : (Vars.player.team().core() != null && Vars.player.team().core().items.has(this.requirements, Vars.state.rules.buildCostMultiplier) || Vars.state.rules.infiniteResources ? "bar.corereq" : "bar.noresources")), x, y, valid);
        }
    }

    static {
        thrusterSizes = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.3f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};
    }

    public class CoreBuild
    extends Building
    implements LaunchAnimator {
        public int storageCapacity;
        public boolean noEffect = false;
        public Team lastDamage = Team.derelict;
        public float iframes = -1.0f;
        public float thrusterTime = 0.0f;
        @Nullable
        public Vec2 commandPos;
        protected float cloudSeed;
        protected float landParticleTimer;

        @Override
        public boolean isCommandable() {
            return this.team != Vars.state.rules.defaultTeam && Vars.state.rules.editor;
        }

        @Override
        public Vec2 getCommandPosition() {
            return this.commandPos;
        }

        @Override
        public void onCommand(Vec2 target) {
            this.commandPos = target;
        }

        @Override
        public void draw() {
            if (this.thrusterTime > 0.0f) {
                float frame = this.thrusterTime;
                Draw.alpha((float)1.0f);
                this.drawThrusters(frame);
                Draw.rect((TextureRegion)this.block.region, (float)this.x, (float)this.y);
                Draw.alpha((float)Interp.pow4In.apply(frame));
                this.drawThrusters(frame);
                Draw.reset();
                this.drawTeamTop();
            } else {
                super.draw();
            }
        }

        public float launchDuration() {
            return CoreBlock.this.landDuration;
        }

        public Music landMusic() {
            return CoreBlock.this.landMusic;
        }

        public void beginLaunch(boolean launching) {
            this.cloudSeed = Mathf.random((float)1.0f);
            if (launching) {
                Fx.coreLaunchConstruct.at(this.x, this.y, (float)CoreBlock.this.size);
            }
            if (!Vars.headless) {
                (launching ? CoreBlock.this.launchSound : CoreBlock.this.landSound).play(CoreBlock.this.launchSoundVolume);
                if (Vars.renderer.isLaunching()) {
                    float margin = 30.0f;
                    Image image = new Image();
                    image.color.a = 0.0f;
                    image.touchable = Touchable.disabled;
                    image.setFillParent(true);
                    image.actions(new Action[]{Actions.delay((float)((this.launchDuration() - margin) / 60.0f)), Actions.fadeIn((float)(margin / 60.0f), (Interp)Interp.pow2In), Actions.delay((float)0.1f), Actions.remove()});
                    image.update(() -> {
                        image.toFront();
                        Vars.ui.loadfrag.toFront();
                        if (Vars.state.isMenu()) {
                            image.remove();
                        }
                    });
                    Core.scene.add((Element)image);
                } else {
                    Image image = new Image();
                    image.color.a = 1.0f;
                    image.touchable = Touchable.disabled;
                    image.setFillParent(true);
                    image.actions(new Action[]{Actions.fadeOut((float)0.5833333f), Actions.remove()});
                    image.update(() -> {
                        image.toFront();
                        Vars.ui.loadfrag.toFront();
                        if (Vars.state.isMenu()) {
                            image.remove();
                        }
                    });
                    Core.scene.add((Element)image);
                    Time.run((float)this.launchDuration(), () -> {
                        CoreBlock.this.launchEffect.at((Position)this);
                        Effect.shake((float)5.0f, (float)5.0f, (Position)this);
                        this.thrusterTime = 1.0f;
                        if (Vars.state.isCampaign() && Vars.showSectorLandInfo && (Vars.state.rules.sector.preset == null || Vars.state.rules.sector.preset.showSectorLandInfo)) {
                            Vars.ui.announce("[accent]" + Vars.state.rules.sector.name() + "\n" + (Vars.state.rules.sector.info.resources.any() ? "[lightgray]" + Core.bundle.get("sectors.resources") + "[white] " + Vars.state.rules.sector.info.resources.toString(" ", UnlockableContent::emoji) : ""), 5.0f);
                        }
                    });
                }
            }
        }

        public void endLaunch() {
        }

        public void drawLaunch() {
            float f;
            Texture clouds = (Texture)Core.assets.get("sprites/clouds.png", Texture.class);
            float fin = Vars.renderer.getLandTimeIn();
            float cameraScl = Vars.renderer.getDisplayScale();
            float fout = 1.0f - fin;
            float scl = Scl.scl((float)4.0f) / cameraScl;
            float pfin = Interp.pow3Out.apply(fin);
            float pf = Interp.pow2In.apply(fout);
            Draw.color((Color)Pal.lightTrail);
            Angles.randLenVectors((long)1L, (float)pfin, (int)100, (float)(800.0f * scl * pfin), (ax, ay, ffin, ffout) -> {
                Lines.stroke(scl * ffin * pf * 3.0f);
                Lines.lineAngle(this.x + ax, this.y + ay, Mathf.angle((float)ax, (float)ay), (ffin * 20.0f + 1.0f) * scl);
            });
            Draw.color();
            this.drawLanding(this.x, this.y);
            Draw.color();
            Draw.mixcol((Color)Color.white, (float)Interp.pow5In.apply(fout));
            if (Vars.renderer.isLaunching() && (f = Mathf.clamp((float)(1.0f - fout * 12.0f))) > 0.001f) {
                Draw.mixcol((Color)Pal.accent, (float)f);
            }
            if (Vars.state.rules.cloudColor.a > 1.0E-4f) {
                float scaling = 1700.0f;
                float sscl = Math.max(1.0f + Mathf.clamp((float)(fin + 0.3f)) * -2.0f, 0.0f) * cameraScl;
                Tmp.tr1.set(clouds);
                Tmp.tr1.set((Core.camera.position.x - Core.camera.width / 2.0f * sscl) / scaling, (Core.camera.position.y - Core.camera.height / 2.0f * sscl) / scaling, (Core.camera.position.x + Core.camera.width / 2.0f * sscl) / scaling, (Core.camera.position.y + Core.camera.height / 2.0f * sscl) / scaling);
                Tmp.tr1.scroll(10.0f * this.cloudSeed, 10.0f * this.cloudSeed);
                Draw.alpha((float)(Mathf.sample((float[])cloudAlphas, (float)(fin + 0.25f)) * 0.81f));
                Draw.mixcol((Color)Vars.state.rules.cloudColor, (float)Vars.state.rules.cloudColor.a);
                Draw.rect((TextureRegion)Tmp.tr1, (float)Core.camera.position.x, (float)Core.camera.position.y, (float)Core.camera.width, (float)Core.camera.height);
                Draw.reset();
            }
        }

        public void drawLanding(float x, float y) {
            float fin = Vars.renderer.getLandTimeIn();
            float fout = 1.0f - fin;
            float scl = Scl.scl((float)4.0f) / Vars.renderer.getDisplayScale();
            float shake = 0.0f;
            float s = (float)CoreBlock.this.region.width * CoreBlock.this.region.scl() * scl * 3.6f * Interp.pow2Out.apply(fout);
            float rotation = Interp.pow2In.apply(fout) * 135.0f;
            x += Mathf.range((float)shake);
            y += Mathf.range((float)shake);
            float thrustOpen = 0.25f;
            float thrusterFrame = fin >= thrustOpen ? 1.0f : fin / thrustOpen;
            float thrusterSize = Mathf.sample((float[])thrusterSizes, (float)fin);
            if (Vars.renderer.isLaunching()) {
                Interp.PowOut i = Interp.pow2Out;
                thrusterFrame = i.apply(Mathf.clamp((float)(fout * 13.0f)));
                thrusterSize = i.apply(Mathf.clamp((float)(fout * 9.0f)));
            }
            Draw.color((Color)Pal.lightTrail);
            Draw.rect((String)"circle-shadow", (float)x, (float)y, (float)s, (float)s);
            Draw.scl((float)scl);
            float strength = (1.0f + (float)(CoreBlock.this.size - 3) / 2.5f) * scl * thrusterSize * (0.95f + Mathf.absin((float)2.0f, (float)0.1f));
            float offset = (float)(CoreBlock.this.size - 3) * 3.0f * scl;
            for (int i = 0; i < 4; ++i) {
                Tmp.v1.trns((float)(i * 90) + rotation, 1.0f);
                Tmp.v1.setLength(((float)(CoreBlock.this.size * 8) / 2.0f + 1.0f) * scl + strength * 2.0f + offset);
                Draw.color((Color)this.team.color);
                Fill.circle((float)(Tmp.v1.x + x), (float)(Tmp.v1.y + y), (float)(6.0f * strength));
                Tmp.v1.setLength(((float)(CoreBlock.this.size * 8) / 2.0f + 1.0f) * scl + strength * 0.5f + offset);
                Draw.color((Color)Color.white);
                Fill.circle((float)(Tmp.v1.x + x), (float)(Tmp.v1.y + y), (float)(3.5f * strength));
            }
            this.drawLandingThrusters(x, y, rotation, thrusterFrame);
            Drawf.spinSprite((TextureRegion)CoreBlock.this.region, (float)x, (float)y, (float)rotation);
            Draw.alpha((float)Interp.pow4In.apply(thrusterFrame));
            this.drawLandingThrusters(x, y, rotation, thrusterFrame);
            Draw.alpha((float)1.0f);
            if (CoreBlock.this.teamRegions[this.team.id] == CoreBlock.this.teamRegion) {
                Draw.color((Color)this.team.color);
            }
            Drawf.spinSprite((TextureRegion)CoreBlock.this.teamRegions[this.team.id], (float)x, (float)y, (float)rotation);
            Draw.color();
            Draw.scl();
            Draw.reset();
        }

        protected void drawLandingThrusters(float x, float y, float rotation, float frame) {
            float length = CoreBlock.this.thrusterLength * (frame - 1.0f) - 0.25f;
            float alpha = Draw.getColorAlpha();
            for (int j = 0; j < 2; ++j) {
                for (int i = 0; i < 4; ++i) {
                    TextureRegion reg = i >= 2 ? CoreBlock.this.thruster2 : CoreBlock.this.thruster1;
                    float rot = (float)(i * 90) + rotation % 90.0f;
                    Tmp.v1.trns(rot, length * Draw.xscl);
                    if (j == 1) {
                        Tmp.v1.rotate(-90.0f);
                        Draw.alpha((float)(rotation % 90.0f / 90.0f * alpha));
                        Draw.rect((TextureRegion)reg, (float)(x + Tmp.v1.x), (float)(y + Tmp.v1.y), (float)(rot -= 90.0f));
                        continue;
                    }
                    Draw.alpha((float)alpha);
                    Draw.rect((TextureRegion)reg, (float)(x + Tmp.v1.x), (float)(y + Tmp.v1.y), (float)rot);
                }
            }
            Draw.alpha((float)1.0f);
        }

        public void drawThrusters(float frame) {
            float length = CoreBlock.this.thrusterLength * (frame - 1.0f) - 0.25f;
            for (int i = 0; i < 4; ++i) {
                TextureRegion reg = i >= 2 ? CoreBlock.this.thruster2 : CoreBlock.this.thruster1;
                float dx = (float)Geometry.d4x[i] * length;
                float dy = (float)Geometry.d4y[i] * length;
                Draw.rect((TextureRegion)reg, (float)(this.x + dx), (float)(this.y + dy), (float)(i * 90));
            }
        }

        @Override
        public void damage(@Nullable Team source, float damage) {
            if (this.iframes > 0.0f) {
                return;
            }
            if (source != null && source != this.team) {
                this.lastDamage = source;
            }
            super.damage(source, damage);
        }

        @Override
        public void created() {
            super.created();
            Events.fire((Object)new EventType.CoreChangeEvent(this));
        }

        @Override
        public void changeTeam(Team next) {
            if (this.team == next) {
                return;
            }
            this.onRemoved();
            super.changeTeam(next);
            this.onProximityUpdate();
            Events.fire((Object)new EventType.CoreChangeEvent(this));
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.itemCapacity) {
                return this.storageCapacity;
            }
            return super.sense(sensor);
        }

        @Override
        public boolean canControlSelect(Unit player) {
            return player.isPlayer();
        }

        @Override
        public void onControlSelect(Unit unit) {
            if (!unit.isPlayer() || !CoreBlock.this.allowSpawn) {
                return;
            }
            Player player = unit.getPlayer();
            Fx.spawn.at((Position)player);
            if (Vars.net.client() && player == Vars.player) {
                Vars.control.input.controlledType = null;
            }
            player.clearUnit();
            player.deathTimer = 61.0f;
            this.requestSpawn(player);
        }

        public void requestSpawn(Player player) {
            if (!CoreBlock.this.unitType.supportsEnv(Vars.state.rules.env) || !CoreBlock.this.allowSpawn) {
                return;
            }
            Call.playerSpawn((Tile)this.tile, (Player)player);
        }

        @Override
        public void updateTile() {
            this.iframes -= Time.delta;
            this.thrusterTime -= Time.delta / 90.0f;
        }

        public float zoomLaunch() {
            Core.camera.position.set((Position)this);
            return CoreBlock.this.landZoomInterp.apply(Scl.scl((float)CoreBlock.this.landZoomFrom), Scl.scl((float)CoreBlock.this.landZoomTo), Vars.renderer.getLandTimeIn());
        }

        public void updateLaunch() {
            float in = Vars.renderer.getLandTimeIn() * this.launchDuration();
            float tsize = Mathf.sample((float[])thrusterSizes, (float)((in + 35.0f) / this.launchDuration()));
            this.landParticleTimer += tsize * Time.delta;
            if (this.landParticleTimer >= 1.0f) {
                this.tile.getLinkedTiles(t -> {
                    if (Mathf.chance((double)0.4f)) {
                        Fx.coreLandDust.at(t.worldx(), t.worldy(), this.angleTo(t.worldx(), t.worldy()) + Mathf.range((float)30.0f), Tmp.c1.set(t.floor().mapColor).mul(1.5f + Mathf.range((float)0.15f)));
                    }
                });
                this.landParticleTimer = 0.0f;
            }
        }

        @Override
        public boolean canPickup() {
            return false;
        }

        @Override
        public void onDestroyed() {
            if (Vars.state.rules.coreCapture) {
                Damage.dynamicExplosion(this.x, this.y, 0.0f, 0.0f, 0.0f, (float)(8 * this.block.size) / 2.0f, Vars.state.rules.damageExplosions);
                Fx.commandSend.at(this.x, this.y, 140.0f);
            } else {
                super.onDestroyed();
            }
            Effect.shockwaveDust((float)this.x, (float)this.y, (float)(40.0f + (float)(this.block.size * 8)), (float)0.5f);
            Fx.coreExplosion.at(this.x, this.y, this.team.color);
            if (Vars.state.isCampaign() && this.team == Vars.state.rules.waveTeam && this.team.cores().size <= 1 && Vars.spawner.getSpawns().size == 0 && Vars.state.rules.sector.planet.enemyCoreSpawnReplace) {
                this.tile.setOverlayQuiet(Blocks.spawn);
                if (!Vars.spawner.getSpawns().contains((Object)this.tile)) {
                    Vars.spawner.getSpawns().add((Object)this.tile);
                }
            }
            Events.fire((Object)new EventType.CoreChangeEvent(this));
        }

        @Override
        public void playDestroySound() {
            if (this.team.data().cores.size <= 1 && Vars.player != null && Vars.player.team() == this.team && Vars.state.rules.canGameOver) {
                this.block.destroySound.play(this.block.destroySoundVolume, Mathf.random((float)this.block.destroyPitchMin, (float)this.block.destroyPitchMax), 0.0f);
            } else {
                super.playDestroySound();
            }
        }

        @Override
        public void afterDestroyed() {
            super.afterDestroyed();
            if (Vars.state.rules.coreCapture && !Vars.net.client()) {
                this.tile.setBlock(this.block, this.lastDamage);
                ((CoreBuild)this.tile.build).iframes = CoreBlock.this.captureInvicibility;
                if (Vars.net.server()) {
                    Time.run((float)0.0f, () -> this.tile.setNet(this.block, this.lastDamage, 0));
                }
            }
        }

        @Override
        public void drawLight() {
            Drawf.light((float)this.x, (float)this.y, (float)CoreBlock.this.lightRadius, (Color)Pal.accent, (float)(0.65f + Mathf.absin((float)20.0f, (float)0.1f)));
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return Vars.state.rules.coreIncinerates || this.items.get(item) < this.getMaximumAccepted(item);
        }

        @Override
        public int getMaximumAccepted(Item item) {
            return Vars.state.rules.coreIncinerates ? 0x3FFFFFFF : this.storageCapacity;
        }

        @Override
        public void onProximityUpdate() {
            super.onProximityUpdate();
            for (Building other : Vars.state.teams.cores(this.team)) {
                if (other.tile == this.tile) continue;
                this.items = other.items;
            }
            Vars.state.teams.registerCore(this);
            this.storageCapacity = CoreBlock.this.itemCapacity + this.proximity.sum(e -> this.owns((Building)e) ? e.block.itemCapacity : 0);
            this.proximity.each(this::owns, t -> {
                t.items = this.items;
                ((StorageBlock.StorageBuild)t).linkedCore = this;
            });
            for (Building other : Vars.state.teams.cores(this.team)) {
                if (other.tile == this.tile) continue;
                this.storageCapacity += other.block.itemCapacity + other.proximity.sum(e -> this.owns(other, (Building)e) ? e.block.itemCapacity : 0);
            }
            if (!Vars.world.isGenerating()) {
                for (Item item : Vars.content.items()) {
                    this.items.set(item, Math.min(this.items.get(item), this.storageCapacity));
                }
            }
            for (Building other : Vars.state.teams.cores(this.team)) {
                ((CoreBuild)other).storageCapacity = this.storageCapacity;
            }
        }

        @Override
        public void handleStack(Item item, int amount, Teamc source) {
            boolean incinerate = CoreBlock.this.incinerateNonBuildable && !item.buildable;
            int realAmount = incinerate ? 0 : Math.min(amount, this.storageCapacity - this.items.get(item));
            super.handleStack(item, realAmount, source);
            if (this.team == Vars.state.rules.defaultTeam && Vars.state.isCampaign()) {
                if (!incinerate) {
                    Vars.state.rules.sector.info.handleCoreItem(item, amount);
                }
                if (realAmount == 0 && this.wasVisible) {
                    Fx.coreBurn.at(this.x, this.y);
                }
            }
        }

        @Override
        public int removeStack(Item item, int amount) {
            int result = super.removeStack(item, amount);
            if (this.team == Vars.state.rules.defaultTeam && Vars.state.isCampaign()) {
                Vars.state.rules.sector.info.handleCoreItem(item, -result);
            }
            return result;
        }

        @Override
        public void drawSelect() {
            if (this.team.cores().size <= 1 && !this.proximity.contains(storage -> storage.items == this.items)) {
                return;
            }
            Lines.stroke(1.0f, Pal.accent);
            Cons outline = b -> {
                for (int i = 0; i < 4; ++i) {
                    Point2 p = Geometry.d8edge[i];
                    float offset = (float)(-Math.max(b.block.size - 1, 0)) / 2.0f * 8.0f;
                    Draw.rect((String)"block-select", (float)(b.x + offset * (float)p.x), (float)(b.y + offset * (float)p.y), (float)(i * 90));
                }
            };
            this.team.cores().each(core -> {
                outline.get(core);
                core.proximity.each(storage -> storage.items == this.items, outline);
            });
            Draw.reset();
        }

        public boolean owns(Building tile) {
            return this.owns(this, tile);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean owns(Building core, Building tile) {
            if (!(tile instanceof StorageBlock.StorageBuild)) return false;
            StorageBlock.StorageBuild b = (StorageBlock.StorageBuild)tile;
            if (!((StorageBlock)b.block).coreMerge) return false;
            if (b.linkedCore == core) return true;
            if (b.linkedCore != null) return false;
            return true;
        }

        @Override
        public void damage(float amount) {
            if (Vars.player != null && this.team == Vars.player.team()) {
                Events.fire((Enum)EventType.Trigger.teamCoreDamage);
            }
            super.damage(amount);
        }

        @Override
        public void onRemoved() {
            int totalCapacity = this.proximity.sum(e -> e.items != null && e.items == this.items ? e.block.itemCapacity : 0);
            this.proximity.each(e -> this.owns((Building)e) && e.items == this.items && this.owns((Building)e), t -> {
                StorageBlock.StorageBuild ent = (StorageBlock.StorageBuild)t;
                ent.linkedCore = null;
                ent.items = new ItemModule();
                for (Item item : Vars.content.items()) {
                    ent.items.set(item, (int)Math.min((float)ent.block.itemCapacity, (float)this.items.get(item) * (float)ent.block.itemCapacity / (float)totalCapacity));
                }
            });
            Vars.state.teams.unregisterCore(this);
            for (CoreBuild other : Vars.state.teams.cores(this.team)) {
                other.onProximityUpdate();
            }
        }

        @Override
        public void placed() {
            super.placed();
            Vars.state.teams.registerCore(this);
        }

        @Override
        public void itemTaken(Item item) {
            if (Vars.state.isCampaign() && this.team == Vars.state.rules.defaultTeam) {
                Vars.state.rules.sector.info.handleCoreItem(item, -1);
            }
        }

        @Override
        public void handleItem(Building source, Item item) {
            boolean incinerate;
            boolean bl = incinerate = CoreBlock.this.incinerateNonBuildable && !item.buildable;
            if (this.team == Vars.state.rules.defaultTeam) {
                Vars.state.stats.coreItemCount.increment((Object)item);
            }
            if (Vars.net.server() || !Vars.net.active()) {
                if (this.team == Vars.state.rules.defaultTeam && Vars.state.isCampaign() && !incinerate) {
                    Vars.state.rules.sector.info.handleCoreItem(item, 1);
                }
                if (this.items.get(item) >= this.storageCapacity || incinerate) {
                    if (!this.noEffect) {
                        StorageBlock.incinerateEffect((Building)this, (Building)source);
                    }
                    this.noEffect = false;
                } else {
                    super.handleItem(source, item);
                }
            } else if ((Vars.state.rules.coreIncinerates && this.items.get(item) >= this.storageCapacity || incinerate) && !this.noEffect) {
                StorageBlock.incinerateEffect((Building)this, (Building)source);
                this.noEffect = false;
            }
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            TypeIO.writeVecNullable(write, this.commandPos);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 1) {
                this.commandPos = TypeIO.readVecNullable(read);
            }
        }
    }
}

