/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.Core;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Intc2;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.struct.EnumSet;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.entities.Effect;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;

public class WallCrafter
extends Block {
    static int idx = 0;
    public TextureRegion topRegion;
    public TextureRegion rotatorBottomRegion;
    public TextureRegion rotatorRegion;
    public float drillTime = 150.0f;
    public float liquidBoostIntensity = 1.6f;
    public Effect updateEffect = Fx.mineWallSmall;
    public float updateEffectChance = 0.02f;
    public float rotateSpeed = 2.0f;
    public Attribute attribute = Attribute.sand;
    public Item output = Items.sand;
    public float boostItemUseTime = 120.0f;
    public float itemBoostIntensity = 1.6f;
    @Nullable
    public Consume itemConsumer;
    public boolean hasLiquidBooster;
    public final int timerUse = this.timers++;

    public WallCrafter(String name) {
        super(name);
        this.hasItems = true;
        this.rotate = true;
        this.update = true;
        this.solid = true;
        this.ignoreLineRotation = true;
        this.regionRotated1 = 1;
        this.envEnabled |= 2;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.drill});
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("drillspeed", e -> new Bar(() -> (this.output == null ? "\u6316\u6398\u901f\u5ea6\uff1a" : this.output.emoji()) + " " + Strings.fixed((float)(e.lastEfficiency * 60.0f / this.drillTime), (int)2) + "/s", () -> Pal.ammo, () -> e.warmup));
    }

    @Override
    public void setStats() {
        Object object;
        boolean consItems;
        super.setStats();
        this.stats.add(Stat.output, this.output);
        this.stats.add(Stat.tiles, StatValues.blocks(this.attribute, this.floating, 1.0f, true, false));
        this.stats.add(Stat.drillSpeed, 60.0f / this.drillTime * (float)this.size, StatUnit.itemsSecond);
        boolean bl = consItems = this.itemConsumer != null;
        if (consItems) {
            this.stats.timePeriod = this.boostItemUseTime;
        }
        if (consItems && (object = this.itemConsumer) instanceof ConsumeItems) {
            ConsumeItems coni = (ConsumeItems)((Object)object);
            this.stats.remove(Stat.booster);
            this.stats.add(Stat.booster, StatValues.itemBoosters("{0}" + StatUnit.timesSpeed.localized(), this.stats.timePeriod, this.itemBoostIntensity, 0.0f, coni.items));
        }
        if (this.liquidBoostIntensity != 1.0f && (object = this.findConsumer((Boolf<Consume>)((Boolf)f -> f instanceof ConsumeLiquidBase && f.booster))) instanceof ConsumeLiquidBase) {
            ConsumeLiquidBase consBase = (ConsumeLiquidBase)object;
            this.stats.remove(Stat.booster);
            this.stats.add(Stat.booster, StatValues.speedBoosters("{0}" + StatUnit.timesSpeed.localized(), consBase.amount, this.liquidBoostIntensity, false, (Boolf<Liquid>)((Boolf)arg_0 -> ((ConsumeLiquidBase)consBase).consumes(arg_0))));
        }
    }

    @Override
    public void init() {
        super.init();
        this.hasLiquidBooster = this.findConsumer((Boolf<Consume>)((Boolf)f -> f instanceof ConsumeLiquidBase && f.booster)) != null;
    }

    @Override
    public boolean outputsItems() {
        return true;
    }

    @Override
    public boolean rotatedOutput(int x, int y) {
        return false;
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.topRegion};
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.region, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)this.topRegion, (float)plan.drawx(), (float)plan.drawy(), (float)(plan.rotation * 90));
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        float eff = this.getEfficiency(x, y, rotation, null, null);
        this.drawPlaceText(Core.bundle.formatFloat("bar.drillspeed", 60.0f / this.drillTime * eff, 2), x, y, valid);
    }

    @Override
    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        return this.getEfficiency(tile.x, tile.y, rotation, null, null) > 0.0f;
    }

    float getEfficiency(int tx, int ty, int rotation, @Nullable Cons<Tile> ctile, @Nullable Intc2 cpos) {
        float eff = 0.0f;
        int cornerX = tx - (this.size - 1) / 2;
        int cornerY = ty - (this.size - 1) / 2;
        int s = this.size;
        for (int i = 0; i < this.size; ++i) {
            Tile other;
            int rx = 0;
            int ry = 0;
            switch (rotation) {
                case 0: {
                    rx = cornerX + s;
                    ry = cornerY + i;
                    break;
                }
                case 1: {
                    rx = cornerX + i;
                    ry = cornerY + s;
                    break;
                }
                case 2: {
                    rx = cornerX - 1;
                    ry = cornerY + i;
                    break;
                }
                case 3: {
                    rx = cornerX + i;
                    ry = cornerY - 1;
                }
            }
            if (cpos != null) {
                cpos.get(rx, ry);
            }
            if ((other = Vars.world.tile(rx, ry)) == null || !other.solid()) continue;
            float at = other.block().attributes.get(this.attribute);
            eff += at;
            if (!(at > 0.0f) || ctile == null) continue;
            ctile.get((Object)other);
        }
        return eff;
    }

    static /* synthetic */ int access$000(WallCrafter x0) {
        return x0.timerDump;
    }
}

