/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.Core;
import arc.math.Mathf;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.blocks.heat.HeatConsumer;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustryX.features.ui.FormatDefault;

public class HeatCrafter
extends GenericCrafter {
    public float heatRequirement = 10.0f;
    public float overheatScale = 1.0f;
    public float maxEfficiency = 4.0f;

    public HeatCrafter(String name) {
        super(name);
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("heat", entity -> new Bar(() -> Core.bundle.get("bar.heat") + " " + FormatDefault.percent(entity.heat, this.heatRequirement, entity.efficiencyScale(), true), () -> Pal.lightOrange, () -> entity.heat / this.heatRequirement));
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.input, this.heatRequirement, StatUnit.heatUnits);
        this.stats.add(Stat.maxEfficiency, (float)((int)(this.maxEfficiency * 100.0f)), StatUnit.percent);
    }

    public class HeatCrafterBuild
    extends GenericCrafter.GenericCrafterBuild
    implements HeatConsumer {
        public float[] sideHeat = new float[4];
        public float heat = 0.0f;

        @Override
        public void updateTile() {
            this.heat = this.calculateHeat(this.sideHeat);
            super.updateTile();
        }

        public float heatRequirement() {
            return HeatCrafter.this.heatRequirement;
        }

        public float[] sideHeat() {
            return this.sideHeat;
        }

        @Override
        public float warmupTarget() {
            return Mathf.clamp((float)(this.heat / HeatCrafter.this.heatRequirement));
        }

        @Override
        public float efficiencyScale() {
            float over = Math.max(this.heat - HeatCrafter.this.heatRequirement, 0.0f);
            return Math.min(Mathf.clamp((float)(this.heat / HeatCrafter.this.heatRequirement)) + over / HeatCrafter.this.heatRequirement * HeatCrafter.this.overheatScale, HeatCrafter.this.maxEfficiency);
        }
    }
}

